/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ASMDiskOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DiskGroupOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.FailGroupPropertyDialogOraclev10g;

public class FailGroupOraclev10g
extends AbstractStorageObjectOracle
implements StorageObjectListener,
ModelObjectSetListener {
    private DiskGroupOraclev10g diskGroup;
    StorageObjectCollection asmDisks;
    public static final String TYPE_NAME = "FailGroup";

    public FailGroupOraclev10g(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
        this.asmDisks = new StorageObjectCollection(((StorageDesignOraclev10g)storageDesign).getASMDiskSet());
        this.asmDisks.setParent(this);
        this.asmDisks.setName(Messages.getString("FailGroupOraclev10g.ASMDisk"));
        this.asmDisks.setSetMethod("setFailGroup");
        this.asmDisks.setClassForParent(FailGroupOraclev10g.class);
        ((StorageDesignOraclev10g)storageDesign).getASMDiskSet().addSetListener(this);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            FailGroupPropertyDialogOraclev10g dialog = new FailGroupPropertyDialogOraclev10g(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "FG";
    }

    public DiskGroupOraclev10g getDiskGroup() {
        return this.diskGroup;
    }

    public void setDiskGroup(DiskGroupOraclev10g diskGroup) {
        this.diskGroup = diskGroup;
        this.setPAC_Element(diskGroup);
        this.fireDataFieldChange();
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.asmDisks;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.asmDisks) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.asmDisks) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.asmDisks.removeAll();
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof ASMDiskOraclev10g) {
                ASMDiskOraclev10g asmDisk = (ASMDiskOraclev10g)event.getAffected();
                asmDisk.addObjectListener(this);
                if (asmDisk.getFailGroup() != null && asmDisk.getFailGroup() == this) {
                    asmDisk.setParent(this.asmDisks);
                    this.asmDisks.add(asmDisk);
                } else {
                    this.asmDisks.remove(asmDisk);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof ASMDiskOraclev10g) {
            ASMDiskOraclev10g asmDisk = (ASMDiskOraclev10g)event.getAffected();
            this.asmDisks.remove(asmDisk);
            asmDisk.removeObjectListener(this);
        }
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof ASMDiskOraclev10g) {
            ASMDiskOraclev10g asmDisk = (ASMDiskOraclev10g)event.getAffected();
            if (asmDisk.getFailGroup() != null && asmDisk.getFailGroup() == this) {
                asmDisk.setParent(this.asmDisks);
                this.asmDisks.add(asmDisk);
            } else {
                this.asmDisks.remove(asmDisk);
            }
        }
    }

    public List getASMDisks() {
        ArrayList list = new ArrayList();
        this.asmDisks.addAllElementsTo(list);
        return list;
    }

    public StorageObjectCollection getASMDiskCollection() {
        return this.asmDisks;
    }

    public ASMDiskOraclev10g createASMDisk() {
        if (this.asmDisks.getStorageObjectSet() != null) {
            return (ASMDiskOraclev10g)this.asmDisks.createElement(null);
        }
        return null;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        FailGroupOraclev10g failGroup = null;
        StorageObject stObject = (StorageObject)((StorageDesignOraclev10g)targetDesign).getFailGroupSet().getByName(this.getName());
        if (stObject != null) {
            if (!this.isRawObject()) {
                failGroup = (FailGroupOraclev10g)stObject;
            }
        } else {
            failGroup = ((StorageDesignOraclev10g)targetDesign).getFailGroupSet().createFailGroup();
        }
        if (failGroup != null) {
            failGroup.setName(this.getName());
            for (ASMDiskOraclev10g asmDisk : this.getASMDisks()) {
                ASMDiskOraclev10g targetAsmDisk = (ASMDiskOraclev10g)((StorageDesignOraclev10g)targetDesign).getASMDiskSet().getByName(asmDisk.getName());
                if (targetAsmDisk == null) {
                    ASMDiskOraclev10g newAsmDisk = ((StorageDesignOraclev10g)targetDesign).getASMDiskSet().createASMDisk();
                    newAsmDisk.setName(asmDisk.getName());
                    newAsmDisk.setFailGroup(failGroup);
                    newAsmDisk.setRawObject(true);
                    failGroup.getASMDisks().add(newAsmDisk);
                    continue;
                }
                targetAsmDisk.setFailGroup(failGroup);
                failGroup.getASMDisks().add(targetAsmDisk);
            }
            failGroup.setComment(this.getComment());
            failGroup.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("GROUP_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    @Override
    public void clearNoneMergableStructure() {
        this.asmDisks.removeAll();
    }
}

