/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.storage.CollectionTypeProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectPlaceHolder;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SynonymOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public abstract class CollectionTypeProxyOracle
extends CollectionTypeProxy {
    private UserOracle owner;
    protected StorageObjectCollection synonyms;

    public CollectionTypeProxyOracle(CollectionType structType, StorageDesign storageDesign) {
        super(structType, storageDesign);
        this.initSynonymsSet(storageDesign);
    }

    public CollectionTypeProxyOracle(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
        this.initSynonymsSet(storageDesign);
    }

    private void initSynonymsSet(StorageDesign storageDesign) {
        this.synonyms = new StorageObjectCollection();
        this.synonyms.setStorageObjectSet(((StorageDesignOracle)storageDesign).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("StorageDesignOracle.Synonyms"));
        this.synonyms.setClassForParent(SequenceOracle.class);
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        this.addSynonymsFromDesign(((StorageDesignOracle)storageDesign).getSynonymSet());
    }

    public UserOracle getOwner() {
        return this.owner;
    }

    public void setOwner(UserOracle owner) {
        if (this.owner != owner) {
            this.owner = owner;
            boolean isPredefined = owner.getName().equalsIgnoreCase("MDSYS") || owner.getName().equalsIgnoreCase("SYS") || owner.getName().equalsIgnoreCase("ORDSYS");
            this.getCollectionType().setPredefined(isPredefined);
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public String getType() {
        return ((CollectionType)this.getObject()).getType();
    }

    public String getDataType() {
        return ((CollectionType)this.getObject()).getElementType().getDataType();
    }

    public String getDataType(String rdbms) {
        return ((CollectionType)this.getObject()).getElementType().getDataType(rdbms);
    }

    public int getMaxElement() {
        return ((CollectionType)this.getObject()).getMaxElement();
    }

    public boolean isArrayType(String type) {
        return ((CollectionType)this.getObject()).isArrayType();
    }

    @Override
    public String getLongName() {
        String ownerName;
        if (this.getOwner() != null && (ownerName = this.getOwner().getLongName()).length() > 0) {
            return new StringBuffer(ownerName).append('.').append(this.getName()).toString();
        }
        return super.getLongName();
    }

    @Override
    public StorageObject getSchemaOrOwner() {
        return this.getOwner();
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public StorageObjectCollection getSynonyms() {
        return this.synonyms;
    }

    public SynonymOracle createSynonym() {
        SynonymOracle syn = (SynonymOracle)this.synonyms.createElement(null);
        syn.setReferredObjectID(this.getObjectID());
        syn.setPAC_Element(this);
        return syn;
    }

    public void removeSynonym(SynonymOracle syn) {
        this.synonyms.justRemove(syn);
        this.setDirty(true);
    }

    public void addSynonym(SynonymOracle syn) {
        if (!this.synonyms.contains(syn) && !this.synonyms.containsPlaceHolderFor(syn)) {
            int size = this.synonyms.size();
            this.synonyms.add(syn);
            if (this.synonyms.size() > size) {
                this.setDirty(true);
            }
        }
    }

    public void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymOracle syn : set) {
            if (!syn.getReferredObjectID().equalsIgnoreCase(this.getObjectID())) continue;
            StorageObjectPlaceHolder ph = new StorageObjectPlaceHolder(syn);
            this.synonyms.add(ph);
            ph.setParent(this.synonyms);
        }
    }
}

