/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2.v70;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentityDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class ColumnProxyDB2v70
extends ColumnProxyDB2 {
    public ColumnProxyDB2v70(Column column, StorageDesign storage) {
        super(column, storage);
    }

    public ColumnProxyDB2v70(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        Column column = (Column)targetDesign.getPhysicalDesign().getColumnSet().getByName(this.getObject().getName());
        ColumnProxyDB2v70 columnProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignDB2v70)targetDesign).getColumnProxySet().getProxy(column.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            columnProxy = (ColumnProxyDB2v70)storageObject;
        }
        if (columnProxy != null) {
            columnProxy.setName(this.getName());
            columnProxy.setBitData(this.getBitData());
            columnProxy.setDefault(this.getDefault());
            columnProxy.setDefaultValue(this.getDefaultValue());
            columnProxy.setDefaultValueConstant(this.getDefaultValueConstant());
            columnProxy.setProgram(this.getProgram());
            columnProxy.setConstant(this.getConstant());
            columnProxy.setLabel(this.getLabel());
            columnProxy.setUseIdentity(this.isUseIdentity());
            if (this.getColumnIdentity() != null) {
                ColumnIdentityDB2 identity = (ColumnIdentityDB2)((StorageDesignDB2v70)targetDesign).getColumnIdentitySet().getByName(this.getColumnIdentity().getName());
                if (identity == null) {
                    ColumnIdentityDB2 newIdentity = ((StorageDesignDB2v70)targetDesign).getColumnIdentitySet().createColumnIdentity();
                    newIdentity.setName(this.getColumnIdentity().getName());
                    newIdentity.setRawObject(true);
                    newIdentity.setColumn(columnProxy);
                    columnProxy.setColumnIdentity(newIdentity);
                } else {
                    identity.setColumn(columnProxy);
                    columnProxy.setColumnIdentity(identity);
                }
            }
            columnProxy.setComment(this.getComment());
            columnProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            columnProxy.setRawObject(false);
        }
    }
}

