/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.StorageObjectListener;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageObjectDB2;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObject;
import oracle.dbtools.crest.model.design.storage.db2.OwnedObjectImpl;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxySetDB2;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.db2.AliasPropertyDialogDB2;

public class AliasDB2
extends AbstractStorageObjectDB2
implements OwnedObject,
ModelObjectSetListener,
StorageObjectListener {
    private OwnedObjectImpl owner;
    private TableProxyDB2 table;
    private TableViewProxyDB2 view;
    private AliasDB2 anotherAlias;
    private StorageObjectCollection synonyms;
    public static final String TYPE_NAME = "Alias";

    public AliasDB2(StorageDesign storage) {
        this.setStorageDesign(storage);
        this.synonyms = new StorageObjectCollection(((AbstractStorageDesignDB2)storage).getSynonymSet());
        this.synonyms.setParent(this);
        this.synonyms.setName(Messages.getString("AliasDB2.Synonyms"));
        this.synonyms.setClassForParent(AliasDB2.class);
        this.synonyms.setSetMethod("setAlias");
        this.synonyms.setIcon(GUIConfiguration.getInstance().getIcon("SYNONYM_FOLDER_ICON", 16));
        ((AbstractStorageDesignDB2)storage).getSynonymSet().addSetListener(this);
        this.addSynonymsFromDesign(((AbstractStorageDesignDB2)storage).getSynonymSet());
    }

    @Override
    public void changed(StorageObject object, ObjectChangeEvent event) {
        if (event.getAffected() instanceof SynonymDB2) {
            SynonymDB2 syn = (SynonymDB2)event.getAffected();
            if (syn.getAlias() != null && syn.getAlias() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
            } else {
                this.synonyms.remove(syn);
            }
        }
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
        if (event.isType(1)) {
            if (event.getAffected() instanceof SynonymDB2) {
                SynonymDB2 syn = (SynonymDB2)event.getAffected();
                syn.addObjectListener(this);
                if (syn.getAlias() != null && syn.getAlias() == this) {
                    syn.setParent(this.synonyms);
                    this.synonyms.add(syn);
                } else {
                    this.synonyms.remove(syn);
                }
            }
        } else if (event.isType(0) && event.getAffected() instanceof SynonymDB2) {
            SynonymDB2 syn = (SynonymDB2)event.getAffected();
            this.synonyms.remove(syn);
            syn.removeObjectListener(this);
        }
    }

    @Override
    public int getNumberOfChildren() {
        return 1;
    }

    @Override
    public ModelObject getChild(int index) {
        switch (index) {
            case 0: {
                return this.synonyms;
            }
        }
        return null;
    }

    @Override
    public Object getChildPlain(int index) {
        return this.getChild(index);
    }

    @Override
    public int getIndexForChild(ModelObject child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object child) {
        if (child == this.synonyms) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void clearChildren() {
        this.synonyms.removeAll();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "ALS";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            AliasPropertyDialogDB2 dialog = new AliasPropertyDialogDB2(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    public AliasDB2 getAnotherAlias() {
        return this.anotherAlias;
    }

    public void setAnotherAlias(AliasDB2 anotherAlias) {
        this.anotherAlias = anotherAlias;
        if (anotherAlias != null) {
            this.table = null;
            this.view = null;
        }
        this.fireDataFieldChange();
    }

    public TableProxyDB2 getTable() {
        return this.table;
    }

    public void setTable(TableProxyDB2 table) {
        this.table = table;
        if (table != null) {
            this.view = null;
            this.anotherAlias = null;
        }
        this.fireDataFieldChange();
    }

    public TableViewProxyDB2 getView() {
        return this.view;
    }

    public void setView(TableViewProxyDB2 view) {
        this.view = view;
        if (view != null) {
            this.table = null;
            this.anotherAlias = null;
        }
        this.fireDataFieldChange();
    }

    @Override
    public void setOwner(Owner owner) {
        this.getOwnedObjectImpl().setOwner(owner);
        this.fireChange(ObjectChangeEvent.NAME_CHANGED);
    }

    @Override
    public Owner getOwner() {
        return this.getOwnedObjectImpl().getOwner();
    }

    private OwnedObjectImpl getOwnedObjectImpl() {
        if (this.owner == null) {
            this.owner = new OwnedObjectImpl();
            this.owner.setOwnerSet(((AbstractStorageDesignDB2)this.getStorageDesign()).getOwnerSet());
        }
        return this.owner;
    }

    @Override
    public boolean allowName(String name, boolean isLongName) {
        Owner owner;
        if (this.getStorageDesign() != null && this.getStorageDesign().isLoading()) {
            return true;
        }
        ModelObjectSet objectSet = this.getObjectSet();
        if (objectSet == null) {
            return true;
        }
        if (!(isLongName || this.getOwner() == null || this.getOwner().isNullInstance() || (owner = this.getOwner()).isNullInstance())) {
            name = owner.getSchemaObject() != null ? owner.getSchemaObject().getName() + "." + (String)name : owner.getName() + "." + (String)name;
        }
        return !objectSet.containsLongName(this, (String)name);
    }

    private void addSynonymsFromDesign(StorageObjectSet set) {
        for (SynonymDB2 syn : set) {
            if (syn.getAlias() != null && syn.getAlias() == this) {
                syn.setParent(this.synonyms);
                this.synonyms.add(syn);
                continue;
            }
            this.synonyms.remove(syn);
        }
    }

    public List getSynonyms() {
        ArrayList list = new ArrayList();
        this.synonyms.addAllElementsTo(list);
        return list;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        AliasDB2 alias = null;
        StorageObject storageObject = (StorageObject)((AbstractStorageDesignDB2)targetDesign).getAliasSet().getByName(this.getName());
        if (storageObject != null) {
            if (this.isRawObject()) {
                alias = (AliasDB2)storageObject;
            }
        } else {
            alias = ((AbstractStorageDesignDB2)targetDesign).getAliasSet().createAlias();
        }
        if (alias != null) {
            alias.setName(this.getName());
            for (SynonymDB2 synonym : this.getSynonyms()) {
                SynonymDB2 targetSynonym = (SynonymDB2)((AbstractStorageDesignDB2)targetDesign).getSynonymSet().getById(synonym.getObjectID());
                if (targetSynonym == null) {
                    SynonymDB2 newSynonym = ((AbstractStorageDesignDB2)targetDesign).getSynonymSet().createSynonym();
                    newSynonym.setName(synonym.getName());
                    newSynonym.setAlias(alias);
                    newSynonym.setRawObject(true);
                    alias.addSynonymsFromDesign(((AbstractStorageDesignDB2)targetDesign).getSynonymSet());
                    continue;
                }
                targetSynonym.setAlias(alias);
                alias.addSynonymsFromDesign(((AbstractStorageDesignDB2)targetDesign).getSynonymSet());
            }
            if (this.getOwner() != null) {
                Owner targetOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().getByName(this.getOwner().getName());
                if (targetOwner == null) {
                    Owner newOwner = (Owner)((AbstractStorageDesignDB2)targetDesign).getOwnerSet().createElement(null);
                    newOwner.setName(this.getOwner().getName());
                    newOwner.setRawObject(true);
                    alias.setOwner(newOwner);
                } else {
                    alias.setOwner(targetOwner);
                }
            }
            if (this.getView() != null) {
                TableViewProxyDB2 targetView = ((TableViewProxySetDB2)targetDesign.getTableViewProxySet()).getByName(this.getView().getName());
                if (targetView == null) {
                    TableViewProxyDB2 newView = (TableViewProxyDB2)((TableViewProxySetDB2)targetDesign.getTableViewProxySet()).createProxy(this.getView().getObject());
                    newView.setName(this.getView().getName());
                    newView.setRawObject(true);
                    alias.setView(newView);
                } else {
                    alias.setView(targetView);
                }
            }
            if (this.getTable() != null) {
                TableProxyDB2 targetTable = ((TableProxySetDB2)targetDesign.getTableProxySet()).getByName(this.getTable().getName());
                if (targetTable == null) {
                    TableProxyDB2 newTable = (TableProxyDB2)((TableProxySetDB2)targetDesign.getTableProxySet()).createProxy(this.getTable().getObject());
                    newTable.setName(this.getTable().getName());
                    newTable.setRawObject(true);
                    alias.setTable(newTable);
                } else {
                    alias.setTable(targetTable);
                }
            }
            if (this.getAnotherAlias() != null) {
                AliasDB2 targetAlias = (AliasDB2)((AbstractStorageDesignDB2)targetDesign).getAliasSet().getByName(this.getAnotherAlias().getName());
                if (targetAlias == null) {
                    AliasDB2 newAlias = ((AbstractStorageDesignDB2)targetDesign).getAliasSet().createAlias();
                    newAlias.setName(this.getAnotherAlias().getName());
                    newAlias.setRawObject(true);
                    alias.setAnotherAlias(newAlias);
                } else {
                    alias.setAnotherAlias(targetAlias);
                }
            }
            alias.setComment(this.getComment());
            alias.setCommentInRDBMS(this.getCommentInRDBMS());
            alias.setRawObject(false);
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("ALIAS_ICON", 16);
    }

    @Override
    public void clearNoneMergableStructure() {
        this.synonyms.removeAll();
    }

    public SynonymDB2 createSynonym() {
        SynonymDB2 syn = (SynonymDB2)this.synonyms.createElement(null);
        syn.setAlias(this);
        return syn;
    }

    public StorageObjectCollection getSynonymsCollection() {
        return this.synonyms;
    }
}

