/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.db2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.udb.SSBNoneTransferableFK_UDB;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.ApplyNamingStandards;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObjectSet;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableIndexSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2Estimates;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.AliasSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnIdentitySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeDB2;
import oracle.dbtools.crest.model.design.storage.db2.DistinctTypeSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.OwnerSet;
import oracle.dbtools.crest.model.design.storage.db2.PartitionSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.PrivilegesSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerDB2;
import oracle.dbtools.crest.model.design.storage.db2.TriggerSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesSetDB2;

public abstract class AbstractStorageDesignDB2
extends StorageDesign {
    private boolean scDialogVisible = false;
    private boolean dtDialogVisible = false;
    private Map substitutionMap = new TreeMap();
    protected Owner publicAtAllLocations;
    private AbstractStorageDesignDB2Estimates abstractStorageDesignDB2Estimates = new AbstractStorageDesignDB2Estimates();

    public AbstractStorageDesignDB2(RelationalDesign physicalDesign, RDBMSSite site, Design design) {
        super(physicalDesign, site, design);
        this.publicAtAllLocations = new Owner();
        this.publicAtAllLocations.setStorageDesign(this);
        this.publicAtAllLocations.setObjectID(null);
        this.publicAtAllLocations.setName("PUBLIC AT ALL LOCATIONS");
        this.publicAtAllLocations.setDesign(this.getDesign());
    }

    public abstract VCatSetDB2 getVCatSet();

    public abstract TableSpaceSetDB2 getTableSpaceSet();

    public abstract AUXTableIndexSetDB2 getAUXTableIndexSet();

    public abstract IndexPartitionSetDB2 getIndexPartitionSet();

    public abstract PartitionSetDB2 getPartitionSet();

    public abstract TriggerSetDB2 getTriggerSet();

    public abstract ColumnIdentitySetDB2 getColumnIdentitySet();

    public abstract BufferPoolSetDB2 getBufferPoolSet();

    public abstract StorageGroupSetDB2 getStorageGroupSet();

    public abstract StorageTemplateSetDB2 getStorageTemplateSet();

    public abstract VolumesSetDB2 getVolumesSet();

    public abstract AliasSetDB2 getAliasSet();

    public abstract DataBaseSetDB2 getDataBaseSet();

    public abstract AUXTableSetDB2 getAUXTableSet();

    public abstract StoredProcedureSetDB2 getStoredProcedureSet();

    public abstract SynonymSetDB2 getSynonymSet();

    public abstract DistinctTypeSetDB2 getDistinctTypeSet();

    public abstract void updateGeneralRule();

    public abstract OwnerSet getOwnerSet();

    public abstract PrivilegesSetDB2 getPrivilegesSet();

    public abstract PermissionsSetDB2 getPermissionsSet();

    public abstract InstanceDescriptorColumnSetDB2 getInstanceDescriptorColumnSet();

    public Owner getPublicAtAllLocations() {
        return this.publicAtAllLocations;
    }

    public boolean isDtDialogVisible() {
        return this.dtDialogVisible;
    }

    public void setDtDialogVisible(boolean dtDialogVisible) {
        this.dtDialogVisible = dtDialogVisible;
    }

    public boolean isScDialogVisible() {
        return this.scDialogVisible;
    }

    public void setScDialogVisible(boolean scDialogVisible) {
        this.scDialogVisible = scDialogVisible;
    }

    @Override
    public List getDropableSets() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getDataBaseSet());
        this.getTableSpaceSet().setName(Messages.getString("AbstractStorageDesignDB2.Tablespaces"));
        list.add(this.getTableSpaceSet());
        list.add(this.getTableProxySet());
        this.getTriggerSet().setName(Messages.getString("AbstractStorageDesignDB2.Triggers"));
        list.add(this.getTriggerSet());
        list.add(this.getSynonymSet());
        list.add(this.getIndexProxySet());
        if (this.getPhysicalDesign() != null) {
            list.add(this.getPhysicalDesign().getFKIndexAssociationSet());
        }
        list.add(this.getTableViewProxySet());
        list.add(this.getStoredProcedureSet());
        list.add(this.getAliasSet());
        this.getStorageGroupSet().setName(Messages.getString("AbstractStorageDesignDB2.StorageGroups"));
        this.getDistinctTypeSet().setName(Messages.getString("AbstractStorageDesignDB2.DistinctTypes"));
        list.add(this.getStorageGroupSet());
        list.add(this.getDistinctTypeSet());
        return list;
    }

    @Override
    public void setOpen(boolean open) {
        super.setOpen(open);
        if (open) {
            StorageTemplateDB2 template;
            Iterator it = this.getTableProxySet().iterator();
            String name = this.getDesign().getAppView().getSettings().getDefaultDB2Database();
            DataBaseDB2 db = null;
            db = name != null ? (DataBaseDB2)this.getDataBaseSet().getByName(name) : (DataBaseDB2)this.getDataBaseSet().getByName("DSNDB04");
            if (db != null) {
                while (it.hasNext()) {
                    String stName;
                    String tname;
                    String namingRule;
                    DesignObject object;
                    TableProxyDB2 table = (TableProxyDB2)it.next();
                    if (table.getTableSpace() == null) {
                        if (!this.getDesign().getAppView().getSettings().newDB2TableSpacePerTable()) continue;
                        TableSpaceDB2 tableSpace = this.getTableSpaceSet().createTableSpace();
                        table.setTableSpace(tableSpace);
                        tableSpace.setDataBase(db);
                        object = table.getObject();
                        namingRule = this.getDesign().getAppView().getSettings().getNamingRuleTablespaceDB2();
                        tname = ApplyNamingStandards.createTableSpaceDB2_Name(object.getName(), namingRule, object.getDesignPart().getName());
                        tableSpace.setName(tname);
                        if (!this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace()) continue;
                        StorageTemplateDB2 template2 = tableSpace.getStorageTemplate();
                        if (template2 == null) {
                            template2 = this.getStorageTemplateSet().createStorageTemplate();
                            table.getTableSpace().setStorageTemplate(template2);
                        }
                        namingRule = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
                        tname = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(table.getTableSpace().getName(), namingRule, object.getDesignPart().getName());
                        template2.setName(tname);
                        continue;
                    }
                    if (table.getTableSpace().getStorageTemplate() != null) continue;
                    if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerTableSpace()) {
                        StorageTemplateDB2 template3 = this.getStorageTemplateSet().createStorageTemplate();
                        table.getTableSpace().setStorageTemplate(template3);
                        object = table.getObject();
                        namingRule = this.getDesign().getAppView().getSettings().getNamingRuleStTablespaceDB2();
                        tname = ApplyNamingStandards.createTableSpaceStorageTemplateDB2_Name(table.getTableSpace().getName(), namingRule, object.getDesignPart().getName());
                        template3.setName(tname);
                        continue;
                    }
                    if (!this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerTS() || (stName = this.getDesign().getAppView().getSettings().getDefaultTSStorageTemplateName()) == null || "".equalsIgnoreCase(stName)) continue;
                    template = (StorageTemplateDB2)this.getStorageTemplateSet().getByName(stName);
                    if (template == null) {
                        template = this.getStorageTemplateSet().createStorageTemplate();
                        template.setName(stName);
                    }
                    if (template == null) continue;
                    table.getTableSpace().setStorageTemplate(template);
                }
            }
            it = this.getIndexProxySet().iterator();
            while (it.hasNext()) {
                String stName;
                IndexProxyDB2 index = (IndexProxyDB2)it.next();
                if (index.getStorageTemplate() != null) continue;
                if (this.getDesign().getAppView().getSettings().newDB2StorageTemplatePerIndex()) {
                    template = this.getStorageTemplateSet().createStorageTemplate();
                    index.setStorageTemplate(template);
                    DesignObject object = index.getObject();
                    String namingRule = this.getDesign().getAppView().getSettings().getNamingRuleStIndexDB2();
                    String tname = ApplyNamingStandards.createIndexStorageTemplateDB2_Name(index.getName(), namingRule, object.getDesignPart().getName());
                    template.setName(tname);
                    continue;
                }
                if (!this.getDesign().getAppView().getSettings().oneDB2StorageTemplatePerIndex() || (stName = this.getDesign().getAppView().getSettings().getDefaultIndexStorageTemplateName()) == null || "".equalsIgnoreCase(stName)) continue;
                StorageTemplateDB2 template4 = (StorageTemplateDB2)this.getStorageTemplateSet().getByName(stName);
                if (template4 == null) {
                    template4 = this.getStorageTemplateSet().createStorageTemplate();
                    template4.setName(stName);
                }
                if (template4 == null) continue;
                index.setStorageTemplate(template4);
            }
            VCatDB2 vcat = (VCatDB2)this.getVCatSet().getNullInstance();
            for (StorageGroupDB2 gr : this.getStorageGroupSet()) {
                if (gr.getVCat() != null) continue;
                gr.setVCat(vcat);
            }
            this.getStorageTemplateSet().sortByName();
        }
    }

    @Override
    protected DDLGenerator createDDLTriggerGenerator() {
        DDLGeneratorSpecific ddlGenerator = new DDLGeneratorSpecific(this);
        ddlGenerator.append(new SSBNoneTransferableFK_UDB(this));
        return ddlGenerator;
    }

    @Override
    public List getUniqueList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getFKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getPKProxyList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected List<ElementSet> createDDLSelectionSetsList() {
        List<ElementSet> objectsSets = super.createDDLSelectionSetsList();
        objectsSets.add(this.getTableProxySet());
        objectsSets.add(this.getAUXTableSet());
        objectsSets.add(this.getTableSpaceSet());
        objectsSets.add(this.getAliasSet());
        objectsSets.add(this.getTableViewProxySet());
        objectsSets.add(this.getStoredProcedureSet());
        objectsSets.add(this.getDistinctTypeSet());
        objectsSets.add(this.getStorageGroupSet());
        return objectsSets;
    }

    @Override
    public void sortCollections() {
        this.getDataBaseSet().sort();
        this.getOwnerSet().sort();
        this.getTableProxySet().sort();
        this.getTableViewProxySet().sort();
        this.getTableSpaceSet().sort();
        this.getPartitionSet().sort();
        this.getVCatSet().sort();
        this.getStorageGroupSet().sort();
        this.getBufferPoolSet().sort();
        this.getAliasSet().sort();
        this.getSynonymSet().sort();
        this.getVolumesSet().sort();
        this.getStorageTemplateSet().sort();
        this.getInstanceDescriptorColumnSet().sort();
        this.getColumnIdentitySet().sort();
        this.getAUXTableSet().sort();
        this.getAUXTableIndexSet().sort();
        this.getTriggerSet().sort();
        this.getStoredProcedureSet().sort();
        this.getDistinctTypeSet().sort();
        this.getPrivilegesSet().sort();
        this.getPermissionsSet().sort();
    }

    @Override
    public StorageObjectSet getUserSchemaSet() {
        return this.getOwnerSet();
    }

    @Override
    public Map getNameSubstituionTypes() {
        if (this.substitutionMap.isEmpty()) {
            this.substitutionMap.put("Table", new StorageDesign.ObjectType("Table"));
            this.substitutionMap.put("Owner", new StorageDesign.ObjectType("Owner"));
        }
        return this.substitutionMap;
    }

    public DataBaseDB2 createDataBase() {
        return this.getDataBaseSet().createDataBase(null);
    }

    public Owner createOwner() {
        return this.getOwnerSet().createOwner();
    }

    public AliasDB2 createAlias() {
        return this.getAliasSet().createAlias(null);
    }

    public TableSpaceDB2 createTableSpace() {
        return this.getTableSpaceSet().createTableSpace();
    }

    public VCatDB2 createVCat() {
        return this.getVCatSet().createVCat();
    }

    public DistinctTypeDB2 createDistinctType() {
        return this.getDistinctTypeSet().createDistinctType(null);
    }

    public AUXTableDB2 createAUXTable() {
        return this.getAUXTableSet().createAUXTable(null);
    }

    public VolumesDB2 createVolumes() {
        return this.getVolumesSet().createVolumes(null);
    }

    public StorageTemplateDB2 createStorageTemplate() {
        return this.getStorageTemplateSet().createStorageTemplate();
    }

    public TriggerDB2 createTrigger() {
        return this.getTriggerSet().createTrigger();
    }

    public StoredProcedureDB2 createStoredProcedure() {
        return this.getStoredProcedureSet().createStoredProcedure();
    }

    public StorageGroupDB2 createStorageGroup() {
        return this.getStorageGroupSet().createStorageGroup(null);
    }

    public AbstractStorageDesignDB2Estimates getAbstractStorageDesignDB2Estimates() {
        return this.abstractStorageDesignDB2Estimates;
    }
}

