/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.reference.ModelIDObjectReference;
import oracle.dbtools.crest.model.reference.ReferenceSet;

public class FKIndexAssociationSet
extends DesignObjectSet {
    public static final Object[] PROTOTYPE_ARRAY = new FKIndexAssociation[0];
    private FKAssociationReferenceSet referenceSet = new FKAssociationReferenceSet();

    public FKIndexAssociationSet(DesignPart designPart) {
        super(designPart);
        this.setNameSpaceController(((RelationalDesign)designPart).getIndexAndConstraintNameController());
        this.setCreateNameVariants(true);
        this.requireSort = true;
    }

    public ModelIDObject createElement(String id) {
        throw new RuntimeException("FKIndexAssociations should be created via Table instances");
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "FK_ASS";
    }

    @Override
    public String getSeparator() {
        return "_";
    }

    public Collection getAssociationsWith(FKContainer foreignTable) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignTable.equals(association.getRemoteTable())) continue;
            list.add(association);
        }
        return list;
    }

    public Collection getAssociationsWith(KeyObject foreignPK) {
        return this.iterateAndFill(foreignPK, false);
    }

    public Collection getAssociatedTablesWith(FKContainer foreignTable) {
        ArrayList<FKIndexAssociation> collection = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignTable.equals(association.getRemoteTable())) continue;
            collection.add(association);
        }
        return collection;
    }

    public List getRelatedTablesTo(FKContainer table) {
        ArrayList<FKContainer> list = new ArrayList<FKContainer>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKContainer remoteTable;
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            FKContainer localTable = association.getTable();
            if (localTable == (remoteTable = association.getRemoteTable()) || remoteTable == null) continue;
            if (table.equals(localTable)) {
                list.add(remoteTable);
                continue;
            }
            if (!table.equals(remoteTable)) continue;
            list.add(localTable);
        }
        return list;
    }

    public List getParentTables(FKContainer table) {
        ArrayList<FKContainer> list = new ArrayList<FKContainer>();
        for (FKIndexAssociation association : table.getFKAssociationsList()) {
            FKContainer remoteTable = association.getRemoteTable();
            if (remoteTable == null) continue;
            list.add(remoteTable);
        }
        return list;
    }

    public List getChildTables(FKContainer table) {
        ArrayList<FKContainer> list = new ArrayList<FKContainer>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!table.equals(association.getRemoteTable())) continue;
            list.add(association.getTable());
        }
        return list;
    }

    public Collection getAssociatedTablesWith(KeyObject foreignPK) {
        return this.iterateAndFill(foreignPK, true);
    }

    private Collection iterateAndFill(KeyObject foreignPK, boolean tables) {
        if (foreignPK == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<DesignObject> collection = new HashSet<DesignObject>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation association = (FKIndexAssociation)it.next();
            if (!foreignPK.equals(association.getRemoteIndex())) continue;
            if (tables) {
                collection.add(association.getTable());
                continue;
            }
            collection.add(association);
        }
        return collection;
    }

    public FKIndexAssociationReference createReference() {
        return (FKIndexAssociationReference)this.referenceSet.createReference(this.getDesign());
    }

    public List getFKeysToListOfKeys(List keys) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!keys.contains(fk.getRemoteIndex())) continue;
            list.add(fk);
        }
        return list;
    }

    public List getFKeysToListOfTables(List containers) {
        return this.getFKeysToListOfTables(containers, null);
    }

    public List getFKeysToListOfTables(List containers, Map filtered) {
        HashMap<Object, ModelIDObject> map = new HashMap<Object, ModelIDObject>();
        for (ModelIDObject obj : containers) {
            if (obj instanceof RelationalObjectProxy) {
                obj = ((RelationalObjectProxy)obj).getObject();
            }
            if (!(obj instanceof FKContainer)) continue;
            map.put(obj, obj);
            map.put(obj.getLongName(), obj);
        }
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            FKContainer cont = (FKContainer)fk.getContainerWithKeyObject();
            if (cont == null || filtered != null && filtered.containsKey(cont)) continue;
            FKContainer remote = fk.getRemoteTable();
            if (remote != null) {
                if (!map.containsKey(remote)) continue;
                list.add(fk);
                continue;
            }
            String rname = fk.getReferredTableLongName();
            if (!map.containsKey(rname)) continue;
            list.add(fk);
        }
        return list;
    }

    public List getFKeysEndingTo(FKContainer table) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        if (table != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                FKIndexAssociation association = (FKIndexAssociation)it.next();
                if (table != association.getRemoteTable() && table != association.getTable()) continue;
                list.add(association);
            }
        }
        return list;
    }

    @Override
    public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        if (nsc != null) {
            String validName = nsc.getValidName(object, schema, newName);
            if (validName.equals(newName)) {
                nsc.updateNamesMap(schema, oldName, newName, object);
                this.doRenaming(oldName, newName, object);
                return true;
            }
            return false;
        }
        Object obj2 = this.names.get(newName.toUpperCase());
        if (obj2 == null || obj2 == object || this.checkDifferentSchema((FKIndexAssociation)object, (FKIndexAssociation)obj2)) {
            this.doRenaming(oldName, newName, object);
            return true;
        }
        return false;
    }

    private boolean checkDifferentSchema(FKIndexAssociation currentFK, FKIndexAssociation otherFK) {
        FKContainer currentFKTable = currentFK.getTable();
        FKContainer otherFKTable = otherFK.getTable();
        if (currentFKTable != null && otherFKTable != null) {
            return !currentFKTable.getSchema().equals(otherFKTable.getSchema());
        }
        return true;
    }

    @Override
    protected void doRenaming(String oldName, String newName, DesignObject object) {
        String oname;
        DesignObject dobj;
        if (oldName != null && (dobj = (DesignObject)this.names.get(oname = oldName.toUpperCase())) == object) {
            this.names.remove(oname);
        }
        this.names.put(newName.toUpperCase(), object);
        if (!object.getDesign().isLoading()) {
            SetEvent.NAME_CHANGED.setAffected(object);
            this.fireChange(SetEvent.NAME_CHANGED);
        }
    }

    @Override
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        boolean res = false;
        if (nsc != null) {
            res = nsc.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            super.updateNamesMap(null, oldName, null, newName, object);
            return res;
        }
        return super.updateNamesMap(null, oldName, null, newName, object);
    }

    @Override
    public FKIndexAssociation getBySchemaAndName(String containerSchema, String fkName) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (!(containerSchema != null && !containerSchema.isEmpty() ? fk.getContainerWithKeyObject() != null && containerSchema.equalsIgnoreCase(fk.getContainerWithKeyObject().getSchema()) && fkName.equalsIgnoreCase(fk.getName()) : fkName.equalsIgnoreCase(fk.getName()))) continue;
            return fk;
        }
        return null;
    }

    class FKAssociationReferenceSet
    extends ReferenceSet {
        FKAssociationReferenceSet() {
        }

        @Override
        protected ModelIDObjectReference instantiateReference(Design design) {
            return new FKIndexAssociationReference(this.counter++, design, this);
        }
    }
}

