/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.util.GUID;

public class TransformationTaskSet
extends ModelIDObjectSet {
    private static final ModelIDObject[] PROTO_ARRAY = new TransformationTask[0];
    private Object elDescriptor;
    private ProcessModel processModel;
    private Design dsn;
    private TransformationPackage transformationPackage;

    public TransformationTaskSet(ProcessModel processModel) {
        this.processModel = processModel;
        this.setDesign(processModel.getDesign());
        this.setElementDescriptor(TransformationTask.class);
    }

    @Override
    public ModelIDObject createElement(String id) {
        TransformationTask design = new TransformationTask(this.getProcessModel(), this.transformationPackage);
        design.setDesign(this.getDesign());
        if (id == null || "".equalsIgnoreCase(id)) {
            design.setObjectID(new GUID().toString());
        } else {
            design.setObjectID(id);
        }
        design.setName(this.createName());
        design.setParent(this);
        this.add(design);
        return design;
    }

    @Override
    protected String createName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        int count = this.size() + 1;
        while (this.getByName(buffer.toString() + String.valueOf(count)) != null) {
            ++count;
        }
        buffer.append(count);
        return buffer.toString();
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Transformation Task";
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public void setElementDescriptor(Object elDescriptor) {
        this.elDescriptor = elDescriptor;
    }

    @Override
    public Design getDesign() {
        return this.dsn;
    }

    @Override
    public void setDesign(Design dsn) {
        this.dsn = dsn;
    }

    public TransformationPackage getTransformationPackage() {
        return this.transformationPackage;
    }

    public void setTransformationPackage(TransformationPackage transformationPackage) {
        this.transformationPackage = transformationPackage;
        this.setParent(transformationPackage);
    }
}

