/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.process;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.util.GUID;

public class DataFlowDesignSet
extends ModelIDObjectSet {
    private static final ModelIDObject[] PROTO_ARRAY = new DataFlowDesign[0];
    private Object elDescriptor;
    private ProcessModel processModel;
    private Design dsn;

    public DataFlowDesignSet(ProcessModel processModel) {
        this.processModel = processModel;
        this.setDesign(processModel.getDesign());
        this.setElementDescriptor(DataFlowDesign.class);
    }

    @Override
    public ModelIDObject createElement(String id) {
        DataFlowDesign design = new DataFlowDesign(this.getProcessModel());
        design.setDesign(this.getDesign());
        if (id == null || "".equalsIgnoreCase(id)) {
            design.setObjectID(new GUID().toString());
        } else {
            design.setObjectID(id);
        }
        design.setName(this.createName());
        design.setParent(this);
        this.add(design);
        return design;
    }

    public ModelIDObject createElement(String id, boolean topLevel) {
        DataFlowDesign design = new DataFlowDesign(this.getProcessModel(), topLevel);
        design.setDesign(this.getDesign());
        if (id == null || "".equalsIgnoreCase(id)) {
            design.createGlobalID();
        } else {
            design.setObjectID(id);
        }
        design.setName(this.createName());
        design.setParent(this);
        this.add(design);
        return design;
    }

    @Override
    protected String createName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultNamePrefix());
        buffer.append(this.getSeparator());
        int count = this.size() + 1;
        while (this.getByName(buffer.toString() + String.valueOf(count)) != null) {
            ++count;
        }
        buffer.append(count);
        return buffer.toString();
    }

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Data Flow Diagram";
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public ProcessModel getProcessModel() {
        return this.processModel;
    }

    public Object getElementDescriptor() {
        return this.elDescriptor;
    }

    public void setElementDescriptor(Object elDescriptor) {
        this.elDescriptor = elDescriptor;
    }

    @Override
    public Design getDesign() {
        return this.dsn;
    }

    @Override
    public void setDesign(Design dsn) {
        this.dsn = dsn;
    }

    public void orderDataFlowDesigns() {
        ArrayList<DFDHelper> dfds = new ArrayList<DFDHelper>();
        ArrayList<DFDHelper> sorted = new ArrayList<DFDHelper>();
        for (int i = 0; i < this.elements.size(); ++i) {
            DataFlowDesign dfd = (DataFlowDesign)this.elements.get(i);
            DFDHelper dph = new DFDHelper();
            dph.id = dfd.getObjectID();
            dph.object = dfd;
            dph.parent_id = dfd.getParentDFD_ID();
            dph.top_level_dfd_design = dfd.isTopLevel();
            if (dph == null) continue;
            if (dph.top_level_dfd_design) {
                sorted.add(0, dph);
                continue;
            }
            dfds.add(dph);
        }
        this.orderDFDs_byParent(dfds, sorted);
        if (this.elements.size() == sorted.size()) {
            this.elements.clear();
            for (DFDHelper dph : sorted) {
                this.elements.add(dph.object);
            }
        }
    }

    public void addOrderedDataFlowDesigns(List list) {
        ArrayList<DFDHelper> dfds = new ArrayList<DFDHelper>();
        ArrayList<DFDHelper> sorted = new ArrayList<DFDHelper>();
        for (int i = 0; i < this.elements.size(); ++i) {
            DataFlowDesign dfd = (DataFlowDesign)this.elements.get(i);
            DFDHelper dph = new DFDHelper();
            dph.id = dfd.getObjectID();
            dph.object = dfd;
            dph.parent_id = dfd.getParentDFD_ID();
            dph.top_level_dfd_design = dfd.isTopLevel();
            if (dph == null) continue;
            if (dph.top_level_dfd_design) {
                sorted.add(0, dph);
                continue;
            }
            dfds.add(dph);
        }
        this.orderDFDs_byParent(dfds, sorted);
        for (DFDHelper dph : sorted) {
            list.add(dph.object);
        }
    }

    private void orderDFDs_byParent(List source, List sorted) {
        for (DFDHelper dph : source) {
            if (sorted.contains(dph)) continue;
            this.addParent(dph, source, sorted);
            sorted.add(dph);
        }
    }

    private void addParent(DFDHelper dph, List source, List sorted) {
        if (dph.parent_id != null) {
            for (int i = 0; i < source.size(); ++i) {
                DFDHelper temp = (DFDHelper)source.get(i);
                if (!temp.id.equals(dph.parent_id)) continue;
                this.addParent(temp, source, sorted);
                if (sorted.contains(temp)) continue;
                sorted.add(temp);
            }
        }
    }

    class DFDHelper {
        public String id;
        public String parent_id;
        public boolean top_level_dfd_design;
        public DataFlowDesign object;

        DFDHelper() {
        }
    }
}

