/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectionCriteriaPropertiesDialog;

public class SelectionCriteria
extends AbstractMDObject {
    private String selectionCriteria = "";
    private String description = "";
    private ContainerObject entity;
    private String partition = "";
    private Slice.MeasureWrapper measureWrapper;
    private Slice slice;
    private List measureWrappersList;
    private String measureID;
    private String funcID;
    public static final String TYPE_NAME = "SelectionCriteria";

    public SelectionCriteria(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return "SC";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SelectionCriteriaPropertiesDialog dialog = new SelectionCriteriaPropertiesDialog(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.show();
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public ContainerObject getEntity() {
        if (this.slice != null) {
            this.entity = this.slice.getCube().getFactEntity();
        }
        return this.entity;
    }

    public void setEntity(ContainerObject entity) {
        this.entity = entity;
    }

    public String getPartition() {
        return this.partition;
    }

    public void setPartition(String partition) {
        this.partition = partition;
    }

    public String getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public void setSelectionCriteria(String selectionCriteria) {
        this.selectionCriteria = selectionCriteria;
    }

    public Slice.MeasureWrapper getMeasureWrapper() {
        if (this.measureWrapper == null) {
            if (this.slice != null && this.measureID != null && this.funcID != null) {
                this.measureWrapper = this.slice.getMeasureWrapper(this.measureID, this.funcID);
            }
        } else if (this.slice != null) {
            this.measureWrapper = this.slice.getMeasureWrapper(this.measureWrapper.getMeasure().getObjectID(), this.measureWrapper.getAggrFunction().getObjectID());
        }
        return this.measureWrapper;
    }

    public void setMeasureWrapper(Slice.MeasureWrapper measureWrapper) {
        this.measureWrapper = measureWrapper;
    }

    public void setSlice(Slice slice) {
        this.slice = slice;
    }

    public Object[] getMeasureWrappers() {
        ArrayList<Slice.MeasureWrapper> list;
        block3: {
            block2: {
                list = new ArrayList<Slice.MeasureWrapper>();
                if (this.measureWrappersList == null) break block2;
                for (Slice.MeasureWrapper mw : this.measureWrappersList) {
                    if (mw.getMeasure().isFormula() || mw.getMeasure().isFactDimension()) continue;
                    list.add(mw);
                }
                break block3;
            }
            if (this.slice == null) break block3;
            for (Slice.MeasureWrapper mw : this.slice.getSelectedMeasureWrappers()) {
                if (mw.getMeasure().isFormula() || mw.getMeasure().isFactDimension()) continue;
                list.add(mw);
            }
        }
        return list.toArray();
    }

    public void setMeasureWrappersList(List measureWrappersList) {
        this.measureWrappersList = measureWrappersList;
    }

    public void setFuncID(String funcID) {
        this.funcID = funcID;
    }

    public void setMeasureID(String measureID) {
        this.measureID = measureID;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "selcriteria" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getMeasureID() {
        return this.measureID;
    }

    public String getFuncID() {
        return this.funcID;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public Measure getMeasure() {
        Slice.MeasureWrapper mw = this.getMeasureWrapper();
        if (mw != null) {
            return mw.getMeasure();
        }
        return null;
    }
}

