/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.SQLtoAWGenerator;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLAccessToAWPropertiesDialogEx;

public class SQLAccessToAW
extends AbstractMDObject {
    private Cube cube;
    private Slice slice;
    private boolean generateGIDs;
    private boolean useModelClause = true;
    private boolean useObjectType = false;
    private String objectADTName = "";
    private String tableADTName = "";
    private List sqlDimensionDefinitions = new ArrayList();
    private List allSQLDimensions = new ArrayList();
    private List selMeasures = new ArrayList();
    private List selMeasureWrappers = new ArrayList();
    private List allMeasures = new ArrayList();
    private List allMeasureWrappers = new ArrayList();
    private List selectedSQLMeasures = new ArrayList();
    private List selectedSQLMeasureWrappers = new ArrayList();
    private List outSQLAttributes = new ArrayList();
    private SQLtoAWGenerator sqlToAWGenerator;
    private boolean useRowToCellColumn = true;
    private String aWName = "";
    public static String ATTR_TYPE_LONG_DESC = Messages.getString("SQLAccessToAW.LongDescription");
    public static String ATTR_TYPE_SHORT_DESC = Messages.getString("SQLAccessToAW.ShortDescription");
    public static String ATTR_TYPE_END_DATE = Messages.getString("SQLAccessToAW.EndDate");
    public static String ATTR_TYPE_TIME_SPAN = Messages.getString("SQLAccessToAW.TimeSpan");
    public static String ATTR_TYPE_LEVEL_NAME = Messages.getString("SQLAccessToAW.LevelName");
    public static String ATTR_TYPE_LEVEL = Messages.getString("SQLAccessToAW.Level");
    public static String ATTR_TYPE_MEASURE = Messages.getString("SQLAccessToAW.Measure");
    public static String ATTR_TYPE_DIMENSION_GID = Messages.getString("SQLAccessToAW.DimensionGid");
    public static String ATTR_TYPE_DIMENSION_ID = Messages.getString("SQLAccessToAW.DimensionID");
    public static String ATTR_TYPE_DESCRIPTIVE_ATTR = Messages.getString("SQLAccessToAW.Attribute");
    public static final String TYPE_NAME = "SQLAccessToAW";
    private Map dimMap = new TreeMap();
    private List sqlmeasCopy = new ArrayList();

    public SQLAccessToAW(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public Cube getCube() {
        return this.cube;
    }

    public void setCube(Cube cube) {
        this.cube = cube;
        if (cube != null && !cube.getSQLDefinitions().contains(this)) {
            cube.getSQLDefinitions().add(this);
        }
    }

    private void verifyDimensions() {
        List dimensions = null;
        dimensions = this.slice != null ? this.slice.getUsedDimensions() : (this.cube != null ? this.cube.getDimensions() : new ArrayList());
        ArrayList sqlDimDefsCopy = new ArrayList();
        sqlDimDefsCopy.addAll(this.sqlDimensionDefinitions);
        this.sqlDimensionDefinitions.clear();
        for (SQLDimension sqld : sqlDimDefsCopy) {
            if (!dimensions.contains(sqld.getDimension())) continue;
            this.sqlDimensionDefinitions.add(sqld);
            sqld.verifyAttributes();
        }
        sqlDimDefsCopy.clear();
        sqlDimDefsCopy.addAll(this.allSQLDimensions);
        this.allSQLDimensions.clear();
        for (Dimension dim : dimensions) {
            SQLDimension sqld = this.getSQLDimensionFor(sqlDimDefsCopy, dim);
            if (sqld == null) {
                sqld = this.getSQLDimensionFor(this.sqlDimensionDefinitions, dim);
            }
            if (sqld == null) {
                sqld = new SQLDimension(dim, this);
                sqld.verifyAttributes();
            }
            this.allSQLDimensions.add(sqld);
        }
    }

    private SQLDimension getSQLDimensionFor(List list, Dimension dim) {
        for (SQLDimension sqld : list) {
            if (sqld.getDimension() != dim) continue;
            return sqld;
        }
        return null;
    }

    private void verifyMeasures() {
        if (this.cube != null) {
            ArrayList meascopy = new ArrayList();
            meascopy.addAll(this.selMeasures);
            List list = this.cube.getMeasures();
            this.selMeasures.clear();
            for (Measure meas : meascopy) {
                if (!list.contains(meas)) continue;
                this.selMeasures.add(meas);
            }
            this.allMeasures.clear();
            this.allMeasures.addAll(list);
        }
    }

    private void verifyMeasureWrappers() {
        if (this.slice != null) {
            ArrayList meascopy = new ArrayList();
            meascopy.addAll(this.selMeasureWrappers);
            List list = this.slice.getSelectedMeasureWrappers();
            this.selMeasureWrappers.clear();
            for (Slice.MeasureWrapper meas : meascopy) {
                Slice.MeasureWrapper mw = this.getMeasureWrapper(list, meas);
                if (mw == null) continue;
                this.selMeasureWrappers.add(mw);
            }
            this.allMeasureWrappers.clear();
            this.allMeasureWrappers.addAll(list);
        }
    }

    private Slice.MeasureWrapper getMeasureWrapper(List list, Slice.MeasureWrapper mw) {
        for (Slice.MeasureWrapper mwo : list) {
            if (mwo.getMeasure() != mw.getMeasure() || !mwo.getAggrFunction().getObjectID().equals(mw.getAggrFunction().getObjectID())) continue;
            return mwo;
        }
        return null;
    }

    public void verifyDefinitions() {
        this.verifyRefsToHierarchies();
        this.verifyDimensions();
        if (this.slice != null) {
            this.verifyMeasureWrappers();
            this.verifySQLMeasureWrappers();
        } else if (this.cube != null) {
            this.verifyMeasures();
            this.verifySQLMeasures();
        }
        this.verifyOutAttributes();
        this.orderOutSQLAttributes();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            SQLAccessToAWPropertiesDialogEx dialog = new SQLAccessToAWPropertiesDialogEx(this.getDesign().getAppView(), this);
            dialog.initProperties(this);
            dialog.setModal(true);
            dialog.show();
        }
    }

    public boolean isGenerateGIDs() {
        return this.generateGIDs;
    }

    public void setGenerateGIDs(boolean generateGIDs) {
        this.generateGIDs = generateGIDs;
    }

    public Slice getSlice() {
        return this.slice;
    }

    public void setSlice(Slice slice) {
        this.slice = slice;
        if (slice != null && !slice.getSQLDefinitions().contains(this)) {
            slice.getSQLDefinitions().add(this);
        }
    }

    public boolean isUseModelClause() {
        return this.useModelClause;
    }

    public void setUseModelClause(boolean useModelClause) {
        this.useModelClause = useModelClause;
    }

    public List getMeasures() {
        return this.selMeasures;
    }

    public List getMeasureWrappers() {
        return this.selMeasureWrappers;
    }

    public List getSqlDimensionDefinitions() {
        return this.sqlDimensionDefinitions;
    }

    private SQLHierarchy getSQLHierarchyFor(List sqlhierList, Hierarchy hier) {
        for (SQLHierarchy sqlh : sqlhierList) {
            if (sqlh.hierarchy != hier) continue;
            return sqlh;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List attrList, Level level, SlowChangingAttribute sca) {
        for (SQLAttribute sqla : attrList) {
            if (sqla.getSlowChangingAttribute() != sca || level != sqla.getLevel()) continue;
            return sqla;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List attrList, Hierarchy hier, Level level) {
        for (SQLAttribute sqla : attrList) {
            if (sqla.getLevel() != level || sqla.hierarchy != hier) continue;
            return sqla;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List attrList, Measure measure) {
        for (SQLAttribute sqla : attrList) {
            if (sqla.getMeasure() != measure) continue;
            return sqla;
        }
        return null;
    }

    private SQLAttribute getSQLAttributeFor(List attrList, Slice.MeasureWrapper mw) {
        for (SQLAttribute sqla : attrList) {
            Slice.MeasureWrapper mwo = sqla.getMeasureWrapper();
            if (mwo.getMeasure() != mw.getMeasure() || !mwo.getAggrFunction().getObjectID().equals(mw.getAggrFunction().getObjectID())) continue;
            return sqla;
        }
        return null;
    }

    public boolean isUseObjectType() {
        return this.useObjectType;
    }

    public void setUseObjectType(boolean useObjectType) {
        this.useObjectType = useObjectType;
    }

    public String getTableADTName() {
        return this.tableADTName;
    }

    public void setTableADTName(String tableADTName) {
        this.tableADTName = tableADTName;
    }

    public String getObjectADTName() {
        return this.objectADTName;
    }

    public void setObjectADTName(String objectADTName) {
        this.objectADTName = objectADTName;
    }

    private void verifySQLMeasures() {
        ArrayList sqlMeasCopy = new ArrayList();
        sqlMeasCopy.addAll(this.selectedSQLMeasures);
        this.selectedSQLMeasures.clear();
        for (Measure meas : this.selMeasures) {
            SQLAttribute sqla = this.getSQLAttributeFor(sqlMeasCopy, meas);
            if (sqla == null) {
                sqla = new SQLAttribute(meas.getName().replaceAll(" ", "_"), meas, this.cube);
            }
            this.selectedSQLMeasures.add(sqla);
        }
    }

    public List getSelectedSQLMeasures() {
        this.verifyMeasures();
        this.verifySQLMeasures();
        return this.selectedSQLMeasures;
    }

    private void verifySQLMeasureWrappers() {
        ArrayList sqlMeasCopy = new ArrayList();
        sqlMeasCopy.addAll(this.selectedSQLMeasureWrappers);
        this.selectedSQLMeasureWrappers.clear();
        for (Slice.MeasureWrapper meas : this.selMeasureWrappers) {
            SQLAttribute sqla = this.getSQLAttributeFor(sqlMeasCopy, meas);
            if (sqla == null) {
                sqla = new SQLAttribute(meas.getAggrFunction().measureAlias.replaceAll(" ", "_"), meas, this.slice);
            }
            this.selectedSQLMeasureWrappers.add(sqla);
        }
    }

    public List getSelectedSQLMeasureWrappers() {
        this.verifyMeasureWrappers();
        this.verifySQLMeasureWrappers();
        return this.selectedSQLMeasureWrappers;
    }

    private void verifyOutAttributes() {
        this.dimMap.clear();
        this.sqlmeasCopy.clear();
        if (this.slice != null) {
            this.sqlmeasCopy.addAll(this.selectedSQLMeasureWrappers);
        } else {
            this.sqlmeasCopy.addAll(this.selectedSQLMeasures);
        }
        ArrayList outAttrCopy = new ArrayList();
        outAttrCopy.addAll(this.outSQLAttributes);
        this.outSQLAttributes.clear();
        for (SQLDimension sqld : this.sqlDimensionDefinitions) {
            DimDesc dd = new DimDesc(sqld);
            this.dimMap.put(sqld.getDimension().getObjectID(), dd);
        }
        for (SQLAttribute sqla : outAttrCopy) {
            SQLAttribute sattr = this.getSQLAttribite(sqla);
            if (sattr == null) continue;
            this.outSQLAttributes.add(sattr);
        }
        this.outSQLAttributes.addAll(this.sqlmeasCopy);
        for (String dimid : this.dimMap.keySet()) {
            DimDesc ddesc = (DimDesc)this.dimMap.get(dimid);
            this.outSQLAttributes.addAll(ddesc.selAttrCopy);
        }
    }

    private void orderOutSQLAttributes() {
        TreeMap<Integer, SQLAttribute> map = new TreeMap<Integer, SQLAttribute>();
        ArrayList<SQLAttribute> list = new ArrayList<SQLAttribute>();
        int max = -1;
        for (SQLAttribute sqla : this.outSQLAttributes) {
            Integer key;
            Object value;
            int pos = sqla.getOutPosition();
            if (max < pos) {
                max = pos;
            }
            if ((value = map.get(key = new Integer(pos))) == null) {
                map.put(key, sqla);
                continue;
            }
            list.add(sqla);
        }
        this.outSQLAttributes.clear();
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.outSQLAttributes.add(value);
        }
        ++max;
        for (SQLAttribute value : list) {
            value.setOutPosition(max);
            this.outSQLAttributes.add(value);
            ++max;
        }
    }

    private SQLAttribute getSQLAttribite(SQLAttribute sqla) {
        String type = sqla.getType();
        SQLAttribute sattr = null;
        if (ATTR_TYPE_MEASURE.equals(type)) {
            sattr = this.slice != null ? (this.getSQLAttributeFor(this.selectedSQLMeasureWrappers, sqla.getMeasureWrapper()) != null ? sqla : null) : (this.getSQLAttributeFor(this.selectedSQLMeasures, sqla.getMeasure()) != null ? sqla : null);
            if (sattr != null) {
                this.sqlmeasCopy.remove(sattr);
            }
            return sattr;
        }
        DimDesc ddesc = (DimDesc)this.dimMap.get(sqla.getDimension().getObjectID());
        if (ddesc != null) {
            SQLDimension sqldim = ddesc.sqldim;
            if (ATTR_TYPE_DIMENSION_ID.equals(type)) {
                if (sqldim.isSelectedDimensionID()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_DIMENSION_GID.equals(type)) {
                if (this.isGenerateGIDs()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_LEVEL.equals(type)) {
                sattr = this.getSQLAttributeFor(ddesc.selAttrCopy, sqla.hierarchy, sqla.getLevel());
            } else if (ATTR_TYPE_LEVEL_NAME.equals(type)) {
                if (sqldim.isSelectedLevelNameAttr()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_SHORT_DESC.equals(type)) {
                if (sqldim.isSelectedShortDescAttr()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_LONG_DESC.equals(type)) {
                if (sqldim.isSelectedLongDescAttr()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_END_DATE.equals(type)) {
                if (sqldim.isSelectedEndDate()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_TIME_SPAN.equals(type)) {
                if (sqldim.isSelectedTimeSpan()) {
                    sattr = sqla;
                }
            } else if (ATTR_TYPE_DESCRIPTIVE_ATTR.equals(type)) {
                sattr = this.getSQLAttributeFor(ddesc.selAttrCopy, sqla.getLevel(), sqla.getSlowChangingAttribute());
            }
            if (sattr != null) {
                ddesc.selAttrCopy.remove(sattr);
            }
        }
        return sattr;
    }

    private void verifyRefsToHierarchies() {
        ArrayList outAttrCopy = new ArrayList();
        outAttrCopy.addAll(this.outSQLAttributes);
        for (SQLAttribute sqla : outAttrCopy) {
            if (sqla.hierarchy != null || sqla.hierarchyID == null) continue;
            Hierarchy hier = (Hierarchy)this.getMultidimensionalDesign().getHierarchySet().getObjectByID(sqla.hierarchyID);
            if (hier != null) {
                sqla.hierarchy = hier;
                continue;
            }
            this.outSQLAttributes.remove(sqla);
        }
    }

    public SQLAccessToAW makeCopy() {
        SQLAccessToAW access = new SQLAccessToAW(this.getDesignPart());
        access.setGenerateGIDs(this.isGenerateGIDs());
        access.setName(this.getName());
        access.setAWName(this.getAWName());
        access.setComment(this.getComment());
        access.setNotes(this.getNotes());
        access.setDescription(this.getDescription());
        access.setSlice(this.getSlice());
        access.setCube(this.getCube());
        access.setUseModelClause(this.isUseModelClause());
        access.setUseObjectType(this.isUseObjectType());
        access.setObjectADTName(this.getObjectADTName());
        access.setTableADTName(this.getTableADTName());
        access.getMeasures().addAll(this.getMeasures());
        access.getMeasureWrappers().addAll(this.getMeasureWrappers());
        access.getSelectedSQLMeasures().addAll(this.selectedSQLMeasures);
        access.getSelectedSQLMeasureWrappers().addAll(this.getSelectedSQLMeasureWrappers());
        for (SQLDimension sqld : this.getSqlDimensionDefinitions()) {
            SQLAccessToAW sQLAccessToAW = access;
            Objects.requireNonNull(sQLAccessToAW);
            SQLDimension sqldc = sQLAccessToAW.new SQLDimension(sqld.getDimension(), access);
            sqld.makeCopyTo(sqldc);
            access.getSqlDimensionDefinitions().add(sqldc);
        }
        List seldims = access.getSqlDimensionDefinitions();
        for (SQLDimension sqld : this.allSQLDimensions) {
            SQLDimension sqldn = this.getSQLDimensionFor(seldims, sqld.getDimension());
            if (sqldn == null) {
                SQLAccessToAW sQLAccessToAW = access;
                Objects.requireNonNull(sQLAccessToAW);
                sqldn = sQLAccessToAW.new SQLDimension(sqld.getDimension(), access);
                sqld.makeCopyTo(sqldn);
            }
            access.getAllSQLDimensions().add(sqldn);
        }
        access.getOutSQLAttributes().addAll(this.getOutSQLAttributes());
        return access;
    }

    public void makeCopyTo(SQLAccessToAW access) {
        access.setGenerateGIDs(this.isGenerateGIDs());
        access.setName(this.getName());
        access.setAWName(this.getAWName());
        access.setComment(this.getComment());
        access.setNotes(this.getNotes());
        access.setDescription(this.getDescription());
        access.setSlice(this.getSlice());
        access.setCube(this.getCube());
        access.setUseModelClause(this.isUseModelClause());
        access.setUseObjectType(this.isUseObjectType());
        access.setObjectADTName(this.getObjectADTName());
        access.setTableADTName(this.getTableADTName());
        access.getMeasures().clear();
        access.getMeasures().addAll(this.getMeasures());
        access.getMeasureWrappers().clear();
        access.getMeasureWrappers().addAll(this.getMeasureWrappers());
        access.getSelectedSQLMeasures().clear();
        access.getSelectedSQLMeasures().addAll(this.selectedSQLMeasures);
        access.getSelectedSQLMeasureWrappers().clear();
        access.getSelectedSQLMeasureWrappers().addAll(this.getSelectedSQLMeasureWrappers());
        access.getSqlDimensionDefinitions().clear();
        for (SQLDimension sqld : this.getSqlDimensionDefinitions()) {
            SQLAccessToAW sQLAccessToAW = access;
            Objects.requireNonNull(sQLAccessToAW);
            SQLDimension sqldc = sQLAccessToAW.new SQLDimension(sqld.getDimension(), access);
            sqld.makeCopyTo(sqldc);
            access.getSqlDimensionDefinitions().add(sqldc);
        }
        List seldims = access.getSqlDimensionDefinitions();
        access.getAllSQLDimensions().clear();
        for (SQLDimension sqld : this.allSQLDimensions) {
            SQLDimension sqldn = this.getSQLDimensionFor(seldims, sqld.getDimension());
            if (sqldn == null) {
                SQLAccessToAW sQLAccessToAW = access;
                Objects.requireNonNull(sQLAccessToAW);
                sqldn = sQLAccessToAW.new SQLDimension(sqld.getDimension(), access);
                sqld.makeCopyTo(sqldn);
            }
            access.getAllSQLDimensions().add(sqldn);
        }
        access.getOutSQLAttributes().clear();
        access.getOutSQLAttributes().addAll(this.getOutSQLAttributes());
    }

    public List getOutSQLAttributes() {
        return this.outSQLAttributes;
    }

    public List getAllSQLDimensions() {
        return this.allSQLDimensions;
    }

    public List getAllMeasures() {
        return this.allMeasures;
    }

    public List getAllMeasureWrappers() {
        return this.allMeasureWrappers;
    }

    public String getSQLText(boolean formatted) {
        return this.getSQLText(formatted, this.getOutSQLAttributes());
    }

    public String getSQLText(boolean formatted, List attrsOrder) {
        return this.getSqlToAWGenerator().generateSQL(this, formatted, attrsOrder);
    }

    private SQLtoAWGenerator getSqlToAWGenerator() {
        if (this.sqlToAWGenerator == null) {
            this.sqlToAWGenerator = new SQLtoAWGenerator();
        }
        return this.sqlToAWGenerator;
    }

    public boolean isUseRowToCellColumn() {
        return this.useRowToCellColumn;
    }

    public void setUseRowToCellColumn(boolean useRowToCellColumn) {
        this.useRowToCellColumn = useRowToCellColumn;
    }

    public String getAWName() {
        return this.aWName;
    }

    public void setAWName(String name) {
        this.aWName = name;
    }

    public SQLAttribute getIDColumnForDimension(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_DIMENSION_ID) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLShortDescAttr(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_SHORT_DESC) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLLongDescAttr(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_LONG_DESC) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLEndDateAttr(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_END_DATE) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLTimeSpanAttr(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_TIME_SPAN) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLLevelNameAttr(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_LEVEL_NAME) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getGIDForDimension(List list, Dimension dimension) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_DIMENSION_GID) || sqla.getDimension() != dimension) continue;
            return sqla;
        }
        return null;
    }

    public SQLAttribute getSQLLevelAttr(List list, Dimension dimension, Hierarchy hier, Level level) {
        for (SQLAttribute sqla : list) {
            if (!sqla.getType().equals(ATTR_TYPE_LEVEL) || sqla.getDimension() != dimension || sqla.getLevel() != level || sqla.getHierarchy() != hier) continue;
            return sqla;
        }
        return null;
    }

    public void attributeIsDeleted(ContainedObject attr) {
    }

    public void entityIsDeleted(ContainerObject ent) {
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "sqltoaw" + File.separatorChar + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public List getOtherOutAttributes() {
        ArrayList<SQLAttribute> list = new ArrayList<SQLAttribute>();
        for (SQLAttribute sqla : this.getOutSQLAttributes()) {
            if (!ATTR_TYPE_MEASURE.equals(sqla.getType())) continue;
            list.add(sqla);
        }
        return list;
    }

    public List getMeasureWrapperMaps() {
        if (this.selMeasureWrappers.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList measureList = new ArrayList();
        for (Slice.MeasureWrapper mw : this.selMeasureWrappers) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("measure_id", mw.getMeasure().getObjectID());
            map.put("aggrFunctionID", mw.getAggrFuncId());
            measureList.add(map);
        }
        return measureList;
    }

    public void applyMeasureWrapperMaps(List maps) {
        this.selMeasureWrappers.clear();
        if (this.slice != null) {
            for (Object obj : maps) {
                Map map;
                String mid;
                if (!(obj instanceof Map) || (mid = (String)(map = (Map)obj).get("measure_id")) == null) continue;
                Slice.MeasureWrapper mw = null;
                String fid = (String)map.get("aggrFunctionID");
                mw = this.slice.getMeasureWrapper(mid, fid);
                if (mw == null) continue;
                this.selMeasureWrappers.add(mw);
            }
        }
    }

    public SQLAttribute createSQLAttribute() {
        return new SQLAttribute(this);
    }

    public SQLDimension createSQLDimension() {
        return new SQLDimension(this);
    }

    private class DimDesc {
        SQLDimension sqldim;
        List selAttrCopy;

        DimDesc(SQLDimension sqldim) {
            this.sqldim = sqldim;
            this.selAttrCopy = new ArrayList();
            this.selAttrCopy.addAll(sqldim.getAllSelectedAttributes());
        }
    }

    public class SQLDimension
    implements ID_ObjectPropertyTranslator {
        private Dimension dimension;
        private SQLAttribute longDescAttr;
        private SQLAttribute shortDescAttr;
        private SQLAttribute levelNameAttr;
        private SQLAttribute dimensionGIDAttr;
        private SQLAttribute dimensionIDAttr;
        private SQLAttribute endDateAttr;
        private SQLAttribute timeSpanAttr;
        private boolean selectedLongDescAttr;
        private boolean selectedShortDescAttr;
        private boolean selectedLevelNameAttr;
        private boolean selectedDimensionID = true;
        private boolean selectedEndDate;
        private boolean selectedTimeSpan;
        private List selectedDescriptiveAttributes = new ArrayList();
        private List selectedNoneDescriptiveAttributes = new ArrayList();
        private List allDescriptiveAttributes = new ArrayList();
        private List selectedSQLHierarhies = new ArrayList();
        private List allSQLHierarchies = new ArrayList();
        private List allSelectedAttributes = new ArrayList();
        private SQLAccessToAW sqlawObject;
        private String dimensionID;

        public SQLDimension(Dimension dimension, SQLAccessToAW sqlaw) {
            this.dimension = dimension;
            this.sqlawObject = sqlaw;
        }

        public SQLDimension(SQLAccessToAW sqlaw) {
            this.sqlawObject = sqlaw;
        }

        public String getName() {
            return this.dimension.getName().replaceAll(" ", "_");
        }

        public SQLHierarchy createSQLHierarchy() {
            return new SQLHierarchy(this.sqlawObject);
        }

        public void makeCopyTo(SQLDimension sqld) {
            sqld.dimension = this.dimension;
            sqld.setSelectedDimensionID(this.isSelectedDimensionID());
            sqld.setSelectedShortDescAttr(this.isSelectedShortDescAttr());
            sqld.setSelectedLongDescAttr(this.isSelectedLongDescAttr());
            sqld.setSelectedLevelNameAttr(this.isSelectedLevelNameAttr());
            sqld.setSelectedEndDate(this.isSelectedEndDate());
            sqld.setSelectedTimeSpan(this.isSelectedTimeSpan());
            sqld.selectedDescriptiveAttributes.clear();
            sqld.selectedDescriptiveAttributes.addAll(this.selectedDescriptiveAttributes);
            sqld.allDescriptiveAttributes.clear();
            sqld.allDescriptiveAttributes.addAll(this.allDescriptiveAttributes);
            sqld.selectedSQLHierarhies.clear();
            sqld.selectedNoneDescriptiveAttributes.clear();
            sqld.selectedNoneDescriptiveAttributes.addAll(this.selectedNoneDescriptiveAttributes);
            for (SQLHierarchy sqlh : this.selectedSQLHierarhies) {
                SQLAccessToAW sQLAccessToAW = this.getSqlawObject();
                Objects.requireNonNull(sQLAccessToAW);
                SQLHierarchy sqlhc = sQLAccessToAW.new SQLHierarchy(sqlh.getHierarchy());
                sqlh.makeCopyTo(sqlhc);
                sqld.selectedSQLHierarhies.add(sqlhc);
            }
            sqld.verifyHierarchies();
            sqld.verifyNoneDescAttributes();
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public SQLAttribute getLevelNameAttr() {
            if (this.levelNameAttr == null) {
                this.levelNameAttr = new SQLAttribute(ATTR_TYPE_LEVEL_NAME, this.dimension.getName().replaceAll(" ", "_") + "Level_Name", this.dimension);
            }
            return this.levelNameAttr;
        }

        public SQLAttribute getLongDescAttr() {
            if (this.longDescAttr == null) {
                this.longDescAttr = new SQLAttribute(ATTR_TYPE_LONG_DESC, this.dimension.getName().replaceAll(" ", "_") + "Long_DSC", this.dimension);
            }
            return this.longDescAttr;
        }

        public SQLAttribute getShortDescAttr() {
            if (this.shortDescAttr == null) {
                this.shortDescAttr = new SQLAttribute(ATTR_TYPE_SHORT_DESC, this.dimension.getName().replaceAll(" ", "_") + "Short_DSC", this.dimension);
            }
            return this.shortDescAttr;
        }

        public SQLAttribute getEndDateAttr() {
            if (this.endDateAttr == null) {
                this.endDateAttr = new SQLAttribute(ATTR_TYPE_END_DATE, this.dimension.getName().replaceAll(" ", "_") + "End_Date", this.dimension);
            }
            return this.endDateAttr;
        }

        public SQLAttribute getTimeSpanAttr() {
            if (this.timeSpanAttr == null) {
                this.timeSpanAttr = new SQLAttribute(ATTR_TYPE_TIME_SPAN, this.dimension.getName().replaceAll(" ", "_") + "Time_Span", this.dimension);
            }
            return this.timeSpanAttr;
        }

        public boolean isSelectedLevelNameAttr() {
            return this.selectedLevelNameAttr;
        }

        public void setSelectedLevelNameAttr(boolean selected) {
            this.selectedLevelNameAttr = selected;
        }

        public boolean isSelectedLongDescAttr() {
            return this.selectedLongDescAttr;
        }

        public void setSelectedLongDescAttr(boolean selected) {
            this.selectedLongDescAttr = selected;
        }

        public boolean isSelectedShortDescAttr() {
            return this.selectedShortDescAttr;
        }

        public void setSelectedShortDescAttr(boolean selected) {
            this.selectedShortDescAttr = selected;
        }

        public List getSelectedDescriptiveAttributes() {
            return this.selectedDescriptiveAttributes;
        }

        public List getSelectedSQLHierarhies() {
            return this.selectedSQLHierarhies;
        }

        public SQLAttribute getDimensionGIDAttr() {
            if (this.dimensionGIDAttr == null) {
                this.dimensionGIDAttr = new SQLAttribute(ATTR_TYPE_DIMENSION_GID, this.dimension.getName().replaceAll(" ", "_") + "_GID", this.dimension);
            }
            return this.dimensionGIDAttr;
        }

        private void verifyHierarchies() {
            ArrayList selhierscopy = new ArrayList();
            selhierscopy.addAll(this.selectedSQLHierarhies);
            this.selectedSQLHierarhies.clear();
            for (SQLHierarchy sqlh : selhierscopy) {
                Hierarchy hier = (Hierarchy)this.dimension.getHierarchies().getObjectByID(sqlh.getHierarchy().getObjectID());
                if (hier == null) continue;
                this.selectedSQLHierarhies.add(sqlh);
            }
            ArrayList allhierscopy = new ArrayList();
            allhierscopy.addAll(this.allSQLHierarchies);
            this.allSQLHierarchies.clear();
            for (Hierarchy hier : this.dimension.getHierarchies()) {
                SQLHierarchy sqlh = SQLAccessToAW.this.getSQLHierarchyFor(allhierscopy, hier);
                if (sqlh == null) {
                    sqlh = SQLAccessToAW.this.getSQLHierarchyFor(this.selectedSQLHierarhies, hier);
                }
                if (sqlh == null) {
                    sqlh = new SQLHierarchy(hier);
                }
                this.allSQLHierarchies.add(sqlh);
            }
        }

        private void verifyNoneDescAttributes() {
            SQLAttribute sqla;
            ArrayList noneDescrCopy = new ArrayList();
            List outAttrs = this.getSqlawObject().getOutSQLAttributes();
            noneDescrCopy.addAll(this.selectedNoneDescriptiveAttributes);
            this.selectedNoneDescriptiveAttributes.clear();
            if (this.isSelectedDimensionID()) {
                sqla = SQLAccessToAW.this.getIDColumnForDimension(outAttrs, this.getDimension());
                if (sqla == null) {
                    sqla = SQLAccessToAW.this.getIDColumnForDimension(noneDescrCopy, this.getDimension());
                }
                if (sqla != null) {
                    this.selectedNoneDescriptiveAttributes.add(sqla);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getDimensionIDAttr());
                }
            }
            if (SQLAccessToAW.this.isGenerateGIDs() && this.selectedSQLHierarhies.size() > 0) {
                sqla = SQLAccessToAW.this.getGIDForDimension(noneDescrCopy, this.getDimension());
                if (sqla != null) {
                    this.selectedNoneDescriptiveAttributes.add(sqla);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getDimensionGIDAttr());
                }
            }
            if (this.isSelectedLevelNameAttr()) {
                sqla = SQLAccessToAW.this.getSQLLevelNameAttr(noneDescrCopy, this.getDimension());
                if (sqla != null) {
                    this.selectedNoneDescriptiveAttributes.add(sqla);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getLevelNameAttr());
                }
            }
            if (this.isSelectedShortDescAttr()) {
                sqla = SQLAccessToAW.this.getSQLShortDescAttr(noneDescrCopy, this.getDimension());
                if (sqla != null) {
                    this.selectedNoneDescriptiveAttributes.add(sqla);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getShortDescAttr());
                }
            }
            if (this.isSelectedLongDescAttr()) {
                sqla = SQLAccessToAW.this.getSQLLongDescAttr(noneDescrCopy, this.getDimension());
                if (sqla != null) {
                    this.selectedNoneDescriptiveAttributes.add(sqla);
                } else {
                    this.selectedNoneDescriptiveAttributes.add(this.getLongDescAttr());
                }
            }
            if (this.getDimension().isTimeDimension()) {
                if (this.isSelectedEndDate()) {
                    sqla = SQLAccessToAW.this.getSQLEndDateAttr(noneDescrCopy, this.getDimension());
                    if (sqla != null) {
                        this.selectedNoneDescriptiveAttributes.add(sqla);
                    } else {
                        this.selectedNoneDescriptiveAttributes.add(this.getEndDateAttr());
                    }
                }
                if (this.isSelectedTimeSpan()) {
                    sqla = SQLAccessToAW.this.getSQLTimeSpanAttr(noneDescrCopy, this.getDimension());
                    if (sqla != null) {
                        this.selectedNoneDescriptiveAttributes.add(sqla);
                    } else {
                        this.selectedNoneDescriptiveAttributes.add(this.getTimeSpanAttr());
                    }
                }
            }
            for (SQLHierarchy sqlh : this.selectedSQLHierarhies) {
                if (!sqlh.isRollupForm()) continue;
                List slevels = sqlh.getValidSelLevels();
                for (Level level : slevels) {
                    SQLAttribute sqla2 = SQLAccessToAW.this.getSQLAttributeFor(noneDescrCopy, sqlh.getHierarchy(), level);
                    if (sqla2 == null) {
                        sqla2 = new SQLAttribute(level.getName().replaceAll(" ", "_"), this.dimension, sqlh.getHierarchy(), level);
                    }
                    this.selectedNoneDescriptiveAttributes.add(sqla2);
                }
            }
        }

        private void verifyDescAttributes() {
            ArrayList selDescAttr_Copy = new ArrayList();
            selDescAttr_Copy.addAll(this.selectedDescriptiveAttributes);
            this.selectedDescriptiveAttributes.clear();
            ArrayList allDescAttr_Copy = new ArrayList();
            allDescAttr_Copy.addAll(this.allDescriptiveAttributes);
            this.allDescriptiveAttributes.clear();
            for (Level level : this.dimension.getAllLevels()) {
                for (SlowChangingAttribute sca : level.getSlowChangingAttributes()) {
                    SQLAttribute sqla = SQLAccessToAW.this.getSQLAttributeFor(selDescAttr_Copy, level, sca);
                    if (sqla != null) {
                        this.selectedDescriptiveAttributes.add(sqla);
                        this.allDescriptiveAttributes.add(sqla);
                        continue;
                    }
                    sqla = SQLAccessToAW.this.getSQLAttributeFor(allDescAttr_Copy, level, sca);
                    if (sqla == null) {
                        sqla = new SQLAttribute(sca.getName().replaceAll(" ", "_"), this.dimension, level, sca);
                    }
                    this.allDescriptiveAttributes.add(sqla);
                }
            }
        }

        public void verifyAttributes() {
            this.verifyHierarchies();
            this.verifyNoneDescAttributes();
            this.verifyDescAttributes();
        }

        public List getAllSelectedAttributes() {
            this.allSelectedAttributes.clear();
            this.allSelectedAttributes.addAll(this.selectedNoneDescriptiveAttributes);
            this.allSelectedAttributes.addAll(this.selectedDescriptiveAttributes);
            return this.allSelectedAttributes;
        }

        public SQLAttribute getDimensionIDAttr() {
            if (this.dimensionIDAttr == null) {
                this.dimensionIDAttr = new SQLAttribute(ATTR_TYPE_DIMENSION_ID, this.dimension.getName().replaceAll(" ", "_") + "_id", this.dimension);
            }
            return this.dimensionIDAttr;
        }

        public boolean isSelectedDimensionID() {
            return this.selectedDimensionID;
        }

        public void setSelectedDimensionID(boolean selectedDimensionID) {
            this.selectedDimensionID = selectedDimensionID;
        }

        public List getAllDescriptiveAttributes() {
            return this.allDescriptiveAttributes;
        }

        public String toString() {
            return this.dimension.getName();
        }

        public List getAllSQLHierarchies() {
            return this.allSQLHierarchies;
        }

        public SQLAccessToAW getSqlawObject() {
            return this.sqlawObject;
        }

        public boolean isSelectedEndDate() {
            return this.selectedEndDate;
        }

        public void setSelectedEndDate(boolean selectedEndDate) {
            this.selectedEndDate = selectedEndDate;
        }

        public boolean isSelectedTimeSpan() {
            return this.selectedTimeSpan;
        }

        public void setSelectedTimeSpan(boolean selectedTimeSpan) {
            this.selectedTimeSpan = selectedTimeSpan;
        }

        public String getDimensionID() {
            return this.dimensionID;
        }

        public void setDimensionID(String dimensionID) {
            this.dimensionID = dimensionID;
        }

        public SQLAttribute createSQLAttribute() {
            SQLAttribute sqla = new SQLAttribute(this.sqlawObject);
            sqla.setDimension(this.getDimension());
            return sqla;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            return this.sqlawObject.translateIdToObject(propertyName, id);
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            return this.sqlawObject.translateObjectToID(propertyName, object);
        }

        public void applySQLAttributes(List attributes) {
            List selList = this.getAllSelectedAttributes();
            for (SQLAttribute sqla : attributes) {
                String type = sqla.getType();
                if (ATTR_TYPE_SHORT_DESC.equals(type)) {
                    this.setSelectedShortDescAttr(true);
                    this.shortDescAttr = sqla;
                } else if (ATTR_TYPE_LONG_DESC.equals(type)) {
                    this.setSelectedLongDescAttr(true);
                    this.longDescAttr = sqla;
                } else if (ATTR_TYPE_END_DATE.equals(type)) {
                    this.setSelectedEndDate(true);
                    this.endDateAttr = sqla;
                } else if (ATTR_TYPE_TIME_SPAN.equals(type)) {
                    this.setSelectedTimeSpan(true);
                    this.timeSpanAttr = sqla;
                } else if (ATTR_TYPE_LEVEL_NAME.equals(type)) {
                    this.setSelectedLevelNameAttr(true);
                    this.levelNameAttr = sqla;
                } else if (ATTR_TYPE_DIMENSION_ID.equals(type)) {
                    this.setSelectedDimensionID(true);
                    this.dimensionIDAttr = sqla;
                } else if (ATTR_TYPE_DIMENSION_GID.equals(type)) {
                    this.dimensionGIDAttr = sqla;
                }
                selList.add(sqla);
            }
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
        }
    }

    public class SQLHierarchy
    implements ID_ObjectPropertyTranslator {
        private List selectedLevels = new ArrayList();
        private Hierarchy hierarchy;
        private SQLAttribute labelAttribute;
        private boolean rollupForm;
        private String hierarchyID = "";
        private SQLAccessToAW sqlawObject;

        public SQLHierarchy(Hierarchy hierarchy) {
            this.hierarchy = hierarchy;
        }

        public SQLHierarchy(SQLAccessToAW sqlawObject) {
            this.sqlawObject = sqlawObject;
        }

        public SQLHierarchy(String hierarchyID) {
            this.hierarchyID = hierarchyID;
        }

        public Hierarchy getHierarchy() {
            if (this.hierarchy == null) {
                this.hierarchy = (Hierarchy)SQLAccessToAW.this.getMultidimensionalDesign().getHierarchySet().getObjectByID(this.hierarchyID);
            }
            return this.hierarchy;
        }

        public String getHierarchyID() {
            return this.hierarchyID;
        }

        public boolean isLevelSelected(Level level) {
            return this.selectedLevels.contains(level);
        }

        public void setLevelSelection(Level level, boolean selected) {
            if (selected && !this.selectedLevels.contains(level)) {
                this.selectedLevels.add(level);
            } else if (!selected) {
                this.selectedLevels.remove(level);
            }
        }

        public SQLAttribute getLabelAttribute() {
            return this.labelAttribute;
        }

        public void setLabelAttribute(SQLAttribute labelAttribute) {
            this.labelAttribute = labelAttribute;
        }

        public SQLAttribute createLabelAttribute() {
            if (this.sqlawObject == null) {
                this.sqlawObject = SQLAccessToAW.this;
            }
            this.labelAttribute = new SQLAttribute(this.sqlawObject);
            return this.labelAttribute;
        }

        public void removeLabelAttribute() {
            this.labelAttribute = null;
        }

        public String toString() {
            return this.getHierarchy().getName();
        }

        public SQLHierarchy makeCopy() {
            SQLHierarchy sqlh = new SQLHierarchy(this.getHierarchy());
            sqlh.labelAttribute = this.labelAttribute;
            sqlh.setRollupForm(this.isRollupForm());
            sqlh.selectedLevels.addAll(this.getValidSelLevels());
            return sqlh;
        }

        public SQLHierarchy makeCopyTo(SQLHierarchy sqlh) {
            sqlh.labelAttribute = this.labelAttribute;
            sqlh.setRollupForm(this.isRollupForm());
            sqlh.selectedLevels.addAll(this.getValidSelLevels());
            return sqlh;
        }

        public boolean isRollupForm() {
            return this.rollupForm;
        }

        public void setRollupForm(boolean rollupForm) {
            this.rollupForm = rollupForm;
        }

        public List getValidSelLevels() {
            List hierList = this.getHierarchy().getLevels();
            ArrayList temp = new ArrayList();
            temp.addAll(this.selectedLevels);
            this.selectedLevels.clear();
            for (Level level : temp) {
                if (!hierList.contains(level)) continue;
                this.selectedLevels.add(level);
            }
            return this.selectedLevels;
        }

        public List getSelectedLevels() {
            return this.selectedLevels;
        }

        public void setHierarchyID(String hierarchyID) {
            this.hierarchyID = hierarchyID;
        }

        @Override
        public Object translateIdToObject(String propertyName, String id) {
            return this.sqlawObject.translateIdToObject(propertyName, id);
        }

        @Override
        public String translateObjectToID(String propertyName, Object object) {
            return this.sqlawObject.translateObjectToID(propertyName, object);
        }
    }
}

