/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OracleModelSelector
extends CustomDialog {
    private File logicalFile = null;
    private JDialog dialog;
    private boolean result;
    private DefaultListModel listModel;
    private static final int FIELD_WIDTH = 220;
    private static final int FIELD_HEIGHT = 20;
    private JComboBox cbRelDes;
    private JComboBox cbStorage;
    private Design design;
    private RelationalDesign physicalDesign;
    private StorageDesign storageDesign;
    private MultidimensionalDesign mdm;
    private String schema = "";
    JButton okButton;

    public OracleModelSelector(ApplicationView appView, MultidimensionalDesign mdm) {
        super(appView);
        this.mdm = mdm;
        this.design = appView.getCurrentDesign();
        this.init();
    }

    private void init() {
        this.okButton = new JButton(Messages.getString("OracleModelSelector.OK"));
        this.okButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleModelSelector.this.result = true;
                OracleModelSelector.this.physicalDesign = (RelationalDesign)OracleModelSelector.this.cbRelDes.getSelectedItem();
                OracleModelSelector.this.storageDesign = (StorageDesign)OracleModelSelector.this.cbStorage.getSelectedItem();
                if (OracleModelSelector.this.result) {
                    OracleModelSelector.this.dialog.dispose();
                }
            }
        });
        JButton cancelButton = new JButton(Messages.getString("OracleModelSelector.Cancel"));
        cancelButton.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleModelSelector.this.result = false;
                OracleModelSelector.this.dialog.dispose();
            }
        });
        JPanel bottom = new JPanel();
        bottom.add(this.okButton);
        bottom.add(cancelButton);
        JPanel modelsPanel = new JPanel(new SpringLayout());
        modelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OracleModelSelector.Model")));
        JLabel lbRelD = new JLabel(Messages.getString("OracleModelSelector.RelationalModel"));
        ArrayList rlist = new ArrayList();
        this.design.getRelationalDesigns().addAllElementsTo(rlist);
        lbRelD.setPreferredSize(new Dimension(150, 20));
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setPreferredSize(new Dimension(220, 20));
        this.cbStorage = new JComboBox();
        this.cbStorage.setFont(this.cbRelDes.getFont().deriveFont(0));
        this.cbStorage.setPreferredSize(new Dimension(220, 20));
        if (this.mdm.getBoundModel() != null && this.mdm.getBoundModel() instanceof RelationalDesign) {
            this.cbRelDes.setSelectedItem(this.mdm.getBoundModel());
            this.cbRelDes.setEnabled(false);
        }
        this.cbRelDes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object ob = OracleModelSelector.this.cbRelDes.getSelectedItem();
                if (ob != null && ob instanceof RelationalDesign) {
                    RelationalDesign phd = (RelationalDesign)ob;
                    ArrayList<StorageDesign> rlist = new ArrayList<StorageDesign>();
                    StorageDesign[] stds = phd.getStorageDesignFactory().getOpenStorageDesigns();
                    for (int i = 0; i < stds.length; ++i) {
                        StorageDesign sd = stds[i];
                        if (!(sd instanceof StorageDesignOracle)) continue;
                        rlist.add(sd);
                    }
                    OracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(rlist.toArray()));
                    if (rlist.size() > 0) {
                        OracleModelSelector.this.okButton.setEnabled(true);
                    } else {
                        OracleModelSelector.this.okButton.setEnabled(false);
                    }
                } else if (ob == null) {
                    OracleModelSelector.this.cbStorage.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
                }
            }
        });
        if (rlist.size() > 0) {
            this.cbRelDes.setSelectedItem(rlist.get(0));
        }
        JLabel lbStoreD = new JLabel(Messages.getString("OracleModelSelector.PhysicalOracleModel"));
        lbStoreD.setPreferredSize(new Dimension(150, 20));
        modelsPanel.add(lbRelD);
        modelsPanel.add(this.cbRelDes);
        modelsPanel.add(lbStoreD);
        modelsPanel.add(this.cbStorage);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), lbRelD, 5, 5);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), this.cbRelDes, 180, 5);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), lbStoreD, 5, 30);
        CommonUtil.setObjectConstraints((SpringLayout)modelsPanel.getLayout(), this.cbStorage, 180, 30);
        this.add((Component)modelsPanel, "Center");
        this.add((Component)bottom, "South");
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    public File getLogicalFile() {
        return this.logicalFile;
    }

    public Object[] getRelationalFiles() {
        return this.listModel.toArray();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.physicalDesign;
    }

    public String getSchema() {
        return this.schema;
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return this.mdm;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("OracleModelSelector.SelectOracleModel"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setPreferredSize(new Dimension(420, 140));
            this.dialog.getContentPane().add(this);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }
}

