/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class Logger {
    private PrintWriter writer = null;
    private boolean verbose = true;

    public Logger() {
    }

    public Logger(PrintWriter out) {
        this.setWriter(out);
    }

    public Logger(Writer out) {
        this(new PrintWriter(out));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public void setWriter(PrintWriter writer) {
        this.close();
        this.writer = writer;
    }

    public void setWriter(PrintStream os) {
        this.setWriter(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os))));
    }

    protected void initWriter() {
        if (this.writer == null) {
            this.setWriter(System.out);
        }
    }

    public void println(String message) {
        this.initWriter();
        this.writer.println(message);
    }

    public void print(String message) {
        this.initWriter();
        this.writer.print(message);
    }

    public void println() {
        this.initWriter();
        this.writer.println();
    }

    public void showInfo(String message) {
        if (this.isVerbose()) {
            this.initWriter();
            this.writer.println(message);
        }
    }

    public void showError(String message) {
        this.initWriter();
        this.writer.print("ERROR: ");
        this.writer.println(message);
    }

    public void close() {
        if (null != this.writer) {
            this.writer.flush();
            this.writer = null;
        }
    }
}

