/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.multidimensional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;

public class LinkSet
extends DesignObjectSet {
    private static final Object[] PROTO_TYPE = new Link[0];

    public LinkSet(DesignPart designPart) {
        super(designPart);
    }

    public Link createLink(String oldID) {
        Link link = new Link(this.getDesignPart());
        link.setObjectID(oldID);
        link.setDesign(this.getDesign());
        link.setParent(this);
        this.getDesign().addDesignObject(link);
        this.add(link);
        return link;
    }

    public Link createLink(String oldID, RollupLink rollupLink) {
        Link link = new Link(this.getDesignPart());
        link.setObjectID(oldID);
        link.setDesign(this.getDesign());
        link.setParent(this);
        link.setRollupLink(rollupLink);
        this.getDesign().addDesignObject(link);
        this.add(link);
        return link;
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTO_TYPE;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return "Link";
    }

    public Collection getLinksToSource(AbstractMDObject source) {
        ArrayList<Link> col = new ArrayList<Link>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (link.getSourceMDObject() != source) continue;
            col.add(link);
        }
        return col;
    }

    public Collection getLinksToTarget(AbstractMDObject target) {
        ArrayList<Link> col = new ArrayList<Link>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (link.getTargetMDObject() != target) continue;
            col.add(link);
        }
        return col;
    }

    public Collection getLinksTo(AbstractMDObject object) {
        ArrayList<Link> col = new ArrayList<Link>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            if (link.getSourceMDObject() != object && link.getTargetMDObject() != object) continue;
            col.add(link);
        }
        return col;
    }
}

