/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.sqlserver;

import java.util.Map;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.SchemaSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.SequenceSqlServerv2k12;

public class SequenceSqlServerComparator
extends StoragePropertiesComparator {
    private SequenceSqlServerv2k12 sourceSequence;
    private SequenceSqlServerv2k12 targetSequence;

    public SequenceSqlServerComparator(StorageObject sourceSequence, StorageObject targetSequence) {
        super(sourceSequence, targetSequence);
        this.sourceSequence = (SequenceSqlServerv2k12)sourceSequence;
        this.targetSequence = (SequenceSqlServerv2k12)targetSequence;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentProperty();
        this.initNotesProperty();
        PropertyHolder ph = new PropertyHolder(DATABASE);
        String sd_name = "";
        String td_name = "";
        if (this.sourceSequence != null && this.sourceSequence.getDatabase() != null) {
            sd_name = this.sourceSequence.getDatabase().getName();
        }
        if (this.targetSequence != null && this.targetSequence.getDatabase() != null) {
            td_name = this.targetSequence.getDatabase().getName();
        }
        ph.setLeftValue(sd_name);
        ph.setRightValue(td_name);
        if (this.isExcludedFromComparison(DATABASE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !sd_name.equalsIgnoreCase(td_name)) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SCHEMA);
        String ss_name = "";
        String ts_name = "";
        if (this.sourceSequence != null && this.sourceSequence.getSchema() != null) {
            ss_name = this.sourceSequence.getSchema().getName();
        }
        if (this.targetSequence != null && this.targetSequence.getSchema() != null) {
            ts_name = this.targetSequence.getSchema().getName();
        }
        ph.setLeftValue(ss_name);
        ph.setRightValue(ts_name);
        if (this.isExcludedFromComparison(SCHEMA)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !ss_name.equalsIgnoreCase(ts_name)) {
            ph.setModified(true);
            if (this.useSchema) {
                ph.setSelected(true);
            } else {
                ph.setFiltered(true);
            }
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INTEGER_TYPE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getIntegerType() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getIntegerType() : "");
        if (this.isExcludedFromComparison(INTEGER_TYPE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getIntegerType().equals(this.targetSequence.getIntegerType())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(PRECISION);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getIntegerPrecision() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getIntegerPrecision() : "");
        if (this.isExcludedFromComparison(PRECISION)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getIntegerPrecision().equals(this.targetSequence.getIntegerPrecision())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(START_WITH);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getStartWith() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getStartWith() : "");
        if (this.isExcludedFromComparison(START_WITH)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getStartWith().equals(this.targetSequence.getStartWith())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(INCREMENT_BY);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getIncrementBy() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getIncrementBy() : "");
        if (this.isExcludedFromComparison(INCREMENT_BY)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getIncrementBy().equals(this.targetSequence.getIncrementBy())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MIN_VALUE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMinValue() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getMinValue() : "");
        if (this.isExcludedFromComparison(MIN_VALUE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMinValue().equals(this.targetSequence.getMinValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(MAX_VALUE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getMaxValue() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getMaxValue() : "");
        if (this.isExcludedFromComparison(MAX_VALUE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getMaxValue().equals(this.targetSequence.getMaxValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CYCLE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCycle() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getCycle() : "");
        if (this.isExcludedFromComparison(CYCLE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCycle().equals(this.targetSequence.getCycle())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(NOCACHE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getNoCache() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getNoCache() : "");
        if (this.isExcludedFromComparison(NOCACHE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getNoCache().equals(this.targetSequence.getNoCache())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(CACHE);
        ph.setLeftValue(this.sourceSequence != null ? this.sourceSequence.getCache() : "");
        ph.setRightValue(this.targetSequence != null ? this.targetSequence.getCache() : "");
        if (this.isExcludedFromComparison(CACHE)) {
            ph.setExcluded(true);
        } else if (this.sourceSequence != null && this.targetSequence != null && !this.sourceSequence.getCache().equals(this.targetSequence.getCache())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromSequenceToSequence();
    }

    private void copyPropertiesFromSequenceToSequence() {
        if (this.sourceSequence != null && this.targetSequence != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATABASE)) {
                    this.targetSequence.setDatabase(this.sourceSequence.getDatabase());
                    continue;
                }
                if (ph.getName().equals(SCHEMA)) {
                    Map objectsMap;
                    SchemaSqlServer targetSchema = null;
                    SchemaSqlServer sourceSchema = this.sourceSequence.getSchema();
                    if (sourceSchema != null && (objectsMap = this.targetSequence.getDesign().getCorrespondenceMap()) != null) {
                        targetSchema = (SchemaSqlServer)objectsMap.get(sourceSchema.getObjectID());
                    }
                    this.targetSequence.setSchema(targetSchema);
                    continue;
                }
                if (ph.getName().equals(INTEGER_TYPE)) {
                    this.targetSequence.setIntegerType(this.sourceSequence.getIntegerType());
                    continue;
                }
                if (ph.getName().equals(START_WITH)) {
                    this.targetSequence.setStartWith(this.sourceSequence.getStartWith());
                    continue;
                }
                if (ph.getName().equals(INCREMENT_BY)) {
                    this.targetSequence.setIncrementBy(this.sourceSequence.getIncrementBy());
                    continue;
                }
                if (ph.getName().equals(MIN_VALUE)) {
                    this.targetSequence.setMinValue(this.sourceSequence.getMinValue());
                    continue;
                }
                if (ph.getName().equals(MAX_VALUE)) {
                    this.targetSequence.setMaxValue(this.sourceSequence.getMaxValue());
                    continue;
                }
                if (ph.getName().equals(CYCLE)) {
                    this.targetSequence.setCycle(this.sourceSequence.getCycle());
                    continue;
                }
                if (ph.getName().equals(NOCACHE)) {
                    this.targetSequence.setNoCache(this.sourceSequence.getNoCache());
                    continue;
                }
                if (!ph.getName().equals(CACHE)) continue;
                this.targetSequence.setCache(this.sourceSequence.getCache());
            }
        }
    }

    public SequenceSqlServerv2k12 getSequenceForProperty(String propertyName) {
        if (this.isTargetSelected(propertyName)) {
            return this.targetSequence;
        }
        return this.sourceSequence;
    }
}

