/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class TypeElementComparator
extends PropertiesComparator {
    private TypeElement source;
    private TypeElement target;
    private CompareCWDDesigns selectionObject;

    public TypeElementComparator(TypeElement source, TypeElement target) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder ph = new PropertyHolder(DATA_TYPE);
        ph.setDDLHolder(true);
        ph.setLeftValue(this.source != null ? this.source.getDataType() : "");
        ph.setRightValue(this.target != null ? this.target.getDataType() : "");
        if (this.isExcludedFromComparison(DATA_TYPE)) {
            ph.setExcluded(true);
        } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        if (!DDL_ONLY) {
            ph = new PropertyHolder(MANDATORY);
            ph.setLeftValue(this.source != null ? String.valueOf(this.source.isMandatory()) : "");
            ph.setRightValue(this.target != null ? String.valueOf(this.target.isMandatory()) : "");
            if (this.isExcludedFromComparison(MANDATORY)) {
                ph.setExcluded(true);
            } else if (this.source != null && this.target != null && !ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
            this.propertiesList.add(ph);
            this.initCommentsAndNotes(false);
        }
        this.initDynamicProperties();
    }

    @Override
    public void copySelectedProperties() {
        if (this.source != null && this.target != null) {
            this.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(DATA_TYPE)) {
                    MergingCWDDesigns.copyDataTypeFromDTO_To_DTO(this.source, this.target);
                    continue;
                }
                if (!ph.getName().equals(MANDATORY)) continue;
                this.target.setMandatory(this.source.isMandatory());
            }
        }
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }
}

