/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.CandidateKey;

public class KeyComparator
extends PropertiesComparator {
    private CandidateKey source;
    private CandidateKey target;
    private Map objectsMap;
    private CompareCWDDesigns selectionObject;

    public KeyComparator(CandidateKey source, CandidateKey target, Map objectsMap) {
        super(source, target);
        this.source = source;
        this.target = target;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initPropertiesFilterList();
        PropertyHolder ph = new PropertyHolder(ATTRIBUTES);
        ph.setLeftValue(source != null ? this.getElementsToString(source) : "");
        ph.setRightValue(target != null ? this.getElementsToString(target) : "");
        if (this.isExcludedFromComparison(ATTRIBUTES)) {
            ph.setExcluded(true);
        } else if (target != null && source != null && !MergingModels.haveIdenticalColumnsAndSortType(source, target, objectsMap, false)) {
            ph.setModified(true);
            ph.setSelected(true);
            ph.setEditable(false);
        }
        this.propertiesList.add(ph);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromKeyToKey();
    }

    private void copyPropertiesFromKeyToKey() {
        if (this.target != null && this.source != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected() || !ph.getName().equals(ATTRIBUTES)) continue;
                MergingModels.synchronizeColumnsFromIndexToKey(this.source, this.target);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? this.source.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? this.target.getLongName() : "";
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns selectionObject) {
        this.selectionObject = selectionObject;
    }

    private String getElementsToString(CandidateKey keyObject) {
        StringBuffer sb = new StringBuffer();
        Iterator it = keyObject.getElementsCollection().iterator();
        boolean first = true;
        while (it.hasNext()) {
            ContainedObject co = (ContainedObject)it.next();
            if (keyObject.isPK() || keyObject.isUnique()) {
                if (first) {
                    sb.append(co.getName());
                    first = false;
                    continue;
                }
                sb.append(" \n").append(co.getName());
                continue;
            }
            if (first) {
                sb.append(co.getName());
                first = false;
                continue;
            }
            sb.append(" \n").append(co.getName());
        }
        return sb.toString();
    }
}

