/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.Map;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.ImpliedForeignKey;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ImpliedFKComparator
extends PropertiesComparator {
    public static final String RELY = ImpliedFKComparator.removeColon(Messages.getString("ForeignKeyPropertiesDialogEx.Rely"));
    private ImpliedForeignKey lfk;
    private ImpliedForeignKey rfk;
    private Map objectsMap;

    public ImpliedFKComparator(ImpliedForeignKey left_fk, ImpliedForeignKey right_fk, Map objectsMap) {
        super(left_fk, right_fk);
        this.lfk = left_fk;
        this.rfk = right_fk;
        this.objectsMap = objectsMap;
        this.initPropertiesList();
        this.initDynamicProperties();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        PropertyHolder ph = new PropertyHolder(NAME);
        ph.setLeftValue(this.lfk != null ? this.lfk.getName() : "");
        ph.setRightValue(this.rfk != null ? this.rfk.getName() : "");
        ph.setDDLHolder(false);
        if (this.isExcludedFromComparison(NAME) || this.isExcludeNamesFromComparison(ph)) {
            ph.setExcluded(true);
        } else if (this.caseSensitive) {
            if (!ph.getLeftValue().equals(ph.getRightValue())) {
                ph.setModified(true);
                ph.setSelected(true);
            }
        } else if (!ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COMMENT);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? this.lfk.getComment() : "");
        ph.setRightValue(this.rfk != null ? this.rfk.getComment() : "");
        if (this.isExcludedFromComparison(COMMENT)) {
            ph.setExcluded(true);
        } else if (this.lfk != null && this.rfk != null && !this.isEqualClearLine(this.lfk.getComment(), this.rfk.getComment())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(REFERRED_OBJECT);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? this.lfk.getReferredTableLongName() : "");
        ph.setRightValue(this.rfk != null ? this.rfk.getReferredTableLongName() : "");
        if (this.isExcludedFromComparison(REFERRED_OBJECT)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(REFERRED_COLUMNS);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? ImpliedFKComparator.getReferredColumnNames(this.lfk) : "");
        ph.setRightValue(this.rfk != null ? ImpliedFKComparator.getReferredColumnNames(this.rfk) : "");
        if (this.isExcludedFromComparison(REFERRED_COLUMNS)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(!this.areListsWithSameMembers(ph.getLeftValue(), ph.getRightValue()));
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(COLUMN_ASSOCIATION);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? this.getElementsToString(this.lfk) : "");
        ph.setRightValue(this.rfk != null ? this.getElementsToString(this.rfk) : "");
        if (this.isExcludedFromComparison(COLUMN_ASSOCIATION)) {
            ph.setExcluded(true);
        } else if (this.rfk != null && this.lfk != null && !ph.getLeftValue().equalsIgnoreCase(ph.getRightValue())) {
            ph.setModified(true);
            ph.setSelected(!this.areListsWithSameMembers(ph.getLeftValue(), ph.getRightValue()));
        }
        this.propertiesList.add(ph);
        ph = new PropertyHolder(SOURCE);
        ph.setDDLHolder(false);
        ph.setLeftValue(this.lfk != null ? this.lfk.getDiscoverySources() : "");
        ph.setRightValue(this.rfk != null ? this.rfk.getDiscoverySources() : "");
        if (this.isExcludedFromComparison(SOURCE)) {
            ph.setExcluded(true);
        } else if (this.lfk != null && this.rfk != null && !this.isEqualClearLine(this.lfk.getDiscoverySources(), this.rfk.getDiscoverySources())) {
            ph.setModified(true);
            ph.setSelected(true);
        }
        this.propertiesList.add(ph);
    }

    static String getReferredColumnNames(ImpliedForeignKey fk) {
        String res = fk.getReferredColumnName();
        if (res == null) {
            return "";
        }
        return res;
    }

    private boolean areListsWithSameMembers(String left, String right) {
        String[] rparts;
        String[] lparts = left.split(",");
        if (lparts.length != (rparts = right.split(",")).length) {
            return false;
        }
        for (String ls : lparts) {
            String l = ls.trim();
            boolean found = false;
            for (String rs : rparts) {
                String r = rs.trim();
                if (!l.equalsIgnoreCase(r)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private String getElementsToString(ImpliedForeignKey fk) {
        String res = fk.getLocalColumnName();
        if (res == null) {
            return "";
        }
        return res;
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromLeftFK();
    }

    private void copyPropertiesFromLeftFK() {
        if (this.rfk != null && this.lfk != null) {
            for (EngPropertyHolder ph : this.propertiesList) {
                if (!ph.isSelected()) continue;
                if (ph.getName().equals(COLUMN_ASSOCIATION)) {
                    this.syncLocalColumns();
                    continue;
                }
                if (ph.getName().equals(REFERRED_OBJECT)) {
                    this.syncReferredObject();
                    continue;
                }
                if (ph.getName().equals(REFERRED_COLUMNS)) {
                    this.syncReferredColumns();
                    continue;
                }
                if (!ph.getName().equals(SOURCE)) continue;
                this.rfk.setDiscoverySources(this.lfk.getDiscoverySources());
            }
        }
    }

    private void syncLocalColumns() {
        FKElement col = this.lfk.getLocalColumn();
        if (col != null) {
            FKElement tcol = (FKElement)this.getTargetObject(col);
            this.rfk.setLocalColumn(tcol);
        }
    }

    private void syncReferredObject() {
        FKContainer col = this.lfk.getRemoteTable();
        if (col != null) {
            FKContainer tcol = (FKContainer)this.getTargetObject(col);
            this.rfk.setRemoteTable(tcol);
        }
    }

    private void syncReferredColumns() {
        FKElement col = this.lfk.getReferredColumn();
        if (col != null) {
            FKElement tcol = (FKElement)this.getTargetObject(col);
            this.rfk.setReferredColumn(tcol);
        }
    }

    private DesignObject getTargetObject(DesignObject dobj) {
        ContainedObject targetObject = (ContainedObject)this.objectsMap.get(dobj.getObjectID());
        return targetObject;
    }

    @Override
    public String getLeftName() {
        return this.lfk != null ? this.lfk.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.rfk != null ? this.rfk.getLongName() : "";
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.lfk == null && this.rfk != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

