/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class AbstractMerging {
    protected Design design;
    protected DesignPartView processedDPV;
    protected String targetDesPartID;
    protected Map comparatorsMap;
    protected static Map physComparatorsMap;
    protected static Map objectsMap;

    public AbstractMerging(Design design) {
        this.design = design;
    }

    public DesignObject[] getProcessedObjects(DesignObjectSet set) {
        if (this.processedDPV == null || this.processedDPV == this.processedDPV.getDesignPart().getMainView()) {
            return (DesignObject[])set.toArray();
        }
        ArrayList<DesignObject> col = new ArrayList<DesignObject>();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            if (!dobj.hasRepresentationInDPV(this.processedDPV)) continue;
            col.add(dobj);
        }
        return col.toArray(set.getProtoArray());
    }

    public void setGraphicalPropertiesOnNewObject(ContainerObject oldObject, ContainerObject newObject) {
        ApplicationView view = oldObject.getDesign().getAppView();
        if (view != null) {
            view.setGraphicalPropsFor(newObject, view.getGraphicalPropsFor(oldObject));
        }
    }

    public boolean isModified(XtdMapping mapping, DesignObject object) {
        return mapping.getOwnerObject().getChange().getTime() > mapping.getCreationTime();
    }

    public boolean isModified(XtdMapping mapping) {
        long delta = 2000L;
        return mapping.getOwnerObject().getChange().getTime() > mapping.getCreationTime() + delta || mapping.getTargetObject().getChange().getTime() > mapping.getCreationTime() + delta;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public static Map getPhysComparatorsMap() {
        return physComparatorsMap;
    }

    public static void setObjectsMap(Map objectsMap) {
        AbstractMerging.objectsMap = objectsMap;
    }

    public static Map getObjectsMap() {
        return objectsMap;
    }
}

