/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.LegendPropertiesDialog;
import oracle.dbtools.crest.util.logging.Logger;

public class Legend
extends MultiShapedDesignObject
implements EditableFonts {
    public static final int ATTRIBUTE_AUTHOR = 2;
    public static final int ATTRIBUTE_CREATED_ON = 4;
    public static final int ATTRIBUTE_MODIFIED_ON = 8;
    public static final int ATTRIBUTE_CHANGED_BY = 16;
    public static final int ATTRIBUTE_DESIGN = 32;
    public static final int ATTRIBUTE_MODEL = 64;
    public static final int ALL_ATTRIBUTES = 126;
    private static final Logger LOGGER = new Logger(Legend.class);
    public static final String TYPE_NAME = "Legend";
    private DesignPartView dpv;

    public Legend(DesignPartView dpv) {
        super(dpv.getDesignPart());
        this.dpv = dpv;
    }

    @Override
    public String getFCObjectType() {
        return TYPE_NAME;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    private ModelIDObject getObject() {
        if (this.dpv.isMainDiagram() && this.dpv.isMasterDPV()) {
            return this.dpv.getDesignPart().getMainDPVPlaceHolder();
        }
        return this.dpv.getPlaceHolder();
    }

    @Override
    public String getName() {
        return "Diagram Properties";
    }

    public String getDiagramName() {
        return this.dpv.getName();
    }

    public String getDiagramAuthor() {
        return this.getObject().getCreatedBy();
    }

    public String getTimeCreated() {
        return this.getObject().getCreationTime();
    }

    public String getTimeChanged() {
        return this.getObject().getChange().getTimeString();
    }

    public String getModifiedBy() {
        return this.dpv.getModifiedBy();
    }

    public String getDesignName() {
        return this.dpv.getDesign().getName();
    }

    public String getModelName() {
        return this.dpv.getDesignPart().getName();
    }

    public Dimension getSize(TopView topView) {
        int width = 140;
        try {
            Font textFont = topView.getFontObject(EditableFonts.FO_DIAGRAM).getFont();
            Canvas canvas = new Canvas();
            FontMetrics fm = canvas.getFontMetrics(textFont);
            int w = fm.getMaxAscent() + fm.getMaxDescent();
            int label = fm.stringWidth(this.getDiagramName()) + (w *= 2);
            int rowCount = 1;
            Iterator it = this.dpv.getPropertyNames();
            while (it.hasNext()) {
                String propName = (String)it.next();
                String value = this.dpv.getProperty(propName);
                ++rowCount;
                int propLength = fm.stringWidth(propName) + w;
                label = Math.max(label, propLength);
                width = Math.max(width, fm.stringWidth(value));
            }
            if (this.showAuthor()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getDiagramAuthor()));
            }
            if (this.showCreatedOn()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getTimeCreated()));
            }
            if (this.showModifiedOn()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getTimeChanged()));
            }
            if (this.showChangedBy()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getModifiedBy()));
            }
            if (this.showDesignName()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getDesignName()));
            }
            if (this.showModelName()) {
                ++rowCount;
                width = Math.max(width, fm.stringWidth(this.getModelName()));
            }
            int rowHeight = fm.getMaxAscent() + fm.getMaxDescent();
            int space = rowHeight / 3 + 1;
            return new Dimension(label + width + w, (rowHeight += space) * rowCount + 2);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            return new Dimension(width, 113);
        }
    }

    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    public boolean showAuthor() {
        return (this.dpv.getLegendAttributes() & 2) != 0;
    }

    public boolean showCreatedOn() {
        return (this.dpv.getLegendAttributes() & 4) != 0;
    }

    public boolean showModifiedOn() {
        return (this.dpv.getLegendAttributes() & 8) != 0;
    }

    public boolean showChangedBy() {
        return (this.dpv.getLegendAttributes() & 0x10) != 0;
    }

    public boolean showDesignName() {
        return (this.dpv.getLegendAttributes() & 0x20) != 0;
    }

    public boolean showModelName() {
        return (this.dpv.getLegendAttributes() & 0x40) != 0;
    }

    @Override
    public void showPropertyDialog() {
        LegendPropertiesDialog dialog = new LegendPropertiesDialog(this.getDesign().getAppView(), this.dpv);
        dialog.showDialog();
    }
}

