/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerObjectListener;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;

public abstract class GlobalKeyObjectSet
extends ModelObjectSet
implements ContainerObjectListener,
SetListener {
    private DesignPart designPart;

    public GlobalKeyObjectSet(DesignObjectSet containerSet) {
        containerSet.addSetListener(this);
        this.setDesign(containerSet.getDesign());
    }

    @Override
    public void add(ModelObject object) {
        super.add(object);
    }

    @Override
    public String getDefaultNamePrefix() {
        return "IDX";
    }

    protected void synchronizeWith(DesignObjectSet containerSet) {
        ContainerWithKeyObject[] array = (ContainerWithKeyObject[])containerSet.toArray();
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    @Override
    public void changed(ContainerObject container, ContainerObjectEvent event) {
        if (event.isType(5)) {
            this.addKey((KeyObject)event.getAffectedElement());
        } else if (event.isType(4)) {
            KeyObject affected = (KeyObject)event.getAffectedElement();
            this.removeKey(affected);
        }
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
        if (event.getAffected() instanceof ContainerWithKeyObject) {
            if (event.isAdded()) {
                this.addContainer((ContainerWithKeyObject)event.getAffected());
            } else if (event.isRemoved()) {
                this.removeContainer((ContainerWithKeyObject)event.getAffected());
            }
        }
    }

    protected void addContainer(ContainerWithKeyObject container) {
        container.addContainerListener(this);
        KeyObject[] array = container.getKeys();
        for (int i = 0; i < array.length; ++i) {
            this.addKey(array[i]);
        }
    }

    protected void addKey(KeyObject key) {
        key.setParent(this);
        this.add(key);
    }

    protected void removeContainer(ContainerWithKeyObject container) {
        container.removeContainerListener(this);
        KeyObject[] array = container.getKeys();
        for (int i = 0; i < array.length; ++i) {
            this.removeKey(array[i]);
        }
    }

    protected void removeKey(KeyObject key) {
        this.remove(key);
    }

    public Object[] getPKUK() {
        ArrayList<KeyObject> col = new ArrayList<KeyObject>();
        KeyObject[] keys = (KeyObject[])this.toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].isUnique() && !keys[i].isPK()) continue;
            col.add(keys[i]);
        }
        return col.toArray();
    }

    public Object[] getPKUK(String schema, String table) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        KeyObject[] keys = (KeyObject[])this.toArray();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].getSchemaObject() == null || !keys[i].getSchemaObject().getName().equalsIgnoreCase(schema) || !keys[i].getContainerWithKeyObject().getName().equalsIgnoreCase(table) || !keys[i].isPK() && !keys[i].isUnique()) continue;
            list.add(keys[i]);
        }
        return list.toArray();
    }

    public DesignPart getDesignPart() {
        return this.designPart;
    }

    public void setDesignPart(DesignPart designPart) {
        this.designPart = designPart;
    }
}

