/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public abstract class ContainedObjectWithDomain
extends ContainedObject
implements ObjectListener {
    public static final short DOMAIN = 0;
    public static final short LOGICAL_TYPE = 1;
    public static final short DISTINCT_TYPE = 2;
    public static final short STRUCTURED_TYPE = 3;
    public static final short COLLECTION_TYPE = 4;
    public static final String SUBST_NONE = "NONE";
    public static final String SUBST_ALL = "ALL";
    public static final String SUBST_RESTRICTED = "RESTRICTED";
    public static final String[] SUBST_OPTIONS = new String[]{"NONE", "ALL", "RESTRICTED"};
    private short use = 0;
    private boolean reference = false;
    private Domain domain;
    private LogicalDatatype logicalDatatype = null;
    private DistinctType distinctType = null;
    private boolean allowSubtypeSubstitution = true;
    private Map parameters = new TreeMap();
    private boolean restrictedTypeSubstitution = false;
    private List permittedSubTypes = new ArrayList();
    private boolean usesDefault;
    private String defaultValue;
    private String separatedCheckConstraint = "";
    private String separatedRangeConstraint = "";
    private String separatedValueConstraint = "";
    private String separatedLikeConstraint = "";
    private SensitiveType sensitiveType;
    private String sensitiveTypeDesc;

    public ContainedObjectWithDomain(DesignPart designPart) {
        super(designPart);
    }

    public void setDomain(Domain domain) {
        if (this.domain == domain) {
            return;
        }
        if (this.domain != null) {
            this.domain.removeObjectListener(this);
        }
        this.domain = domain;
        if (domain != null) {
            if (this.logicalDatatype != domain.getLogicalDatatype()) {
                this.logicalDatatype = domain.getLogicalDatatype();
            }
            if (!"Unknown".equalsIgnoreCase(domain.getName())) {
                domain.addObjectListener(this);
            }
            ObjectChangeEvent event = ObjectChangeEvent.DOMAIN_CHANGED;
            event.setAffected(domain);
            this.fireChange(event);
            event.setAffected(null);
        } else if (this.getUse() == 0) {
            this.setUse((short)1);
        } else {
            this.logicalDatatype = null;
        }
    }

    public Domain getDomain() {
        if (this.domain == null || this.use != 0) {
            this.domain = this.getDesign().getDomainSet().getDefaultDomain();
        }
        return this.domain;
    }

    public Datatype getDataType() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getDataType();
        }
        if (this.use == 1) {
            String rdbmsName = this.getSelectedRDBMSType().toString();
            MDDataType type = (MDDataType)this.getDataType(rdbmsName);
            return type;
        }
        if (this.use == 2) {
            if (this.distinctType == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.distinctType;
        }
        if (this.use == 3) {
            if (this.getStructuredType() == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.getStructuredType();
        }
        if (this.use == 4) {
            if (this.getCollectionType() == null) {
                return this.getDesign().getDomainSet().getDefaultDomain().getDataType();
            }
            return this.getCollectionType();
        }
        return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
    }

    public static MDDataType getDataTypeWithDefaults(LogicalDatatype logicalDatatype, Map parameters, String rdbmsName) {
        Map s = logicalDatatype.getDefaultValues();
        Map defaults = (Map)s.get(rdbmsName);
        String defSize = "";
        String defPrecision = "";
        String defScale = "";
        if (defaults != null) {
            defPrecision = (String)defaults.get("precision_default_value");
            defSize = (String)defaults.get("size_default_value");
            defScale = (String)defaults.get("scale_default_value");
        }
        String precision = (String)parameters.get("precision");
        String size = (String)parameters.get("size");
        String scale = (String)parameters.get("scale");
        TreeMap<String, String> nMap = new TreeMap<String, String>();
        nMap.putAll(parameters);
        if (size != null && !"0".equals(size) && !"".equals(size)) {
            nMap.put("size", size);
        } else if (defSize != null && !"0".equals(defSize) && !"".equals(defSize)) {
            nMap.put("size", defSize);
        }
        if (defPrecision != null && !"".equals(defPrecision) && (precision == null || "".equals(precision))) {
            nMap.put("precision", defPrecision);
        }
        if (defScale != null && !"".equals(defScale) && (scale == null || "".equals(scale))) {
            nMap.put("scale", defScale);
        }
        MDDataType type = logicalDatatype.createDataType(rdbmsName, nMap);
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDataTypePresentationForHive() {
        String rdbmsName = StorageDesignOraclev12c.RDBMS_TYPE.getName();
        String type = "String";
        try {
            LogicalDatatype lt = this.getLogicalDatatype();
            if (this.getUse() == 2) {
                if (this.getDistinctType() == null) {
                    return type;
                }
                if (this.distinctType != null) {
                    lt = this.distinctType.getLogicalDataType();
                }
            }
            if (this.getUse() == 0) {
                if (this.getDomain() == null) {
                    return type;
                }
                TreeMap<String, CallSite> parameters = new TreeMap<String, CallSite>();
                parameters.put("size", (CallSite)((Object)this.getDomain().getDataTypeSize()));
                parameters.put("precision", (CallSite)((Object)this.getDomain().getDataTypePrecision()));
                parameters.put("scale", (CallSite)((Object)this.getDomain().getDataTypeScale()));
                lt = this.getDomain().getLogicalDatatype();
                type = lt.getDataTypeForHive(parameters);
                if (type != null) {
                    return type;
                }
                type = this.getDomain().getDataType(rdbmsName).toString();
                return lt.transformOracleTypeToHive(type);
            }
            if (this.getUse() == 1 || this.getUse() == 2) {
                if (lt == null) {
                    return type;
                }
                type = lt.getDataTypeForHive(this.parameters);
                if (type != null) {
                    return type;
                }
                type = ContainedObjectWithDomain.getDataTypeWithDefaults(lt, this.parameters, rdbmsName).toString();
                return lt.transformOracleTypeToHive(type);
            }
            if (this.getUse() == 3) {
                if (this.getStructuredType() != null) return this.getStructuredType().getDataTypePresentationForHive();
                return type;
            }
            if (this.getUse() == 4) {
                if (this.getCollectionType() != null) return this.getCollectionType().getDataTypePresentationForHive();
                return type;
            }
            if ("String".equalsIgnoreCase(type)) return type;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    public Datatype getDataType(String rdbmsName) {
        if (this.getUse() == 0) {
            if (this.getDomain() == null) {
                return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
            }
            return this.getDomain().getDataType(rdbmsName);
        }
        if (this.getUse() == 1) {
            if (this.logicalDatatype == null) {
                this.logicalDatatype = (LogicalDatatype)this.getDesign().getLogicalDatatypeSet().getByName("unknown", false);
            }
            LogicalDatatype lt = this.getLogicalDatatype();
            return ContainedObjectWithDomain.getDataTypeWithDefaults(lt, this.parameters, rdbmsName);
        }
        if (this.getUse() == 2) {
            LogicalDatatype logicalDatatype;
            if (this.getDistinctType() == null) {
                return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
            }
            if (this.distinctType != null && rdbmsName.startsWith("Oracle") && (logicalDatatype = this.distinctType.getLogicalDataType()) != null) {
                int dtScale;
                int dtPrecision;
                TreeMap<String, String> dtParams = new TreeMap<String, String>();
                String dtSize = this.distinctType.getSize();
                if (dtSize != null && dtSize.length() > 0 && !dtSize.equals("0")) {
                    dtParams.put("size", dtSize);
                }
                if ((dtPrecision = this.distinctType.getPrecision()) != 0) {
                    dtParams.put("precision", String.valueOf(dtPrecision));
                }
                if ((dtScale = this.distinctType.getScale()) != 0) {
                    dtParams.put("scale", String.valueOf(dtScale));
                }
                MDDataType type = logicalDatatype.createDataType(rdbmsName, dtParams);
                return type;
            }
            return this.distinctType;
        }
        if (this.getUse() == 3) {
            if (this.getStructuredType() == null) {
                return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
            }
            return this.getStructuredType();
        }
        if (this.getUse() == 4) {
            if (this.getCollectionType() == null) {
                return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings());
            }
            return this.getCollectionType();
        }
        return null;
    }

    public String getDatatypeString(String rdbmsName) {
        Datatype type = this.getDataType(rdbmsName);
        if (type == null) {
            return this.getPreferences().getDefaultType(this.getDesign().getAppView().getSettings()).getName();
        }
        StringBuffer buff = new StringBuffer();
        if (rdbmsName.indexOf("DB2/UDB") > -1) {
            if (this.use == 3 && this.isReference()) {
                buff.append("REF (");
                buff.append(type.toString()).append(')');
            } else {
                buff.append(type.toString());
            }
        } else {
            if (this.use == 3 && this.isReference()) {
                buff.append("REF ");
            }
            buff.append(type.toString());
        }
        return buff.toString();
    }

    public String getGenericDatatypeString() {
        if (this.getUse() == 0) {
            Domain domain = this.getDomain();
            if (domain != null) {
                return domain.getName();
            }
        } else {
            if (this.getUse() == 1) {
                LogicalDatatype logDatatype = this.getLogicalDatatype();
                String logDatatypeName = logDatatype.toString();
                String rdbmsName = this.getSelectedRDBMSType().toString();
                MDDataType type = logDatatype.createDataType(rdbmsName, this.parameters);
                if (type == null) {
                    return logDatatypeName;
                }
                if (logDatatypeName.startsWith("INTERVAL")) {
                    return type.toString();
                }
                StringBuffer logical = new StringBuffer(logDatatypeName);
                if (type.hasSize() && !"".equals(this.getSize())) {
                    logical.append(' ');
                    logical.append('(');
                    logical.append(this.getSize());
                    logical.append(')');
                } else if (type.hasPrecision() && type.getPrecision() > 0) {
                    logical.append(' ');
                    logical.append('(');
                    logical.append(type.getPrecisionStr());
                    if (type.hasScale() && (type.getScale() != 0 || "*".equals(type.getPrecisionStr()))) {
                        logical.append(',');
                        logical.append(' ');
                        logical.append(type.getScale());
                    }
                    logical.append(')');
                }
                return logical.toString();
            }
            if (this.getUse() == 2) {
                if (this.getDistinctType() != null) {
                    return this.getDistinctType().getName();
                }
            } else if (this.getUse() == 3) {
                if (this.getStructuredType() != null) {
                    if (this.isReference()) {
                        return "REF " + this.getStructuredType().getName();
                    }
                    return this.getStructuredType().getName();
                }
            } else if (this.getUse() == 4 && this.getCollectionType() != null) {
                return this.getCollectionType().getName();
            }
        }
        return "";
    }

    public LogicalDatatype getLogicalDatatype() {
        if (this.getUse() == 0 && this.getDomain() != null) {
            return this.getDomain().getLogicalDatatype();
        }
        if (this.logicalDatatype == null) {
            return this.getDomain().getLogicalDatatype();
        }
        return this.logicalDatatype;
    }

    public void setLogicalDatatype(LogicalDatatype logicalType) {
        if (this.logicalDatatype == logicalType) {
            return;
        }
        if (this.logicalDatatype != null) {
            this.logicalDatatype.removeObjectListener(this);
        }
        this.logicalDatatype = logicalType;
        if (logicalType != null) {
            logicalType.addObjectListener(this);
            ObjectChangeEvent event = ObjectChangeEvent.LOGICALDATATYPE_CHANGED;
            event.setAffected(this.domain);
            this.fireChange(event);
            event.setAffected(null);
        }
    }

    public Map getParameters() {
        return this.parameters;
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public String getPrecision() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getPrecision();
        }
        return this.getDataTypeParameter("precision");
    }

    public String getScale() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getScale();
        }
        return this.getDataTypeParameter("scale");
    }

    @Override
    public String getSize() {
        if (this.use == 0 && this.getDomain() != null) {
            return this.getDomain().getSize();
        }
        return this.getDataTypeParameter("size");
    }

    public void setDataTypeParameter(String key, String value) {
        String dval;
        ContainedObjectWithDomain co;
        if (this.getAppView().getSettings().isAllowSimilarTypesFK() && (co = (ContainedObjectWithDomain)this.getDelegateElement()) != null && ((dval = co.getDataTypeParameter(key)) == null && value == null || dval != null && dval.equals(value))) {
            this.parameters.remove(key);
            return;
        }
        if (value == null || "".equals(value)) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, value);
        }
    }

    public String getSizeOnly() {
        String size = this.getSize();
        String[] parts_n = size.split(" ");
        if (parts_n.length > 0) {
            return parts_n[0];
        }
        return "";
    }

    public String getUnits() {
        String size = this.getSize();
        String[] parts_n = size.split(" ");
        if (parts_n.length == 2) {
            return parts_n[1];
        }
        return "";
    }

    public String getDataTypeParameter(String key) {
        Object value = this.parameters.get(key);
        if (value == null) {
            value = "";
        }
        return (String)value;
    }

    public ContainerWithKeyObject getContainerWithKeyObject() {
        return (ContainerWithKeyObject)this.getContainer();
    }

    public boolean isPKElement() {
        ContainerWithKeyObject cont = this.getContainerWithKeyObject();
        return cont != null && cont.getPK() != null && cont.getPK().contains(this);
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        Object obj = event.getAffected();
        if (obj instanceof DistinctType && event == ObjectChangeEvent.OBJECT_REMOVED) {
            ((DistinctType)obj).copyLogicalTypeAndParamsTo(this);
            this.setDirty(true);
            this.setUse((short)1);
            this.setDistinctType(null);
        }
        this.fireChange(event);
    }

    public void setUsesDefaultValue(boolean value) {
        boolean old_value = this.usesDefault;
        this.usesDefault = value;
        if (old_value != value) {
            this.fireChange(ObjectChangeEvent.USE_DEFAULT_CHANGED);
        }
    }

    public boolean getUsesDefaultValue() {
        return this.usesDefault;
    }

    public void setDefaultValue(String value) {
        String domDef;
        if (value != null && !"".equals(value) && this.domain != null && this.use == 0 && (domDef = this.domain.getDefaultValue()) != null && domDef.equals(value)) {
            this.defaultValue = null;
            return;
        }
        this.defaultValue = value;
    }

    public String getDefaultValue() {
        String result = this.defaultValue;
        if (result == null || "".equals(result)) {
            if (this.domain != null && this.use == 0) {
                result = this.domain.getDefaultValue();
                if (result == null) {
                    return "";
                }
                return result;
            }
            return "";
        }
        return this.defaultValue;
    }

    @Override
    public ConstraintEnumeration getValueList() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getValueList();
        }
        return super.getValueList();
    }

    public int getPositionInPK() {
        if (this.getContainerWithKeyObject() != null && this.getContainerWithKeyObject().hasPK()) {
            return this.getContainerWithKeyObject().getPK().getIndexOf(this);
        }
        return -1;
    }

    @Override
    public boolean getUseDomainConstraints() {
        return this.use == 0 && super.getUseDomainConstraints();
    }

    @Override
    public void setUseDomainConstraints(boolean value) {
        super.setUseDomainConstraints(value);
    }

    public DistinctType getDistinctType() {
        return this.distinctType;
    }

    public void setDistinctType(DistinctType distinctType) {
        ContainerObject container;
        if (this.distinctType != distinctType && this.distinctType != null) {
            this.distinctType.removeObjectListener(this);
        }
        this.distinctType = distinctType;
        if (this.distinctType != null && (container = this.getContainer()) != null && !container.isBackup()) {
            this.distinctType.addObjectListener(this);
        }
    }

    public short getUse() {
        DistinctType dt;
        if (this.use == 2 && (dt = this.getDistinctType()) != null && dt.isRemoved()) {
            this.use = 1;
            dt.copyLogicalTypeAndParamsTo(this);
        }
        return this.use;
    }

    public void setUse(short use) {
        if (use >= 0 && use <= 4) {
            this.use = use;
        }
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isRefToStructuredType(StructuredType type) {
        Datatype obj = this.getDataType();
        if (this.reference && obj != null && obj instanceof StructuredType) {
            for (StructuredType st = type; st != null; st = st.getParentType()) {
                if (st != obj) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExactRefToStructuredType(StructuredType type) {
        Datatype obj = this.getDataType();
        return this.reference && obj != null && obj instanceof StructuredType && obj == type;
    }

    public void setReference(boolean reference) {
        this.reference = reference;
    }

    public boolean isAllowSubtypeSubstitution() {
        return this.allowSubtypeSubstitution;
    }

    @Override
    public void setStructuredType(StructuredType structuredType) {
        StructuredType old = this.getStructuredType();
        super.setStructuredType(structuredType);
        if (structuredType != old) {
            this.removeNestedObjects();
            if (structuredType == null) {
                this.setAllowSubtypeSubstitution(true);
            }
        }
    }

    public void setAllowSubtypeSubstitution(boolean allowSubtypeSubstitution) {
        this.allowSubtypeSubstitution = allowSubtypeSubstitution;
    }

    @Override
    public boolean isUnique() {
        if (this.getContainerWithKeyObject() != null) {
            Iterator it = this.getContainerWithKeyObject().getKeySet().iterator();
            while (it.hasNext()) {
                KeyObject key = (KeyObject)it.next();
                if (!key.isUnique() || !key.contains(this)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRestrictedTypeSubstitution() {
        return this.restrictedTypeSubstitution;
    }

    public void setRestrictedTypeSubstitution(boolean restrictedTypeSubstitution) {
        this.restrictedTypeSubstitution = restrictedTypeSubstitution;
    }

    public List getPermittedSubTypes() {
        Object[] objs = this.permittedSubTypes.toArray();
        for (int i = 0; i < objs.length; ++i) {
            DesignObject dobj = (DesignObject)objs[i];
            if (this.getDesign().getDesignObject(dobj.getObjectID()) != null) continue;
            this.permittedSubTypes.remove(dobj);
        }
        return this.permittedSubTypes;
    }

    public void copyParametersFrom(ContainedObjectWithDomain co) {
        this.parameters.clear();
        Map map = co.getParameters();
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (value == null) continue;
            this.setDataTypeParameter(key, value);
        }
    }

    public boolean hasConstraintsDefined() {
        if (this.getUseDomainConstraints()) {
            Domain domain = this.getDomain();
            if (domain != null) {
                if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                    return true;
                }
                if (domain.getValueList() != null && !domain.getValueList().isEmpty()) {
                    return true;
                }
                if (!domain.getAVTs().isEmpty()) {
                    return true;
                }
            }
        } else {
            if (this.getCheck() != null && !this.getCheck().isEmpty()) {
                return true;
            }
            if (this.getValueList() != null && !this.getValueList().isEmpty()) {
                return true;
            }
            if (!this.getAVTs().isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasConstraintsDefinedForDDL() {
        if (this.getUseDomainConstraints()) {
            Domain domain = this.getDomain();
            if (domain != null) {
                if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                    return true;
                }
                if (domain.getValueList() != null && !domain.getValueList().isEmpty() && domain.getAppView().getSettings().isGenerateValidValueCC()) {
                    return true;
                }
                if (!domain.getAVTs().isEmpty() && domain.getAppView().getSettings().isGenerateValidValueCC()) {
                    return true;
                }
            }
        } else {
            if (this.getCheck() != null && !this.getCheck().isEmpty()) {
                return true;
            }
            if (this.getValueList() != null && !this.getValueList().isEmpty() && this.getAppView().getSettings().isGenerateValidValueCC()) {
                return true;
            }
            if (!this.getAVTs().isEmpty() && this.getAppView().getSettings().isGenerateValidValueCC()) {
                return true;
            }
        }
        return false;
    }

    public String getConstraintsText() {
        return this.getConstraintsText(this.getName());
    }

    public String getConstraintsText(String name) {
        return this.getConstraintsText(name, null);
    }

    public String getConstraintsText(String name, RDBMSType type) {
        ConstraintEnumeration valueList;
        StringBuffer sb = new StringBuffer();
        CheckConstraint check = this.getCheck();
        boolean first = true;
        if (check != null && !check.isEmpty()) {
            String constrText;
            if (type == null) {
                type = this.getDesignPart().getSelectedRDBMSSite().getType();
            }
            if (!(constrText = check.getImplementation(type)).trim().equalsIgnoreCase("")) {
                constrText = constrText.replaceAll("%COLUMN%", name);
                constrText = constrText.replaceAll("%column%", name);
                sb.append(constrText).append(' ');
                first = false;
            }
        }
        if (!this.getAVTs().isEmpty() && this.getAppView().getSettings().isGenerateValidValueCC()) {
            if (first) {
                first = false;
            } else {
                sb.append("OR").append(' ');
            }
            this.appendAVTs(sb, name);
        }
        if ((valueList = this.getValueList()) != null && !valueList.isEmpty() && this.getAppView().getSettings().isGenerateValidValueCC()) {
            if (first) {
                first = false;
            } else {
                sb.append("OR").append(' ');
            }
            this.appendStringEnumeration(sb, name);
        }
        return sb.toString().trim();
    }

    public void appendAVTs(StringBuffer sb, String name) {
        if (this.getAppView().getSettings().isGenerateValidValueCC()) {
            String dtName = this.getDataType().getName().toUpperCase();
            boolean characterType = dtName.indexOf("CHAR") > -1 || dtName.indexOf("CLOB") > -1;
            Iterator it = this.getAVTs().iterator();
            boolean more = false;
            while (it.hasNext()) {
                AVT avt = (AVT)it.next();
                if (more) {
                    sb.append("OR").append(' ');
                }
                sb.append(name).append(' ');
                String end = avt.getEndValue();
                if (!"".equals(end)) {
                    sb.append("BETWEEN").append(' ');
                    this.appendString(sb, avt.getBeginValue(), characterType);
                    sb.append(' ').append("AND").append(' ');
                    this.appendString(sb, end, characterType);
                } else {
                    sb.append("=").append(' ');
                    this.appendString(sb, avt.getBeginValue(), characterType);
                }
                sb.append(' ');
                more = true;
            }
        }
    }

    public void appendStringEnumeration(StringBuffer sb, String name) {
        if (this.getAppView().getSettings().isGenerateValidValueCC()) {
            StringBuffer sbIn = new StringBuffer();
            StringBuffer sbLike = new StringBuffer();
            String dtName = this.getDataType().getName().toUpperCase();
            boolean characterType = dtName.indexOf("CHAR") > -1 || dtName.indexOf("CLOB") > -1;
            Map valuesDescriptionMap = this.getValueList().getValuesDescriptionMap();
            Iterator itConstraint = this.getValueIterator();
            while (itConstraint.hasNext()) {
                String value = (String)itConstraint.next();
                String valueDesc = (String)valuesDescriptionMap.get(value);
                if (valueDesc != null && valueDesc.startsWith("LIKE")) {
                    if (sbLike.length() > 0) {
                        sbLike.append(' ').append("OR").append(' ');
                    }
                    sbLike.append(name).append(' ').append("LIKE").append(' ');
                    this.appendString(sbLike, value, characterType);
                    continue;
                }
                if (sbIn.length() == 0) {
                    sbIn.append(name).append(' ').append("IN").append(' ').append("(");
                } else {
                    sbIn.append(',').append(' ');
                }
                this.appendString(sbIn, value, characterType);
            }
            if (sbIn.length() > 0) {
                sbIn.append(")");
                sb.append(sbIn);
            }
            if (sbIn.length() > 0 && sbLike.length() > 0) {
                sb.append(' ').append("OR").append(' ');
            }
            if (sbLike.length() > 0) {
                sb.append(sbLike);
            }
        }
    }

    private void appendString(StringBuffer sb, String value, boolean characterType) {
        if (characterType && !value.startsWith("'") && !value.endsWith("'")) {
            sb.append('\'').append(value).append('\'');
        } else {
            sb.append(value);
        }
    }

    public String formatDiscriminatorValue(String value) {
        boolean characterType;
        String dtName = this.getDataType().getName().toUpperCase();
        boolean bl = characterType = dtName.indexOf("CHAR") > -1 || dtName.indexOf("CLOB") > -1;
        if (characterType && !value.startsWith("'") && !value.endsWith("'")) {
            return "'" + value + "'";
        }
        return value;
    }

    public String getSeparatedCheckConstraint() {
        return this.separatedCheckConstraint;
    }

    public String getSeparatedRangeConstraint() {
        return this.separatedRangeConstraint;
    }

    public String getSeparatedValueConstraint() {
        return this.separatedValueConstraint;
    }

    public String getSeparatedLikeConstraint() {
        return this.separatedLikeConstraint;
    }

    public boolean setSeparatedConstraints(String text) {
        this.separatedCheckConstraint = "";
        this.separatedRangeConstraint = "";
        this.separatedValueConstraint = "";
        this.separatedLikeConstraint = "";
        StringBuffer checkBuffer = new StringBuffer();
        if ("".equals(text.trim())) {
            return false;
        }
        String checkText = text;
        String objName = this.getName();
        boolean atEnd = false;
        while (!atEnd) {
            String checkValue;
            String checkOr = Token.getStringBeforeToken(checkText, "OR");
            if ("".equals(checkOr)) {
                checkOr = checkText;
                atEnd = true;
            }
            if (checkOr.startsWith("(")) {
                checkOr = Token.getValBetweenBrackets(checkOr);
            }
            boolean used = false;
            boolean hasNot = Token.hasToken(checkOr, "NOT");
            String checkBetween = Token.getStringBeforeToken(checkOr, "BETWEEN");
            String checkIn = Token.getStringBeforeToken(checkOr, "IN");
            String checkLike = "";
            if (!"".equals(checkBetween) && !hasNot) {
                String checkRange;
                if (objName.equalsIgnoreCase(checkBetween.trim()) && !"".equals(checkRange = this.parseRangeConstraint(checkOr))) {
                    this.separatedRangeConstraint = this.separatedRangeConstraint.concat(checkRange);
                    used = true;
                }
            } else if (!"".equals(checkIn) && !hasNot) {
                if (objName.equalsIgnoreCase(checkIn.trim()) && !"".equals(checkValue = this.parseValueConstraint(checkOr))) {
                    if (!"".equals(this.separatedValueConstraint)) {
                        this.separatedValueConstraint = this.separatedValueConstraint.concat(String.valueOf(','));
                    }
                    this.separatedValueConstraint = this.separatedValueConstraint.concat(checkValue);
                    used = true;
                }
            } else if (!"".equals(checkLike) && !hasNot && objName.equalsIgnoreCase(checkLike.trim()) && !"".equals(checkValue = this.parseLikeConstraint(checkOr))) {
                if (!"".equals(this.separatedLikeConstraint)) {
                    this.separatedLikeConstraint = this.separatedLikeConstraint.concat(String.valueOf(','));
                }
                this.separatedLikeConstraint = this.separatedLikeConstraint.concat(checkValue);
                used = true;
            }
            if (!used) {
                if (checkBuffer.length() > 0) {
                    checkBuffer.append(' ').append("OR").append(' ');
                }
                checkBuffer.append(checkOr);
            }
            if (atEnd) continue;
            checkText = Token.getStringAfterToken(checkText, "OR");
        }
        this.separatedCheckConstraint = checkBuffer.toString();
        if (this.separatedRangeConstraint.endsWith(String.valueOf(','))) {
            this.separatedRangeConstraint = this.separatedRangeConstraint.substring(0, this.separatedRangeConstraint.length() - 1);
        }
        return !"".equals(this.separatedRangeConstraint) || !"".equals(this.separatedValueConstraint) || !"".equals(this.separatedLikeConstraint);
    }

    private String parseRangeConstraint(String text) {
        StringBuffer buf = new StringBuffer();
        String range = Token.getStringAfterToken(text, "BETWEEN");
        String rangeFrom = Token.getStringBeforeToken(range, "AND");
        String rangeTo = Token.getStringAfterToken(range, "AND");
        if ("".equals(rangeTo)) {
            rangeTo = rangeFrom;
        }
        buf.append(rangeFrom).append(',');
        buf.append(rangeTo).append(',');
        return buf.toString();
    }

    private String parseValueConstraint(String text) {
        String valueList = Token.getStringAfterToken(text, "IN");
        return Token.getValBetweenBrackets(valueList);
    }

    private String parseLikeConstraint(String text) {
        return Token.getStringAfterToken(text, "LIKE");
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        ModelIDObject object = null;
        object = this.getDesign().getDesignObject(id);
        if (object != null) {
            return object;
        }
        if ("domain".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDomainSet().getObjectByID(id);
            if (object == null) {
                object = this.getDesign().getDomainSet().getObjectByImportedID(id);
            }
            if (object == null) {
                object = this.getDesign().getDomainSet().getObjectByRemoteObjectID(id);
            }
        } else if ("logicalDatatype".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getLogicalDatatypeSet().getObjectByID(id);
        } else if ("distinctType".equalsIgnoreCase(propertyName)) {
            object = this.getDesign().getDataTypesDesign().getDistinctTypeSet().getObjectByID(id);
        } else if ("maskTemplate".equalsIgnoreCase(propertyName)) {
            object = this.getAppView().getMaskTemplateSet().getObjectByID(id);
        } else if ("sensitiveType".equalsIgnoreCase(propertyName)) {
            object = this.getAppView().getSensitiveTypeSet().getObjectByID(id);
        }
        if (object != null) {
            return object;
        }
        return super.translateIdToObject(propertyName, id);
    }

    public void setDataTypeSize(String value) {
        this.setDataTypeParameter("size", value);
    }

    public String getDataTypeSize() {
        return this.getDataTypeParameter("size");
    }

    public void setDataTypePrecision(String value) {
        this.setDataTypeParameter("precision", value);
    }

    public String getDataTypePrecision() {
        return this.getDataTypeParameter("precision");
    }

    public void setDataTypeScale(String value) {
        this.setDataTypeParameter("scale", value);
    }

    public String getDataTypeScale() {
        return this.getDataTypeParameter("scale");
    }

    public ConstraintEnumeration getOwnValueList() {
        if (this.getUseDomainConstraints()) {
            return null;
        }
        return super.getValueList();
    }

    public void setOwnValueList(ConstraintEnumeration valueList) {
        if (this.getUseDomainConstraints()) {
            super.setValueList(null);
        } else if (valueList != null && valueList.isEmpty()) {
            super.setValueList(null);
        } else {
            super.setValueList(valueList);
        }
    }

    public void clearOwnValueList() {
        super.setValueList(null);
    }

    public Iterator getValueIterator() {
        return this.getValues().iterator();
    }

    public Set getValues() {
        if (this.getUseDomainConstraints()) {
            return this.getDomain().getValues();
        }
        ConstraintEnumeration constraintEnumeration = this.getValueList();
        if (constraintEnumeration != null) {
            LogicalDatatype logicalDatatype;
            Set valueSet = constraintEnumeration.getValues();
            if (valueSet.size() > 1 && (logicalDatatype = this.getLogicalDatatype()) != null && logicalDatatype.isNumeric()) {
                TreeSet sortedSet = new TreeSet(new ValueComparator());
                sortedSet.addAll(valueSet);
                return sortedSet;
            }
            return valueSet;
        }
        return new TreeSet();
    }

    public CheckConstraint getOwnCheck() {
        if (this.getUseDomainConstraints()) {
            return null;
        }
        return super.getCheck();
    }

    public void setOwnCheck(CheckConstraint check) {
        if (this.getUseDomainConstraints()) {
            super.setCheck(null);
        } else if (check != null && check.isEmpty()) {
            super.setCheck(null);
        } else {
            super.setCheck(check);
        }
    }

    public void clearOwnCheckConstraint() {
        super.setCheck(null);
    }

    public ConstraintEnumeration createConstraintEnumeration() {
        ConstraintEnumeration ce = new ConstraintEnumeration();
        ce.setDesign(this.getDesign());
        return ce;
    }

    public CheckConstraint createCheckConstraint() {
        CheckConstraint cc = new CheckConstraint();
        cc.setDesign(this.getDesign());
        return cc;
    }

    public boolean hasEqulaDataType(ContainedObjectWithDomain co) {
        String co_dtype;
        String rdbmsName = this.getSelectedRDBMSType().toString();
        String dtype = this.getDatatypeString(rdbmsName);
        return dtype.equalsIgnoreCase(co_dtype = co.getDatatypeString(rdbmsName));
    }

    public boolean hasSimilarDataType(ContainedObjectWithDomain co) {
        String rdbmsName = this.getSelectedRDBMSType().toString();
        String dtype = this.getDatatypeString(rdbmsName);
        String co_dtype = co.getDatatypeString(rdbmsName);
        int ind = dtype.indexOf(40);
        if (ind > 0) {
            dtype = dtype.substring(0, ind);
        }
        if ((ind = co_dtype.indexOf(40)) > 0) {
            co_dtype = co_dtype.substring(0, ind).trim();
        }
        return dtype.equalsIgnoreCase(co_dtype);
    }

    public SensitiveType getSensitiveType() {
        return this.sensitiveType;
    }

    public void setSensitiveType(SensitiveType sensitiveType) {
        this.sensitiveType = sensitiveType;
    }

    public String getSensitiveTypeDescription() {
        return this.sensitiveTypeDesc;
    }

    public void setSensitiveTypeDescription(String sensitiveTypeDesc) {
        this.sensitiveTypeDesc = sensitiveTypeDesc;
    }

    public String getDataTypeKind() {
        String result = "";
        Datatype dt = this.getDataType();
        if (dt != null) {
            if (this.getUse() == 0) {
                result = "Dom";
            } else if (this.getUse() == 1) {
                result = "LT";
            } else if (this.getUse() == 3) {
                result = "ST";
            } else if (this.getUse() == 4) {
                result = "CT";
            } else if (this.getUse() == 2) {
                result = "DT";
            }
        }
        return result;
    }

    public String getOwnDataTypeParameters() {
        Object result = "";
        String size = (String)this.parameters.get("size");
        String precision = (String)this.parameters.get("precision");
        String scale = (String)this.parameters.get("scale");
        if (size != null && !"".equals(size)) {
            result = (String)result + size;
        }
        result = (String)result + ",";
        if (precision != null && !"".equals(precision)) {
            result = (String)result + precision;
        }
        result = (String)result + ",";
        if (scale != null && !"".equals(scale)) {
            result = (String)result + scale;
        }
        return result;
    }

    public void setOwnDataTypeParameters(String params) {
        if (params.indexOf(44) > -1) {
            String[] parts = params.split(",");
            for (int i = 0; i < parts.length; ++i) {
                if (!"".equals(parts[i])) {
                    if (i == 0) {
                        this.parameters.put("size", parts[i]);
                        continue;
                    }
                    if (i == 1) {
                        this.parameters.put("precision", parts[i]);
                        continue;
                    }
                    if (i != 2) continue;
                    this.parameters.put("scale", parts[i]);
                    continue;
                }
                if (i == 0) {
                    this.parameters.remove("size");
                    continue;
                }
                if (i == 1) {
                    this.parameters.remove("precision");
                    continue;
                }
                if (i != 2) continue;
                this.parameters.remove("scale");
            }
        }
    }

    public boolean isPartOfUnresolvedFK(FKContainer container) {
        return false;
    }

    private class ValueComparator
    implements Comparator {
        private ValueComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                double d1 = Double.parseDouble((String)o1);
                double d2 = Double.parseDouble((String)o2);
                if (d1 > d2) {
                    return 1;
                }
                if (d1 < d2) {
                    return -1;
                }
                return 0;
            }
            catch (Exception e) {
                return ((String)o1).compareTo((String)o2);
            }
        }
    }
}

