/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.persistence.db.RepDeleteDescr;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;

public abstract class AbstractLevelDomains
implements RepositoryObject {
    private Design design;
    private String repositoryOID = null;
    private String repositoryOVID = null;
    private boolean checkedOut = false;
    private boolean checkedOutByMe = false;
    private String checkedOutBy = "";
    private boolean dirty = false;
    private TreeMap repositoryMap = new TreeMap();
    private RepositoryObject pac_Element;

    public AbstractLevelDomains(Design design) {
        this.design = design;
    }

    public abstract List getDomains();

    public abstract String getType();

    @Override
    public abstract String getName();

    public Design getDesign() {
        return this.design;
    }

    @Override
    public boolean canBedeleted() {
        return false;
    }

    @Override
    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    @Override
    public String getRepositoryOID() {
        return this.repositoryOID;
    }

    @Override
    public String getRepositoryOVID() {
        return this.repositoryOVID;
    }

    @Override
    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    @Override
    public boolean isCheckedOutByMe() {
        return this.checkedOutByMe;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setCheckedOut(boolean checkedOut) {
        this.checkedOut = checkedOut;
    }

    @Override
    public void setCheckedOutBy(String checkedOutBy) {
        this.checkedOutBy = checkedOutBy;
    }

    @Override
    public void setCheckedOutByMe(boolean checkedOutByMe) {
        this.checkedOutByMe = checkedOutByMe;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setRepositoryOID(String repositoryOID) {
        this.repositoryOID = repositoryOID;
    }

    @Override
    public void setRepositoryOVID(String repositoryOVID) {
        this.repositoryOVID = repositoryOVID;
    }

    public void createRepositoryMap() {
        this.repositoryMap.clear();
        for (DesignObject dobj : this.getDomains()) {
            if (dobj.getRepositoryOID() == null) continue;
            RepDeleteDescr descr = new RepDeleteDescr();
            descr.objectType = dobj.getObjectTypeName();
            descr.repOID = dobj.getRepositoryOID();
            descr.repOVID = dobj.getRepositoryOVID();
            this.repositoryMap.put(dobj.getObjectID(), descr);
        }
    }

    public List getObjectsToDeleteFromRepository() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (DesignObject dobj : this.getDomains()) {
            if (dobj.getRepositoryOID() == null) continue;
            map.put(dobj.getObjectID(), dobj.getObjectID());
        }
        ArrayList deleted = new ArrayList();
        for (Map.Entry entry : this.repositoryMap.entrySet()) {
            Object obj = map.get(entry.getKey());
            if (obj != null) continue;
            deleted.add(entry.getValue());
        }
        return deleted;
    }

    public void clearDomains() {
        List domains = this.getDomains();
        for (int i = domains.size() - 1; i >= 0; --i) {
            Domain domain = (Domain)domains.get(i);
            if (!domain.isDefault()) continue;
            domain.remove();
        }
    }

    @Override
    public RepositoryObject getPAC_Element() {
        return this.pac_Element;
    }

    @Override
    public boolean isPAC_Element() {
        return true;
    }

    @Override
    public void setPAC_Element(RepositoryObject object) {
        this.pac_Element = object;
    }
}

