/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.datatype.oracle;

import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDFixedSized;
import oracle.dbtools.crest.util.options.Settings;

public class MDCharOracle
extends MDFixedSized {
    private String name = "CHAR";
    Settings settings;

    public MDCharOracle() {
        this.size = "1";
        this.settings = null;
    }

    public MDCharOracle(Settings settings) {
        this.size = "1";
        this.settings = settings;
    }

    @Override
    public String getMaxSize() {
        return "2000";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MDDataType deepCopy() {
        MDCharOracle copy = new MDCharOracle(this.settings);
        copy.setSize(this.getSize());
        return copy;
    }

    @Override
    public void appendTo(StringBuffer buffer) {
        String numeric = this.size;
        if (numeric != null && numeric.indexOf(32) > 0) {
            String[] parts_n = numeric.split(" ");
            if (parts_n.length == 2 && (parts_n[1].equalsIgnoreCase("BYTE") || parts_n[1].equalsIgnoreCase("CHAR"))) {
                buffer.append(this.getName());
                buffer.append(" (");
                if (this.settings != null && this.settings.isShowByteCharInDDL()) {
                    buffer.append(numeric);
                } else {
                    buffer.append(parts_n[0]);
                }
                buffer.append(')');
                return;
            }
            numeric = parts_n[0];
        }
        if (numeric == null || "".equalsIgnoreCase(numeric) || "0".equalsIgnoreCase(numeric)) {
            buffer.append(this.getName());
        } else {
            buffer.append(this.getName());
            buffer.append(" (");
            buffer.append(this.getSize());
            buffer.append(')');
        }
    }
}

