/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;

public abstract class MultiShapedDesignObject
extends DesignObject {
    protected Collection allViews = new ArrayList();

    public MultiShapedDesignObject(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public void setTopView(TopView tv) {
        this.addTopView(tv);
    }

    public void addTopView(TopView view) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (!views.contains(view)) {
            views.add(view);
            this.resetViewNumbers();
            this.addObjectListener(view);
        }
    }

    public void removeTopView(TopView view, boolean removeInMainView) {
        DesignPartView dpv = view.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (dpv == this.getDesignPart().getMainView()) {
            if (views.size() > 1 || removeInMainView) {
                views.remove(view);
                view.setCellView(null);
                this.removeObjectListener(view);
                this.resetViewNumbers();
            }
            if (!this.isAlwaysVisibleInMainView()) {
                view.setCellView(null);
            }
        } else {
            views.remove(view);
            view.setCellView(null);
            this.removeObjectListener(view);
            this.resetViewNumbers();
        }
        if (views.size() == 0) {
            this.allViews.remove(views);
        }
    }

    public void removeTopView(TopView view) {
        this.removeTopView(view, false);
    }

    @Override
    public TopView getTopView() {
        if (this.allViews.isEmpty()) {
            return null;
        }
        Iterator it = this.allViews.iterator();
        TopViewCollection tvc = (TopViewCollection)it.next();
        if (tvc.isEmpty()) {
            return null;
        }
        Iterator it2 = tvc.iterator();
        return (TopView)it2.next();
    }

    @Override
    public TopView getTopViewByID(DesignPartView dpv, String id, int viewnumber) {
        if (id != null) {
            Collection tvc = this.getAllViews(dpv);
            for (TopView tv : tvc) {
                if (!id.equalsIgnoreCase(tv.getViewID())) continue;
                return tv;
            }
            int i = 0;
            for (TopView tv : tvc) {
                if (viewnumber == i) {
                    tv.setViewNumber(viewnumber);
                    return tv;
                }
                ++i;
            }
        }
        return null;
    }

    public TopView getTopViewByGeneratorID(DesignPartView dpv, String generatorID) {
        if (generatorID != null) {
            Collection tvc = this.getAllViews(dpv);
            for (TopView tv : tvc) {
                if (!generatorID.equalsIgnoreCase(tv.getGeneratorID())) continue;
                return tv;
            }
        }
        return null;
    }

    @Override
    public int getViewNumber(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.isEmpty()) {
            return -100;
        }
        Iterator it = views.iterator();
        int i = 0;
        while (it.hasNext()) {
            TopView t = (TopView)it.next();
            if (t == tv) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveViewToPosition(TopView tv, int viewNumber) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        int index = views.indexOf(tv);
        if (index > -1 && index != viewNumber && views.remove(tv)) {
            views.add(viewNumber, tv);
            this.resetViewNumbers();
        }
    }

    public Collection getViewSynonims(DesignPartView dpv) {
        TopViewCollection views = this.getViewsForDPV(dpv);
        ArrayList vs = new ArrayList();
        if (views.size() > 1) {
            Iterator it = views.iterator();
            it.next();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    public Collection getAllViews(DesignPartView dpv) {
        ArrayList vs = new ArrayList();
        TopViewCollection views = this.getViewsForDPV(dpv);
        if (views.size() > 0) {
            Iterator it = views.iterator();
            while (it.hasNext()) {
                vs.add(it.next());
            }
        }
        return vs;
    }

    public void removeAllViews() {
    }

    public TopView getAnotherView(TopView tv) {
        DesignPartView dpv = tv.getDesignPartView();
        TopViewCollection views = this.getViewsForDPV(dpv);
        for (TopView v : views) {
            if (v == tv) continue;
            return v;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView tv) {
        this.removeTopView(tv);
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                tv.setViewNumber(this.getViewNumber(tv));
            }
        }
    }

    @Override
    public int getTopViewsCount() {
        int count = 0;
        for (TopViewCollection tvc : this.allViews) {
            count += tvc.size();
        }
        return count;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            return tvc.size();
        }
        return 0;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView dpv) {
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.getDPV() != dpv) continue;
            if (tvc.size() > 0) {
                return (TopView)tvc.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView dpv) {
        TopViewCollection tvc2;
        for (TopViewCollection tvc2 : this.allViews) {
            if (tvc2.getDPV() != dpv) continue;
            return tvc2;
        }
        tvc2 = new TopViewCollection();
        tvc2.setDPV(dpv);
        this.allViews.add(tvc2);
        return tvc2;
    }

    @Override
    public Collection getAffectedDPVs() {
        HashSet<DesignPartView> col = new HashSet<DesignPartView>();
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.dpv == null || tvc.size() <= 0) continue;
            col.add(tvc.dpv);
        }
        return col;
    }

    public List getUsedInSubviews() {
        HashSet<DesignPartView> col = new HashSet<DesignPartView>();
        for (TopViewCollection tvc : this.allViews) {
            if (tvc.dpv == null || tvc.size() <= 0 || tvc.dpv.isMainDiagram() || !tvc.dpv.isMasterDPV()) continue;
            col.add(tvc.dpv);
        }
        if (col.size() > 0) {
            return new ArrayList(col);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean hasRepresentationInDPV(DesignPartView dpv) {
        TopViewCollection tvc = this.getViewsForDPV(dpv);
        return tvc.size() > 0;
    }

    public boolean isAlwaysVisibleInMainView() {
        return true;
    }

    public boolean isVisibleInMainView() {
        for (TopView tv : this.getViewsForDPV(this.getDesignPart().getMainView())) {
            if (tv.getCellView() == null) continue;
            return true;
        }
        return false;
    }

    public List getAllViewsWithCellViews() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                if (tv.getCellView() == null) continue;
                list.add(tv);
            }
        }
        return list;
    }

    public List getAllTopViews() {
        ArrayList<TopView> list = new ArrayList<TopView>();
        for (TopViewCollection tvc : this.allViews) {
            for (TopView tv : tvc) {
                list.add(tv);
            }
        }
        return list;
    }

    @Override
    public void remove() {
        super.remove();
        for (TopViewCollection tvc : this.allViews) {
            tvc.dpv = null;
            tvc.clear();
        }
        this.allViews.clear();
    }

    public void resetAllTopViewsCustomFormat() {
        for (TopView tv : this.getAllTopViews()) {
            tv.setUseCustomFormat(false);
        }
    }
}

