/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.imports.var.process.RHStructureAttributes;
import oracle.dbtools.crest.imports.var.process.RHStructureEntities;
import oracle.dbtools.crest.imports.var.process.RHStructureProps;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStructure;
import oracle.dbtools.crest.util.logging.Logger;

public class RHStructure
extends RowHandler {
    public static final String OBJECT_TYPE = "STRUCTURE";
    private static final Logger LOGGER = new Logger(RHStructure.class);

    public RHStructure(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStructure(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createStructure(VarFileLine line) {
        block12: {
            try {
                String structureID = this.getField(line, "general_id");
                String structureName = this.getField(line, "STRUCTURE_NAME");
                InfoStructure structure = this.getProcessModel().createInfoStructure();
                if (structure == null) break block12;
                structure.setName(structureName);
                String comment = this.getComment(line);
                structure.setComment(comment);
                structure.setSynonym(this.getSynonym(line));
                structure.setNotes(this.getNotes(line, "NOTE_STRUCTURE_ID"));
                this.setFlows(structure, structureID);
                String volInfo = this.getField(line, "STRUCTURE_VOLUME_INFO");
                if (!"0".equalsIgnoreCase(volInfo)) {
                    try {
                        int percentFactor = 0x200000;
                        int yearFactor = 0x40000000;
                        int vi = Integer.parseInt(volInfo);
                        if (vi < 0) {
                            if ((vi += yearFactor) < 0) {
                                vi += yearFactor;
                                structure.setGrowthRateUnit(InfoStructure.GROWTH_RATE_UNITS[1]);
                            } else {
                                structure.setGrowthRateUnit(InfoStructure.GROWTH_RATE_UNITS[2]);
                            }
                        }
                        if (vi > 0) {
                            int percent = vi / percentFactor;
                            int volume = vi % percentFactor;
                            structure.setVolume(volume);
                            structure.setGrowthRatePercent(percent);
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.error("Error in RHStructure.createStructure()", e);
                    }
                }
                try {
                    List attriburtesIDs = this.getAttributesIDs(structureID);
                    int length = attriburtesIDs.size();
                    for (int i = 0; i < length; ++i) {
                        String attrID = (String)attriburtesIDs.get(i);
                        Attribute attribute = (Attribute)this.getAllCreatedObjects().get(attrID);
                        if (attribute == null) continue;
                        structure.addAttribute(attribute);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in RHStructure.createStructure() - Assign Attributes", e);
                }
                this.addCreatedObject(structureID, structure);
            }
            catch (Exception e) {
                LOGGER.error("Error in RHStructure.createStructure()", e);
            }
        }
        this.removeSelectedLine(line);
    }

    private List getAttributesIDs(String structureID) {
        ArrayList<String> list = new ArrayList<String>();
        List entities = (List)this.getSpecificRowHandler(RHStructureEntities.class).getMap().get(structureID);
        if (entities != null) {
            int length = entities.size();
            for (int i = 0; i < length; ++i) {
                VarFileLine line = (VarFileLine)entities.get(i);
                String entID = this.getField(line, "general_id");
                List attributes = (List)this.getSpecificRowHandler(RHStructureAttributes.class).getMap().get(entID);
                if (attributes == null) continue;
                int len = attributes.size();
                for (int j = 0; j < len; ++j) {
                    VarFileLine selectedLine = (VarFileLine)attributes.get(j);
                    list.add(this.getField(selectedLine, "STRUCTURE_ATTR_ATTRIBUTE_ID"));
                }
            }
        }
        return list;
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "STRUCTURE_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private void setFlows(InfoStructure structure, String structureID) {
        List list = this.getSpecificRowHandler(RHStructureProps.class).getOwnLines();
        for (int i = list.size() - 1; i >= 0; --i) {
            VarFileLine line = (VarFileLine)list.get(i);
            if (!structureID.equalsIgnoreCase(this.getField(line, "general_id"))) continue;
            String flowID = this.getField(line, "DESTINATION_OBJECT_ID");
            Flow flow = (Flow)this.getAllCreatedObjects().get(flowID);
            if (flow != null) {
                flow.addInfoStructure(structure);
            }
            list.remove(line);
        }
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("STRUCTURESYNONYM_O") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

