/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.swingui.process.DPVProcess;
import oracle.dbtools.crest.util.logging.Logger;

public class RHStore
extends RowHandler {
    public static final String OBJECT_TYPE = "INFO_STORE";
    private static final Logger LOGGER = new Logger(RHStore.class);

    public RHStore(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStore(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createStore(VarFileLine line) {
        try {
            DataFlowDesign diagram;
            String storeID = this.getField(line, "general_id");
            String storeName = this.getField(line, "INFO_STORE_NAME");
            String processID = this.getField(line, "INFO_STORE_PROCESS_ID");
            String diagramID = this.getField(line, "INFO_STORE_PMID");
            DesignObject store = null;
            if (!"0".equalsIgnoreCase(processID)) {
                DataFlowDesign diagram2;
                Process process = (Process)this.getAllCreatedObjects().get(processID);
                if (process != null && (diagram2 = process.getDiagram()) != null) {
                    store = diagram2.createInfoStore();
                    ((DPVProcess)diagram2.getMainView()).createViewSynonim(store);
                }
            } else if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                store = diagram.createInfoStore();
                ((DPVProcess)diagram.getMainView()).createViewSynonim(store);
            }
            if (store != null) {
                store.setName(storeName);
                String comment = this.getComment(line);
                store.setComment(comment);
                ((InfoStore)store).setSystemObjective(this.getSystemObjective(line));
                ((AbstractProcessObject)store).setSynonym(this.getSynonym(line));
                store.setNotes(this.getNotes(line, "NOTE_STORE_ID"));
                this.addCreatedObject(storeID, store);
                this.removeSelectedLine(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in RHStore.createStore()", e);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "INFO_STORE_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSystemObjective(VarFileLine line) {
        String comment = null;
        String soID = this.getField(line, "INFO_STORE_SYSTEM_OBJECTIVE");
        if (!"0".equalsIgnoreCase(soID)) {
            VarFileLine commentLine = this.getCommentLine(soID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("INFO_STORESYNONYM_") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

