/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;

public class RHProcessModel
extends RowHandler {
    public static final String OBJECT_TYPE = "PROCESS_MODEL";
    List lines = new ArrayList();

    public RHProcessModel(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
            if (!this.lines.contains(line)) {
                this.lines.add(line);
            }
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createDataFlowDesign(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createDataFlowDesign(VarFileLine line) {
        String objectID = this.getField(line, "general_id");
        if (this.getAllCreatedObjects().get(objectID) == null) {
            DataFlowDesign design = this.getDesign().getProcessModel().addDataFlowDesign(null);
            design.setVisible(false);
            this.getDesign().getProcessModel().setDataFlowDesign(design);
            design.setName(this.getField(line, "PROCESS_MODEL_NAME"));
            this.addCreatedObject(objectID, design);
        }
    }

    @Override
    public List getOwnLines() {
        return this.lines;
    }
}

