/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.util.logging.Logger;

public class RHProcess
extends RowHandler {
    public static final String OBJECT_TYPE = "PROCESS";
    private static final Logger LOGGER = new Logger(RHProcess.class);

    public RHProcess(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createProcess(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private Process getParent(String parentID) {
        Process process = null;
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            DataFlowDesign diagram;
            if (!selectedLine.getType().equalsIgnoreCase(OBJECT_TYPE) || !parentID.equalsIgnoreCase(this.getField(selectedLine, "general_id"))) continue;
            String pID = this.getField(selectedLine, "PROCESS_PARENT_PROCESS_ID");
            String processName = this.getField(selectedLine, "PROCESS_NAME");
            String diagramID = this.getField(selectedLine, "PROCESS_PMID");
            if (!"0".equalsIgnoreCase(pID)) {
                DataFlowDesign diagram2;
                Process parent = (Process)this.getAllCreatedObjects().get(pID);
                if (parent == null) {
                    parent = this.getParent(pID);
                }
                if (parent != null && (diagram2 = parent.getDiagram()) != null) {
                    process = diagram2.createProcess();
                }
            } else if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                process = diagram.createProcess();
            }
            if (process != null) {
                String type = this.getField(selectedLine, "PROCESS_TYPE");
                if ("0".equalsIgnoreCase(type)) {
                    process.setType(1);
                    process.getDiagram().setVisible(false);
                }
                this.addCreatedObject(parentID, process);
            }
            return process;
        }
        return process;
    }

    private void createProcess(VarFileLine line) {
        block32: {
            try {
                Process process;
                String processID;
                block33: {
                    processID = this.getField(line, "general_id");
                    String processName = this.getField(line, "PROCESS_NAME");
                    String parentID = this.getField(line, "PROCESS_PARENT_PROCESS_ID");
                    String diagramID = this.getField(line, "PROCESS_PMID");
                    process = (Process)this.getAllCreatedObjects().get(processID);
                    if (process == null) {
                        String type;
                        DataFlowDesign diagram;
                        if (!"0".equalsIgnoreCase(parentID)) {
                            DataFlowDesign diagram2;
                            Process parent = (Process)this.getAllCreatedObjects().get(parentID);
                            if (parent == null) {
                                parent = this.getParent(parentID);
                            }
                            if (parent != null && (diagram2 = parent.getDiagram()) != null) {
                                process = diagram2.createProcess();
                            }
                        } else if (!"".equalsIgnoreCase(diagramID) && (diagram = (DataFlowDesign)this.getAllCreatedObjects().get(diagramID)) != null) {
                            process = diagram.createProcess();
                        }
                        if (process != null && "0".equalsIgnoreCase(type = this.getField(line, "PROCESS_TYPE"))) {
                            process.setType(1);
                            process.getDiagram().setVisible(false);
                        }
                    }
                    if (process == null) break block32;
                    process.setName(processName);
                    String comment = this.getComment(line);
                    process.setComment(comment);
                    process.setSynonym(this.getSynonym(line));
                    process.setNotes(this.getNotes(line, "NOTE_PROCESS_ID"));
                    process.setFootNote(this.getField(line, "PROCESS_FOOTNOTE"));
                    String mode = this.getField(line, "PROCESS_MODE");
                    try {
                        int value = Integer.parseInt(mode);
                        process.setMode(Process.MODES[value]);
                        if (value == 1) {
                            String batchMinTrans = this.getField(line, "PROCESS_BATCH_MIN_TRANS");
                            try {
                                int bmt = Integer.parseInt(batchMinTrans);
                                process.setBatchMinimumTransactions(bmt);
                            }
                            catch (NumberFormatException bmt) {
                                // empty catch block
                            }
                            String batchTimeUnit = this.getField(line, "PROCESS_BATCH_TIME_UNIT");
                            try {
                                int btu = Integer.parseInt(batchTimeUnit);
                                process.setBatchTimeUnit(Process.BATCH_TIME_UNITS[btu - 1]);
                            }
                            catch (NumberFormatException e) {
                                LOGGER.error("Error in RHProcess.createProcess()", e);
                            }
                            break block33;
                        }
                        if (value != 2) break block33;
                        String longestResponseTime = this.getField(line, "PROCESS_LONGEST_RESPONSE_TIME");
                        try {
                            int lrt = Integer.parseInt(longestResponseTime);
                            process.setInteractiveLongestResponseTime(lrt);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Error in RHProcess.createProcess()", e);
                        }
                        String responseTimeUnit = this.getField(line, "PROCESS_RESPONSE_TIME_UNIT");
                        try {
                            int rtu = Integer.parseInt(responseTimeUnit);
                            process.setInteractiveResponseTimeUnit(Process.INTERACTIVE_RESPONSE_TIME_UNITS[rtu - 1]);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.error("Error in RHProcess.createProcess()", e);
                        }
                    }
                    catch (NumberFormatException value) {
                        // empty catch block
                    }
                }
                String freqTimes = this.getField(line, "PROCESS_FREQ_TIMES");
                try {
                    int value = Integer.parseInt(freqTimes);
                    process.setFrequencyTimes(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Error in RHProcess.createProcess()", e);
                }
                String freqTimeUnit = this.getField(line, "PROCESS_FREQ_TIME_UNIT");
                try {
                    int value = Integer.parseInt(freqTimeUnit);
                    if (value <= 6) {
                        process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[value - 1]);
                    } else {
                        process.setFrequencyTimeUnit(Process.FREQUENCY_TIME_UNITS[8]);
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Error in RHProcess.createProcess()", e);
                }
                String priority = this.getField(line, "PROCESS_PRIORITY");
                try {
                    int value = Integer.parseInt(priority);
                    process.setPriority(Process.PRIORITY[value]);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Error in RHProcess.createProcess()", e);
                }
                String peakPeriods = this.getField(line, "PROCESS_PEAK_PERIODS");
                try {
                    int value = Integer.parseInt(peakPeriods);
                    if (value > 0) {
                        for (int i = 0; i < 24; ++i) {
                            int selected = value & 1 << i;
                            process.getPeakPeriods()[i] = selected != 0;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Error in RHProcess.createProcess()", e);
                }
                this.addCreatedObject(processID, process);
                this.removeSelectedLine(line);
            }
            catch (Exception e) {
                LOGGER.error("Error in RHProcess.createProcess()", e);
            }
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "PROCESS_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("PROCESSSYNONYM_OBJ") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

