/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.process.RHPOSynonyms;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.util.logging.Logger;

public class RHInfoFlow
extends RowHandler {
    public static final String OBJECT_TYPE = "INFO_FLOW";
    private static final Logger LOGGER = new Logger(RHInfoFlow.class);

    public RHInfoFlow(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createFlow(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createFlow(VarFileLine line) {
        try {
            String flowID = this.getField(line, "general_id");
            String flowName = this.getField(line, "INFO_FLOW_NAME");
            Flow flow = (Flow)this.getAllCreatedObjects().get(flowID);
            if (flow != null) {
                Event event;
                flow.setName(flowName);
                String comment = this.getComment(line);
                flow.setComment(comment);
                flow.setSynonym(this.getSynonym(line));
                flow.setSystemObjective(this.getSystemObjective(line));
                flow.setNotes(this.getNotes(line, "NOTE_FLOW_ID"));
                String eventID = this.getField(line, "INFO_FLOW_EVENT_ID");
                if (!"0".equalsIgnoreCase(eventID) && (event = (Event)this.getAllCreatedObjects().get(eventID)) != null) {
                    flow.setEvent(event);
                }
                this.addCreatedObject(flowID, flow);
                this.removeSelectedLine(line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in RHInfoFlow.createFlow()", e);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "INFO_FLOW_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHPOSynonyms.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("INFO_FLOWSYNONYM_O") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }

    private String getSystemObjective(VarFileLine line) {
        String comment = null;
        String soID = this.getField(line, "INFO_FLOW_SYSTEM_OBJECTIVE");
        if (!"0".equalsIgnoreCase(soID)) {
            VarFileLine commentLine = this.getCommentLine(soID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }
}

