/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHNotes;
import oracle.dbtools.crest.imports.var.RowCollector;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.logging.ImportLogger;

public class RowHandler {
    private RowHandler successor = null;
    private RowCollector rowCollector = null;
    protected ImportLogger importLog = new ImportLogger();

    public RowHandler(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        this.rowCollector = new RowCollector();
        this.rowCollector.initialize(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    public void add(RowHandler succ) {
        RowHandler end = this;
        while (end.successor != null) {
            end = end.successor;
        }
        end.successor = succ;
    }

    public RowHandler next() {
        return this.successor;
    }

    public List getAllTypes() {
        return new ArrayList();
    }

    public void handle(VarFileLine line, boolean hasMapping) {
        this.nextHandler(line, hasMapping);
    }

    protected void nextHandler(VarFileLine line, boolean hasMapping) {
        if (this.successor != null) {
            this.successor.setImportLog(this.importLog);
            this.successor.handle(line, hasMapping);
        }
    }

    public RowHandler getSpecificRowHandler(Class classtype) {
        if (this.getClass() == classtype) {
            return this;
        }
        if (this.successor != null) {
            return this.successor.getSpecificRowHandler(classtype);
        }
        return null;
    }

    public void read(VarFileLine line) {
        this.nextRead(line);
    }

    protected void nextRead(VarFileLine line) {
        if (this.successor != null) {
            this.successor.read(line);
        }
    }

    protected String getNotes(VarFileLine line, String objectID) {
        StringBuffer comment = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHNotes.class).getOwnLines()) {
            VarFileLine commentLine;
            String entityID = this.getField(selectedLine, objectID);
            if (!id.equalsIgnoreCase(entityID)) continue;
            String textID = this.getField(selectedLine, "note_text_id");
            String noteName = this.getField(selectedLine, "note_text_name");
            if ("0".equalsIgnoreCase(textID) || (commentLine = this.getCommentLine(textID, "ANLTEXT")) == null) continue;
            if (comment.length() > 0) {
                comment.append("\n\n");
            }
            comment.append(noteName).append("\n");
            comment.append(this.getField(commentLine, "TEXT_COMMENT_2"));
        }
        return comment.toString();
    }

    protected void addSelectedLine(VarFileLine read) {
        this.rowCollector.addSelectedLine(read);
    }

    protected void addForeignKeyLine(VarFileLine read) {
        this.rowCollector.addForeignKeyLine(read);
    }

    protected void addPrimaryKeyLine(VarFileLine read) {
        this.rowCollector.addPrimaryKeyLine(read);
    }

    protected void addColumnLine(VarFileLine read) {
        this.rowCollector.addColumnLine(read);
    }

    protected void addReferences(String id, Object reference) {
        this.rowCollector.addReferences(id, reference);
    }

    protected void addCreatedObject(String id, ModelIDObject object) {
        this.rowCollector.addCreatedObject(id, object);
    }

    protected boolean contains(VarFileLine line) {
        return this.rowCollector.contains(line);
    }

    public List getAllSelectedLines() {
        return this.rowCollector.getAllSelectedLines();
    }

    public List getCommentLines() {
        return this.rowCollector.getCommentLines();
    }

    public void setCommentLines(List commentLines) {
        this.rowCollector.setCommentLines(commentLines);
    }

    public List getAllForeignKeyLines() {
        return this.rowCollector.getAllForeignKeyLines();
    }

    public List getAllPrimaryKeyLines() {
        return this.rowCollector.getAllPrimaryKeyLines();
    }

    public List getAllColumnLines() {
        return this.rowCollector.getAllColumnLines();
    }

    public VarFileLine getLastSelectedLine() {
        return this.rowCollector.getLastSelectedLine();
    }

    public List getSelectedLinesOfType(String type) {
        return this.rowCollector.getSelectedLinesOfType(type);
    }

    public List removeSelectedLinesOfType(String type) {
        return this.rowCollector.removeSelectedLinesOfType(type);
    }

    public void removeSelectedLine(VarFileLine line) {
        this.rowCollector.removeSelectedLine(line);
    }

    public List getOwnLines() {
        return null;
    }

    public Map getMap() {
        return null;
    }

    public void removeSelectedLineObject(VarFileLine line) {
        this.rowCollector.removeSelectedLineObject(line);
    }

    public void removeAllSelectedLines() {
        this.rowCollector.removeAllSelectedLines();
    }

    public Hashtable getFieldConstants() {
        return this.rowCollector.getFieldConstants();
    }

    protected String getField(VarFileLine line, String constantName) {
        return this.getField(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getCommentField(VarFileLine line, String constantName) {
        return this.getCommentField(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getDefinitionField(VarFileLine line, String constantName) {
        return this.rowCollector.getDefinitionField(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getCommentField(String line, Object Nr) {
        return this.rowCollector.getCommentField(line, Nr);
    }

    protected String getField(String line, Object Nr) {
        return this.rowCollector.getField(line, Nr);
    }

    public VarFileLine getCommentLine(String commentId, String type) {
        return this.rowCollector.getCommentLine(commentId, type);
    }

    public VarFileLine getCommentLine(String commentId, String type, List lines) {
        return this.rowCollector.getCommentLine(commentId, type, lines);
    }

    public ModelIDObject getCreatedObject(String id) {
        return this.rowCollector.getCreatedObject(id);
    }

    public Design getDesign() {
        return this.rowCollector.getDesign();
    }

    protected void setCreatorChanger(ModelIDObject object, VarFileLine line) {
        this.rowCollector.setCreatorChanger(object, line);
    }

    public Map getAllCreatedObjects() {
        return this.rowCollector.getAllCreatedObjects();
    }

    public Map getAllReferences() {
        return this.rowCollector.getAllReferences();
    }

    public LogicalDesign getLogicalDesign() {
        return this.rowCollector.getLogicalDesign();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.rowCollector.getPhysicalDesign();
    }

    public DataFlowDesign getDataFlowDesign() {
        return this.rowCollector.getDataFlowDesign();
    }

    public ProcessModel getProcessModel() {
        return this.rowCollector.getProcessModel();
    }

    public ImportLogger getImportLog() {
        return this.importLog;
    }

    public void setImportLog(ImportLogger importLog) {
        this.importLog = importLog;
    }
}

