/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.MDUser;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.util.logging.Logger;

public class RowCollector {
    private List allSelectedLines;
    private List allForeignKeyLines;
    private List allPrimaryKeyLines;
    private List allColumnLines;
    private Map allCreatedObjects;
    private Map allReferences;
    private Fields constants;
    private Design design;
    private List commentLines;
    private static final Logger LOGGER = new Logger(RowCollector.class);

    public void initialize(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        this.setDesign(design);
        this.setFieldConstants(constants);
        this.setAllSelectedLines(allSelectedLines);
        this.setAllCreatedObjects(allCreatedObjects);
        this.setAllForeignKeyLines(allForeignKeyLines);
        this.setAllPrimaryKeyLines(allPrimaryKeyLines);
        this.setAllColumnLines(allColumnLines);
        this.setAllReferences(allReferences);
        this.setCommentLines(commentLines);
    }

    public void setAllCreatedObjects(Map allCreatedObjects) {
        this.allCreatedObjects = allCreatedObjects;
    }

    public Map getAllCreatedObjects() {
        return this.allCreatedObjects;
    }

    public Map getAllReferences() {
        return this.allReferences;
    }

    protected void addCreatedObject(String id, ModelIDObject object) {
        this.allCreatedObjects.put(id, object);
    }

    public ModelIDObject getCreatedObject(String id) {
        return (ModelIDObject)this.allCreatedObjects.get(id);
    }

    public void setAllSelectedLines(List allSelectedLines) {
        this.allSelectedLines = allSelectedLines;
    }

    public void setAllForeignKeyLines(List allForeignKeyLines) {
        this.allForeignKeyLines = allForeignKeyLines;
    }

    public void setAllPrimaryKeyLines(List allPrimaryKeyLines) {
        this.allPrimaryKeyLines = allPrimaryKeyLines;
    }

    public void setAllColumnLines(List allColumnLines) {
        this.allColumnLines = allColumnLines;
    }

    public void setAllReferences(Map allReferences) {
        this.allReferences = allReferences;
    }

    protected void addSelectedLine(VarFileLine read) {
        this.allSelectedLines.add(read);
    }

    protected void addForeignKeyLine(VarFileLine read) {
        this.allForeignKeyLines.add(read);
    }

    protected void addPrimaryKeyLine(VarFileLine read) {
        this.allPrimaryKeyLines.add(read);
    }

    protected void addColumnLine(VarFileLine read) {
        this.allColumnLines.add(read);
    }

    protected void addReferences(String id, Object reference) {
        this.allReferences.put(id, reference);
    }

    protected boolean contains(VarFileLine line) {
        return this.allSelectedLines.contains(line);
    }

    public List getAllSelectedLines() {
        return this.allSelectedLines;
    }

    public List getAllForeignKeyLines() {
        return this.allForeignKeyLines;
    }

    public List getAllPrimaryKeyLines() {
        return this.allPrimaryKeyLines;
    }

    public List getAllColumnLines() {
        return this.allColumnLines;
    }

    public VarFileLine getLastSelectedLine() {
        if (this.allSelectedLines.size() > 0) {
            return (VarFileLine)this.allSelectedLines.get(this.allSelectedLines.size() - 1);
        }
        return null;
    }

    public List getSelectedLinesOfType(String type) {
        ArrayList<VarFileLine> selected = new ArrayList<VarFileLine>();
        for (VarFileLine line : this.allSelectedLines) {
            if (!line.getType().equalsIgnoreCase(type)) continue;
            selected.add(line);
        }
        return selected;
    }

    public List getSelectedLinesOfType(String type, List lines) {
        ArrayList<VarFileLine> selected = new ArrayList<VarFileLine>();
        for (VarFileLine line : lines) {
            if (!line.getType().equalsIgnoreCase(type)) continue;
            selected.add(line);
        }
        return selected;
    }

    public List removeSelectedLinesOfType(String type) {
        ArrayList<VarFileLine> selectedLinesToDelete = new ArrayList<VarFileLine>();
        for (VarFileLine line : this.allSelectedLines) {
            if (!line.getType().equalsIgnoreCase(type)) continue;
            selectedLinesToDelete.add(line);
        }
        this.allSelectedLines.removeAll(selectedLinesToDelete);
        return this.allSelectedLines;
    }

    public void removeSelectedLine(VarFileLine line) {
        int index = this.allSelectedLines.indexOf(line);
        if (index > -1) {
            this.allSelectedLines.remove(index);
        }
    }

    public void removeSelectedLineObject(VarFileLine line) {
        this.allSelectedLines.remove(line);
    }

    public void removeAllSelectedLines() {
        this.allSelectedLines.clear();
    }

    public void setDesign(Design design) {
        this.design = design;
    }

    public Design getDesign() {
        return this.design;
    }

    public LogicalDesign getLogicalDesign() {
        return this.getDesign().getLogicalDesign();
    }

    public RelationalDesign getPhysicalDesign() {
        return this.getDesign().getRelationalDesign();
    }

    public DataFlowDesign getDataFlowDesign() {
        return this.getDesign().getProcessModel().getDataFlowDesign();
    }

    public ProcessModel getProcessModel() {
        return this.getDesign().getProcessModel();
    }

    public void setFieldConstants(Fields fields) {
        this.constants = fields;
    }

    protected String toTime(String time) {
        StringBuffer buffer = new StringBuffer(time);
        buffer.setLength(23);
        buffer.setCharAt(10, ' ');
        buffer.setCharAt(13, ':');
        buffer.setCharAt(16, ':');
        return buffer.toString();
    }

    protected void setCreatorChanger(ModelIDObject object, VarFileLine line) {
        object.getCreation().setUser(new MDUser(this.getField(line, "general_creator")));
        object.getCreation().setTimeString(this.toTime(this.getField(line, "general_creation_time")));
        object.getChange().setUser(new MDUser(this.getField(line, "general_changer")));
        object.getChange().setTimeString(this.toTime(this.getField(line, "general_change_time")));
    }

    public Hashtable getFieldConstants() {
        return this.constants.getFields();
    }

    protected String getField(VarFileLine line, String constantName) {
        return this.getField(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getCommentField(VarFileLine line, String constantName) {
        return this.getCommentField(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getDefinitionField(String line, Object Nr) {
        String field = "";
        StringBuffer buffer = new StringBuffer("");
        Integer fieldNr = (Integer)Nr;
        if (!"".equalsIgnoreCase(line)) {
            StringTokenizer tok = new StringTokenizer(line, ",");
            for (int tokNr = 0; tok.hasMoreTokens() && tokNr < fieldNr; ++tokNr) {
                field = tok.nextToken().trim();
            }
            buffer = new StringBuffer(field);
            while (tok.hasMoreTokens()) {
                buffer.append(",\n   ");
                buffer.append(tok.nextToken().trim());
            }
            field = buffer.toString();
            if (field.startsWith("\"") && field.endsWith("\"")) {
                field = field.substring(1, field.length() - 1);
            }
        } else {
            LOGGER.error("Field cannot be found because there is no line");
        }
        return field.trim();
    }

    protected String getCommentField(String line, Object Nr) {
        String field = "";
        StringBuffer buffer = new StringBuffer("");
        Integer fieldNr = (Integer)Nr;
        if (!"".equalsIgnoreCase(line)) {
            StringTokenizer tok = new StringTokenizer(line, ",");
            for (int tokNr = 0; tok.hasMoreTokens() && tokNr < fieldNr; ++tokNr) {
                field = tok.nextToken().trim();
            }
            buffer = new StringBuffer(field);
            while (tok.hasMoreTokens()) {
                buffer.append(tok.nextToken().trim());
            }
            field = buffer.toString();
            if (field.startsWith("\"") && field.endsWith("\"")) {
                field = field.substring(1, field.length() - 1);
            }
        } else {
            LOGGER.error("Field cannot be found because there is no line");
        }
        return field.trim();
    }

    protected String getField(String line, Object Nr) {
        try {
            boolean startwithQuote = false;
            StringBuffer field = new StringBuffer();
            Integer fieldNr = (Integer)Nr;
            if (!"".equalsIgnoreCase(line)) {
                StringTokenizer tok = new StringTokenizer(line, ",");
                int tokNr = 1;
                while (tok != null && tok.hasMoreTokens() && fieldNr != null) {
                    String token = tok.nextToken();
                    if (tokNr == fieldNr) {
                        field.append(token);
                        if (field.toString().trim().startsWith("\"") && !field.toString().trim().endsWith("\"")) {
                            startwithQuote = true;
                        }
                    }
                    if (tokNr > fieldNr && startwithQuote) {
                        String nextToken = token;
                        field.append(nextToken);
                        if (nextToken.endsWith("\"")) {
                            startwithQuote = false;
                            break;
                        }
                    }
                    ++tokNr;
                }
                if (field.toString().startsWith("\"") && field.toString().endsWith("\"")) {
                    field = new StringBuffer(field.toString().substring(1, field.length() - 1));
                }
            } else {
                LOGGER.error("Field cannot be found because there is no line");
            }
            return field.toString();
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    public VarFileLine getCommentLine(String commentId, String type) {
        List allComments = this.getSelectedLinesOfType(type);
        for (VarFileLine line : allComments) {
            if (!this.getField(line, "general_id").equalsIgnoreCase(commentId)) continue;
            return line;
        }
        return null;
    }

    public VarFileLine getCommentLine(String commentId, String type, List lines) {
        List allComments = this.getSelectedLinesOfType(type, lines);
        for (VarFileLine line : allComments) {
            if (!this.getField(line, "general_id").equalsIgnoreCase(commentId)) continue;
            return line;
        }
        return null;
    }

    public List getCommentLines() {
        return this.commentLines;
    }

    public void setCommentLines(List commentLines) {
        this.commentLines = commentLines;
    }
}

