/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.util.logging.Logger;

public class RHText
extends RowHandler {
    public static final String OBJECT_TYPE = "TEXT";
    public static final String OBJECT_TYPE2 = "ANLTEXT";
    private static final Logger LOGGER = new Logger(RHText.class);

    public RHText(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE2)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE2);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        this.nextHandler(line, hasMapping);
    }

    @Override
    public void addSelectedLine(VarFileLine line) {
        VarFileLine prevLine = this.getLastSelectedLine();
        if (prevLine != null && (prevLine.getType().equalsIgnoreCase(OBJECT_TYPE) || prevLine.getType().equalsIgnoreCase(OBJECT_TYPE2))) {
            String prevCommentWithSpace = prevLine.getLine();
            if (!this.isComplete(prevLine)) {
                prevLine.setLine(prevCommentWithSpace + "\n" + line.getLine());
                return;
            }
        }
        super.addSelectedLine(line);
    }

    private boolean isComplete(VarFileLine line) {
        String comment = this.getComment(line, "text_comment").trim();
        if (comment.length() > 1) {
            boolean check = comment.startsWith("\"") && comment.endsWith("\"");
            return check;
        }
        return false;
    }

    protected String getComment(VarFileLine line, String constantName) {
        return this.getComment(line.getLine(), this.getFieldConstants().get(constantName));
    }

    protected String getComment(String line, Object Nr) {
        boolean startwithQuote = false;
        StringBuffer field = new StringBuffer();
        Integer fieldNr = (Integer)Nr;
        if (!"".equalsIgnoreCase(line)) {
            StringTokenizer tok = new StringTokenizer(line, ",");
            int tokNr = 1;
            while (tok != null && tok.hasMoreTokens() && fieldNr != null) {
                String token = tok.nextToken().trim();
                if (tokNr == fieldNr) {
                    field.append(token);
                    if (field.toString().startsWith("\"") && !field.toString().endsWith("\"")) {
                        startwithQuote = true;
                    }
                }
                if (tokNr > fieldNr && startwithQuote) {
                    String nextToken = token.trim();
                    field.append(nextToken.trim());
                    if (nextToken.trim().endsWith("\"")) {
                        startwithQuote = false;
                        break;
                    }
                }
                ++tokNr;
            }
        } else {
            LOGGER.error("Field cannot be found because there is no line");
            this.importLog.addError("Field cannot be found because there is no line");
        }
        return field.toString();
    }
}

