/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxySetDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHTable
extends RowHandler {
    public static final String OBJECT_TYPE = "TABLES";
    public static final String OBJECT_TYPE_COOL = "TABLE";
    private static final Logger LOGGER = new Logger(RHTable.class);

    public RHTable(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createTable(line, hasMapping);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createTable(VarFileLine line, boolean hasMapping) {
        String keyTableSpaces = this.getField(line, "table_TABLE_SPACES");
        TableSpaceDB2 tableSpace = (TableSpaceDB2)this.getCreatedObject(keyTableSpaces);
        if (!hasMapping) {
            Table table = this.getPhysicalDesign().getTableSet().createTable(null);
            this.fillElements(line, table, tableSpace);
            this.addCreatedObject(this.getField(line, "general_id"), table);
            this.removeSelectedLine(line);
        } else {
            String idTable = this.getField(line, "general_id");
            Table table = (Table)this.getAllCreatedObjects().get(idTable);
            if (table == null) {
                String tbName = this.getField(line, "table_name");
                table = (Table)this.getDesign().getRelationalDesign().getTableSet().getByName(tbName);
                if (table != null) {
                    this.addCreatedObject(this.getField(line, "general_id"), table);
                } else {
                    table = this.getPhysicalDesign().getTableSet().createTable(null);
                    this.addCreatedObject(this.getField(line, "general_id"), table);
                }
            }
            if (table != null) {
                this.fillElements(line, table, tableSpace);
                this.removeSelectedLine(line);
            }
        }
    }

    private void fillRows(VarFileLine line, TableProxyDB2 tableProxy) {
        this.fillMaxRows(line, tableProxy);
        this.fillInitRows(line, tableProxy);
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "table_text").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "table_text"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private void fillDataCapture(VarFileLine line, TableProxyDB2 tableProxy) {
        String dataCapture = this.getField(line, "table_DATA_CAPTURE");
        if (dataCapture.equalsIgnoreCase("0")) {
            tableProxy.setDataCapture(false);
        } else {
            tableProxy.setDataCapture(true);
        }
    }

    private void fillObid(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int obid = Integer.parseInt(this.getField(line, "table_OBID"));
            if (obid > 0) {
                tableProxy.setObid(obid);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillObid : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL OBID format near " + line);
        }
    }

    private void fillAudit(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int audit = Integer.parseInt(this.getField(line, "table_AUDIT"));
            String[] auditChoises = TableProxyDB2.getAuditChoices();
            switch (audit) {
                case 1: 
                case 2: 
                case 3: {
                    tableProxy.setAudit(auditChoises[audit - 1]);
                    break;
                }
                default: {
                    tableProxy.setAudit(auditChoises[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillAudit : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL AUDIT format near " + line);
        }
    }

    private void fillInitRows(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            long initRows = Long.parseLong(this.getField(line, "table_INIT_ROWS"));
            if (initRows >= 1L) {
                tableProxy.setInitialRowNumber(initRows);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillInitRows : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL INIT ROWS format near " + line);
        }
    }

    private void fillMaxRows(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            long maxRows = Long.parseLong(this.getField(line, "table_MAX_ROWS"));
            if (maxRows >= 1L) {
                tableProxy.setMaxRowNumber(maxRows);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillMaxRows : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL MAX ROWS format near " + line);
        }
    }

    private void fillInsertRate(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float insertRate = Float.parseFloat(this.getField(line, "table_INSERT_RATE"));
            if ((double)insertRate >= -3.4E38) {
                tableProxy.setAnnualUpdateRateInsert(insertRate);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillInsertRate : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL INSERT RATE format near " + line);
        }
    }

    private void fillDeleteRate(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float deleteRate = Float.parseFloat(this.getField(line, "table_DELETE_RATE"));
            if ((double)deleteRate >= -3.4E38) {
                tableProxy.setAnnualUpdateRateDelete(deleteRate);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillDeleteRate : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL DELETE RATE format near " + line);
        }
    }

    private void fillGrowthHorizon(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float growthHorizon = Float.parseFloat(this.getField(line, "table_GROWTH_HORIZON"));
            if ((double)growthHorizon >= -3.4E38) {
                tableProxy.setGrowthHorizon((int)growthHorizon);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillGrowthHorizon : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL GROWTH HORIZON format near " + line);
        }
    }

    private void fillActiveInserts(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float activeInserts = Float.parseFloat(this.getField(line, "table_ACTIVE_INSERTS"));
            if ((double)activeInserts >= -3.4E38) {
                tableProxy.setActiveGroupInsert(activeInserts);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillActiveInserts : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL ACTIVE INSERTS format near " + line);
        }
    }

    private void fillActiveDel(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float activeDel = Float.parseFloat(this.getField(line, "table_ACTIVE_DEL"));
            if ((double)activeDel >= -3.4E38) {
                tableProxy.setActiveGroupDelete(activeDel);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillActiveDel : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL ACTIVE DEL format near " + line);
        }
    }

    private void fillActiveData(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float activeData = Float.parseFloat(this.getField(line, "table_ACTIVE_DATA"));
            if ((double)activeData >= -3.4E38) {
                tableProxy.setActiveGroupData(activeData);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillActiveData : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL ACTIVE DATA format near " + line);
        }
    }

    private void fillGrowthMethod(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int growthMethod = Integer.parseInt(this.getField(line, "table_GROWTH_METHOD"));
            String[] choisesGrowth = TableProxyDB2.getGrowthMethodChoices();
            switch (growthMethod) {
                case 1: 
                case 2: 
                case 3: {
                    tableProxy.setGrowthMethod(choisesGrowth[growthMethod - 1]);
                    break;
                }
                default: {
                    tableProxy.setGrowthMethod(choisesGrowth[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillGrowthMethod : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
        }
    }

    private void fillExcludeFreespace(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int excludeFreespace = Integer.parseInt(this.getField(line, "table_EXCLUDE_FREESPACE"));
            if (excludeFreespace == 0) {
                tableProxy.setFreepageExcluded(false);
            } else if (excludeFreespace == 1) {
                tableProxy.setFreepageExcluded(true);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillExcludeFreespace : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL EXCLUDE FREESPACE format near " + line);
        }
    }

    private void fillCatalogCard(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int catalogCard = Integer.parseInt(this.getField(line, "table_catalog_card"));
            if (catalogCard > 0) {
                tableProxy.setNumberOfRows(catalogCard);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillCatalogCard : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CATALOG CARD format near " + line);
        }
    }

    private void fillCatalogRecLength(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int maxRecLength = Integer.parseInt(this.getField(line, "table_CATALOG_REC_LENGTH"));
            if (maxRecLength > 0) {
                tableProxy.setRecordLength(maxRecLength);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillCatalogRecLength : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CATALOG REC LENGTH format near " + line);
        }
    }

    private void fillCatalogNpages(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            float catalogNPages = Float.parseFloat(this.getField(line, "table_CATALOG_NPAGES"));
            if (catalogNPages > 0.0f) {
                tableProxy.setNumberOfPages((int)catalogNPages);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillCatalogNpages : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CATALOG NPAGES format near " + line);
        }
    }

    private void fillPctPages(VarFileLine line, TableProxyDB2 tableProxy) {
        try {
            int pctPages = Integer.parseInt(this.getField(line, "table_PCTPAGES"));
            if (pctPages > 0) {
                tableProxy.setPercentageOfPages(pctPages);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHTable.fillPctPages : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PCT PAGES format near " + line);
        }
    }

    private void fillLabelOn(VarFileLine line, TableProxyDB2 tableProxy) {
        String labelOn = this.getField(line, "table_LABEL_ON");
        tableProxy.setLabel(labelOn);
    }

    private void fillCreatedBy(VarFileLine line, TableProxyDB2 tableProxy) {
        String createdBy = this.getField(line, "TABLE_CREATED_BY");
        tableProxy.setCreatedBy(createdBy);
    }

    private void fillCommontOn(VarFileLine line, TableProxyDB2 tableProxy) {
        String commentKey = this.getField(line, "table_description");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            tableProxy.setCommentInRDBMS(comment);
        }
    }

    private void fillOwner(VarFileLine line, TableProxyDB2 tableProxy) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String ownerName = this.getField(line, "table_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)tableProxy.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.addCreatedObject(ownerName, owner);
            }
            tableProxy.setOwner(owner);
        } else {
            String key = this.getField(line, "table_AUTHID");
            Owner owner = (Owner)this.getAllCreatedObjects().get(key);
            tableProxy.setOwner(owner);
        }
    }

    protected void fillElements(VarFileLine line, Table table, TableSpaceDB2 tableSpace) {
        String name = this.getField(line, "table_name");
        table.setName(name);
        this.setCreatorChanger(table, line);
        table.setComment(this.getComment(line));
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        TableProxySetDB2 tableProxySet = (TableProxySetDB2)storageDesign.getTableProxySet();
        TableProxyDB2 tableProxy = (TableProxyDB2)tableProxySet.getProxy(table.getObjectID());
        if (tableProxy != null) {
            this.fillOwner(line, tableProxy);
            this.fillDataCapture(line, tableProxy);
            this.fillObid(line, tableProxy);
            tableProxy.setTableSpace(tableSpace);
            tableProxy.setEditProc(this.getField(line, "table_EDITPROC"));
            tableProxy.setValidProc(this.getField(line, "table_EDITPROC"));
            this.fillAudit(line, tableProxy);
            this.fillRows(line, tableProxy);
            this.fillInsertRate(line, tableProxy);
            this.fillDeleteRate(line, tableProxy);
            this.fillGrowthHorizon(line, tableProxy);
            this.fillActiveInserts(line, tableProxy);
            this.fillActiveDel(line, tableProxy);
            this.fillActiveData(line, tableProxy);
            this.fillGrowthMethod(line, tableProxy);
            this.fillExcludeFreespace(line, tableProxy);
            this.fillCatalogCard(line, tableProxy);
            this.fillCatalogRecLength(line, tableProxy);
            this.fillCatalogNpages(line, tableProxy);
            this.fillPctPages(line, tableProxy);
            this.fillLabelOn(line, tableProxy);
            this.fillCreatedBy(line, tableProxy);
            this.fillCommontOn(line, tableProxy);
        }
    }
}

