/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupSetDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.VolumesDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;

public class RHStorageGroup
extends RowHandler {
    public static final String OBJECT_TYPE = "STORAGE_GROUPS";

    public RHStorageGroup(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createStorageGroup(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createStorageGroup(VarFileLine line) {
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        if (!this.getField(line, "STORAGEGROUP_NAME").equalsIgnoreCase("SYSDEFLT")) {
            StorageGroupDB2 storagegroup = storageDesign.createStorageGroup();
            if (storagegroup != null) {
                String keyVcat;
                VCatDB2 vcat;
                storagegroup.setName(this.getField(line, "STORAGEGROUP_NAME"));
                this.setCreatorChanger(storagegroup, line);
                this.fillCommontOn(line, storagegroup);
                String sgKey = this.getField(line, "general_id");
                List listKey = this.getVolSGMapKeys(sgKey);
                if (listKey.size() > 0) {
                    for (String key : listKey) {
                        VolumesDB2 volumes = (VolumesDB2)this.getCreatedObject(key);
                        if (volumes == null) continue;
                        storagegroup.setVolumes(volumes.getObjectID());
                    }
                }
                if ((vcat = (VCatDB2)this.getCreatedObject(keyVcat = this.getField(line, "STORAGEGROUP_VCAT_ID"))) != null) {
                    storagegroup.setVCat(vcat);
                }
                this.addCreatedObject(this.getField(line, "general_id"), storagegroup);
                this.removeSelectedLine(line);
            }
        } else {
            StorageGroupSetDB2 stoGroupSet = storageDesign.getStorageGroupSet();
            for (StorageGroupDB2 stoGroup : stoGroupSet) {
                if (!stoGroup.getName().equalsIgnoreCase("SYSDEFLT")) continue;
                this.addCreatedObject(this.getField(line, "general_id"), stoGroup);
                this.removeSelectedLine(line);
            }
        }
    }

    private void fillCommontOn(VarFileLine line, StorageGroupDB2 stogroup) {
        String commentKey = this.getField(line, "STORAGEGROUP_TEXT");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            stogroup.setCommentInRDBMS(comment);
        }
    }

    private List getVolSGMapKeys(String sgKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        List allLines = this.getAllSelectedLines();
        for (VarFileLine selectedLine : allLines) {
            if (!selectedLine.getType().equalsIgnoreCase("VOL_SG_MAP") || !this.getField(selectedLine, "STORAGEGROUP_VOL_SG_MAP_KEY").equalsIgnoreCase(sgKey)) continue;
            String key = this.getField(selectedLine, "STORAGEGROUP_VOLUME_KEY");
            keyList.add(key);
        }
        return keyList;
    }
}

