/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandlerDomain;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;

public class RHDomain
extends RowHandlerDomain {
    public static final String OBJECT_TYPE = "DOMAINS";

    public RHDomain(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createDomain(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createDomain(VarFileLine line) {
        String nameDomain = this.getField(line, "DOMAIN_NAME");
        Domain domain = this.getCorrespondingDomain(nameDomain);
        if (domain != null) {
            this.addCreatedObject(this.getField(line, "general_id").trim(), domain);
            this.removeSelectedLine(line);
        }
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.getDesign().getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }
}

