/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingBachmannPhysicalDatatype;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandlerDomain;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHColumn
extends RowHandlerDomain
implements SectionConstants {
    public static final String OBJECT_TYPE = "TABLE_COLUMNS";
    public static final String OBJECT_TYPE_COOL = "COLUMN";
    private static final Logger LOGGER = new Logger(RHColumn.class);
    private Map coljct5ToFKMap;
    private Map colToFKMap;

    public RHColumn(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.addSelectedLine(line);
            this.addColumnLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        list.add(OBJECT_TYPE_COOL);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE) || line.getType().equalsIgnoreCase(OBJECT_TYPE_COOL)) {
            this.createColumn(line, hasMapping);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createColumn(VarFileLine line, boolean hasMapping) {
        String tableKey = this.getField(line, "column_table_id");
        Table table = (Table)this.getCreatedObject(tableKey);
        if (table != null) {
            if (!hasMapping) {
                boolean isFK = this.isFkColumn(this.getField(line, "general_id"), tableKey);
                if (isFK) {
                    VarColumnFK varColumnFk = new VarColumnFK();
                    varColumnFk.constructColumn(line, table);
                } else {
                    VarColumn varColumn = new VarColumn();
                    varColumn.constructColumn(line, table);
                }
            } else {
                String idColumn = this.getField(line, "general_id");
                Column column = (Column)this.getAllCreatedObjects().get(idColumn);
                if (column != null) {
                    if (column.getContainer() != null) {
                        column.setName(this.getField(line, "column_name"));
                        column.setComment(this.getComment(line));
                        this.fillElements(column, line, table);
                        this.removeSelectedLine(line);
                    } else {
                        boolean isFK = this.isFkColumn(this.getField(line, "general_id"), tableKey);
                        if (isFK) {
                            VarColumnFK varColumnFk = new VarColumnFK();
                            varColumnFk.constructColumn(line, table);
                        } else {
                            VarColumn varColumn = new VarColumn();
                            varColumn.constructColumn(line, table);
                        }
                    }
                } else {
                    boolean isFK = this.isFkColumn(this.getField(line, "general_id"), tableKey);
                    if (isFK) {
                        VarColumnFK varColumnFk = new VarColumnFK();
                        varColumnFk.constructColumn(line, table);
                    } else {
                        VarColumn varColumn = new VarColumn();
                        varColumn.constructColumn(line, table);
                    }
                }
            }
        }
    }

    private void fillNulls(VarFileLine line, Column column) {
        try {
            int nulls = Integer.parseInt(this.getField(line, "column_nulls_allowed"));
            if (!Fields.typeVar.equalsIgnoreCase("Sterling COOL:DBA V2.1")) {
                if (nulls == 1) {
                    column.setNullsAllowed(true);
                } else if (nulls == 2 || nulls == 3) {
                    column.setNullsAllowed(false);
                }
            } else if (nulls == 1) {
                column.setNullsAllowed(true);
            } else if (nulls == 0) {
                column.setNullsAllowed(false);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillNulls: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL NULLS format near " + line);
        }
    }

    private void fillType(VarFileLine line, Column column) {
        try {
            int type = Integer.parseInt(this.getField(line, "COLUMN_TYPE"));
            String namePhysDT = MappingBachmannPhysicalDatatype.getNamePhysicalDatatype(type);
            String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(namePhysDT);
            LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, nameDatatype);
            String[] parameters = new String[3];
            String scale = this.getField(line, "COLUMN_SCALE");
            if (scale.equalsIgnoreCase("0")) {
                if (nameDatatype.equals("real") || nameDatatype.equals("NUMERIC") || nameDatatype.equals("DECIMAL")) {
                    parameters[2] = scale;
                    parameters[1] = scale;
                    parameters[0] = this.getField(line, "COLUMN_LENGTH");
                } else {
                    parameters[2] = this.getField(line, "COLUMN_LENGTH");
                    parameters[1] = scale;
                    parameters[0] = scale;
                }
            } else {
                parameters[2] = "0";
                parameters[1] = scale;
                parameters[0] = this.getField(line, "COLUMN_LENGTH");
            }
            String nameDomain = DomainFactory.createDomainName(logicalDT, parameters);
            Domain domain = this.getCorrespondingDomain(nameDomain);
            if (domain != null) {
                column.setDomain(domain);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillType: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL TYPE format near " + line);
        }
    }

    private void fillForbitdata(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            int forbitdata = Integer.parseInt(this.getField(line, "COLUMN_FORBITDATA"));
            String[] choisesBitdata = ColumnProxyDB2.getBitDataChoices();
            switch (forbitdata) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    columnProxy.setBitData(choisesBitdata[forbitdata]);
                    break;
                }
                default: {
                    columnProxy.setBitData(choisesBitdata[0]);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillForbitdata: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL FORBIT DATA format near " + line);
        }
    }

    private void fillValue(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            long value = Long.parseLong(this.getField(line, "COLUMN_VALUE"));
            columnProxy.setInitial(value);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillValue: ");
            message.append(this.getField(line, "COLUMN_VALUE")).append(' ');
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL VALUE format near " + line);
        }
    }

    private void fillAvglen(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            float avglen = Float.parseFloat(this.getField(line, "COLUMN_AVGLEN"));
            columnProxy.setAverageLength(avglen);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillAvglen: ");
            message.append(this.getField(line, "COLUMN_AVGLEN")).append(' ');
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL AVG LEN format near " + line);
        }
    }

    private void fillFrequentPct(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            float frequentPct = Float.parseFloat(this.getField(line, "COLUMN_FREQUENT_PCT"));
            columnProxy.setFrequencyPercent(frequentPct *= 100.0f);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillFrequentPct: ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL FREQUENT PCT format near " + line);
        }
    }

    private void fillFrequentCount(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            long frequentCount = Long.parseLong(this.getField(line, "COLUMN_FREQUENT_COUNT"));
            columnProxy.setFrequencyCount(frequentCount);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillFrequentCount : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL FREQUENT COUNT format near " + line);
        }
    }

    private void fillUpdateRate(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            float updateRate = Float.parseFloat(this.getField(line, "COLUMN_UPDATE_RATE"));
            columnProxy.setUpdateRatePercent(updateRate *= 100.0f);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillUpdateRate : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL UPDATE RATE format near " + line);
        }
    }

    private void fillGrowthPct(VarFileLine line, ColumnProxyDB2 columnProxy) {
        try {
            float growthPct = Float.parseFloat(this.getField(line, "COLUMN_GROWTH_PCT"));
            columnProxy.setGrowthPercent(growthPct *= 100.0f);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHColumn.fillGrowthPct : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL GROWTH PCT format near " + line);
        }
    }

    private void fillLabelOn(VarFileLine line, ColumnProxyDB2 columnProxy) {
        String labelOn = this.getField(line, "COLUMN_LABEL_ON");
        columnProxy.setLabel(labelOn);
    }

    private Domain getCorrespondingDomain(String nameDomain) {
        Domain result = null;
        DomainSet domainSet = this.getDesign().getDomainSet();
        Iterator itDomSet = domainSet.iterator();
        while (itDomSet.hasNext()) {
            Domain domain = (Domain)itDomSet.next();
            if (!domain.getName().equalsIgnoreCase(nameDomain)) continue;
            result = domain;
            return result;
        }
        return result;
    }

    private void fillCommontOn(VarFileLine line, ColumnProxyDB2 columnProxy) {
        String commentKey = this.getField(line, "COLUMN_DESCRIPTION");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            columnProxy.setCommentInRDBMS(comment);
        }
    }

    private void fillProgram(VarFileLine line, ColumnProxyDB2 columnProxy) {
        String program = this.getField(line, "COLUMN_FIELDPROC2");
        if (!"".equalsIgnoreCase(program) && !"0".equalsIgnoreCase(program)) {
            columnProxy.setProgram(program);
        }
    }

    private void fillConstant(VarFileLine line, ColumnProxyDB2 columnProxy) {
        String constant = this.getField(line, "COLUMN_FPCONSTANT");
        if (!"".equalsIgnoreCase(constant) && !"0".equalsIgnoreCase(constant)) {
            columnProxy.setConstant(constant);
        }
    }

    private void fillDefault(VarFileLine line, ColumnProxyDB2 columnProxy) {
        String defaultValueKey = this.getField(line, "COLUMN_DEFAULT_KEY").trim();
        if (defaultValueKey != null && defaultValueKey.equalsIgnoreCase("1")) {
            String constant = this.getDefaultValue(defaultValueKey);
            String[] choises = ColumnProxyDB2.getDefaultValueChoices();
            columnProxy.setDefault(true);
            columnProxy.setDefaultValue(choises[1]);
            columnProxy.setDefaultValueConstant(constant);
            columnProxy.getColumn().setUsesDefaultValue(true);
        }
    }

    private String getDefaultValue(String key) {
        String value = "";
        List lines = this.getAllSelectedLines();
        for (VarFileLine line : lines) {
            if (!line.getType().equalsIgnoreCase("COL_DEFAULT") || !key.equalsIgnoreCase(this.getField(line, "general_id"))) continue;
            value = this.getField(line, "col_default_value");
        }
        return value;
    }

    private boolean isFkColumn(String columnKey, String tableKey) {
        boolean result = false;
        if (columnKey != null) {
            int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
            if (testCool == 1000) {
                ArrayList<String> keyColumnSetList = new ArrayList<String>();
                List allLines = this.getAllSelectedLines();
                for (VarFileLine selectedLine : allLines) {
                    if (!selectedLine.getType().equalsIgnoreCase("COLUMN_SETTABLE_CO") || !columnKey.equalsIgnoreCase(this.getField(selectedLine, "COLUMNSETTABLE_TABLECOLUMN"))) continue;
                    keyColumnSetList.add(this.getField(selectedLine, "COLUMNSETTABLE_COLUMNSET"));
                }
                if (keyColumnSetList.size() > 0) {
                    List foreignLines = this.getAllForeignKeyLines();
                    for (int colsetNumber = 0; colsetNumber < keyColumnSetList.size(); ++colsetNumber) {
                        for (VarFileLine selectedLine : foreignLines) {
                            String keyColumnSet;
                            if (!selectedLine.getType().equalsIgnoreCase("FOREIGN_KEY") || !(keyColumnSet = (String)keyColumnSetList.get(colsetNumber)).equalsIgnoreCase(this.getField(selectedLine, "FOREIGNKEY_COLUMNSET")) || !tableKey.equalsIgnoreCase(this.getField(selectedLine, "foreignkey_table_id"))) continue;
                            result = true;
                        }
                    }
                }
            } else {
                return this.getColToFKMap().get(columnKey) != null;
            }
        }
        return result;
    }

    private void makeFKMap(List fkLines) {
        this.coljct5ToFKMap = new TreeMap();
        for (VarFileLine vfline : fkLines) {
            String fkId = this.getField(vfline, "FOREIGNKEY_COLJCT5");
            this.coljct5ToFKMap.put(fkId, fkId);
        }
    }

    private Map getFKMap() {
        if (this.coljct5ToFKMap == null) {
            this.makeFKMap(this.getAllForeignKeyLines());
        }
        return this.coljct5ToFKMap;
    }

    private void makeColToFKMap() {
        this.colToFKMap = new TreeMap();
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            String key5;
            if (!selectedLine.getType().equalsIgnoreCase("COLJCT") || (key5 = this.getField(selectedLine, "COLJCT_5_KEY")).equals("") || this.getFKMap().get(key5) == null) continue;
            String colId = this.getField(selectedLine, "COLJCT_COLUMN_KEY");
            this.colToFKMap.put(colId, colId);
        }
    }

    private Map getColToFKMap() {
        if (this.colToFKMap == null) {
            this.makeColToFKMap();
        }
        return this.colToFKMap;
    }

    protected void fillElements(Column column, VarFileLine line, Table table) {
        column.getParent();
        this.setCreatorChanger(column, line);
        this.fillNulls(line, column);
        this.fillType(line, column);
        Design design = column.getDesign();
        RDBMSSite site = design.getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)design.getStorageDesign(site);
        ColumnProxyDB2 columnProxy = (ColumnProxyDB2)storageDesign.getColumnProxySet().getProxy(column.getObjectID());
        if (columnProxy != null) {
            this.fillCommontOn(line, columnProxy);
            this.fillForbitdata(line, columnProxy);
            this.fillValue(line, columnProxy);
            this.fillAvglen(line, columnProxy);
            this.fillFrequentPct(line, columnProxy);
            this.fillFrequentCount(line, columnProxy);
            this.fillUpdateRate(line, columnProxy);
            this.fillGrowthPct(line, columnProxy);
            this.fillLabelOn(line, columnProxy);
            this.fillProgram(line, columnProxy);
            this.fillConstant(line, columnProxy);
            this.fillDefault(line, columnProxy);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "COLUMN_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "COLUMN_TEXT_ID"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }

    class VarColumnFK
    extends VarColumn {
        VarColumnFK() {
        }

        @Override
        public void constructColumn(VarFileLine line, Table table) {
            Column column = table.createColumn();
            column.setName(RHColumn.this.getField(line, "column_name"));
            column.setComment(RHColumn.this.getComment(line));
            column.setNameFixed(true);
            RHColumn.this.fillElements(column, line, table);
            this.handleLine(column, line, table);
        }

        @Override
        protected void handleLine(Column column, VarFileLine line, Table table) {
            RHColumn.this.addCreatedObject(RHColumn.this.getField(line, "general_id"), column);
            RHColumn.this.removeSelectedLine(line);
        }
    }

    class VarColumn {
        VarColumn() {
        }

        public void constructColumn(VarFileLine line, Table table) {
            Column column = table.createColumn(RHColumn.this.getField(line, "column_name"));
            column.setComment(RHColumn.this.getComment(line));
            RHColumn.this.fillElements(column, line, table);
            this.handleLine(column, line, table);
        }

        protected void handleLine(Column column, VarFileLine line, Table table) {
            RHColumn.this.addCreatedObject(RHColumn.this.getField(line, "general_id"), column);
            RHColumn.this.removeSelectedLine(line);
        }
    }
}

