/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.var.ChainBuilderSeperate;
import oracle.dbtools.crest.imports.var.DomainHandlerVarConversie;
import oracle.dbtools.crest.imports.var.RHAnlextRteObj;
import oracle.dbtools.crest.imports.var.RHAttribute;
import oracle.dbtools.crest.imports.var.RHDataModel;
import oracle.dbtools.crest.imports.var.RHDataModelDiagram;
import oracle.dbtools.crest.imports.var.RHDiagram;
import oracle.dbtools.crest.imports.var.RHDiagramObjectPro;
import oracle.dbtools.crest.imports.var.RHEntityDiagramObj;
import oracle.dbtools.crest.imports.var.RHFKPoints;
import oracle.dbtools.crest.imports.var.RHForeignKey;
import oracle.dbtools.crest.imports.var.RHPartnership;
import oracle.dbtools.crest.imports.var.RHPartnershipDiagram;
import oracle.dbtools.crest.imports.var.RHPlacement;
import oracle.dbtools.crest.imports.var.RHcdbaAssociations;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.VarFileReader;
import oracle.dbtools.crest.imports.var.process.RHAPODiagramObj;
import oracle.dbtools.crest.imports.var.process.RHProcessModel;
import oracle.dbtools.crest.imports.var.process.RHProcessModelDiagram;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class ParserSeperateVar {
    private static final String[] SEQUENCE = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "BUFFER_POOLS", "VOLUMES", "VCATS", "VOL_SG_MAP", "STORAGE_GROUPS", "DATABASES", "DATABASE", "USER", "TABLESPACE", "TABLE_SPACES", "PARTITIONS", "DIAGRAM", "TABLES", "TABLE", "COLUMN_SETTABLE_CO", "COL_DEFAULT", "COLUMN_SET", "KEY_COL_JUNC", "TABLE_COLUMNS", "COLUMN", "COLJCT", "CHECK_CONSTRAINT", "PRIMARY_KEY", "PRIMARY_KEYS", "FOREIGN_KEY", "FOREIGN_KEYS", "INDEX", "VIEWDEPENDE2", "VIEWDEPENDENT", "VIEW_DEPENDENT", "VIEW", "VIEWS", "ALIASES", "SYNONYM", "PARTITION_BOUNDARY", "PLACEMENT", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "PROCESS_MODEL", "PROCESSSYNONYM_OBJ", "EXTERNAL_AGENTSYNO", "INFO_STORESYNONYM_", "INFO_FLOWSYNONYM_O", "STORAGE_EVENTSYNON", "FLOW_EVENTSYNONYM_", "PERSON_EVENTSYNONY", "CLOCK_EVENTSYNONYM", "STRUCTURESYNONYM_O", "PROCESS_MODELCLOCK", "PROCESS_MODELPERSO", "PROCESS_MODELSTORA", "PROCESS_MODELFLOW_", "FLOW_EVENT", "CLOCK_EVENT", "PERSON_EVENT", "STORAGE_EVENT", "PROCESS", "PROCESSCLOCK_EVENT", "PROCESSPERSON_EVEN", "PROCESSSTORAGE_EVE", "EXTERNAL_AGENT", "INFO_STORE", "PROCESSINFO_FLOW", "EXTERNAL_AGENTINFO", "INFO_STOREINFO_FLO", "INFO_FLOWEXTERNAL_", "INFO_FLOWINFO_STOR", "INFO_FLOWPROCESS", "INFO_FLOW", "STRUCTUREPROCESS_M", "STRUCTUREINFO_FLOW", "STRUCTURE", "STRUCT_ENT", "STRUCT_ATTR", "PROCESSDIAGRAM_OBJ", "EXTERNAL_AGENTDIAG", "INFO_STOREDIAGRAM_", "PROCESS_MODELDIAGR", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "ASSOCIATION", "POINT", "PARTNERSHIPDIAGRAM"};
    private static final String[] SEQUENCE_NO_PM = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "BUFFER_POOLS", "VOLUMES", "VCATS", "VOL_SG_MAP", "STORAGE_GROUPS", "DATABASES", "DATABASE", "USER", "TABLESPACE", "TABLE_SPACES", "PARTITIONS", "DIAGRAM", "TABLES", "TABLE", "COLUMN_SETTABLE_CO", "COL_DEFAULT", "COLUMN_SET", "KEY_COL_JUNC", "TABLE_COLUMNS", "COLUMN", "COLJCT", "CHECK_CONSTRAINT", "PRIMARY_KEY", "PRIMARY_KEYS", "FOREIGN_KEY", "FOREIGN_KEYS", "INDEX", "VIEWDEPENDE2", "VIEWDEPENDENT", "VIEW_DEPENDENT", "VIEW", "VIEWS", "ALIASES", "SYNONYM", "PARTITION_BOUNDARY", "PLACEMENT", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "ASSOCIATION", "POINT", "PARTNERSHIPDIAGRAM"};
    private VarFileReader reader;
    private VarFileReader readerForDomains;
    private Design design;
    private Design designForDomains;
    private ChainBuilderSeperate chainBuilder;
    private List allSelectedLines = new ArrayList();
    private Map allCreatedObjects = new HashMap();
    private Map allReferences = new HashMap();
    private List allForeignKeyLines = new ArrayList();
    private List allPrimaryKeyLines = new ArrayList();
    private List allColumnLines = new ArrayList();
    private ApplicationView view = null;
    private ProgressDialog monitor;
    private String designName;
    private List commentLines = new ArrayList();
    private double scale = 0.5;
    private StatusBarOwner statusBarOwner = StatusBarOwner.NULL_INSTANCE;
    private boolean hasMapping = false;
    private RDBMSSite site;
    private boolean importPM;
    private static final Logger LOGGER = new Logger(ParserSeperateVar.class);
    int minLeft = Integer.MAX_VALUE;
    int maxTop = -2147483647;

    public void parseContent(File file, View view, RDBMSSite site, String version, boolean importPM) {
        this.reader = new VarFileReader(file.getAbsolutePath());
        this.site = site;
        this.importPM = importPM;
        if (this.isRightVersion(version)) {
            if (this.canParse()) {
                if (view instanceof ApplicationView) {
                    this.view = (ApplicationView)view;
                }
                this.readerForDomains = new VarFileReader(file.getAbsolutePath());
                this.design = this.view.getCurrentDesign();
                String oldDesignPath = this.view.getCurrentDesign().getDesignPath();
                this.designName = this.reader.getName();
                if (this.designName != null) {
                    this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
                    if (this.view.designExists(this.designName)) {
                        this.view.deleteDesign(this.designName);
                    }
                    this.design.setFileName(this.designName);
                    ((ApplicationView)view).setDesignName(this.designName);
                    this.design.setSelectedRDBMSSite(site);
                    this.designForDomains = this.design;
                    StringBuffer filenameDes = new StringBuffer(this.design.getDesign().getFileName());
                    filenameDes.append("_Domains");
                    this.designForDomains.setFileName(filenameDes.toString());
                    this.designForDomains.setSelectedRDBMSSite(site);
                    if (view != null && view instanceof StatusBarOwner) {
                        this.statusBarOwner = (StatusBarOwner)((Object)view);
                    }
                    this.chainBuilder = new ChainBuilderSeperate();
                    if (importPM) {
                        this.chainBuilder.buildChain(this.design, this.reader.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
                    } else {
                        this.chainBuilder.buildChainNoPM(this.design, this.reader.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
                    }
                    new Thread(new Runner()).start();
                } else {
                    this.view.getCurrentDesign().setDesignPath(oldDesignPath);
                    this.design = null;
                    System.gc();
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("ParserSeperateVar.TheVersionOfSelectedVARFileNot"), version), Messages.getString("ParserSeperateVar.Warning"), 2);
        }
    }

    public boolean canParse() {
        return this.reader.isSupportedVersion();
    }

    private boolean isRightVersion(String version) {
        return this.reader.getVersion().startsWith(version);
    }

    private void constructDomains() {
        try {
            ApplicationView.log(Messages.getString("ParserSeperateVar.OpeningFileForDomainConstruction"));
            List linesForDomains = this.collectLinesForDomains();
            DomainHandlerVarConversie domainHandler = new DomainHandlerVarConversie(this.designForDomains, this.readerForDomains.getConstants(), this.allSelectedLines, this.allCreatedObjects, this.allForeignKeyLines, this.allPrimaryKeyLines, this.allReferences, this.allColumnLines, this.commentLines);
            domainHandler.createDomains(linesForDomains, this.commentLines, this.statusBarOwner);
            this.designForDomains.setFileName(this.designName);
            this.designForDomains.resetDomains();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create domains!", e);
        }
    }

    private void parseFile() {
        VarFileLine line;
        this.design.setSelectedRDBMSSite(this.site);
        ApplicationView.log(Messages.getString("ParserSeperateVar.OpeningFileForParsing"));
        while ((line = this.reader.readLine()) != null) {
            try {
                RowHandler rh = (RowHandler)this.chainBuilder.getObjectMap().get(line.getType());
                if (rh == null) continue;
                rh.read(line);
            }
            catch (Exception e) {
                LOGGER.error("Unable to read the line: " + line.getLine(), e);
                this.chainBuilder.getChain().nextRead(line);
            }
        }
        this.reader.closeReader();
        this.parseInRightSequence();
    }

    private void parsePoints() {
        RowHandler fkrh = this.chainBuilder.getSpecificRowHandler(RHForeignKey.class);
        RowHandler assrh = this.chainBuilder.getSpecificRowHandler(RHcdbaAssociations.class);
        RHDiagram diagramrh = (RHDiagram)this.chainBuilder.getSpecificRowHandler(RHDiagram.class);
        RHFKPoints pointrh = (RHFKPoints)this.chainBuilder.getSpecificRowHandler(RHFKPoints.class);
        pointrh.processPointsForPhysical(fkrh.getOwnLines(), assrh.getOwnLines());
        pointrh.processPointsForPhysicalSubViews(fkrh.getOwnLines(), assrh.getOwnLines(), diagramrh.getDiagramsMap());
    }

    private void parseList() {
        int i;
        int sizeOfList = this.allSelectedLines.size();
        int sizeOfListAfter = sizeOfList - 1;
        while (sizeOfList - sizeOfListAfter > 0) {
            this.parseInRightSequence();
            sizeOfList = sizeOfListAfter;
            sizeOfListAfter = this.allSelectedLines.size();
        }
        if (this.importPM) {
            for (i = 0; i < SEQUENCE.length; ++i) {
                this.chainBuilder.getChain().removeSelectedLinesOfType(SEQUENCE[i]);
            }
        } else {
            for (i = 0; i < SEQUENCE_NO_PM.length; ++i) {
                this.chainBuilder.getChain().removeSelectedLinesOfType(SEQUENCE_NO_PM[i]);
            }
        }
        for (VarFileLine line : this.allSelectedLines) {
            StringBuffer message = new StringBuffer("!!! UNHANDLED : ");
            message.append(line.getType());
            message.append(" : ");
            message.append(line.getLine());
            LOGGER.error(message.toString());
        }
    }

    private void arrangeColumnPositionInTable() {
        Hashtable current = this.reader.getConstants().getFields();
        Integer num = (Integer)current.get("COLUMN_ORDNUM");
        int ordnum = num != null ? num : 10;
        TreeMap<String, Holder> tablesMap = new TreeMap<String, Holder>();
        for (VarFileLine line : this.allColumnLines) {
            String keyColumn = null;
            StringTokenizer tok = new StringTokenizer(line.getLine(), ",");
            keyColumn = tok.nextToken().trim();
            Object columnObject = this.allCreatedObjects.get(keyColumn);
            Column column = null;
            if (columnObject instanceof Column) {
                column = (Column)columnObject;
            }
            if (column == null) continue;
            Table table = (Table)column.getParent();
            try {
                Holder holder;
                StringTokenizer tok2 = new StringTokenizer(line.getLine(), ",");
                int position = 0;
                int count = 0;
                while (tok2.hasMoreElements()) {
                    String element = tok2.nextToken().trim();
                    if (++count != ordnum) continue;
                    position = Integer.parseInt(element);
                    break;
                }
                if ((holder = (Holder)tablesMap.get(table.getObjectID())) == null) {
                    holder = new Holder();
                    holder.container = table;
                    holder.map = new TreeMap();
                    tablesMap.put(table.getObjectID(), holder);
                }
                holder.map.put(new Integer(position - 1), column);
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
            }
        }
        for (String key : tablesMap.keySet()) {
            Holder holder = (Holder)tablesMap.get(key);
            this.sortAttributes(holder.container, holder.map);
        }
    }

    private void createArcs() {
        RHPartnership handler = (RHPartnership)this.chainBuilder.getSpecificRowHandler(RHPartnership.class);
        handler.createArcs();
    }

    private void arrangeAttributePositionInEntity() {
        TreeMap<String, Holder> tablesMap = new TreeMap<String, Holder>();
        for (VarFileLine line : this.chainBuilder.getSpecificRowHandler(RHAttribute.class).getOwnLines()) {
            String keyColumn = null;
            StringTokenizer tok = new StringTokenizer(line.getLine(), ",");
            keyColumn = tok.nextToken().trim();
            Object columnObject = this.allCreatedObjects.get(keyColumn);
            Attribute column = null;
            if (columnObject instanceof Attribute) {
                column = (Attribute)columnObject;
            }
            if (column == null) continue;
            Entity table = (Entity)column.getParent();
            int ordnum = 10;
            try {
                Holder holder;
                StringTokenizer tok2 = new StringTokenizer(line.getLine(), ",");
                int position = 0;
                int count = 0;
                while (tok2.hasMoreElements()) {
                    String element = tok2.nextToken().trim();
                    if (++count != ordnum) continue;
                    position = Integer.parseInt(element);
                    break;
                }
                if ((holder = (Holder)tablesMap.get(table.getObjectID())) == null) {
                    holder = new Holder();
                    holder.container = table;
                    holder.map = new TreeMap();
                    tablesMap.put(table.getObjectID(), holder);
                }
                holder.map.put(new Integer(position - 1), column);
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
            }
        }
        for (String key : tablesMap.keySet()) {
            Holder holder = (Holder)tablesMap.get(key);
            this.sortAttributes(holder.container, holder.map);
        }
    }

    private void sortAttributes(ContainerObject cont, Map map) {
        Iterator it = map.keySet().iterator();
        int ind = 0;
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            ContainedObject attr = (ContainedObject)map.get(key);
            if (attr != null) {
                cont.moveToIndex(attr, key);
            }
            ++ind;
        }
    }

    public void rearrangePhysDes() {
        RHPlacement rhPlacement = (RHPlacement)this.chainBuilder.getSpecificRowHandler(RHPlacement.class);
        rhPlacement.rearrangePhysDes();
    }

    public void createObjectsInSubViews() {
        RHDiagram rhDiagram = (RHDiagram)this.chainBuilder.getSpecificRowHandler(RHDiagram.class);
        RHPlacement rhPlacement = (RHPlacement)this.chainBuilder.getSpecificRowHandler(RHPlacement.class);
        rhPlacement.createObjectsInSubViews(rhDiagram.getDiagramsMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        try {
            this.monitor = new ProgressDialog(this.view, "", 0, 100);
            try {
                this.view.setImporting(true);
                this.design.closeAllDiagrams();
                this.design.setDisableTreeUpdate(true);
                try {
                    ParserSeperateVar.initialSettings(this.design);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.ConstructDomains"));
                    this.monitor.setProgress(10);
                    this.constructDomains();
                    this.design.setPropagatePKChahges(false);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.ParseFile"));
                    this.monitor.setProgress(30);
                    this.parseFile();
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeGraphicalObjects"));
                    this.monitor.setProgress(80);
                    try {
                        this.rearrangeEntitiesAndPartnerships();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to rearrange Entities and Partnerships", e);
                    }
                    try {
                        this.parseList();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to parse List", e);
                    }
                    try {
                        this.createArcs();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create Arcs", e);
                    }
                    this.design.getLogicalDesign().resetIdentifyingRelationships();
                    try {
                        this.arrangeColumnPositionInTable();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to arrange Column Position in Table", e);
                    }
                    try {
                        this.arrangeAttributePositionInEntity();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to arrange Attribute positions in Entity", e);
                    }
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.CreateSubViews"));
                    this.monitor.setProgress(84);
                    try {
                        this.createObjectsInSubViews();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create Objects in SubViews", e);
                    }
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeForeignKeyLines"));
                    this.monitor.setProgress(86);
                    try {
                        this.parsePoints();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to parse Points", e);
                    }
                    ParserSeperateVar.createDetailsDisplay(this.design);
                    this.monitor.setNote(Messages.getString("ParserSeperateVar.RearrangeRelationalModel"));
                    this.monitor.setProgress(88);
                    try {
                        this.rearrangePhysDes();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to Rearrange Relational Model", e);
                    }
                    this.nullifyAll1();
                    this.nullifyAll2();
                    this.design.setPropagatePKChahges(true);
                    this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.OpenDesign"), this.designName));
                    this.monitor.setProgress(90);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setOpen(true);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setTempModel(false);
                    this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setDirty(true);
                    this.monitor.setProgress(100);
                    this.designName = this.design.getName();
                    this.view.getCurrentDesign().setDesignPath("");
                    this.view.synchronizeTitle();
                }
                finally {
                    this.view.setImporting(false);
                    this.design.getLogicalDesign().setMainViewVisible(true);
                    this.design.showAllRelationalDesigns();
                    this.design.setDisableTreeUpdate(false);
                    this.view.clearTree();
                    this.resetDirty(this.design);
                }
            }
            finally {
                this.monitor.close();
            }
        }
        finally {
            ApplicationView.loading = false;
        }
    }

    private void resetDirty(Design design) {
        for (RelationalDesign pd : design.getRelationalDesigns()) {
            pd.setDirty(true);
        }
    }

    public List getSelectedLines() {
        return this.allSelectedLines;
    }

    public List getPrimaryKeyLines() {
        return this.allPrimaryKeyLines;
    }

    public List getForeignKeyLines() {
        return this.allForeignKeyLines;
    }

    public List getColumnLines() {
        return this.allColumnLines;
    }

    private List collectLinesForDomains() {
        ArrayList<VarFileLine> listLines = new ArrayList<VarFileLine>();
        VarFileLine line = this.readerForDomains.readLine();
        int lineNbr = 1;
        while (line != null) {
            String type = line.getType();
            if (type.equalsIgnoreCase("TABLE_COLUMNS") || type.equalsIgnoreCase("COLUMN") || type.equalsIgnoreCase("DOMAINS")) {
                listLines.add(line);
            } else if (type.equalsIgnoreCase("ANLTEXT") || type.equalsIgnoreCase("SYNONYM_OBJECT") || type.equalsIgnoreCase("DOMAINSSYNONYM_OBJ") || type.equalsIgnoreCase("DIMENSION") || type.equalsIgnoreCase("ALLOWED_VAL_TBL") || type.equalsIgnoreCase("ALLOWABLE_VALUE")) {
                this.commentLines.add(line);
            }
            line = this.readerForDomains.readLine();
            ++lineNbr;
        }
        this.chainBuilder.getChain().setCommentLines(this.commentLines);
        this.readerForDomains.closeReader();
        return listLines;
    }

    private void parseInRightSequence() {
        String hierStyle = this.getDataHierarchyStyle(this.chainBuilder.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        if ("1".equals(hierStyle)) {
            this.view.getSettings().setBoxInBox(false);
        } else {
            this.view.getSettings().setBoxInBox(true);
        }
        ArrayList lines = new ArrayList(this.allSelectedLines);
        double p = 50.0;
        int seqLength = this.importPM ? SEQUENCE.length : SEQUENCE_NO_PM.length;
        for (int sequenceNumber = 0; sequenceNumber < seqLength; ++sequenceNumber) {
            p += 50.0 / (double)seqLength;
            if (this.importPM) {
                this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.Processing"), SEQUENCE[sequenceNumber].toString()));
            } else {
                this.monitor.setNote(MessageFormat.format(Messages.getString("ParserSeperateVar.Processing"), SEQUENCE_NO_PM[sequenceNumber].toString()));
            }
            this.monitor.setProgress((int)p);
            int linesSize = lines.size();
            for (int lineNumber = 0; lineNumber < linesSize; ++lineNumber) {
                VarFileLine line = (VarFileLine)lines.get(lineNumber);
                boolean b = this.importPM ? line.getType().equalsIgnoreCase(SEQUENCE[sequenceNumber]) : line.getType().equalsIgnoreCase(SEQUENCE_NO_PM[sequenceNumber]);
                if (!b) continue;
                try {
                    RowHandler rh = (RowHandler)this.chainBuilder.getObjectMap().get(line.getType());
                    if (rh == null) continue;
                    rh.handle(line, this.hasMapping);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to handle the line: " + line.getLine(), e);
                    this.chainBuilder.getChain().nextHandler(line, this.hasMapping);
                }
            }
        }
    }

    private void nullifyAll1() {
        this.allCreatedObjects = null;
        this.allReferences = null;
        this.allForeignKeyLines = null;
        this.allPrimaryKeyLines = null;
        this.allColumnLines = null;
        this.commentLines = null;
    }

    private void nullifyAll2() {
        this.allSelectedLines = null;
        this.chainBuilder = null;
    }

    private String getDataModelId(List dataModel) {
        String id;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator it = dataModel.iterator();
        if (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
        } else {
            id = null;
        }
        return id;
    }

    private String getDataHierarchyStyle(List dataModel) {
        String style;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator it = dataModel.iterator();
        if (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            style = rowHandler.getField(selectedLine.getLine(), new Integer(15));
        } else {
            style = null;
        }
        return style;
    }

    private String getDataModelDiagramId(List dataModelDiagram, String dataModelId) {
        String id = null;
        RowHandler rowHandler = this.chainBuilder.getChain();
        for (VarFileLine selectedLine : dataModelDiagram) {
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
            if (!dataModelId.equalsIgnoreCase(id)) continue;
            return rowHandler.getField(selectedLine.getLine(), new Integer(2));
        }
        return null;
    }

    private String getProcessModelDiagramId(List processModelDiagram, String processModelId) {
        String id = null;
        RowHandler rowHandler = this.chainBuilder.getChain();
        for (VarFileLine selectedLine : processModelDiagram) {
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
            if (!processModelId.equalsIgnoreCase(id)) continue;
            return rowHandler.getField(selectedLine.getLine(), new Integer(2));
        }
        return null;
    }

    private void rearrangeEntitiesAndPartnerships() {
        List diagramObjectPro;
        List partnerships = this.chainBuilder.getSpecificRowHandler(RHPartnership.class).getOwnLines();
        List partnershipsDiagram = this.chainBuilder.getSpecificRowHandler(RHPartnershipDiagram.class).getOwnLines();
        List entityDiagramObj = this.chainBuilder.getSpecificRowHandler(RHEntityDiagramObj.class).getOwnLines();
        List apoDiagramObj = null;
        if (this.importPM) {
            apoDiagramObj = this.chainBuilder.getSpecificRowHandler(RHAPODiagramObj.class).getOwnLines();
        }
        List anlextRteObj = this.chainBuilder.getSpecificRowHandler(RHAnlextRteObj.class).getOwnLines();
        String dataModelId = this.getDataModelId(this.chainBuilder.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        String dataModelDiagramId = this.getDataModelDiagramId(this.chainBuilder.getSpecificRowHandler(RHDataModelDiagram.class).getOwnLines(), dataModelId);
        if (dataModelDiagramId != null && (diagramObjectPro = (List)this.chainBuilder.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(dataModelDiagramId)) != null) {
            this.initMinleftMaxtop(diagramObjectPro, anlextRteObj);
            this.rearrangeEntities(entityDiagramObj, diagramObjectPro);
            this.rearrangePartnerships(partnerships, partnershipsDiagram, diagramObjectPro, anlextRteObj, this.minLeft, this.maxTop);
        }
        if (this.importPM) {
            List processModelIDs = this.chainBuilder.getSpecificRowHandler(RHProcessModel.class).getOwnLines();
            Iterator it = processModelIDs.iterator();
            RowHandler rowHandler = this.chainBuilder.getChain();
            while (it.hasNext()) {
                List diagramObjectPro2;
                VarFileLine selectedLine = (VarFileLine)it.next();
                String pmID = rowHandler.getField(selectedLine.getLine(), new Integer(1));
                String pmDiagramId = this.getProcessModelDiagramId(this.chainBuilder.getSpecificRowHandler(RHProcessModelDiagram.class).getOwnLines(), pmID);
                if (pmDiagramId == null || (diagramObjectPro2 = (List)this.chainBuilder.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(pmDiagramId)) == null) continue;
                this.initMinleftMaxtop(diagramObjectPro2, anlextRteObj);
                this.rearrangeProcessObjects(apoDiagramObj, diagramObjectPro2);
            }
            for (DataFlowDesign dfd : this.design.getProcessModel().getDataFlowDesigns()) {
                dfd.getMainView().getWorkSpace().alignDiagram();
            }
        }
        Iterator it = this.design.getLogicalDesign().getRelationSet().iterator();
        DesignPartView dpv = this.design.getLogicalDesign().getMainView();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            TVRelation tv = (TVRelation)rel.getViewFor(dpv);
            if (tv == null) continue;
            tv.resetEdgeParams();
        }
    }

    private void rearrangePartnerships(List partnerships, List partnershipsDiagram, List diagramObjectPro, List anlextRteObj, int minLeft, int maxTop) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator it = partnerships.iterator();
        Integer posParId = new Integer(1);
        Integer posId = new Integer(2);
        while (it.hasNext()) {
            String diagramId;
            VarFileLine selectedLine = (VarFileLine)it.next();
            String relId = rowHandler.getField(selectedLine, "general_id");
            Relation rel = (Relation)rowHandler.getAllCreatedObjects().get(relId);
            if (rel.getTopView() == null) {
                rowHandler.getDesign().getLogicalDesign().getMainView().createViewFor(rel);
            }
            if ((diagramId = this.getIdFromList(partnershipsDiagram, relId, posParId, posId, rowHandler)) == null) continue;
            List points = this.getPartnershipPoints(diagramObjectPro, diagramId, anlextRteObj, minLeft, maxTop, rowHandler);
            this.addRelPoints(rel, points);
        }
    }

    private List getPartnershipPoints(List lines, String diagramId, List anlextRteObj, int minLeft, int maxTop, RowHandler rowHandler) {
        ArrayList<Point> points = new ArrayList<Point>();
        Iterator it = lines.iterator();
        Integer idPos = new Integer(1);
        int numOfPointsPosition = 19;
        Integer pos = new Integer(numOfPointsPosition);
        while (it.hasNext()) {
            int numOfPoints;
            VarFileLine selectedLine = (VarFileLine)it.next();
            String line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramId.equalsIgnoreCase(id)) continue;
            int numOfPoints2 = numOfPoints = Integer.parseInt(rowHandler.getField(line, pos));
            if (numOfPoints > 1) {
                if (numOfPoints2 > 5) {
                    numOfPoints2 = 5;
                }
                for (int i = numOfPointsPosition; i < numOfPointsPosition + numOfPoints2 * 2; i += 2) {
                    String sleft = rowHandler.getField(line, new Integer(i + 1));
                    String stop = rowHandler.getField(line, new Integer(i + 2));
                    int left = Integer.parseInt(sleft);
                    int top = Integer.parseInt(stop);
                    left = minLeft < 0 ? 20 + left + minLeft * -1 : 20 + left - minLeft;
                    top = maxTop > 0 ? 20 + maxTop - top : 20 + top * -1 + maxTop;
                    points.add(new Point(left, top));
                }
            }
            if (numOfPoints == numOfPoints2) break;
            this.addPointsFromAnlextRteObj(points, diagramId, anlextRteObj, minLeft, maxTop, rowHandler);
            break;
        }
        return points;
    }

    private void addPointsFromAnlextRteObj(List points, String diagramOPROId, List anlextRteObj, int minLeft, int maxTop, RowHandler rowHandler) {
        String line;
        ArrayList<String> selLines = new ArrayList<String>();
        Iterator it = anlextRteObj.iterator();
        Integer idPos = new Integer(8);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramOPROId.equalsIgnoreCase(id)) continue;
            selLines.add(line);
        }
        it = selLines.iterator();
        int startpos = 8;
        while (it.hasNext()) {
            line = (String)it.next();
            for (int i = startpos; i < startpos + 10; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                if (sleft.equalsIgnoreCase("0") && stop.equalsIgnoreCase("0")) continue;
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                left = minLeft < 0 ? 20 + left + minLeft * -1 : 20 + left - minLeft;
                top = maxTop > 0 ? 20 + maxTop - top : 20 + top * -1 + maxTop;
                points.add(new Point(left, top));
            }
        }
    }

    private String getIdFromList(List lines, String parentId, Integer parentIdPosition, Integer idPosition, RowHandler rowHandler) {
        String id = null;
        for (VarFileLine selectedLine : lines) {
            String pId = rowHandler.getField(selectedLine.getLine(), parentIdPosition);
            if (!parentId.equalsIgnoreCase(pId)) continue;
            id = rowHandler.getField(selectedLine.getLine(), idPosition);
            return id;
        }
        return id;
    }

    private void addRelPoints(Relation rel, List points) {
        try {
            if (points.size() > 1) {
                TVRelation tvrel;
                if (points.size() > 2) {
                    TVRelation tvrel2 = (TVRelation)rel.getTopView();
                    if (tvrel2 != null) {
                        EdgeView edge = (EdgeView)tvrel2.getCellView();
                        for (int i = 1; i < points.size() - 1; ++i) {
                            Point p = (Point)points.get(i);
                            p.x = (int)((double)p.x * this.scale);
                            p.y = (int)((double)p.y * this.scale);
                            tvrel2.getEdgePoints().add(DiagramConstants.createPoint(p));
                        }
                        tvrel2.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel2.getEdgePoints());
                        edge.update();
                    }
                } else if (points.size() == 2 && (tvrel = (TVRelation)rel.getTopView()) != null) {
                    Point p1 = (Point)points.get(0);
                    Point p2 = (Point)points.get(1);
                    if (p1.x == p2.x) {
                        int y = (p1.y + p2.y) / 2;
                        tvrel.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)p1.x * this.scale), (int)((double)y * this.scale))));
                        EdgeView edge = (EdgeView)tvrel.getCellView();
                        tvrel.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel.getEdgePoints());
                        edge.update();
                    } else if (p1.y == p2.y) {
                        int x = (p1.x + p2.x) / 2;
                        tvrel.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)x * this.scale), (int)((double)p1.y * this.scale))));
                        EdgeView edge = (EdgeView)tvrel.getCellView();
                        tvrel.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel.getEdgePoints());
                        edge.update();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMinleftMaxtop(List diagramObjectPro, List anlextRteObj) {
        this.minLeft = Integer.MAX_VALUE;
        this.maxTop = -2147483647;
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator it = diagramObjectPro.iterator();
        int numOfPointsPosition = 19;
        Integer idPos = new Integer(1);
        Integer pos = new Integer(numOfPointsPosition);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            String line = selectedLine.getLine();
            String diagramObjectProId = rowHandler.getField(line, idPos);
            int numOfPoints = Integer.parseInt(rowHandler.getField(line, pos));
            int numOfPoints2 = numOfPoints;
            if (numOfPoints2 > 5) {
                numOfPoints2 = 5;
            }
            for (int i = numOfPointsPosition; i < numOfPointsPosition + numOfPoints2 * 2; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                if (left < this.minLeft) {
                    this.minLeft = left;
                }
                if (top <= this.maxTop) continue;
                this.maxTop = top;
            }
            if (numOfPoints == numOfPoints2) continue;
            this.scanPointsFromAnlextRteObj(diagramObjectProId, anlextRteObj, rowHandler);
        }
    }

    private void scanPointsFromAnlextRteObj(String diagramOPROId, List anlextRteObj, RowHandler rowHandler) {
        String line;
        ArrayList<String> selLines = new ArrayList<String>();
        Iterator it = anlextRteObj.iterator();
        Integer idPos = new Integer(8);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramOPROId.equalsIgnoreCase(id)) continue;
            selLines.add(line);
        }
        it = selLines.iterator();
        int startpos = 8;
        while (it.hasNext()) {
            line = (String)it.next();
            for (int i = startpos; i < startpos + 10; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                if (sleft.equalsIgnoreCase("0") && stop.equalsIgnoreCase("0")) continue;
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                if (left < this.minLeft) {
                    this.minLeft = left;
                }
                if (top <= this.maxTop) continue;
                this.maxTop = top;
            }
        }
    }

    private void rearrangeProcessObjects(List apoDiagramObj, List diagramObjectPro) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        int length = diagramObjectPro.size();
        block2: for (int i = 0; i < length; ++i) {
            VarFileLine diagramLine = (VarFileLine)diagramObjectPro.get(i);
            String dopID = rowHandler.getField(diagramLine, "general_id");
            int len = apoDiagramObj.size();
            for (int j = len - 1; j >= 0; --j) {
                VarFileLine line = (VarFileLine)apoDiagramObj.get(j);
                String diagramID = rowHandler.getField(line, "DIAGRAM_ID");
                if (!dopID.equalsIgnoreCase(diagramID)) continue;
                String apoID = rowHandler.getField(line, "general_id");
                AbstractProcessObject apo = (AbstractProcessObject)rowHandler.getAllCreatedObjects().get(apoID);
                if (apo == null) continue;
                try {
                    int left = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_LEFT"));
                    int top = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_TOP"));
                    int width = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_WIDTH"));
                    int height = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_HEIGHT"));
                    width = this.minLeft < 0 ? width + this.minLeft * -1 - (left += this.minLeft * -1) : width - this.minLeft - (left -= this.minLeft);
                    if (this.maxTop > 0) {
                        top = this.maxTop - top;
                        height = this.maxTop - height - top;
                    } else {
                        top = top * -1 + this.maxTop;
                        height = height * -1 + this.maxTop - top;
                    }
                    Rectangle rec = new Rectangle(left / 2 + 20, top / 2 + 20, width / 2, height / 2);
                    List allViews = apo.getAllViews();
                    for (TopView topView : allViews) {
                        if (topView == null) continue;
                        if (topView.getCellView() != null) {
                            topView.getCellView().setNewBounds(rec);
                            continue;
                        }
                        topView.setBounds(rec);
                    }
                    apoDiagramObj.remove(line);
                }
                catch (NumberFormatException e) {
                    StringBuffer message = new StringBuffer("wrong Format in rearrangeProcessObjects: ");
                    message.append(diagramLine.getLine());
                    LOGGER.error(message.toString(), e);
                }
                continue block2;
            }
        }
    }

    private void rearrangeEntities(List entityDiagramObj, List diagramObjectPro) {
        RowHandler rowHandler = this.chainBuilder.getChain();
        Iterator itr = entityDiagramObj.iterator();
        String tableID = "";
        block2: while (itr.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)itr.next();
            if (!selectedLine.getType().equalsIgnoreCase("ENTITYDIAGRAM_OBJE") || tableID.equalsIgnoreCase(rowHandler.getField(selectedLine, "general_id"))) continue;
            tableID = rowHandler.getField(selectedLine, "general_id");
            Entity entity = (Entity)rowHandler.getAllCreatedObjects().get(tableID);
            if (entity == null) continue;
            String diagramID = rowHandler.getField(selectedLine, "DIAGRAM_ID");
            for (VarFileLine diagramLine : diagramObjectPro) {
                String id;
                if (!diagramLine.getType().equalsIgnoreCase("DIAGRAM_OBJECT_PRO") || !diagramID.equalsIgnoreCase(id = rowHandler.getField(diagramLine, "general_id"))) continue;
                try {
                    TopView topView;
                    int left = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_LEFT"));
                    int top = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_TOP"));
                    int width = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_WIDTH"));
                    int height = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_HEIGHT"));
                    int color = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_ENT_COLOR"));
                    width = this.minLeft < 0 ? width + this.minLeft * -1 - (left += this.minLeft * -1) : width - this.minLeft - (left -= this.minLeft);
                    if (this.maxTop > 0) {
                        top = this.maxTop - top;
                        height = this.maxTop - height - top;
                    } else {
                        top = top * -1 + this.maxTop;
                        height = height * -1 + this.maxTop - top;
                    }
                    if ((topView = entity.getTopView()) == null) continue block2;
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle((int)((double)left * this.scale + 20.0), (int)((double)top * this.scale + 20.0), (int)((double)width * this.scale), (int)((double)height * this.scale)));
                    } else {
                        topView.setBounds(new Rectangle((int)((double)left * this.scale + 20.0), (int)((double)top * this.scale + 20.0), (int)((double)width * this.scale), (int)((double)height * this.scale)));
                    }
                    RHPlacement.setColor(topView, color);
                }
                catch (NumberFormatException e) {
                    StringBuffer message = new StringBuffer("wrong Format in rearrangeEntities: ");
                    message.append(diagramLine.getLine());
                    LOGGER.error(message.toString(), e);
                }
                continue block2;
            }
        }
    }

    static void initialSettings(Design design) {
        Settings settings = design.getAppView().getSettings();
        settings.setNotation(0);
        design.getAppView().updateSettings(true, true);
    }

    static void createDetailsDisplay(Design design) {
    }

    class Holder {
        Map map;
        ContainerObject container;

        Holder() {
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            TimeLog.log("Start");
            try {
                ImportLogger importLog = new ImportLogger();
                ParserSeperateVar.this.parse();
                if (ParserSeperateVar.this.design.getRelationalDesign().getTableSet().size() > 0) {
                    ParserSeperateVar.this.view.setCurrentDPV(ParserSeperateVar.this.design.getRelationalDesign().getMainView());
                } else {
                    ParserSeperateVar.this.view.setCurrentDPV(ParserSeperateVar.this.design.getLogicalDesign().getMainView());
                }
                ParserSeperateVar.this.view.centerDesign();
                ParserSeperateVar.this.design.getDataTypesDesign().setDirty(false);
                if (ParserSeperateVar.this.view.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(ParserSeperateVar.this.view);
                    logPanel.setLog(importLog.generateVARReport(ParserSeperateVar.this.view));
                    logPanel.showDialog(new Dimension(750, 550));
                }
                System.gc();
            }
            catch (Exception e) {
                ParserSeperateVar.this.design.destroyAll(false);
                ParserSeperateVar.this.design.destroyAll(true);
                ParserSeperateVar.this.design = null;
                LOGGER.error("Error Parsing File: " + ParserSeperateVar.this.designName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserSeperateVar.UnabletoImPortTheFile"), Messages.getString("ParserSeperateVar.ErrorImportingFile"), 0);
            }
            TimeLog.log("End");
        }
    }
}

