/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.imports.Messages;
import oracle.dbtools.crest.imports.var.ChainBuilderJoint;
import oracle.dbtools.crest.imports.var.ChainBuilderLogical;
import oracle.dbtools.crest.imports.var.DomainHandlerVarConversie;
import oracle.dbtools.crest.imports.var.MappedVarsCollector;
import oracle.dbtools.crest.imports.var.ParserSeperateVar;
import oracle.dbtools.crest.imports.var.RHAnlextRteObj;
import oracle.dbtools.crest.imports.var.RHAttribute;
import oracle.dbtools.crest.imports.var.RHDataModel;
import oracle.dbtools.crest.imports.var.RHDataModelDiagram;
import oracle.dbtools.crest.imports.var.RHDiagram;
import oracle.dbtools.crest.imports.var.RHDiagramObjectPro;
import oracle.dbtools.crest.imports.var.RHEntityDiagramObj;
import oracle.dbtools.crest.imports.var.RHFKPoints;
import oracle.dbtools.crest.imports.var.RHForeignKey;
import oracle.dbtools.crest.imports.var.RHMapExtDesign;
import oracle.dbtools.crest.imports.var.RHMapNameTable;
import oracle.dbtools.crest.imports.var.RHMapSysMap;
import oracle.dbtools.crest.imports.var.RHMapSystemMap;
import oracle.dbtools.crest.imports.var.RHPartnership;
import oracle.dbtools.crest.imports.var.RHPartnershipDiagram;
import oracle.dbtools.crest.imports.var.RHPlacement;
import oracle.dbtools.crest.imports.var.RHcdbaAssociations;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.imports.var.VarFileReader;
import oracle.dbtools.crest.imports.var.process.RHAPODiagramObj;
import oracle.dbtools.crest.imports.var.process.RHProcessModel;
import oracle.dbtools.crest.imports.var.process.RHProcessModelDiagram;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.InheritanceRelationSet;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FK_And_Delegate_Holder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.LogReport;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;

public class ParserMultiMappedVars {
    String[] physSequence = new String[]{"BUFFER_POOLS", "TEXT", "ANLTEXT", "BUFFER_POOLS", "VOLUMES", "VCATS", "VOL_SG_MAP", "STORAGE_GROUPS", "DATABASES", "DATABASE", "USER", "TABLESPACE", "TABLE_SPACES", "PARTITIONS", "DIAGRAM", "TABLES", "TABLE", "COLUMN_SETTABLE_CO", "COL_DEFAULT", "COLUMN_SET", "KEY_COL_JUNC", "TABLE_COLUMNS", "COLUMN", "COLJCT", "CHECK_CONSTRAINT", "PRIMARY_KEY", "PRIMARY_KEYS", "FOREIGN_KEY", "FOREIGN_KEYS", "INDEX", "VIEWDEPENDE2", "VIEW_DEPENDENT", "VIEWDEPENDENT", "VIEW", "VIEWS", "ALIASES", "SYNONYM", "PARTITION_BOUNDARY", "PLACEMENT", "ASSOCIATION", "POINT", "MAPSYSMAP"};
    String[] logSequence = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ALLOWED_VAL_TBL", "ALLOWABLE_VALUE", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "PROCESS_MODEL", "PROCESSSYNONYM_OBJ", "EXTERNAL_AGENTSYNO", "INFO_STORESYNONYM_", "INFO_FLOWSYNONYM_O", "STORAGE_EVENTSYNON", "FLOW_EVENTSYNONYM_", "PERSON_EVENTSYNONY", "CLOCK_EVENTSYNONYM", "STRUCTURESYNONYM_O", "PROCESS_MODELCLOCK", "PROCESS_MODELPERSO", "PROCESS_MODELSTORA", "PROCESS_MODELFLOW_", "FLOW_EVENT", "CLOCK_EVENT", "PERSON_EVENT", "STORAGE_EVENT", "PROCESS", "PROCESSCLOCK_EVENT", "PROCESSPERSON_EVEN", "PROCESSSTORAGE_EVE", "EXTERNAL_AGENT", "INFO_STORE", "PROCESSINFO_FLOW", "EXTERNAL_AGENTINFO", "INFO_STOREINFO_FLO", "INFO_FLOWEXTERNAL_", "INFO_FLOWINFO_STOR", "INFO_FLOWPROCESS", "INFO_FLOW", "STRUCTUREPROCESS_M", "STRUCTUREINFO_FLOW", "STRUCTURE", "STRUCT_ENT", "STRUCT_ATTR", "PROCESSDIAGRAM_OBJ", "EXTERNAL_AGENTDIAG", "INFO_STOREDIAGRAM_", "PROCESS_MODELDIAGR", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "PARTNERSHIPDIAGRAM", "MAP_SYSTEM_MAP", "MAP_NAME_TABLE", "MAP_EXT_DESIGN"};
    String[] logSequenceNoPM = new String[]{"TEXT", "ANLTEXT", "SYNONYM_OBJECT", "ENTITYSYNONYM_OBJE", "ENT_KEYSYNONYM_OBJ", "PARTNERSHIP_SETSYN", "ATTRIBUTESYNONYM_O", "NOTES", "DIMENSION", "DOMAINS", "DOMAINSSYNONYM_OBJ", "ALLOWED_VAL_TBL", "ALLOWABLE_VALUE", "ENTITY", "ENTITY", "ATTRIBUTE", "ENT_KEY", "ATTRIBUTEENT_KEY", "PARTNERSHIP_SET", "PARTNERSHIP", "PARTNERSHIP_SETENT", "PARTNERSHIPFOREIGN", "PARTNERSHIPFOREIG2", "FOREIGN_KEY_ATTR", "ENTITYDIAGRAM_OBJE", "ANLEXT_RTE_OBJ", "DATA_MODEL", "DATA_MODELDIAGRAM_", "DIAGRAM_OBJECT_PRO", "PARTNERSHIPDIAGRAM", "MAP_SYSTEM_MAP", "MAP_NAME_TABLE", "MAP_EXT_DESIGN"};
    private VarFileReader readerLogical;
    private VarFileReader readerForDomains;
    private Design design;
    private Design designForDomains;
    private ChainBuilderLogical chainBuilderLogical;
    private List allSelectedLinesLogical = new ArrayList();
    private Map allCreatedObjectsLogical = new HashMap();
    private Map allReferencesLogical = new HashMap();
    private List allForeignKeyLinesLogical = new ArrayList();
    private List allPrimaryKeyLinesLogical = new ArrayList();
    private List allColumnLinesLogical = new ArrayList();
    private List allCommentLinesLogical = new ArrayList();
    private List allSelectedLinesPhysical = new ArrayList();
    private Map allCreatedObjectsPhysical = new HashMap();
    private Map allReferencesPhysical = new HashMap();
    private List allForeignKeyLinesPhysical = new ArrayList();
    private List allPrimaryKeyLinesPhysical = new ArrayList();
    private List allColumnLinesPhysical = new ArrayList();
    private List allCommentLinesPhysical = new ArrayList();
    private RDBMSSite site;
    private boolean matched = false;
    private ApplicationView view = null;
    private StatusBarOwner statusBarOwner = StatusBarOwner.NULL_INSTANCE;
    private boolean hasMapping = false;
    private List relationalModels = new ArrayList();
    private String nameLogicalDesign;
    private List relNames;
    private List tempFiles = new ArrayList();
    private ProgressDialog monitor;
    private String designName;
    private double scale = 0.5;
    private boolean importPM;
    private static final Logger LOGGER = new Logger(ParserMultiMappedVars.class);
    private VarFileLine linePhysical;
    int minLeft = Integer.MAX_VALUE;
    int maxTop = -2147483647;
    List fkMapList = new ArrayList();
    List fkColList = new ArrayList();

    public void parseContens(View view, RDBMSSite site, MappedVarsCollector collector, boolean importPM) {
        this.view = (ApplicationView)view;
        this.importPM = importPM;
        this.readerLogical = new VarFileReader(collector.getLogicalFile().getAbsolutePath());
        boolean isLogical = this.readerLogical.isLogicalDesign();
        if (isLogical) {
            Object[] files = collector.getRelationalFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!(files[i] instanceof File)) continue;
                VarFileReader reader = new VarFileReader(((File)files[i]).getAbsolutePath());
                if (reader.isLogicalDesign()) {
                    int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ParserMultiMappedVars.FileNotRelationalModel"), ((File)files[i]).getName()), Messages.getString("ParserMultiMappedVars.Warning"), 0);
                    if (choice == 0) continue;
                    ApplicationView.log(Messages.getString("ParserMultiMappedVars.IimportProcessStopped"));
                    return;
                }
                this.relationalModels.add(reader);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserMultiMappedVars.LogicalVARFileSelectedNotLogicalModel"), Messages.getString("ParserMultiMappedVars.Error"), 0);
            ApplicationView.log(Messages.getString("ParserMultiMappedVars.TheImportProcessStopped"));
            return;
        }
        if (this.relationalModels.size() == 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserMultiMappedVars.ThereIsntRelationalModelToImport"), Messages.getString("ParserMultiMappedVars.Error"), 0);
            ApplicationView.log(Messages.getString("ParserMultiMappedVars.TheImportProcessStopped"));
            return;
        }
        this.design = this.view.getCurrentDesign();
        this.readerForDomains = new VarFileReader(collector.getLogicalFile().getAbsolutePath());
        String oldDesignPath = this.view.getCurrentDesign().getDesignPath();
        this.designName = this.readerLogical.getName();
        if (this.designName != null) {
            this.view.getCurrentDesign().setDesignPath(ApplicationView.TEMP_DIR);
            if (this.view.designExists(this.designName)) {
                this.view.deleteDesign(this.designName);
            }
            this.site = site;
            this.design.setFileName(this.designName);
            ((ApplicationView)view).setDesignName(this.designName);
            this.design.setSelectedRDBMSSite(site);
            this.designForDomains = this.design;
            if (view != null && view instanceof StatusBarOwner) {
                this.statusBarOwner = (StatusBarOwner)((Object)view);
            }
            this.chainBuilderLogical = new ChainBuilderLogical();
            if (importPM) {
                this.chainBuilderLogical.buildChain(this.design, this.readerLogical.getConstants(), this.allSelectedLinesLogical, this.allCreatedObjectsLogical, this.allForeignKeyLinesLogical, this.allPrimaryKeyLinesLogical, this.allReferencesLogical, this.allColumnLinesLogical, this.allCommentLinesLogical);
            } else {
                this.chainBuilderLogical.buildChainNoPM(this.design, this.readerLogical.getConstants(), this.allSelectedLinesLogical, this.allCreatedObjectsLogical, this.allForeignKeyLinesLogical, this.allPrimaryKeyLinesLogical, this.allReferencesLogical, this.allColumnLinesLogical, this.allCommentLinesLogical);
            }
            new Thread(new Runner()).start();
        } else {
            this.view.getCurrentDesign().setDesignPath(oldDesignPath);
            this.design = null;
            System.gc();
        }
    }

    private void resetDirty(Design design) {
        for (RelationalDesign pd : design.getRelationalDesigns()) {
            pd.setDirty(true);
        }
    }

    private void parse() {
        ParserSeperateVar.initialSettings(this.design);
        this.monitor.setNote(Messages.getString("ParserMultiMappedVars.ReadLogicalLines"));
        this.monitor.setProgress(5);
        Integer extDesIdPos = new Integer(1);
        Integer desIdInNameTabPos = new Integer(8);
        this.readLogicalLines();
        this.monitor.setNote(Messages.getString("ParserMultiMappedVars.ConstructDomains"));
        this.monitor.setProgress(15);
        this.constructDomains();
        this.monitor.setNote(Messages.getString("ParserMultiMappedVars.ParseFile"));
        this.monitor.setProgress(25);
        this.parseFile();
        this.monitor.setNote(Messages.getString("ParserMultiMappedVars.RearrangeGraphicalObjects"));
        this.monitor.setProgress(40);
        try {
            this.rearrangeEntitiesAndPartnerships();
        }
        catch (Exception e) {
            LOGGER.error("Unable to rearrange Entities and Partnerships", e);
        }
        try {
            this.parseList();
        }
        catch (Exception e) {
            LOGGER.error("Unable to parse List", e);
        }
        try {
            this.createArcs();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create Arcs", e);
        }
        this.design.getLogicalDesign().resetIdentifyingRelationships();
        this.design.removeRelationalDesign(this.design.getRelationalDesign());
        RHMapExtDesign rhMapExtDesign = (RHMapExtDesign)this.chainBuilderLogical.getSpecificRowHandler(RHMapExtDesign.class);
        this.monitor.setNote(Messages.getString("ParserMultiMappedVars.CheckMatchingM"));
        this.monitor.setProgress(50);
        double p = 40.0;
        if (this.readLogicalMappingInfo(rhMapExtDesign)) {
            for (int i = this.relationalModels.size() - 1; i >= 0; --i) {
                this.monitor.setProgress((int)(p += (double)(40 / this.relationalModels.size())));
                VarFileReader relReader = (VarFileReader)this.relationalModels.get(i);
                ChainBuilderJoint chain = this.buildRelChain(relReader);
                this.readRelationalLines(relReader, chain);
                Object relName = relReader.getName();
                if (((String)relName).length() > 25) {
                    relName = ((String)relName).substring(0, 24) + "...";
                }
                this.monitor.setNote(MessageFormat.format(Messages.getString("ParserMultiMappedVars.CheckMatching"), relName));
                boolean areMatching = this.checkMatching(relReader);
                if (areMatching) {
                    this.matched = true;
                    RelationalDesign relDesign = this.design.addRelationalDesign(relReader.getName());
                    this.design.setRelationalDesign(relDesign);
                    this.monitor.setNote(Messages.getString("ParserMultiMappedVars.ConstructRelationalDomains"));
                    this.constructRelationalDomains(relReader, relDesign.getObjectID());
                    relName = relReader.getName();
                    if (((String)relName).length() > 25) {
                        relName = ((String)relName).substring(0, 24) + "...";
                    }
                    this.monitor.setNote(MessageFormat.format(Messages.getString("ParserMultiMappedVars.ParseMatchingFile"), relName));
                    this.parseMatchingFile(relReader, chain);
                    try {
                        this.parseMatchingList(chain);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to parse Matching List", e);
                    }
                    this.monitor.setNote(Messages.getString("ParserMultiMappedVars.CreateObjectsInSubViews"));
                    try {
                        this.createObjectsInSubViews(chain);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to parse Matching List", e);
                    }
                    try {
                        this.parsePoints(chain);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to parse Points", e);
                    }
                    this.monitor.setNote(Messages.getString("ParserMultiMappedVars.RearrangeGraphicalObjects"));
                    try {
                        this.rearrangePhysDes(chain);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to rearange Relational Design", e);
                    }
                    try {
                        this.arrangeColumnPositionInTable();
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to arrange Column positions in Table", e);
                    }
                    ParserSeperateVar.createDetailsDisplay(this.design);
                    VarFileLine lineForRelDes = rhMapExtDesign.getLineForRelationalDesign(relReader.getName().trim());
                    if (lineForRelDes == null) continue;
                    String extDesId = rhMapExtDesign.getField(lineForRelDes.getLine(), extDesIdPos);
                    String desIdInNameTab = rhMapExtDesign.getField(lineForRelDes.getLine(), desIdInNameTabPos);
                    try {
                        this.fkColList.clear();
                        this.fkMapList.clear();
                        this.recreateMappingInfo(extDesId, desIdInNameTab, chain, relDesign);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to recreat Mapping Info", e);
                    }
                    continue;
                }
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ParserMultiMappedVars.RelationalModel"), relReader.getName()), Messages.getString("ParserMultiMappedVars.Information"), 1);
                this.relationalModels.remove(relReader);
            }
            try {
                this.arrangeAttributePositionInEntity();
            }
            catch (Exception e) {
                LOGGER.error("Unable to arrange Attribute positions in Entity", e);
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserMultiMappedVars.MissingMappingInfoInTheLogicalModel"), Messages.getString("ParserMultiMappedVars.Error"), 0);
            ApplicationView.log(Messages.getString("ParserMultiMappedVars.TheImportProcessIsStopped"));
        }
    }

    private void createArcs() {
        RHPartnership handler = (RHPartnership)this.chainBuilderLogical.getSpecificRowHandler(RHPartnership.class);
        handler.createArcs();
    }

    private void arrangeColumnPositionInTable() {
        TreeMap<String, Holder> tablesMap = new TreeMap<String, Holder>();
        for (VarFileLine line : this.allColumnLinesPhysical) {
            String keyColumn = null;
            StringTokenizer tok = new StringTokenizer(line.getLine(), ",");
            keyColumn = tok.nextToken().trim();
            Object columnObject = this.allCreatedObjectsPhysical.get(keyColumn);
            Column column = null;
            if (columnObject instanceof Column) {
                column = (Column)columnObject;
            }
            if (column == null) continue;
            Table table = (Table)column.getParent();
            int ordnum = 21;
            try {
                Holder holder;
                StringTokenizer tok2 = new StringTokenizer(line.getLine(), ",");
                int position = 0;
                int count = 0;
                while (tok2.hasMoreElements()) {
                    String element = tok2.nextToken().trim();
                    if (++count != ordnum) continue;
                    position = Integer.parseInt(element);
                    break;
                }
                if ((holder = (Holder)tablesMap.get(table.getObjectID())) == null) {
                    holder = new Holder();
                    holder.container = table;
                    holder.map = new TreeMap();
                    tablesMap.put(table.getObjectID(), holder);
                }
                holder.map.put(new Integer(position - 1), column);
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
            }
        }
        for (String key : tablesMap.keySet()) {
            Holder holder = (Holder)tablesMap.get(key);
            this.sortAttributes(holder.container, holder.map);
        }
    }

    private void arrangeAttributePositionInEntity() {
        TreeMap<String, Holder> tablesMap = new TreeMap<String, Holder>();
        for (VarFileLine line : this.chainBuilderLogical.getSpecificRowHandler(RHAttribute.class).getOwnLines()) {
            String keyColumn = null;
            StringTokenizer tok = new StringTokenizer(line.getLine(), ",");
            keyColumn = tok.nextToken().trim();
            Object columnObject = this.allCreatedObjectsLogical.get(keyColumn);
            Attribute column = null;
            if (columnObject instanceof Attribute) {
                column = (Attribute)columnObject;
            }
            if (column == null) continue;
            Entity table = (Entity)column.getParent();
            int ordnum = 10;
            try {
                Holder holder;
                StringTokenizer tok2 = new StringTokenizer(line.getLine(), ",");
                int position = 0;
                int count = 0;
                while (tok2.hasMoreElements()) {
                    String element = tok2.nextToken().trim();
                    if (++count != ordnum) continue;
                    position = Integer.parseInt(element);
                    break;
                }
                if ((holder = (Holder)tablesMap.get(table.getObjectID())) == null) {
                    holder = new Holder();
                    holder.container = table;
                    holder.map = new TreeMap();
                    tablesMap.put(table.getObjectID(), holder);
                }
                holder.map.put(new Integer(position - 1), column);
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("Wrong Format in ParserJointVars.arrangeColumnPositionInTable() : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
            }
        }
        for (String key : tablesMap.keySet()) {
            Holder holder = (Holder)tablesMap.get(key);
            this.sortAttributes(holder.container, holder.map);
        }
    }

    private void sortAttributes(ContainerObject cont, Map map) {
        for (Integer key : map.keySet()) {
            ContainedObject attr = (ContainedObject)map.get(key);
            if (attr == null) continue;
            cont.moveToIndex(attr, key);
        }
    }

    public void rearrangePhysDes(ChainBuilderJoint chain) {
        RHPlacement rhPlacement = (RHPlacement)chain.getSpecificRowHandler(RHPlacement.class);
        rhPlacement.rearrangePhysDes();
    }

    private void parsePoints(ChainBuilderJoint chain) {
        RowHandler fkrh = chain.getSpecificRowHandler(RHForeignKey.class);
        RowHandler assrh = chain.getSpecificRowHandler(RHcdbaAssociations.class);
        RHFKPoints pointrh = (RHFKPoints)chain.getSpecificRowHandler(RHFKPoints.class);
        pointrh.processPointsForPhysical(fkrh.getOwnLines(), assrh.getOwnLines());
    }

    public void createObjectsInSubViews(ChainBuilderJoint chain) {
        RHDiagram rhDiagram = (RHDiagram)chain.getSpecificRowHandler(RHDiagram.class);
        RHPlacement rhPlacement = (RHPlacement)chain.getSpecificRowHandler(RHPlacement.class);
        rhPlacement.createObjectsInSubViews(rhDiagram.getDiagramsMap());
    }

    private void parseMatchingList(ChainBuilderJoint chain) {
        int sizeOfList = this.allSelectedLinesPhysical.size();
        int sizeOfListAfter = sizeOfList - 1;
        while (sizeOfList - sizeOfListAfter > 0) {
            this.parseInRightSequencePhysical(chain);
            sizeOfList = sizeOfListAfter;
            sizeOfListAfter = this.allSelectedLinesPhysical.size();
        }
        for (int i = 0; i < this.physSequence.length; ++i) {
            chain.getChain().removeSelectedLinesOfType(this.physSequence[i]);
        }
        for (VarFileLine line : this.allSelectedLinesPhysical) {
            if (line.getType().equals("MAPNAMET") || line.getType().equals("MAPSYSMAP") || line.getType().equals("MAP_NAME_TABLE") || line.getType().equals("MAP_EXT_DESIGN") || line.getType().equals("MAPEXTDGN") || line.getType().equals("MAP_SYSTEM_MAP")) continue;
            StringBuffer message = new StringBuffer("!!! UNHANDLED : ");
            message.append(line.getType());
            message.append(" : ");
            message.append(line.getLine());
            LOGGER.error(message.toString());
        }
    }

    private void parseMatchingFile(VarFileReader relReader, ChainBuilderJoint chain) {
        this.design.setSelectedRDBMSSite(this.site);
        this.parseInRightSequencePhysical(chain);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setOpen(true);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setTempModel(false);
        this.design.getStorageDesign(this.design.getSelectedRDBMSSite()).setDirty(true);
        relReader.closeReader();
    }

    private void parseInRightSequencePhysical(ChainBuilderJoint chain) {
        ArrayList lines = new ArrayList(this.allSelectedLinesPhysical);
        int seqLength = this.physSequence.length;
        for (int sequenceNumber = 0; sequenceNumber < seqLength; ++sequenceNumber) {
            int linesSize = lines.size();
            for (int lineNumber = 0; lineNumber < linesSize; ++lineNumber) {
                VarFileLine line = (VarFileLine)lines.get(lineNumber);
                if (!line.getType().equalsIgnoreCase(this.physSequence[sequenceNumber])) continue;
                try {
                    RowHandler rh = (RowHandler)chain.getObjectMap().get(line.getType());
                    if (rh == null) continue;
                    rh.handle(line, this.hasMapping);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to handle the line: " + line.getLine(), e);
                    chain.getChain().nextHandler(line, this.hasMapping);
                }
            }
        }
    }

    private void parseList() {
        int i;
        int sizeOfList = this.allSelectedLinesLogical.size();
        int sizeOfListAfter = sizeOfList - 1;
        while (sizeOfList - sizeOfListAfter > 0) {
            this.parseInRightSequenceLogical();
            sizeOfList = sizeOfListAfter;
            sizeOfListAfter = this.allSelectedLinesLogical.size();
        }
        if (this.importPM) {
            for (i = 0; i < this.logSequence.length; ++i) {
                this.chainBuilderLogical.getChain().removeSelectedLinesOfType(this.logSequence[i]);
            }
        } else {
            for (i = 0; i < this.logSequenceNoPM.length; ++i) {
                this.chainBuilderLogical.getChain().removeSelectedLinesOfType(this.logSequenceNoPM[i]);
            }
        }
        for (VarFileLine line : this.allSelectedLinesLogical) {
            if (line.getType().equals("MAPNAMET") || line.getType().equals("MAPSYSMAP") || line.getType().equals("MAP_NAME_TABLE") || line.getType().equals("MAP_EXT_DESIGN") || line.getType().equals("MAPEXTDGN") || line.getType().equals("MAP_SYSTEM_MAP")) continue;
            StringBuffer message = new StringBuffer("!!! UNHANDLED : ");
            message.append(line.getType());
            message.append(" : ");
            message.append(line.getLine());
            LOGGER.error(message.toString());
        }
    }

    private void readLogicalLines() {
        VarFileLine line;
        ApplicationView.log(Messages.getString("ParserMultiMappedVars.OpeningLogicalFileForParsing"));
        this.readerLogical.startReader();
        while ((line = this.readerLogical.readLine()) != null) {
            try {
                RowHandler rh = (RowHandler)this.chainBuilderLogical.getObjectMap().get(line.getType());
                if (rh == null) continue;
                rh.read(line);
            }
            catch (Exception e) {
                LOGGER.error("Unable to read the line: " + line.getLine(), e);
                this.chainBuilderLogical.getChain().nextRead(line);
            }
        }
    }

    private void readRelationalLines(VarFileReader relReader, ChainBuilderJoint chain) {
        VarFileLine line;
        ApplicationView.log(Messages.getString("ParserMultiMappedVars.OpeningRlationalFileForParsing"));
        relReader.startReader();
        while ((line = relReader.readLine()) != null) {
            try {
                RowHandler rh = (RowHandler)chain.getObjectMap().get(line.getType());
                if (rh == null) continue;
                rh.read(line);
            }
            catch (Exception e) {
                LOGGER.error("Unable to read the line: " + line.getLine(), e);
                chain.getChain().nextRead(line);
            }
        }
    }

    private ChainBuilderJoint buildRelChain(VarFileReader relReader) {
        ChainBuilderJoint chain = new ChainBuilderJoint();
        this.allSelectedLinesPhysical.clear();
        this.allCreatedObjectsPhysical.clear();
        this.allForeignKeyLinesPhysical.clear();
        this.allPrimaryKeyLinesPhysical.clear();
        this.allReferencesPhysical.clear();
        this.allColumnLinesPhysical.clear();
        this.allCommentLinesPhysical.clear();
        chain.buildChain(this.design, relReader.getConstants(), this.allSelectedLinesPhysical, this.allCreatedObjectsPhysical, this.allForeignKeyLinesPhysical, this.allPrimaryKeyLinesPhysical, this.allReferencesPhysical, this.allColumnLinesPhysical, this.allCommentLinesPhysical);
        return chain;
    }

    private boolean readLogicalMappingInfo(RHMapExtDesign mapExtDesignLogical) {
        this.nameLogicalDesign = this.getDataModelName(this.chainBuilderLogical.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        List logicalLines = mapExtDesignLogical.getLogicalLines();
        if (logicalLines.size() == 0) {
            return false;
        }
        this.relNames = mapExtDesignLogical.getDesignNames();
        return true;
    }

    private boolean checkMatching(VarFileReader relReader) {
        try {
            String namePhysicalDesign = relReader.getName().trim();
            RHMapExtDesign mapExtDesignPhysical = new RHMapExtDesign(this.design, this.readerLogical.getConstants(), this.allSelectedLinesPhysical, this.allCreatedObjectsPhysical, this.allForeignKeyLinesPhysical, this.allPrimaryKeyLinesPhysical, this.allReferencesPhysical, this.allColumnLinesPhysical, this.allCommentLinesPhysical);
            this.linePhysical = this.getLine(this.allSelectedLinesPhysical);
            while (this.linePhysical != null) {
                mapExtDesignPhysical.handle(this.linePhysical, this.hasMapping);
                String nameForLogicalFromPhysical = mapExtDesignPhysical.getNameDesign();
                if (this.nameLogicalDesign.equalsIgnoreCase(nameForLogicalFromPhysical) && this.relNames.contains(namePhysicalDesign)) {
                    return true;
                }
                this.linePhysical = this.getLine(this.allSelectedLinesPhysical);
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Unable to check Matching", e);
            return false;
        }
    }

    private VarFileLine getLine(List allSelectedLines) {
        ArrayList lines = new ArrayList(allSelectedLines);
        for (int lineNumber = 0; lineNumber < lines.size(); ++lineNumber) {
            VarFileLine line = (VarFileLine)lines.get(lineNumber);
            if (!line.getType().equalsIgnoreCase("MAP_EXT_DESIGN") && !line.getType().equalsIgnoreCase("MAPEXTDGN")) continue;
            return line;
        }
        return null;
    }

    private void constructDomains() {
        try {
            StringBuffer filenameDes = new StringBuffer(this.design.getFileName());
            filenameDes.append("_Domains");
            this.designForDomains.setFileName(filenameDes.toString());
            this.tempFiles.add(filenameDes.toString());
            ApplicationView.log(Messages.getString("ParserMultiMappedVars.OpeningFileForDomainConstruction"));
            List linesForDomains = this.collectLinesForDomains();
            DomainHandlerVarConversie domainHandler = new DomainHandlerVarConversie(this.designForDomains, this.readerForDomains.getConstants(), this.allSelectedLinesLogical, this.allCreatedObjectsLogical, this.allForeignKeyLinesLogical, this.allPrimaryKeyLinesLogical, this.allReferencesLogical, this.allColumnLinesLogical, this.allCommentLinesLogical);
            domainHandler.createDomains(linesForDomains, this.allCommentLinesLogical, this.statusBarOwner);
            this.designForDomains.setFileName(this.designName);
            this.designForDomains.resetDomains();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create domains!", e);
        }
    }

    private void constructRelationalDomains(VarFileReader relReader, String domainFileName) {
        try {
            ApplicationView.log(Messages.getString("ParserMultiMappedVars.OpeningFileForDomainConstruction"));
            StringBuffer filenameDes = new StringBuffer(domainFileName);
            filenameDes.append("_Domains");
            this.designForDomains.setFileName(filenameDes.toString());
            this.tempFiles.add(filenameDes.toString());
            this.readerForDomains = new VarFileReader(relReader.getPath());
            List linesForDomains = this.collectLinesForDomains();
            DomainHandlerVarConversie domainHandler = new DomainHandlerVarConversie(this.designForDomains, relReader.getConstants(), this.allSelectedLinesPhysical, this.allCreatedObjectsPhysical, this.allForeignKeyLinesPhysical, this.allPrimaryKeyLinesPhysical, this.allReferencesPhysical, this.allColumnLinesPhysical, this.allCommentLinesPhysical);
            domainHandler.createDomains(linesForDomains, this.allCommentLinesPhysical, this.statusBarOwner);
            this.designForDomains.setFileName(this.designName);
            this.designForDomains.resetDomains();
        }
        catch (Exception e) {
            LOGGER.error("Unable to create relational domains!", e);
        }
    }

    private List collectLinesForDomains() {
        ArrayList<VarFileLine> listLines = new ArrayList<VarFileLine>();
        VarFileLine line = this.readerForDomains.readLine();
        int lineNbr = 1;
        while (line != null) {
            String type = line.getType();
            if (type.equalsIgnoreCase("TABLE_COLUMNS") || type.equalsIgnoreCase("COLUMN") || type.equalsIgnoreCase("DOMAINS")) {
                listLines.add(line);
            } else if (type.equalsIgnoreCase("ANLTEXT") || type.equalsIgnoreCase("SYNONYM_OBJECT") || type.equalsIgnoreCase("DOMAINSSYNONYM_OBJ") || type.equalsIgnoreCase("DIMENSION") || type.equalsIgnoreCase("ALLOWED_VAL_TBL") || type.equalsIgnoreCase("ALLOWABLE_VALUE")) {
                this.allCommentLinesLogical.add(line);
            }
            line = this.readerForDomains.readLine();
            ++lineNbr;
        }
        this.readerForDomains.closeReader();
        return listLines;
    }

    private void parseFile() {
        this.design.setSelectedRDBMSSite(this.site);
        this.parseInRightSequenceLogical();
        this.readerLogical.closeReader();
    }

    private void parseInRightSequenceLogical() {
        String hierStyle = this.getDataHierarchyStyle(this.chainBuilderLogical.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        if ("1".equals(hierStyle)) {
            this.view.getSettings().setBoxInBox(false);
        } else {
            this.view.getSettings().setBoxInBox(true);
        }
        ArrayList lines = new ArrayList(this.allSelectedLinesLogical);
        int seqLength = this.importPM ? this.logSequence.length : this.logSequenceNoPM.length;
        for (int sequenceNumber = 0; sequenceNumber < seqLength; ++sequenceNumber) {
            int linesSize = lines.size();
            for (int lineNumber = 0; lineNumber < linesSize; ++lineNumber) {
                VarFileLine line = (VarFileLine)lines.get(lineNumber);
                boolean b = this.importPM ? line.getType().equalsIgnoreCase(this.logSequence[sequenceNumber]) : line.getType().equalsIgnoreCase(this.logSequenceNoPM[sequenceNumber]);
                if (!b) continue;
                try {
                    RowHandler rh = (RowHandler)this.chainBuilderLogical.getObjectMap().get(line.getType());
                    if (rh == null) continue;
                    rh.handle(line, this.hasMapping);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Unable to handle the line: " + line.getLine(), e);
                    this.chainBuilderLogical.getChain().nextHandler(line, this.hasMapping);
                }
            }
        }
    }

    private String getDataHierarchyStyle(List dataModel) {
        String style;
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator it = dataModel.iterator();
        if (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            style = rowHandler.getField(selectedLine.getLine(), new Integer(15));
        } else {
            style = null;
        }
        return style;
    }

    private void rearrangeEntitiesAndPartnerships() {
        List diagramObjectPro;
        List partnerships = this.chainBuilderLogical.getSpecificRowHandler(RHPartnership.class).getOwnLines();
        List partnershipsDiagram = this.chainBuilderLogical.getSpecificRowHandler(RHPartnershipDiagram.class).getOwnLines();
        List entityDiagramObj = this.chainBuilderLogical.getSpecificRowHandler(RHEntityDiagramObj.class).getOwnLines();
        List apoDiagramObj = null;
        if (this.importPM) {
            apoDiagramObj = this.chainBuilderLogical.getSpecificRowHandler(RHAPODiagramObj.class).getOwnLines();
        }
        List anlextRteObj = this.chainBuilderLogical.getSpecificRowHandler(RHAnlextRteObj.class).getOwnLines();
        String dataModelId = this.getDataModelId(this.chainBuilderLogical.getSpecificRowHandler(RHDataModel.class).getOwnLines());
        String dataModelDiagramId = this.getDataModelDiagramId(this.chainBuilderLogical.getSpecificRowHandler(RHDataModelDiagram.class).getOwnLines(), dataModelId);
        if (dataModelDiagramId != null && (diagramObjectPro = (List)this.chainBuilderLogical.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(dataModelDiagramId)) != null) {
            this.initMinleftMaxtop(diagramObjectPro, anlextRteObj);
            this.rearrangeEntities(entityDiagramObj, diagramObjectPro);
            this.rearrangePartnerships(partnerships, partnershipsDiagram, diagramObjectPro, anlextRteObj, this.minLeft, this.maxTop);
        }
        if (this.importPM) {
            List processModelIDs = this.chainBuilderLogical.getSpecificRowHandler(RHProcessModel.class).getOwnLines();
            Iterator it = processModelIDs.iterator();
            RowHandler rowHandler = this.chainBuilderLogical.getChain();
            while (it.hasNext()) {
                List diagramObjectPro2;
                VarFileLine selectedLine = (VarFileLine)it.next();
                String pmID = rowHandler.getField(selectedLine.getLine(), new Integer(1));
                String pmDiagramId = this.getProcessModelDiagramId(this.chainBuilderLogical.getSpecificRowHandler(RHProcessModelDiagram.class).getOwnLines(), pmID);
                if (pmDiagramId == null || (diagramObjectPro2 = (List)this.chainBuilderLogical.getSpecificRowHandler(RHDiagramObjectPro.class).getMap().get(pmDiagramId)) == null) continue;
                this.initMinleftMaxtop(diagramObjectPro2, anlextRteObj);
                this.rearrangeProcessObjects(apoDiagramObj, diagramObjectPro2);
            }
            for (DataFlowDesign dfd : this.design.getProcessModel().getDataFlowDesigns()) {
                dfd.getMainView().getWorkSpace().alignDiagram();
            }
        }
        Iterator it = this.design.getLogicalDesign().getRelationSet().iterator();
        DesignPartView dpv = this.design.getLogicalDesign().getMainView();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            TVRelation tv = (TVRelation)rel.getViewFor(dpv);
            if (tv == null) continue;
            tv.resetEdgeParams();
        }
    }

    private String getProcessModelDiagramId(List processModelDiagram, String processModelId) {
        String id = null;
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        for (VarFileLine selectedLine : processModelDiagram) {
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
            if (!processModelId.equalsIgnoreCase(id)) continue;
            return rowHandler.getField(selectedLine.getLine(), new Integer(2));
        }
        return null;
    }

    private void rearrangeProcessObjects(List apoDiagramObj, List diagramObjectPro) {
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        int length = diagramObjectPro.size();
        block2: for (int i = 0; i < length; ++i) {
            VarFileLine diagramLine = (VarFileLine)diagramObjectPro.get(i);
            String dopID = rowHandler.getField(diagramLine, "general_id");
            int len = apoDiagramObj.size();
            for (int j = len - 1; j >= 0; --j) {
                VarFileLine line = (VarFileLine)apoDiagramObj.get(j);
                String diagramID = rowHandler.getField(line, "DIAGRAM_ID");
                if (!dopID.equalsIgnoreCase(diagramID)) continue;
                String apoID = rowHandler.getField(line, "general_id");
                AbstractProcessObject apo = (AbstractProcessObject)rowHandler.getAllCreatedObjects().get(apoID);
                if (apo == null) continue;
                try {
                    int left = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_LEFT"));
                    int top = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_TOP"));
                    int width = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_WIDTH"));
                    int height = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_HEIGHT"));
                    width = this.minLeft < 0 ? width + this.minLeft * -1 - (left += this.minLeft * -1) : width - this.minLeft - (left -= this.minLeft);
                    if (this.maxTop > 0) {
                        top = this.maxTop - top;
                        height = this.maxTop - height - top;
                    } else {
                        top = top * -1 + this.maxTop;
                        height = height * -1 + this.maxTop - top;
                    }
                    Rectangle rec = new Rectangle(left / 2 + 20, top / 2 + 20, width / 2, height / 2);
                    List allViews = apo.getAllViews();
                    for (TopView topView : allViews) {
                        if (topView == null) continue;
                        if (topView.getCellView() != null) {
                            topView.getCellView().setNewBounds(rec);
                            continue;
                        }
                        topView.setBounds(rec);
                    }
                    apoDiagramObj.remove(line);
                }
                catch (NumberFormatException e) {
                    StringBuffer message = new StringBuffer("wrong Format in rearrangeProcessObjects: ");
                    message.append(diagramLine.getLine());
                    LOGGER.error(message.toString(), e);
                }
                continue block2;
            }
        }
    }

    private String getDataModelId(List dataModel) {
        String id;
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator it = dataModel.iterator();
        if (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
        } else {
            id = null;
        }
        return id;
    }

    private String getDataModelName(List dataModel) {
        String name = "";
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator it = dataModel.iterator();
        if (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            name = rowHandler.getField(selectedLine.getLine(), new Integer(7));
        }
        return name;
    }

    private String getDataModelDiagramId(List dataModelDiagram, String dataModelId) {
        String id = null;
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        for (VarFileLine selectedLine : dataModelDiagram) {
            id = rowHandler.getField(selectedLine.getLine(), new Integer(1));
            if (!dataModelId.equalsIgnoreCase(id)) continue;
            return rowHandler.getField(selectedLine.getLine(), new Integer(2));
        }
        return null;
    }

    private void initMinleftMaxtop(List diagramObjectPro, List anlextRteObj) {
        this.minLeft = Integer.MAX_VALUE;
        this.maxTop = -2147483647;
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator it = diagramObjectPro.iterator();
        int numOfPointsPosition = 19;
        Integer idPos = new Integer(1);
        Integer pos = new Integer(numOfPointsPosition);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            String line = selectedLine.getLine();
            String diagramObjectProId = rowHandler.getField(line, idPos);
            int numOfPoints = Integer.parseInt(rowHandler.getField(line, pos));
            int numOfPoints2 = numOfPoints;
            if (numOfPoints2 > 5) {
                numOfPoints2 = 5;
            }
            for (int i = numOfPointsPosition; i < numOfPointsPosition + numOfPoints2 * 2; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                if (left < this.minLeft) {
                    this.minLeft = left;
                }
                if (top <= this.maxTop) continue;
                this.maxTop = top;
            }
            if (numOfPoints == numOfPoints2) continue;
            this.scanPointsFromAnlextRteObj(diagramObjectProId, anlextRteObj, rowHandler);
        }
    }

    private void scanPointsFromAnlextRteObj(String diagramOPROId, List anlextRteObj, RowHandler rowHandler) {
        String line;
        ArrayList<String> selLines = new ArrayList<String>();
        Iterator it = anlextRteObj.iterator();
        Integer idPos = new Integer(8);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramOPROId.equalsIgnoreCase(id)) continue;
            selLines.add(line);
        }
        it = selLines.iterator();
        int startpos = 8;
        while (it.hasNext()) {
            line = (String)it.next();
            for (int i = startpos; i < startpos + 10; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                if (sleft.equalsIgnoreCase("0") && stop.equalsIgnoreCase("0")) continue;
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                if (left < this.minLeft) {
                    this.minLeft = left;
                }
                if (top <= this.maxTop) continue;
                this.maxTop = top;
            }
        }
    }

    private void rearrangeEntities(List entityDiagramObj, List diagramObjectPro) {
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator itr = entityDiagramObj.iterator();
        String tableID = "";
        block2: while (itr.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)itr.next();
            if (!selectedLine.getType().equalsIgnoreCase("ENTITYDIAGRAM_OBJE") || tableID.equalsIgnoreCase(rowHandler.getField(selectedLine, "general_id"))) continue;
            tableID = rowHandler.getField(selectedLine, "general_id");
            Entity entity = (Entity)rowHandler.getAllCreatedObjects().get(tableID);
            if (entity == null) continue;
            String diagramID = rowHandler.getField(selectedLine, "DIAGRAM_ID");
            for (VarFileLine diagramLine : diagramObjectPro) {
                String id;
                if (!diagramLine.getType().equalsIgnoreCase("DIAGRAM_OBJECT_PRO") || !diagramID.equalsIgnoreCase(id = rowHandler.getField(diagramLine, "general_id"))) continue;
                try {
                    TopView topView;
                    int left = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_LEFT"));
                    int top = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_TOP"));
                    int width = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_WIDTH"));
                    int height = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_HEIGHT"));
                    int color = Integer.parseInt(rowHandler.getField(diagramLine, "DIAGRAM_ENT_COLOR"));
                    width = this.minLeft < 0 ? width + this.minLeft * -1 - (left += this.minLeft * -1) : width - this.minLeft - (left -= this.minLeft);
                    if (this.maxTop > 0) {
                        top = this.maxTop - top;
                        height = this.maxTop - height - top;
                    } else {
                        top = top * -1 + this.maxTop;
                        height = height * -1 + this.maxTop - top;
                    }
                    if ((topView = entity.getTopView()) == null) continue block2;
                    if (topView.getCellView() != null) {
                        topView.getCellView().setNewBounds(new Rectangle((int)((double)left * this.scale + 20.0), (int)((double)top * this.scale + 20.0), (int)((double)width * this.scale), (int)((double)height * this.scale)));
                    } else {
                        topView.setBounds(new Rectangle((int)((double)left * this.scale + 20.0), (int)((double)top * this.scale + 20.0), (int)((double)width * this.scale), (int)((double)height * this.scale)));
                    }
                    RHPlacement.setColor(topView, color);
                }
                catch (NumberFormatException e) {
                    StringBuffer message = new StringBuffer("wrong Format in RHDiagram.replaceEntities: ");
                    message.append(diagramLine.getLine());
                    LOGGER.error(message.toString(), e);
                }
                continue block2;
            }
        }
    }

    private void rearrangePartnerships(List partnerships, List partnershipsDiagram, List diagramObjectPro, List anlextRteObj, int minLeft, int maxTop) {
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        Iterator it = partnerships.iterator();
        Integer posParId = new Integer(1);
        Integer posId = new Integer(2);
        while (it.hasNext()) {
            String diagramId;
            VarFileLine selectedLine = (VarFileLine)it.next();
            String relId = rowHandler.getField(selectedLine, "general_id");
            Relation rel = (Relation)rowHandler.getAllCreatedObjects().get(relId);
            if (rel.getTopView() == null) {
                rowHandler.getDesign().getLogicalDesign().getMainView().createViewFor(rel);
            }
            if ((diagramId = this.getIdFromList(partnershipsDiagram, relId, posParId, posId, rowHandler)) == null) continue;
            List points = this.getPartnershipPoints(diagramObjectPro, diagramId, anlextRteObj, minLeft, maxTop, rowHandler);
            this.addRelPoints(rel, points);
        }
    }

    private void addRelPoints(Relation rel, List points) {
        try {
            if (points.size() > 1) {
                TVRelation tvrel;
                if (points.size() > 2) {
                    TVRelation tvrel2 = (TVRelation)rel.getTopView();
                    if (tvrel2 != null) {
                        EdgeView edge = (EdgeView)tvrel2.getCellView();
                        for (int i = 1; i < points.size() - 1; ++i) {
                            Point p = (Point)points.get(i);
                            p.x = (int)((double)p.x * this.scale);
                            p.y = (int)((double)p.y * this.scale);
                            tvrel2.getEdgePoints().add(DiagramConstants.createPoint(p));
                        }
                        tvrel2.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel2.getEdgePoints());
                        edge.update();
                    }
                } else if (points.size() == 2 && (tvrel = (TVRelation)rel.getTopView()) != null) {
                    Point p1 = (Point)points.get(0);
                    Point p2 = (Point)points.get(1);
                    if (p1.x == p2.x) {
                        int y = (p1.y + p2.y) / 2;
                        tvrel.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)p1.x * this.scale), (int)((double)y * this.scale))));
                        EdgeView edge = (EdgeView)tvrel.getCellView();
                        tvrel.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel.getEdgePoints());
                        edge.update();
                    } else if (p1.y == p2.y) {
                        int x = (p1.x + p2.x) / 2;
                        tvrel.getEdgePoints().add(DiagramConstants.createPoint(new Point((int)((double)x * this.scale), (int)((double)p1.y * this.scale))));
                        EdgeView edge = (EdgeView)tvrel.getCellView();
                        tvrel.getDesignPartView().getWorkSpace().addPoints((DefaultEdge)edge.getCell(), tvrel.getEdgePoints());
                        edge.update();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List getPartnershipPoints(List lines, String diagramId, List anlextRteObj, int minLeft, int maxTop, RowHandler rowHandler) {
        ArrayList<Point> points = new ArrayList<Point>();
        Iterator it = lines.iterator();
        Integer idPos = new Integer(1);
        int numOfPointsPosition = 19;
        Integer pos = new Integer(numOfPointsPosition);
        while (it.hasNext()) {
            int numOfPoints;
            VarFileLine selectedLine = (VarFileLine)it.next();
            String line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramId.equalsIgnoreCase(id)) continue;
            int numOfPoints2 = numOfPoints = Integer.parseInt(rowHandler.getField(line, pos));
            if (numOfPoints > 1) {
                if (numOfPoints2 > 5) {
                    numOfPoints2 = 5;
                }
                for (int i = numOfPointsPosition; i < numOfPointsPosition + numOfPoints2 * 2; i += 2) {
                    String sleft = rowHandler.getField(line, new Integer(i + 1));
                    String stop = rowHandler.getField(line, new Integer(i + 2));
                    int left = Integer.parseInt(sleft);
                    int top = Integer.parseInt(stop);
                    left = minLeft < 0 ? 20 + left + minLeft * -1 : 20 + left - minLeft;
                    top = maxTop > 0 ? 20 + maxTop - top : 20 + top * -1 + maxTop;
                    points.add(new Point(left, top));
                }
            }
            if (numOfPoints == numOfPoints2) break;
            this.addPointsFromAnlextRteObj(points, diagramId, anlextRteObj, minLeft, maxTop, rowHandler);
            break;
        }
        return points;
    }

    private void addPointsFromAnlextRteObj(List points, String diagramOPROId, List anlextRteObj, int minLeft, int maxTop, RowHandler rowHandler) {
        String line;
        ArrayList<String> selLines = new ArrayList<String>();
        Iterator it = anlextRteObj.iterator();
        Integer idPos = new Integer(8);
        while (it.hasNext()) {
            VarFileLine selectedLine = (VarFileLine)it.next();
            line = selectedLine.getLine();
            String id = rowHandler.getField(line, idPos);
            if (!diagramOPROId.equalsIgnoreCase(id)) continue;
            selLines.add(line);
        }
        it = selLines.iterator();
        int startpos = 8;
        while (it.hasNext()) {
            line = (String)it.next();
            for (int i = startpos; i < startpos + 10; i += 2) {
                String sleft = rowHandler.getField(line, new Integer(i + 1));
                String stop = rowHandler.getField(line, new Integer(i + 2));
                if (sleft.equalsIgnoreCase("0") && stop.equalsIgnoreCase("0")) continue;
                int left = Integer.parseInt(sleft);
                int top = Integer.parseInt(stop);
                left = minLeft < 0 ? 20 + left + minLeft * -1 : 20 + left - minLeft;
                top = maxTop > 0 ? 20 + maxTop - top : 20 + top * -1 + maxTop;
                points.add(new Point(left, top));
            }
        }
    }

    private String getIdFromList(List lines, String parentId, Integer parentIdPosition, Integer idPosition, RowHandler rowHandler) {
        String id = null;
        for (VarFileLine selectedLine : lines) {
            String pId = rowHandler.getField(selectedLine.getLine(), parentIdPosition);
            if (!parentId.equalsIgnoreCase(pId)) continue;
            id = rowHandler.getField(selectedLine.getLine(), idPosition);
            return id;
        }
        return id;
    }

    private List getVFLinesSubset(List varFileLineList, int idPos, String idString) {
        ArrayList<VarFileLine> lines = new ArrayList<VarFileLine>();
        String id = null;
        Integer pos = new Integer(idPos);
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        for (VarFileLine selectedLine : varFileLineList) {
            id = rowHandler.getField(selectedLine.getLine(), pos);
            if (!idString.equalsIgnoreCase(id)) continue;
            lines.add(selectedLine);
        }
        return lines;
    }

    private VarFileLine getVarFileLine(List varFileLineList, int idPos, String idString) {
        String id = null;
        Integer pos = new Integer(idPos);
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        for (VarFileLine selectedLine : varFileLineList) {
            id = rowHandler.getField(selectedLine.getLine(), pos);
            if (!idString.equalsIgnoreCase(id)) continue;
            return selectedLine;
        }
        return null;
    }

    private void recreateMappingInfo(String mapExtDesignId, String designId, ChainBuilderJoint chainBuilderPhysical, RelationalDesign relDesign) {
        int MAP_EXT_DESIGN_ID_POS = 17;
        int OBJ_TYPE_TABLE = 2;
        int OBJ_TYPE_COLUMN = 3;
        int OBJ_TYPE_PRIMKEY = 6;
        int OBJ_TYPE_FORKEY = 8;
        TreeMap<String, ObjInfo> objectTypeMap = new TreeMap<String, ObjInfo>();
        Integer objTypePos = new Integer(10);
        Integer idFromNameTablePos = new Integer(18);
        Integer idInLogDesPos = new Integer(9);
        Integer idInPhysSysMapPos_BT = new Integer(13);
        Integer idHelpObjInPhysSysMapPos_BT = new Integer(15);
        Integer ONE = new Integer(1);
        Integer dbaObjIdPosTable = new Integer(19);
        Integer dbaObjIdPosPK = new Integer(21);
        Integer dbaObjIdPosFK = new Integer(21);
        Integer dbaObjIdPosColumn = new Integer(20);
        Integer objNamePos = new Integer(9);
        int[] objTypes = new int[]{2, 3, 6, 8};
        RowHandler rowHandler = this.chainBuilderLogical.getChain();
        List logSysMap = this.chainBuilderLogical.getSpecificRowHandler(RHMapSystemMap.class).getOwnLines();
        List logNameMap = this.chainBuilderLogical.getSpecificRowHandler(RHMapNameTable.class).getOwnLines();
        List physSysMap = chainBuilderPhysical.getSpecificRowHandler(RHMapSysMap.class).getOwnLines();
        logSysMap = this.getVFLinesSubset(logSysMap, 17, mapExtDesignId);
        for (VarFileLine selectedLine : logNameMap) {
            String objType = rowHandler.getField(selectedLine.getLine(), objTypePos);
            String objName = rowHandler.getField(selectedLine.getLine(), objNamePos);
            if (objType == null) continue;
            ObjInfo objInfo = new ObjInfo(objType, objName);
            objectTypeMap.put(rowHandler.getField(selectedLine.getLine(), ONE), objInfo);
        }
        VarFileLine[] vfLines = logSysMap.toArray(new VarFileLine[0]);
        for (int j = 0; j < objTypes.length; ++j) {
            int objtype = objTypes[j];
            block8: for (int i = 0; i < vfLines.length; ++i) {
                int type;
                VarFileLine selectedLine = vfLines[i];
                String idFromNameTable = rowHandler.getField(selectedLine.getLine(), idFromNameTablePos);
                ObjInfo objInfo = (ObjInfo)objectTypeMap.get(idFromNameTable);
                if (objInfo == null || objInfo.getType() == null || (type = Integer.parseInt(objInfo.getType())) != objtype) continue;
                String logId = rowHandler.getField(selectedLine.getLine(), idInLogDesPos);
                String physSysMapId_BT = rowHandler.getField(selectedLine.getLine(), idInPhysSysMapPos_BT);
                VarFileLine idLine = this.getVarFileLine(physSysMap, 25, physSysMapId_BT);
                if (idLine == null) continue;
                switch (type) {
                    case 2: {
                        String dbaObjId = rowHandler.getField(idLine.getLine(), dbaObjIdPosTable);
                        this.mapTable(logId, dbaObjId);
                        continue block8;
                    }
                    case 3: {
                        String dbaObjId = rowHandler.getField(idLine.getLine(), dbaObjIdPosColumn);
                        this.mapColumn(logId, dbaObjId);
                        continue block8;
                    }
                    case 6: {
                        String dbaObjId = rowHandler.getField(idLine.getLine(), dbaObjIdPosPK);
                        this.mapPK(logId, dbaObjId);
                        continue block8;
                    }
                    case 8: {
                        String dbaObjId = rowHandler.getField(idLine.getLine(), dbaObjIdPosFK);
                        String partnershipId = rowHandler.getField(selectedLine.getLine(), idHelpObjInPhysSysMapPos_BT);
                        this.mapFK(partnershipId, dbaObjId, objInfo.getName());
                        continue block8;
                    }
                }
            }
        }
        this.mapFK_To_Inheritance();
        this.processFKColumnsMapping();
        this.mapDependentAttributes(relDesign);
        this.resetEngineerStatus(relDesign);
    }

    private void mapTable(String logId, String dbaObjId) {
        Object obj = this.allCreatedObjectsLogical.get(logId);
        Table tab = (Table)this.allCreatedObjectsPhysical.get(dbaObjId);
        if (obj instanceof Entity) {
            Entity ent = (Entity)this.allCreatedObjectsLogical.get(logId);
            if (tab != null && ent != null) {
                XtdMapping mapping = this.design.getExtendedMap().createMapping(ent, tab);
                mapping.setInheritanceType(3);
                tab.setGeneratorID(ent.getObjectID());
            }
        } else if (obj != null && obj instanceof Relation && tab != null) {
            Relation rel = (Relation)obj;
            XtdMapping mapping = this.design.getExtendedMap().getMapping(rel, tab);
            if (mapping == null) {
                this.design.getExtendedMap().createMapping(rel, tab);
                tab.setGeneratorID(rel.getObjectID());
            }
        }
    }

    private void mapColumn(String logId, String dbaObjId) {
        Attribute att = (Attribute)this.allCreatedObjectsLogical.get(logId);
        Column col = (Column)this.allCreatedObjectsPhysical.get(dbaObjId);
        if (att != null && col != null) {
            Table table = (Table)col.getContainerWithKeyObject();
            Entity entity = (Entity)att.getContainerWithKeyObject();
            if (col.isFKColumn()) {
                FKCol fc = new FKCol();
                fc.attribute = att;
                fc.column = col;
                this.fkColList.add(fc);
            } else {
                boolean hasMapping = table.hasMappingWithEntity(entity);
                if (hasMapping) {
                    this.design.getExtendedMap().createMapping(att, col);
                    col.setGeneratorID(att.getObjectID());
                } else {
                    Attribute attribute;
                    Entity ent = table.getEngEntity();
                    if (ent != null && ent != entity && (attribute = ent.getFKAttributeForOriginating(att)) != null) {
                        this.design.getExtendedMap().createMapping(attribute, col);
                        col.setGeneratorID(att.getObjectID());
                    }
                }
            }
        }
    }

    private void processFKColumnsMapping() {
        for (FKCol fc : this.fkColList) {
            Column col = fc.column;
            Attribute attr = fc.attribute;
            Table table = (Table)col.getContainerWithKeyObject();
            for (FK_And_Delegate_Holder fkh : col.getAllDelegatesAndFK()) {
                Column delc = (Column)fkh.delegateColumn;
                FKIndexAssociation fk = fkh.fk;
                if (delc == null || fk == null) continue;
                Attribute delegattrib = delc.getEngAttribute();
                Relation rel = fk.getEngRelation();
                Entity ent = table.getEngEntity();
                Attribute attrib = null;
                if (ent != null && rel != null && !(rel instanceof InheritanceRelation)) {
                    attrib = ent.getFKAttributeForOriginating(attr, rel);
                } else if (fk.getEngInheritanceRelation() != null) {
                    FKElement orig = col.getOriginatingColumn();
                    if (orig != null) {
                        attrib = orig.getEngAttribute();
                    }
                } else if (ent != null) {
                    attrib = ent.getFKAttributeForOriginating(attr);
                }
                if (attrib == null) {
                    if (delegattrib != null && rel != null) {
                        if (ent != null) {
                            attrib = ent.getAttributeForDelegate(delegattrib, rel);
                        }
                    } else if (delegattrib != null && ent != null) {
                        attrib = ent.getAttributeForDelegate(delegattrib);
                    }
                }
                if (attrib == null) continue;
                XtdMapping mapping = this.design.getExtendedMap().createMapping(attrib, col);
                if (rel != null && rel instanceof InheritanceRelation || fk.getEngInheritanceRelation() != null) {
                    mapping.setInheritanceType(5);
                }
                col.setGeneratorID(attrib.getObjectID());
            }
        }
    }

    private void mapDependentAttributes(RelationalDesign phdes) {
        LogicalDesign ldes = phdes.getDesign().getLogicalDesign();
        ExtendedMap xmap = phdes.getDesign().getExtendedMap();
        String relID = phdes.getObjectID();
        Iterator it = ldes.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            KeyObject key = ent.getPK();
            if (key == null) continue;
            for (Attribute attr : key.getElementsCollection()) {
                List list;
                if (attr.isFKElement() || (list = xmap.getMappingsForDesignPart(attr, relID)).size() <= 0) continue;
                this.mapDependentAttributes(attr, list, xmap, relID);
            }
        }
    }

    private void mapDependentAttributes(Attribute attr, List mappings, ExtendedMap xmap, String relDesID) {
        Iterator it = attr.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            Attribute da = (Attribute)it.next();
            if (da == attr || !da.isFKElement() || da.getDelegate() != attr) continue;
            List list = xmap.getMappingsForDesignPart(da, relDesID);
            if (list.size() == 0) {
                for (XtdMapping mapping : mappings) {
                    DesignObject dobj = mapping.getTargetObject();
                    if (dobj != null && dobj instanceof Column) {
                        xmap.createMapping(da, dobj);
                        continue;
                    }
                    dobj = mapping.getOwnerObject();
                    if (dobj == null || !(dobj instanceof Column)) continue;
                    xmap.createMapping(da, dobj);
                }
            }
            this.mapDependentAttributes(da, mappings, xmap, relDesID);
        }
    }

    private void resetEngineerStatus(RelationalDesign phdes) {
        DesignObject dobj;
        LogicalDesign ldes = phdes.getDesign().getLogicalDesign();
        ExtendedMap xmap = phdes.getDesign().getExtendedMap();
        String relID = phdes.getObjectID();
        Iterator it = ldes.getEntitySet().iterator();
        while (it.hasNext()) {
            Entity ent = (Entity)it.next();
            if (this.resetStatus(ent, relID, xmap)) continue;
            for (DesignObject dobj2 : ent.getElementsCollection()) {
                this.resetStatus(dobj2, relID, xmap);
            }
            Iterator ite = ent.getKeySet().iterator();
            while (ite.hasNext()) {
                DesignObject dobj2;
                dobj2 = (DesignObject)ite.next();
                this.resetStatus(dobj2, relID, xmap);
            }
        }
        it = ldes.getRelationSet().iterator();
        while (it.hasNext()) {
            Relation rel = (Relation)it.next();
            this.resetStatus(rel, relID, xmap);
        }
        String logID = ldes.getObjectID();
        it = phdes.getTableSet().iterator();
        while (it.hasNext()) {
            Table tab = (Table)it.next();
            if (this.resetStatus(tab, logID, xmap)) continue;
            for (DesignObject dobj3 : tab.getElementsCollection()) {
                this.resetStatus(dobj3, logID, xmap);
            }
            Iterator ite = tab.getKeySet().iterator();
            while (ite.hasNext()) {
                DesignObject dobj3;
                dobj3 = (Index)ite.next();
                if (((KeyObject)dobj3).isFK() || !((Index)dobj3).isPK() && !((KeyObject)dobj3).isUnique()) continue;
                this.resetStatus(dobj3, logID, xmap);
            }
        }
        it = phdes.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            dobj = (DesignObject)it.next();
            this.resetStatus(dobj, relID, xmap);
        }
        it = phdes.getTableViewSet().iterator();
        while (it.hasNext()) {
            dobj = (DesignObject)it.next();
            this.resetStatus(dobj, relID, xmap);
        }
    }

    private boolean resetStatus(DesignObject dobj, String desPartID, ExtendedMap xmap) {
        List list = xmap.getMappingsForDesignPart(dobj, desPartID);
        if (list.size() == 0) {
            dobj.setShouldEngineer(false);
            return true;
        }
        return false;
    }

    private MapFKAss getTempMapForFK(FKIndexAssociation fk) {
        for (MapFKAss mp : this.fkMapList) {
            if (mp.fk != fk) continue;
            return mp;
        }
        return null;
    }

    private void mapPK(String logId, String dbaObjId) {
        CandidateKey key = (CandidateKey)this.allCreatedObjectsLogical.get(logId);
        Index ind = (Index)this.allCreatedObjectsPhysical.get(dbaObjId);
        if (key != null && ind != null) {
            if (ind.isPK() && key.isPK()) {
                this.design.getExtendedMap().createMapping(key, ind);
                ind.setGeneratorID(key.getObjectID());
            } else if (!ind.isPK() && !key.isPK()) {
                this.design.getExtendedMap().createMapping(key, ind);
                ind.setGeneratorID(key.getObjectID());
            }
        }
    }

    private void mapFK(String partnershipId, String dbaObjId, String partnershipName) {
        ExtendedMap xmap = this.design.getExtendedMap();
        Object obj = this.allCreatedObjectsLogical.get(partnershipId);
        FKIndexAssociation fkass = (FKIndexAssociation)this.allCreatedObjectsPhysical.get(dbaObjId);
        if (obj instanceof Relation) {
            Relation rel = (Relation)obj;
            if (fkass != null && rel != null) {
                xmap.createMapping(rel, fkass);
                fkass.setGeneratorID(rel.getObjectID());
                if (partnershipName != null && !"".equalsIgnoreCase(partnershipName)) {
                    rel.setName(partnershipName);
                }
            }
        } else if (obj instanceof Entity) {
            MapFKAss mp = this.getTempMapForFK(fkass);
            if (mp == null) {
                mp = new MapFKAss();
                mp.fk = fkass;
                mp.ent1 = (Entity)obj;
                this.fkMapList.add(mp);
            } else {
                mp.ent2 = (Entity)obj;
            }
        }
    }

    private void mapFK_To_Inheritance() {
        for (MapFKAss mp : this.fkMapList) {
            InheritanceRelation inh;
            if (mp.ent2 == null || (inh = ((InheritanceRelationSet)this.design.getLogicalDesign().getInheritanceRelationSet()).getInheritanceRelationFor(mp.ent1, mp.ent2)) == null) continue;
            XtdMapping mapping = this.design.getExtendedMap().createMapping(inh, mp.fk);
            mapping.setInheritanceType(4);
        }
    }

    private class MapFKAss {
        FKIndexAssociation fk;
        Entity ent1;
        Entity ent2;

        private MapFKAss() {
        }
    }

    private class FKCol {
        Column column;
        Attribute attribute;

        private FKCol() {
        }
    }

    class ObjInfo {
        private String type;
        private String name;

        public ObjInfo(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }

    class Holder {
        Map map;
        ContainerObject container;

        Holder() {
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeLog.log("Start");
            try {
                ParserMultiMappedVars.this.design.closeAllDiagrams();
                ParserMultiMappedVars.this.design.setDisableTreeUpdate(true);
                ImportLogger importLog = new ImportLogger();
                try {
                    ParserMultiMappedVars.this.design.setPropagatePKChahges(false);
                    ParserMultiMappedVars.this.monitor = new ProgressDialog(ParserMultiMappedVars.this.view, "", 0, 100);
                    try {
                        ParserMultiMappedVars.this.view.setImporting(true);
                        try {
                            ParserMultiMappedVars.this.parse();
                            ParserMultiMappedVars.this.design.setPropagatePKChahges(true);
                            if (ParserMultiMappedVars.this.matched) {
                                ParserMultiMappedVars.this.monitor.setProgress(100);
                                ParserMultiMappedVars.this.view.getCurrentDesign().setDesignPath("");
                                ParserMultiMappedVars.this.view.synchronizeTitle();
                            }
                        }
                        finally {
                            ParserMultiMappedVars.this.view.setImporting(false);
                        }
                    }
                    finally {
                        ParserMultiMappedVars.this.monitor.close();
                    }
                }
                finally {
                    ApplicationView.loading = false;
                    ParserMultiMappedVars.this.design.getLogicalDesign().setMainViewVisible(true);
                    ParserMultiMappedVars.this.design.showAllRelationalDesigns();
                    ParserMultiMappedVars.this.view.centerDesign();
                    ParserMultiMappedVars.this.design.setDisableTreeUpdate(false);
                    ParserMultiMappedVars.this.view.clearTree();
                    ParserMultiMappedVars.this.resetDirty(ParserMultiMappedVars.this.design);
                    ParserMultiMappedVars.this.design.getDataTypesDesign().setDirty(false);
                }
                if (ParserMultiMappedVars.this.view.getSettings().showImportLog()) {
                    LogReport logPanel = new LogReport(ParserMultiMappedVars.this.view);
                    logPanel.setLog(importLog.generateVARReport(ParserMultiMappedVars.this.view));
                    logPanel.showDialog(new Dimension(750, 550));
                }
            }
            catch (Exception e) {
                ParserMultiMappedVars.this.design.destroyAll(false);
                ParserMultiMappedVars.this.design.destroyAll(true);
                ParserMultiMappedVars.this.design = null;
                LOGGER.error("Error Parsing File: " + ParserMultiMappedVars.this.designName, e);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("ParserMultiMappedVars.UnableIimportFile"), Messages.getString("ParserMultiMappedVars.ErrorImportingFile"), 0);
            }
            TimeLog.log("End");
        }
    }
}

