/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.MappingBachmannPhysicalDatatype;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.SectionConstants;
import oracle.dbtools.crest.imports.var.ConstantsForDomainCreation;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.LogicalDataTypesVersusBachman;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFactory;
import oracle.dbtools.crest.model.design.LogicalDataTypeStrings;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class DomainHandlerVarConversie
extends RowHandler
implements ConstantsForDomainCreation,
LogicalDataTypeStrings,
SectionConstants {
    private DomainFactory factory = new DomainFactory();
    private LogicalDatatypeFactory factoryLogicalDatatype = new LogicalDatatypeFactory();
    private Map avtMap = new TreeMap();
    private List notes = new ArrayList();
    private static final Logger LOGGER = new Logger(DomainHandlerVarConversie.class);

    public DomainHandlerVarConversie(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    public void createDomains(List listLines, List domainLines, StatusBarOwner statusBarOwner) {
        this.createDomains(listLines, domainLines);
    }

    private void collectAVTandNotes(List allLines) {
        this.avtMap.clear();
        this.notes.clear();
        for (int i = allLines.size() - 1; i >= 0; --i) {
            VarFileLine selectedLine = (VarFileLine)allLines.get(i);
            if (selectedLine.getType().equalsIgnoreCase("ALLOWED_VAL_TBL")) {
                String lineID = this.getField(selectedLine, "general_id");
                Iterator av = allLines.iterator();
                while (av.hasNext()) {
                    VarFileLine commentLine;
                    String valueID;
                    String comment = "";
                    String avtStart = "";
                    String avtEnd = "";
                    VarFileLine avLine = (VarFileLine)av.next();
                    if (!avLine.getType().equalsIgnoreCase("ALLOWABLE_VALUE") || !lineID.equalsIgnoreCase(valueID = this.getField(avLine, "AVT_ID"))) continue;
                    String textID = this.getField(avLine, "AVT_TEXT_ID_2");
                    if (!"0".equalsIgnoreCase(textID) && (commentLine = this.getCommentLine(textID, "ANLTEXT", allLines)) != null) {
                        comment = this.getField(commentLine, "TEXT_COMMENT_2");
                    }
                    avtStart = this.getField(avLine, "AVT_START_VALUE");
                    avtEnd = this.getField(avLine, "AVT_END_VALUE");
                    if ("".equalsIgnoreCase(avtStart) && "".equalsIgnoreCase(avtEnd) && "".equalsIgnoreCase(comment)) continue;
                    AVTObj avtObj = new AVTObj(comment, avtStart, avtEnd);
                    ArrayList<AVTObj> list = (ArrayList<AVTObj>)this.avtMap.get(lineID);
                    if (list == null) {
                        list = new ArrayList<AVTObj>();
                        this.avtMap.put(lineID, list);
                    }
                    list.add(avtObj);
                }
                allLines.remove(i);
                continue;
            }
            if (!selectedLine.getType().equalsIgnoreCase("NOTES")) continue;
            this.notes.add(selectedLine);
            allLines.remove(i);
        }
    }

    public void createDomains(List listLines, List domainLines) {
        this.collectAVTandNotes(domainLines);
        for (int i = 0; i < listLines.size(); ++i) {
            VarFileLine line = (VarFileLine)listLines.get(i);
            if (line.getType().equalsIgnoreCase("DOMAINS")) {
                String nameDataTypeShort = this.getField(line, "DOMAIN_DATATYPE");
                String nameDataType = LogicalDataTypesVersusBachman.getNameLogDataTypeFromBachName(nameDataTypeShort);
                LogicalDatatype logDT = this.factoryLogicalDatatype.searchLogicalDatatype(this.getDesign(), nameDataType);
                String[] parameters = this.fillParametersDomains(line, nameDataType);
                String domainName = this.getField(line, "DOMAIN_NAME");
                Domain domain = this.factory.getInstance(this.getDesign(), logDT, null, 1, parameters, domainName);
                domain.setComment(this.getComment(line, domainLines));
                domain.setNotes(this.getNotes(line, domainLines));
                domain.setSynonym(this.getSynonym(line, domainLines));
                this.setAVT(line, domain);
                domain.setDimension(this.getDimension(line, domainLines));
                continue;
            }
            try {
                int type = Integer.parseInt(this.getField(line, "COLUMN_TYPE"));
                String namePhysDT = MappingBachmannPhysicalDatatype.getNamePhysicalDatatype(type);
                String nameDatatype = StandardDatatypeNames.getUsedDatatypeName(namePhysDT);
                LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(StorageDesignDB2v70.RDBMS_TYPE, nameDatatype);
                String[] parameters = new String[3];
                String scale = this.getField(line, "COLUMN_SCALE");
                if (scale.equalsIgnoreCase("0")) {
                    if (nameDatatype.equals("real") || nameDatatype.equals("NUMERIC") || nameDatatype.equals("DECIMAL")) {
                        parameters[2] = scale;
                        parameters[1] = scale;
                        parameters[0] = this.getField(line, "COLUMN_LENGTH");
                    } else {
                        parameters[2] = this.getField(line, "COLUMN_LENGTH");
                        parameters[1] = scale;
                        parameters[0] = scale;
                    }
                } else {
                    parameters[2] = "0";
                    parameters[1] = scale;
                    parameters[0] = this.getField(line, "COLUMN_LENGTH");
                }
                this.factory.getInstance(this.getDesign(), logicalDT, null, 0, parameters, null);
                continue;
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format in DomainHandlerVarConversie.createDomains : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
            }
        }
    }

    private String[] fillParametersDomains(VarFileLine line, String nameDataType) {
        String[] parameters = new String[3];
        if (nameDataType.equals("alphabetic") || nameDataType.equals("long alphabetic") || nameDataType.equals("alphanumeric") || nameDataType.equals("long alphanumeric") || nameDataType.equals("mixed") || nameDataType.equals("doublebyte") || nameDataType.equals("VARCHAR") || nameDataType.equals("CHAR") || nameDataType.equals("GRAPHIC") || nameDataType.equals("VARGRAPHIC")) {
            parameters[2] = this.getField(line, "DOMAIN_MAXLEN");
        } else if (nameDataType.equals("real") || nameDataType.equals("NUMERIC") || nameDataType.equals("DECIMAL")) {
            parameters[1] = this.getField(line, "DOMAIN_SCALE");
            parameters[0] = this.getField(line, "DOMAIN_PRECISION");
        }
        return parameters;
    }

    private String getComment(VarFileLine line, List domainLines) {
        String comment = null;
        String textID = this.getField(line, "DOMAIN_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT", domainLines);
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getNotes(VarFileLine line, List domainLines) {
        StringBuffer comment = new StringBuffer("");
        String id = this.getField(line, "general_id");
        ArrayList<VarFileLine> forDelete = new ArrayList<VarFileLine>();
        for (VarFileLine selectedLine : this.notes) {
            VarFileLine commentLine;
            String domainID = this.getField(selectedLine, "NOTE_DOMAIN_ID");
            if (!id.equalsIgnoreCase(domainID)) continue;
            String textID = this.getField(selectedLine, "note_text_id");
            if (!"0".equalsIgnoreCase(textID) && (commentLine = this.getCommentLine(textID, "ANLTEXT", domainLines)) != null) {
                if (comment.length() > 0) {
                    comment.append("\n");
                }
                comment.append(this.getField(commentLine, "TEXT_COMMENT_2"));
            }
            forDelete.add(selectedLine);
        }
        this.notes.removeAll(forDelete);
        return comment.toString();
    }

    private String getSynonym(VarFileLine line, List domainLines) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : domainLines) {
            VarFileLine synonymLine;
            String synID;
            String lineID;
            if (!selectedLine.getType().equalsIgnoreCase("DOMAINSSYNONYM_OBJ") || !id.equalsIgnoreCase(lineID = this.getField(selectedLine, "general_id")) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT", domainLines)) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }

    private void setAVT(VarFileLine line, Domain domain) {
        List list;
        String avtID = this.getField(line, "DOMAIN_ALLOWED_VAL_TBL");
        if (!"0".equalsIgnoreCase(avtID) && (list = (List)this.avtMap.get(avtID)) != null) {
            for (AVTObj avtObj : list) {
                if (avtObj == null) continue;
                AVT avt = new AVT(avtObj.getAvtStart(), avtObj.getAvtEnd(), avtObj.getComment());
                domain.addAVT(avt);
            }
        }
    }

    private String getDimension(VarFileLine line, List domainLines) {
        VarFileLine dimensionLine;
        String dimension = "";
        String dimensionID = this.getField(line, "DOMAIN_DIMENSION");
        if (!"0".equalsIgnoreCase(dimensionID) && (dimensionLine = this.getCommentLine(dimensionID, "DIMENSION", domainLines)) != null) {
            dimension = this.getField(dimensionLine, "DIMENSION_NAME");
        }
        return dimension;
    }

    class AVTObj {
        private String comment = "";
        private String avtStart = "";
        private String avtEnd = "";

        public AVTObj(String comment, String avtStart, String avtEnd) {
            this.comment = comment;
            this.avtStart = avtStart;
            this.avtEnd = avtEnd;
        }

        public String getAvtEnd() {
            return this.avtEnd;
        }

        public String getAvtStart() {
            return this.avtStart;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

