/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODLogicalDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODLogicalDiagram.class);
    PreparedStatement ent_statement;

    public ODLogicalDiagram(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        this.ent_statement = null;
        for (ODObject odNext : this.getExtractionHandler().getSelectedAppSystems()) {
            String query;
            ODExtractionHandler.Branch branch = odNext.branch;
            if (branch == null) {
                if (statement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'ERD' order by name";
                    statement = sqlConnection.prepareStatement(query);
                }
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
            } else {
                if (statement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'ERD' ";
                    StringBuffer buffer = new StringBuffer(query);
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
            }
            ResultSet rs = null;
            try {
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODLogicalDiagram.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                String diagramName = rs.getString("NAME");
                String diagramID = rs.getString("ID");
                String ivid = rs.getString("ivid");
                boolean isNew = false;
                DesignPartView dpv = this.getDesign().getLogicalDesign().getSubViewByID(diagramID);
                if (dpv == null) {
                    dpv = this.getDesign().getLogicalDesign().getSubViewByName(diagramName);
                }
                if (dpv == null) {
                    dpv = this.getDesign().getLogicalDesign().createDesignPartSubView();
                    isNew = true;
                    dpv.setDPVId(diagramID);
                }
                dpv.setName(diagramName);
                dpv.setMustBeVisible(false);
                if (!this.addEntitiesToDiagram(sqlConnection, dpv, diagramID, ivid) && isNew) {
                    this.getDesign().getLogicalDesign().deleteSubview(dpv);
                    continue;
                }
                this.setNotesAndComments(sqlConnection, dpv.getPlaceHolder(), diagramID, odNext.ivid);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.ent_statement != null) {
            this.ent_statement.close();
        }
    }

    private boolean addEntitiesToDiagram(Connection sqlConnection, DesignPartView dpv, String diagramID, String ivid) throws Exception {
        boolean result = false;
        if (this.ent_statement == null) {
            String query = "SELECT CIELEMENT_REFERENCE id from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and ELEMENT_TYPE_FOR ='ENT' and d.PARENT_IVID = ? ";
            this.ent_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.ent_statement.setString(1, diagramID);
            this.ent_statement.setString(2, ivid);
            rs = this.ent_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODLogicalDiagram.addEntitiesToDiagram(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String entityID = rs.getString("ID");
                Entity entity = (Entity)this.getExtractionHandler().getImportedObject(entityID);
                if (entity == null) continue;
                result = true;
                ContainerView tv = (ContainerView)entity.getFirstViewForDPV(dpv);
                if (tv == null) {
                    tv = entity.getTopView().createViewSynonim(dpv);
                }
                ((TVEntity)tv).addTVRelations();
                tv.addTVTypeSubstitutions();
            }
            rs.close();
        }
        return result;
    }
}

