/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.datatypes.DPVDataTypesSubView;
import oracle.dbtools.crest.swingui.datatypes.TVStructuredType;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODDataTypeDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODDataTypeDiagram.class);
    PreparedStatement st_statement;

    public ODDataTypeDiagram(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        PreparedStatement nvstatement = null;
        Statement statement = null;
        this.st_statement = null;
        for (ODObject odNext : this.getExtractionHandler().getSelectedAppSystems()) {
            String query;
            ODExtractionHandler.Branch branch = odNext.branch;
            ResultSet rs = null;
            if (branch == null) {
                if (nvstatement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b, i$sdd_object_versions v where d.ID = b.member_object and b.folder_reference = ?  and DIAGRAM_TYPE = 'DSD' and b.parent_ivid = ?  and d.ivid = v.ivid and v.wastebasket = 'N' and v.state in ('I','N') and not exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) and exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('OOT') and rownum<2 ) order by name";
                    nvstatement = sqlConnection.prepareStatement(query);
                }
                nvstatement.setString(1, odNext.getIrid());
                nvstatement.setString(2, odNext.ivid);
                rs = nvstatement.executeQuery();
            } else {
                if (statement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ?  and DIAGRAM_TYPE = 'DSD' and not exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) and exists ( select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('OOT') and rownum<2 ) ";
                    StringBuffer buffer = new StringBuffer(query);
                    buffer.append("  and d.ivid = ");
                    buffer.append("(select ivid from i$sdd_object_versions v ");
                    buffer.append("  where ");
                    buffer.append("  v.irid = d.irid");
                    buffer.append("  and branch_id = ? ");
                    buffer.append("  and sequence_in_branch  is not null ");
                    buffer.append("  and wastebasket='N' ");
                    buffer.append("  and sequence_in_branch = ");
                    buffer.append("   ( ");
                    buffer.append("   select max(sequence_in_branch) from i$sdd_object_versions v2 ");
                    buffer.append("     where ");
                    buffer.append("     v2.irid = d.irid");
                    buffer.append("     and branch_id = ? ");
                    buffer.append("     and sequence_in_branch  is not null ");
                    buffer.append("     and wastebasket='N' ");
                    buffer.append("   ) )");
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                if (branch != null) {
                    statement.setString(3, branch.getId());
                    statement.setString(4, branch.getId());
                }
                rs = statement.executeQuery();
            }
            if (rs == null) continue;
            while (rs.next()) {
                String diagramName = rs.getString("NAME");
                String diagramID = rs.getString("ID");
                String ivid = rs.getString("ivid");
                DesignPartView dpv = this.getDesign().getDataTypesDesign().getSubViewByID(diagramID);
                if (dpv == null) {
                    dpv = this.getDesign().getDataTypesDesign().createDesignPartSubView();
                    dpv.setDPVId(diagramID);
                }
                dpv.setName(diagramName);
                dpv.setMustBeVisible(false);
                if (!this.addStructuredTypesToDiagram(sqlConnection, dpv, diagramID, ivid)) {
                    this.getDesign().getDataTypesDesign().deleteSubview(dpv);
                    continue;
                }
                this.setNotesAndComments(sqlConnection, dpv.getPlaceHolder(), diagramID, odNext.ivid);
                ((DPVDataTypesSubView)dpv).rearrangeDiagram();
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.st_statement != null) {
            this.st_statement.close();
        }
    }

    private boolean addStructuredTypesToDiagram(Connection sqlConnection, DesignPartView dpv, String diagramID, String ivid) throws Exception {
        boolean result = false;
        if (this.st_statement == null) {
            String query = "SELECT CIELEMENT_REFERENCE ID from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and d.parent_ivid = ?  and ELEMENT_TYPE_FOR = 'OOT'";
            this.st_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.st_statement.setString(1, diagramID);
            this.st_statement.setString(2, ivid);
            rs = this.st_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODDataTypeDiagram.addStructuredTypesToDiagram(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                String stID = rs.getString("ID");
                StructuredType st = (StructuredType)this.getExtractionHandler().getImportedObject(stID);
                if (st == null) continue;
                result = true;
                ContainerView tv = st.getTopView().createViewSynonim(dpv);
                ((TVStructuredType)tv).addTVRelations();
                ((TVStructuredType)tv).addTVInheritances();
            }
            rs.close();
        }
        return result;
    }
}

