/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb.v81;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.MOHForeignKey;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.FKProxyUDBv81;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHForeignKeyUDBv81
extends MOHForeignKey {
    private static final Logger LOGGER = new Logger(MOHForeignKeyUDBv81.class);

    public MOHForeignKeyUDBv81(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        StorageDesign storageDesign = this.getStorageDesign();
        Iterator it = storageDesign.getTableProxySet().iterator();
        TableProxyUDB tableProxy = null;
        SchemaUDB schema = null;
        while (it.hasNext()) {
            tableProxy = (TableProxyUDB)it.next();
            schema = tableProxy.getSchema();
            if (schema == null) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("select  r.constname,r.refkeyname,r.reftabschema, ");
                buffer.append("r.reftabname,r.colcount,r.deleterule, ");
                buffer.append("r.updaterule,r.fk_colnames,r.pk_colnames, ");
                buffer.append(" t.enforced, t.enablequeryopt ");
                buffer.append("from ");
                buffer.append("syscat.references r, syscat.TABCONST t ");
                buffer.append("WHERE r.tabschema  = '");
                buffer.append(schema.getName().trim()).append("'");
                buffer.append(" AND r.tabname  = '");
                buffer.append(tableProxy.getName()).append("'");
                buffer.append(" AND  r.tabschema = t.tabschema ");
                buffer.append("AND r.tabname = t.tabname ");
                buffer.append("AND r.constname = t.constname  ");
                buffer.append("AND t.type = 'F' ");
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHForeignKeyUDBv81.generate():", e);
            }
            if (rs != null) {
                while (rs.next()) {
                    RelationalDesign rd;
                    String fkName = rs.getString(1).trim();
                    String refKeyName = rs.getString(2).trim();
                    String reftabschema = rs.getString(3).trim();
                    String reftabname = rs.getString(4).trim();
                    String deleteRule = rs.getString(6);
                    String updateRule = rs.getString(7);
                    String enforced = rs.getString(10);
                    String enablequeryopt = rs.getString(11);
                    Table table = (Table)tableProxy.getObject();
                    Table refTable = this.getRelationalDesign().getTableSet().getBySchemaAndName(reftabschema, reftabname);
                    if (refTable == null && table != null && (rd = ((RelationalDesign)table.getDesignPart()).getRelatedSyncModel()) != null) {
                        refTable = rd.getTableSet().getBySchemaAndName(reftabschema, reftabname);
                    }
                    if (table == null || refTable == null) continue;
                    Index index = null;
                    FKProxyUDBv81 fkproxy = null;
                    if (storageDesign == null || !(storageDesign instanceof StorageDesignUDB)) continue;
                    StorageDesignUDB storage = (StorageDesignUDB)storageDesign;
                    index = (Index)refTable.getKeySet().getByName(refKeyName);
                    if (index == null) continue;
                    FKIndexAssociation fk = table.addFK(index);
                    if (fkName != null) {
                        fk.setName(fkName);
                        fk.getLocalFKIndex().setName(fkName);
                        this.stampModelObject((ModelObject)fk, table.getSchema(), fkName);
                        if ("R".equalsIgnoreCase(deleteRule)) {
                            fk.setDeleteRule("NO ACTION");
                        } else if ("C".equalsIgnoreCase(deleteRule)) {
                            fk.setDeleteRule("CASCADE");
                        }
                    }
                    this.initFKColumns(sqlConnection, fk, index, reftabschema, tableProxy.getName());
                    fk.resetMandatoryUsingColumns();
                    fkproxy = (FKProxyUDBv81)storage.getFKProxySet().getObjectGeneratedBy(fk);
                    if (fkproxy == null) {
                        fkproxy = (FKProxyUDBv81)storage.getFKProxySet().getByName(fk.getName());
                    }
                    if (fkproxy == null) continue;
                    if ("R".equalsIgnoreCase(deleteRule)) {
                        fkproxy.setOnDelete(FKProxyUDB.getOnDeleteChoices()[1]);
                    } else if ("C".equalsIgnoreCase(deleteRule)) {
                        fkproxy.setOnDelete(FKProxyUDB.getOnDeleteChoices()[2]);
                    } else if ("N".equalsIgnoreCase(deleteRule)) {
                        fkproxy.setOnDelete(FKProxyUDB.getOnDeleteChoices()[3]);
                    }
                    if ("R".equalsIgnoreCase(updateRule)) {
                        fkproxy.setOnUpdate(FKProxyUDB.getOnUpdateChoices()[1]);
                    }
                    if ("N".equalsIgnoreCase(enforced)) {
                        fkproxy.setValidation("NOT ENFORCED");
                    }
                    if (!"N".equalsIgnoreCase(enablequeryopt)) continue;
                    fkproxy.setQueryOptimization("DISABLE");
                }
                rs.close();
            }
            statement.close();
        }
    }

    private void initFKColumns(Connection sqlConnection, FKIndexAssociation fk, Index index, String owner, String tableName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT COLNAME, COLSEQ ");
            buffer.append("from syscat.keycoluse ");
            buffer.append("WHERE tabschema  = '");
            buffer.append(owner).append("'");
            buffer.append(" AND tabname = '");
            buffer.append(tableName).append("' and ");
            buffer.append("constname = '").append(fk.getName());
            buffer.append("' order by colseq");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHForeignKeyUDBv81.initFKColumns():", e);
        }
        if (rs != null) {
            FKContainer table = fk.getTable();
            while (rs.next()) {
                String colName = rs.getString(1);
                int colSeq = rs.getInt(2);
                Column col = (Column)table.getElementByName(colName);
                Column refCol = null;
                try {
                    refCol = (Column)index.getElement(colSeq - 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                if (col == null || refCol == null) continue;
                col.addFKAssociation(refCol, fk);
                fk.getLocalFKIndex().add(col);
            }
            rs.close();
        }
        statement.close();
    }
}

