/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.udb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.MOHTable;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StructuredTypeProxy;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.udb.ColumnProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StructuredTypeProxySetUDB;
import oracle.dbtools.crest.model.design.storage.udb.TableProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.TriggerUDB;
import oracle.dbtools.crest.model.design.storage.udb.v71.ColumnProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.IndexProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.SchemaUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.StorageDesignUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableProxyUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TableSpaceUDBv71;
import oracle.dbtools.crest.model.design.storage.udb.v71.TriggerUDBv71;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHTableUDB
extends MOHTable {
    private static final Logger LOGGER = new Logger(MOHTableUDB.class);
    String CWD_TS_TAB_META = "<cwd_ts_tab ";
    String CWD_TS_COLUMN_META = "<cwd_ts_column ";

    public MOHTableUDB(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!"TABLE".equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                buffer.append("TABSCHEMA").append(',');
                buffer.append("TABNAME").append(',');
                buffer.append("DEFINER").append(',');
                buffer.append("TYPE").append(',');
                buffer.append("ROWTYPESCHEMA").append(',');
                buffer.append("ROWTYPENAME").append(',');
                buffer.append("TABLEID").append(',');
                buffer.append("KEYINDEXID").append(',');
                buffer.append("TBSPACE").append(',');
                buffer.append("INDEX_TBSPACE").append(',');
                buffer.append("LONG_TBSPACE").append(',');
                buffer.append("PARTITION_MODE").append(',');
                buffer.append("DATACAPTURE").append(',');
                buffer.append("LOG_ATTRIBUTE").append(',');
                buffer.append("REMARKS").append(',');
                buffer.append("REFRESH").append(',');
                buffer.append("COMPRESSION").append(',');
                buffer.append("CLUSTERED").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("SYSCAT").append('.').append("TABLES").append(' ').append("t ");
                buffer.append("WHERE").append(' ');
                buffer.append("TABSCHEMA").append('=').append('\'');
                buffer.append(dbo.getSchema()).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TABNAME").append('=').append('\'');
                buffer.append(dbo.getName()).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("TYPE").append('=').append('\'');
                buffer.append("T").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("NOT").append(' ').append("EXISTS");
                buffer.append('(').append("SELECT").append(' ').append("1").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append("SYSCAT").append('.').append("VIEWS").append(' ').append("v ");
                buffer.append("WHERE").append(' ');
                buffer.append("v").append('.').append("VIEWNAME").append('=');
                buffer.append("t").append('.').append("TABNAME").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("v").append('.').append("VIEWSCHEMA").append('=');
                buffer.append("t").append('.').append("TABSCHEMA").append(')');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHTableUDB.generate():", e);
            }
            Table table = null;
            TableProxyUDBv71 tableProxy = null;
            StorageDesign storageDesign = null;
            if (rs != null) {
                if (rs.next()) {
                    table = this.getRelationalDesign().createTable();
                    table.setSchema(dbo.getSchema());
                    table.setName(dbo.getName());
                    this.stampModelObject(table, dbo);
                    String tbspace = rs.getString("TBSPACE");
                    String schemaname = rs.getString("TABSCHEMA");
                    String indextspacename = rs.getString("INDEX_TBSPACE");
                    String longtspacename = rs.getString("LONG_TBSPACE");
                    TableSpaceUDBv71 ts = null;
                    TableSpaceUDBv71 indextspace = null;
                    TableSpaceUDBv71 longtspace = null;
                    SchemaUDBv71 schema = null;
                    storageDesign = this.getStorageDesign();
                    if (storageDesign != null && storageDesign instanceof StorageDesignUDBv71) {
                        tableProxy = (TableProxyUDBv71)((StorageDesignUDBv71)storageDesign).getTableProxySet().getProxy(table.getObjectID());
                        if (tableProxy != null) {
                            tableProxy.setName(dbo.getName());
                            ts = this.getTableSpace(storageDesign, tbspace);
                            if (ts != null) {
                                tableProxy.setTableSpace(ts);
                            }
                            if ((indextspace = this.getTableSpace(storageDesign, indextspacename)) != null) {
                                tableProxy.setIndexInTableSpace(indextspace);
                            }
                            if ((longtspace = this.getTableSpace(storageDesign, longtspacename)) != null) {
                                tableProxy.setLongInTableSpace(longtspace);
                            }
                            if ((schema = (SchemaUDBv71)((StorageDesignUDBv71)storageDesign).getSchemaSet().getByName(schemaname.trim())) != null) {
                                tableProxy.setSchema(schema);
                                tableProxy.setOwner(schema.getOwner());
                            }
                            this.initTriggers(sqlConnection, tableProxy);
                            this.setProperties(tableProxy, (StorageDesignUDBv71)storageDesign, rs);
                        } else {
                            LOGGER.error("Unable to find TableProxy for table ID: " + table.getObjectID());
                        }
                    } else {
                        LOGGER.error("Unable to find Storage Design!");
                    }
                    this.initColumns(sqlConnection, tableProxy, dbo);
                    this.initColumnConstraints(sqlConnection, table, schemaname);
                    this.initTableConstraints(sqlConnection, table, schemaname);
                    this.initUniqueConstraints(sqlConnection, table, schemaname);
                    this.initIndexes(sqlConnection, table, schemaname);
                }
                rs.close();
            }
            statement.close();
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    protected TableSpaceUDBv71 getTableSpace(StorageDesign storageDesign, String tbspace) {
        if (tbspace != null && tbspace.equalsIgnoreCase("")) {
            TableSpaceUDBv71 ts = (TableSpaceUDBv71)((StorageDesignUDBv71)storageDesign).getTableSpaceSet().getByName(tbspace);
            return ts;
        }
        return null;
    }

    protected void setProperties(TableProxyUDBv71 tableProxy, StorageDesignUDBv71 storageDesign, ResultSet rs) throws SQLException {
        String partiotion_mode = rs.getString("PARTITION_MODE");
        String comment = rs.getString("REMARKS");
        String logged = rs.getString("LOG_ATTRIBUTE");
        String datacapture = rs.getString("DATACAPTURE");
        if ("H".equalsIgnoreCase(partiotion_mode)) {
            tableProxy.setPartKeyHashing(true);
        }
        if ("1".equalsIgnoreCase(logged)) {
            tableProxy.setInitialLogging(false);
        }
        if (!"N".equalsIgnoreCase(datacapture)) {
            tableProxy.setDataCapture(TableProxyUDB.getAvailableDataCaptureValues()[1]);
        }
        if (comment != null && !"".equalsIgnoreCase(comment)) {
            tableProxy.setCommentInRDBMS(comment);
            tableProxy.setCommentInRDBMSChanged(true);
        }
    }

    protected void initColumns(Connection sqlConnection, TableProxyUDBv71 tableProxy, DBObject dbo) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("TABSCHEMA").append(',');
            buffer.append("TABNAME").append(',');
            buffer.append("COLNAME").append(',');
            buffer.append("COLNO").append(',');
            buffer.append("TYPESCHEMA").append(',');
            buffer.append("TYPENAME").append(',');
            buffer.append("LENGTH").append(',');
            buffer.append("scale").append(',');
            buffer.append("DEFAULT").append(',');
            buffer.append("NULLS").append(',');
            buffer.append("LOGGED").append(',');
            buffer.append("COMPACT").append(',');
            buffer.append("CODEPAGE").append(',');
            buffer.append("TARGET_TYPESCHEMA").append(',');
            buffer.append("SCOPE_TABSCHEMA").append(',');
            buffer.append("SCOPE_TABNAME").append(',');
            buffer.append("IDENTITY").append(',');
            buffer.append("GENERATED").append(',');
            buffer.append("TEXT").append(',');
            buffer.append("REMARKS").append(',');
            buffer.append("SPECIAL_PROPS").append(',');
            buffer.append("DL_FEATURES").append(',');
            buffer.append("PARTKEYSEQ").append(',');
            buffer.append("COMPRESS").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("SYSCAT").append('.').append("COLUMNS").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TABSCHEMA").append('=');
            buffer.append('\'').append(dbo.getSchema()).append('\'');
            buffer.append("AND").append(' ');
            buffer.append("TABNAME").append('=');
            buffer.append('\'').append(dbo.getName()).append('\'');
            buffer.append("ORDER BY").append(' ').append("COLNO");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initColumns():", e);
        }
        RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv71 storage;
                ColumnProxyUDBv71 columnProxy;
                StorageDesign storageDesign;
                String colName = rs.getString("COLNAME");
                String colDatatype = rs.getString("TYPENAME");
                int colSize = rs.getInt("LENGTH");
                int colScale = rs.getInt("scale");
                Integer partkeyseq = (Integer)rs.getObject("PARTKEYSEQ");
                String allowNull = rs.getString("NULLS");
                String colDefault = rs.getString("DEFAULT");
                String logged = rs.getString("LOGGED");
                String compact = rs.getString("COMPACT");
                String identity = rs.getString("IDENTITY");
                String generated = rs.getString("GENERATED");
                String remarks = rs.getString("REMARKS");
                String dlOptions = rs.getString("DL_FEATURES");
                Table table = (Table)tableProxy.getObject();
                Column column = (Column)table.getElementByName(colName);
                if (column == null) {
                    column = table.createColumn(colName);
                    this.stampModelObject((ModelObject)column, table.getName(), colName);
                    String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(colDatatype);
                    LogicalDatatype logDatatype = null;
                    NativeDBType nt = StandardDatatypeNames.getNativeDBType(dbtype, colDatatype);
                    if (nt != null) {
                        logDatatype = nt.getLogicalDatatype();
                    }
                    if (logDatatype == null) {
                        logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                    }
                    if (logDatatype == null) {
                        logDatatype = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(colDatatype, this.getDbmeHandler().getRDBMSSite().getType().getName());
                    }
                    if (logDatatype != null && !"UNKNOWN".equalsIgnoreCase(usedDatatype)) {
                        column.setUse((short)1);
                        column.setLogicalDatatype(logDatatype);
                        column.setDataTypeParameter("size", String.valueOf(colSize));
                        column.setDataTypeParameter("scale", String.valueOf(colScale));
                    } else {
                        StructuredType st = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(colDatatype);
                        if (st != null) {
                            column.setUse((short)3);
                            column.setStructuredType(st);
                        } else {
                            DistinctType ct = (DistinctType)this.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(colDatatype);
                            if (ct != null) {
                                column.setUse((short)2);
                                column.setDistinctType(ct);
                            }
                        }
                    }
                    if ("Y".equalsIgnoreCase(allowNull)) {
                        column.setNullsAllowed(true);
                    } else {
                        column.setNullsAllowed(false);
                    }
                    if (colDefault != null) {
                        column.setDefaultValue(colDefault);
                    }
                    if (partkeyseq != null && partkeyseq > 0) {
                        tableProxy.setPartitioningKey(column.getName());
                    }
                }
                if ((storageDesign = this.getStorageDesign()) == null || !(storageDesign instanceof StorageDesignUDBv71) || (columnProxy = (ColumnProxyUDBv71)(storage = (StorageDesignUDBv71)storageDesign).getColumnProxySet().getProxy(column.getObjectID())) == null) continue;
                if ("Y".equalsIgnoreCase(logged)) {
                    columnProxy.setLogging("LOGGED");
                }
                if ("Y".equalsIgnoreCase(compact)) {
                    columnProxy.setCompact(ColumnProxyUDB.getCompactChoices()[0]);
                }
                if ("Y".equalsIgnoreCase(identity)) {
                    columnProxy.setUseIdentity(true);
                    this.initIdentityColumn(sqlConnection, table, columnProxy);
                    if ("D".equalsIgnoreCase(generated)) {
                        columnProxy.setGenerate(ColumnProxyUDB.getGenerateValues()[1]);
                    }
                }
                if (dlOptions != null && dlOptions.equals("")) {
                    this.initDatalinkOptions(columnProxy, dlOptions);
                }
                columnProxy.setCommentInRDBMS(remarks);
                columnProxy.setCommentInRDBMSChanged(true);
            }
            rs.close();
        }
        statement.close();
    }

    private void initIdentityColumn(Connection sqlConnection, Table table, ColumnProxyUDBv71 columnProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("s").append('.').append("INCREMENT").append(',');
            buffer.append("s").append('.').append("START").append(',');
            buffer.append("s").append('.').append("MAXVALUE").append(',');
            buffer.append("s").append('.').append("MINVALUE").append(',');
            buffer.append("s").append('.').append("CYCLE").append(',');
            buffer.append("s").append('.').append("CACHE").append(',');
            buffer.append("s").append('.').append("ORDER").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("sysibm.SYSSEQUENCES s").append(',');
            buffer.append("sysibm.SYSDEPENDENCIES d").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("d").append('.').append("dschema");
            buffer.append('=').append('\'').append(table.getSchema()).append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("d").append('.').append("dname");
            buffer.append('=').append('\'').append(table.getName()).append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqtype ");
            buffer.append('=').append('\'').append("I").append('\'');
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqschema");
            buffer.append('=').append("d.bschema");
            buffer.append(' ').append("AND").append(' ');
            buffer.append("s").append('.').append("seqname");
            buffer.append('=').append("d.bname");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHTableUDB.initIdentityColumn():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                int increment = rs.getInt(1);
                String start = rs.getString(2);
                columnProxy.setIncrementBy(increment);
                columnProxy.setStartWith(start);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initColumnConstraints(Connection sqlConnection, Table table, String shemaName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.constname,a.definition, b.enforced, b.enablequeryopt,d.colname ");
            buffer.append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            buffer.append("from syscat.CHECKS c where c.tabschema = '");
            buffer.append(shemaName.trim()).append("' and ");
            buffer.append("c.tabname = '");
            buffer.append(table.getName()).append("' and c.type = 'C' and 1 = (select count(*) ");
            buffer.append("from syscat.COLCHECKS ch where c.constname = ch.constname and ");
            buffer.append("c.tabschema = ch.tabschema and c.tabname = ch.tabname))a, syscat.TABCONST b, syscat.colchecks d ");
            buffer.append("where a.tabname = b.tabname and a.tabschema = b.tabschema and a.constname = b.constname and ");
            buffer.append("a.tabname = d.tabname and a.tabschema = d.tabschema and a.constname = d.constname ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initColumnConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String definition = rs.getString(2);
                String colName = rs.getString(5);
                CheckConstraint constraint = new CheckConstraint();
                constraint.setDesign(table.getDesign());
                constraint.setName(constrName);
                constraint.add(StorageDesignUDBv71.RDBMS_TYPE, definition);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                col.setUseDomainConstraints(false);
                col.setCheck(constraint);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initTableConstraints(Connection sqlConnection, Table table, String schemaName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select a.constname,a.definition, b.enforced, b.enablequeryopt ");
            buffer.append("from (select c.constname,c.text definition,c.tabschema,c.tabname ");
            buffer.append("from syscat.CHECKS c where ");
            buffer.append("c.tabschema =  '");
            buffer.append(schemaName.trim()).append("' and ");
            buffer.append("c.tabname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append(" c.type = 'C' and ");
            buffer.append("1<( ");
            buffer.append("select count(*) ");
            buffer.append("from syscat.COLCHECKS ch  ");
            buffer.append("where ");
            buffer.append("c.constname = ch.constname and ");
            buffer.append("c.tabschema = ch.tabschema and ");
            buffer.append("c.tabname = ch.tabname)) a, syscat.TABCONST b ");
            buffer.append("where ");
            buffer.append("a.tabname = b.tabname and ");
            buffer.append("a.tabschema = b.tabschema and ");
            buffer.append("a.constname = b.constname ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initTableConstraints:", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String definition = rs.getString(2);
                TableLevelConstraint constraint = table.createCheckConstraint(constrName, definition);
                table.addCheckConstraint(constraint);
                this.stampModelObject((ModelObject)constraint, schemaName.trim(), constrName);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initUniqueConstraints(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  constname,type, enforced, ");
            buffer.append("enablequeryopt, remarks comment ");
            buffer.append("FROM  syscat.TABCONST ");
            buffer.append("WHERE tabschema  = '");
            buffer.append(ownerName.trim()).append("'");
            buffer.append(" AND tabname  = '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND type in ('P','U')");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initUniqueConstraints():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String constrName = rs.getString(1);
                String type = rs.getString(2);
                Index index = table.createIndex();
                index.setContainerObject(table);
                index.setName(constrName);
                this.stampModelObject((ModelObject)index, ownerName.trim(), constrName);
                this.initKeyColumns(sqlConnection, index, constrName, table);
                if ("U".equalsIgnoreCase(type)) {
                    index.setIndexState("Unique Constraint");
                    continue;
                }
                if ("P".equalsIgnoreCase(type) && !table.isBST()) {
                    index.setIndexState("Primary Constraint");
                    continue;
                }
                if (!"P".equalsIgnoreCase(type) || !table.isBST()) continue;
                if (index.getElementsCollection().size() > 0) {
                    table.getOidPKColumns().addAll(index.getElementsCollection());
                    table.setOidIsPK(true);
                }
                index.remove();
                index = (Index)table.getPK();
                index.setName(constrName);
            }
            rs.close();
        }
        statement.close();
    }

    private void initKeyColumns(Connection sqlConnection, Index index, String indName, Table table) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT COLNAME, COLSEQ ");
            buffer.append("from syscat.keycoluse ");
            buffer.append("WHERE tabschema  = '");
            buffer.append(table.getSchema()).append("'");
            buffer.append(" AND tabname = '");
            buffer.append(table.getName()).append("' and ");
            buffer.append("constname = '").append(index.getName());
            buffer.append("' order by colseq");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initKeyColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                Column col = (Column)table.getElementByName(colName);
                if (col == null) continue;
                index.add(col);
            }
            rs.close();
        }
        statement.close();
    }

    protected void initIndexes(Connection sqlConnection, Table table, String ownerName) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT  indname,indschema,colnames, uniquerule, ");
            buffer.append("colcount,unique_colcount,indextype clust_reg, ");
            buffer.append("pctfree,minpctused,reverse_scans,remarks comment ");
            buffer.append("from syscat.indexes  ");
            buffer.append("WHERE  tabname  =  '");
            buffer.append(table.getName()).append("'");
            buffer.append(" AND tabschema  = '");
            buffer.append(ownerName.trim()).append("'");
            buffer.append(" AND entrytype <>'H' ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initIndexes():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                StorageDesignUDBv71 storage;
                String name = rs.getString(1);
                String schemaName = rs.getString(2);
                String type = rs.getString(4);
                String cluster = rs.getString(7);
                int pctfree = rs.getInt(8);
                int minpctused = rs.getInt(9);
                String reverseScan = rs.getString(10);
                String remark = rs.getString(11);
                Index index = table.createIndex();
                index.setName(name);
                index.setCommentInRDBMS(remark);
                this.stampModelObject((ModelObject)index, ownerName.trim(), name);
                if ("U".equalsIgnoreCase(type)) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(type) && !table.isBST()) {
                    index.setIndexState("Unique Plain Index");
                } else if ("P".equalsIgnoreCase(type) && table.isBST()) {
                    if (index.getElementsCollection().size() > 0) {
                        table.getOidPKColumns().addAll(index.getElementsCollection());
                        table.setOidIsPK(true);
                    }
                    index.remove();
                    index = (Index)table.getPK();
                    index.setName(name);
                }
                IndexProxyUDBv71 indexProxy = null;
                SchemaUDBv71 schema = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71) || (indexProxy = (IndexProxyUDBv71)(storage = (StorageDesignUDBv71)storageDesign).getIndexProxySet().getByName(name)) == null) continue;
                schema = (SchemaUDBv71)storage.getSchemaSet().getByName(schemaName);
                if (schema != null) {
                    indexProxy.setSchema(schema);
                    indexProxy.setOwner(schema.getOwner());
                }
                indexProxy.setPercentageFree(pctfree);
                indexProxy.setMinimumPercentageUsed(minpctused);
                if ("CLUS".equalsIgnoreCase(cluster)) {
                    indexProxy.setCluster(true);
                }
                if ("Y".equalsIgnoreCase(reverseScan)) {
                    indexProxy.setReverseScanSupport(true);
                }
                this.initIndexPrivileges(sqlConnection, indexProxy);
                this.initIndexColumns(sqlConnection, indexProxy, name, table);
            }
            rs.close();
        }
        statement.close();
    }

    private void initIndexPrivileges(Connection sqlConnection, IndexProxyUDBv71 indexProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT grantee,granteetype,controlauth ");
            buffer.append("from syscat.indexauth ");
            buffer.append("WHERE INDNAME = '");
            buffer.append(indexProxy.getName()).append("'");
            buffer.append(" AND INDSCHEMA = '");
            buffer.append(indexProxy.getSchema()).append("'");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String grantee = rs.getString(1);
                String type = rs.getString(2);
                String controlauth = rs.getString(3);
                if (!"Y".equalsIgnoreCase(controlauth)) continue;
                if ("U".equalsIgnoreCase(type)) {
                    indexProxy.setUsers(grantee.trim());
                    continue;
                }
                indexProxy.setGroups(grantee.trim());
            }
            rs.close();
        }
        statement.close();
    }

    private void initIndexColumns(Connection sqlConnection, IndexProxyUDBv71 indexProxy, String indName, Table table) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT colname, colseq, colorder ");
            buffer.append("from syscat.INDEXCOLUSE ");
            buffer.append("WHERE INDNAME = '");
            buffer.append(indName).append("'");
            buffer.append(" AND INDSCHEMA = '");
            buffer.append(table.getSchema()).append("'");
            buffer.append(" ORDER BY COLSEQ ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String colName = rs.getString(1);
                String order = rs.getString(2);
                Column col = (Column)table.getElementByName(colName);
                Index index = indexProxy.getIndex();
                if (col == null) continue;
                index.add(col);
                if ("A".equals(order)) {
                    index.setColumnSortOrder(col, "ASC");
                } else {
                    index.setColumnSortOrder(col, "DESC");
                }
                indexProxy.setColumnList(col.getName());
            }
            rs.close();
        }
        statement.close();
    }

    protected void initTriggers(Connection sqlConnection, TableProxyUDBv71 tableProxy) throws Exception {
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT TRIGSCHEMA,TRIGNAME,TRIGTIME, ");
            buffer.append("TRIGEVENT,GRANULARITY,TEXT definition,REMARKS comment ");
            buffer.append("from syscat.triggers ");
            buffer.append("WHERE tabname = '");
            buffer.append(tableProxy.getName()).append("'");
            buffer.append(" AND tabschema = '");
            buffer.append(tableProxy.getSchema()).append("'");
            buffer.append(" ORDER BY TRIGEVENT,TRIGTIME,create_time ");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHTableUDB.initIndexColumns():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String schemaName = rs.getString(1);
                String name = rs.getString(2);
                String triggerTime = rs.getString(3);
                String action = rs.getString(4);
                String scope = rs.getString(5);
                String triggerBody = rs.getString(6);
                String comments = rs.getString(7);
                SchemaUDBv71 schema = null;
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign == null || !(storageDesign instanceof StorageDesignUDBv71)) continue;
                StorageDesignUDBv71 storage = (StorageDesignUDBv71)storageDesign;
                TriggerUDBv71 trigger = (TriggerUDBv71)storage.getTriggerSet().createTrigger();
                trigger.setName(name);
                trigger.setTable(tableProxy);
                this.stampModelObject((ModelObject)trigger, schemaName, name);
                schema = (SchemaUDBv71)storage.getSchemaSet().getByName(schemaName);
                if (schema != null) {
                    trigger.setOwner(schema.getOwner());
                }
                if ("U".equalsIgnoreCase(action)) {
                    trigger.setActions(Trigger.ACTION_TYPES[1]);
                } else if ("D".equalsIgnoreCase(action)) {
                    trigger.setActions(Trigger.ACTION_TYPES[2]);
                }
                if ("A".equalsIgnoreCase(triggerTime)) {
                    trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[1]);
                } else if ("B".equalsIgnoreCase(triggerTime)) {
                    trigger.setTriggerTime(TriggerUDB.TRIGGER_TIMES[0]);
                }
                if ("S".equalsIgnoreCase(scope)) {
                    trigger.setScope(TriggerUDB.SCOPE_TYPES[1]);
                }
                trigger.setBody(triggerBody);
                trigger.setCommentInRDBMS(comments);
                this.initTriggerColumnTypeSubstitution(sqlConnection, (Table)tableProxy.getObject(), trigger, triggerBody);
            }
            rs.close();
        }
        statement.close();
    }

    private void initDatalinkOptions(ColumnProxyUDBv71 columnProxy, String dlOptions) {
        String linkControl = String.valueOf(dlOptions.charAt(2));
        String readPermission = String.valueOf(dlOptions.charAt(4));
        String writePermission = String.valueOf(dlOptions.charAt(5));
        String recovery = String.valueOf(dlOptions.charAt(6));
        String onUnlink = String.valueOf(dlOptions.charAt(7));
        if ("F".equalsIgnoreCase(linkControl)) {
            columnProxy.setLinkControl(ColumnProxyUDB.getLinkControlChoices()[1]);
        }
        if ("D".equalsIgnoreCase(readPermission)) {
            columnProxy.setReadPermission(ColumnProxyUDB.getReadPermissionChoices()[1]);
        }
        if ("B".equalsIgnoreCase(writePermission)) {
            columnProxy.setWritePermission(ColumnProxyUDB.getWritePermissionChoices()[1]);
        }
        if ("N".equalsIgnoreCase(recovery)) {
            columnProxy.setRecovery(ColumnProxyUDB.getRecoveryChoices()[1]);
        }
        if ("D".equalsIgnoreCase(onUnlink)) {
            columnProxy.setOnUnlink(ColumnProxyUDB.getOnUnlinkChoices()[1]);
        }
    }

    private void initTriggerColumnTypeSubstitution(Connection sqlConnection, Table table, Trigger trigger, String trBody) {
        ArrayList<Temp> list = new ArrayList<Temp>();
        String body = trBody;
        int l = this.CWD_TS_COLUMN_META.length();
        int ind = body.indexOf(this.CWD_TS_COLUMN_META);
        try {
            while (ind > -1) {
                body = body.substring(ind + l);
                String columnName = Token.getFirstToken(Token.getStringAfter(body, "column="));
                String typeName = Token.getFirstToken(Token.getStringAfter(body, "type="));
                Temp temp = new Temp();
                temp.tableName = Token.removeQuotes(columnName);
                temp.typeName = Token.removeQuotes(typeName);
                list.add(temp);
                ind = body.indexOf(this.CWD_TS_COLUMN_META);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("MOHTableUDB.initTriggerColumnTypeSubstitution():", e);
        }
        for (Temp temp : list) {
            StructuredType st;
            Column column = (Column)table.getElementByName(temp.tableName);
            if (column == null || (st = this.getStructuredType(temp.typeName, table.getDesign(), trigger.getStorageDesign())) == null) continue;
            List types = column.getPermittedSubTypes();
            if (!types.contains(st)) {
                types.add(st);
            }
            column.setAllowSubtypeSubstitution(true);
            column.setRestrictedTypeSubstitution(true);
        }
    }

    private StructuredType getStructuredType(String longName, Design design, StorageDesign sd) {
        int ind = longName.indexOf(46);
        if (ind > -1) {
            String user = longName.substring(0, ind);
            String name = longName.substring(ind + 1);
            StructuredTypeProxy stp = ((StructuredTypeProxySetUDB)sd.getStructuredTypeProxySet()).getBySchemaAndName(name, user);
            if (stp != null) {
                return stp.getStructuredType();
            }
            return null;
        }
        return (StructuredType)design.getDataTypesDesign().getStructuredTypeSet().getByName(longName);
    }

    class Temp {
        String tableName;
        String typeName;
        String parenTypeName;
        StructuredType st;
        StructuredType stPar;

        Temp() {
        }
    }
}

