/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver.v2k5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataFileSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHSchemaSqlServer2k5
extends AbstractMOHandler {
    protected static final String OBJECT_TYPE = "SCHEMA";
    private static final Logger LOGGER = new Logger(MOHSchemaSqlServer2k5.class);

    public MOHSchemaSqlServer2k5(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            String id = dbo.getId();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            String uid = ((DBUserSqlServer)dbo).getUid();
            StorageDesign storageDesign = this.getStorageDesign();
            if (storageDesign != null && storageDesign instanceof StorageDesignSqlServerv2k5) {
                StorageDesignSqlServerv2k5 storage = (StorageDesignSqlServerv2k5)storageDesign;
                DataBaseSqlServerv2k5 database = (DataBaseSqlServerv2k5)storage.getDataBaseSet().getByName(db);
                if (database == null) {
                    database = (DataBaseSqlServerv2k5)storage.getDataBaseSet().createDataBase();
                    database.setName(db);
                    this.stampModelObject((ModelObject)database, "", db);
                    this.initFilegroups(database, storage, sqlConnection);
                }
                SchemaSqlServerv2k5 schema = (SchemaSqlServerv2k5)storage.getSchemaSet().createSchema();
                schema.setDatabase(database);
                schema.setName(name);
                schema.setObjectID(id);
                schema.setUid(uid);
                this.stampModelObject((ModelObject)schema, db, name);
                String userName = dbo.getUserName(sqlConnection, uid);
                UserSqlServer user = (UserSqlServer)database.getUsers().getByName(userName);
                schema.setOwner(user);
            } else {
                LOGGER.error("Unable to find Storage Design!");
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void initFilegroups(DataBaseSqlServer database, StorageDesignSqlServer storage, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("groupname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("groupid").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(database.getName())).append('.').append("dbo.sysfilegroups").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String groupName = rs.getString(1);
                    String groupId = rs.getString(2);
                    FileGroupSqlServer fg = (FileGroupSqlServer)database.getFilegroups().getByName(groupName);
                    if (fg == null) {
                        fg = storage.getFileGroupSet().createFileGroup();
                        fg.setName(groupName);
                        fg.setDataBase(database);
                        this.stampModelObject((ModelObject)fg, database, groupName);
                    }
                    this.initDatafiles(fg, groupId, database.getName(), storage, sqlConnection);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initFilegroups():", e);
        }
    }

    private void initDatafiles(FileGroupSqlServer fg, String groupId, String db, StorageDesignSqlServer storage, Connection sqlConnection) throws Exception {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("size").append(' ');
            buffer.append(',').append(' ');
            buffer.append("maxsize").append(' ');
            buffer.append(',').append(' ');
            buffer.append("growth").append(' ');
            buffer.append(',').append(' ');
            buffer.append("GROWTH_IN_PERCENTAGE = ");
            buffer.append("case status & 0x100000 ");
            buffer.append("when 0x100000 then 'YES' ");
            buffer.append("else 'NO' ");
            buffer.append("end").append(' ');
            buffer.append(',').append(' ');
            buffer.append("filename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHandlerSqlServer.getFormattedName(db)).append('.').append("dbo.sysfiles").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("status & 0x2 = 0x2").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("groupid").append(' ');
            buffer.append('=').append(' ');
            buffer.append(groupId).append(' ');
            buffer.append("ORDER BY").append(' ');
            buffer.append("fileid").append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1).trim();
                    int size = rs.getInt(2);
                    int maxsize = rs.getInt(3);
                    int growth = rs.getInt(4);
                    String percentage = rs.getString(5);
                    String filename = rs.getString(6).trim();
                    DataFileSqlServer df = storage.getDataFileSet().createDataFile();
                    df.setName(name);
                    df.setFileGroup(fg);
                    df.setFileName(filename);
                    df.setInitialSize(size);
                    this.stampModelObject((ModelObject)df, fg.getDataBase(), name);
                    if (percentage.equalsIgnoreCase("YES")) {
                        df.setGrowthMethod("By Percent");
                    } else {
                        df.setGrowthMethod("In MegaBytes");
                    }
                    df.setGrowthValue(growth);
                    if (maxsize == -1) {
                        df.setIsUnlimited(true);
                        continue;
                    }
                    df.setIsUnlimited(false);
                    df.setMaxSize(maxsize);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHDatabaseSqlServerv2k5.initDatafiles():", e);
        }
    }
}

