/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.sqlserver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBObjectSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.DBUserSqlServer;
import oracle.dbtools.crest.imports.metadata.sqlserver.MOHandlerSqlServer;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.ColumnProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.DefaultSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.LoginSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDefaultSqlServer
extends MOHandlerSqlServer {
    protected static final String OBJECT_TYPE = "DEFAULT";
    private static final Logger LOGGER = new Logger(MOHDefaultSqlServer.class);

    public MOHDefaultSqlServer(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObjectSqlServer dbo = (DBObjectSqlServer)selectedObjects.get(i);
            String name = dbo.getName();
            String db = dbo.getDb();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("USE").append(' ');
                buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append(' ').append("\n");
                buffer.append(';').append("\n").append("\n");
                buffer.append("SELECT").append(' ');
                buffer.append("u").append('.');
                buffer.append("NAME").append(' ');
                buffer.append(',').append(' ');
                buffer.append("c").append('.');
                buffer.append("TEXT").append(' ');
                buffer.append(',').append(' ');
                buffer.append("s").append('.');
                buffer.append("ID").append(' ');
                buffer.append("FROM").append(' ');
                buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects s").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
                buffer.append(',').append(' ');
                buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.syscomments c").append(' ');
                buffer.append("WHERE").append(' ');
                buffer.append("XTYPE").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append("D").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append(1).append(' ').append('=').append(' ');
                buffer.append('(').append(' ');
                buffer.append("SELECT").append(' ');
                buffer.append("OBJECTPROPERTY").append(' ');
                buffer.append('(').append(' ');
                buffer.append("s.id ,'IsDefault'").append(' ');
                buffer.append(')').append(' ');
                buffer.append(')').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("s").append('.').append("NAME").append(' ');
                buffer.append('=').append(' ');
                buffer.append('\'').append(name).append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("s").append('.').append("UID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("u").append('.').append("UID").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("c").append('.').append("ID").append(' ');
                buffer.append('=').append(' ');
                buffer.append("s").append('.').append("ID").append(' ');
                rs = statement.executeQuery(buffer.toString());
            }
            catch (SQLException e) {
                LOGGER.error("MOHDefaultSqlServer.generate():", e);
            }
            if (rs != null && rs.next()) {
                StorageDesign storageDesign = this.getStorageDesign();
                if (storageDesign != null && storageDesign instanceof StorageDesignSqlServer) {
                    StorageDesignSqlServer storage = (StorageDesignSqlServer)storageDesign;
                    DataBaseSqlServer database = (DataBaseSqlServer)storage.getDataBaseSet().getByName(db);
                    if (database == null) {
                        database = storage.getDataBaseSet().createDataBase();
                        database.setName(db);
                        this.stampModelObject((ModelObject)database, "", db);
                    }
                    DefaultSqlServer def = storage.getDefaultSet().createDefault();
                    def.setName(name);
                    this.stampModelObject(def, dbo);
                    String username = rs.getString(1);
                    String text = rs.getString(2);
                    String def_id = rs.getString(3);
                    def.setDataBase(database);
                    this.setUser(def, storage, username, db, sqlConnection);
                    this.setText(def, text);
                    this.bindColumns(def, storage, def_id, db, sqlConnection);
                } else {
                    LOGGER.error("Unable to find Storage Design!");
                }
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setUser(DefaultSqlServer def, StorageDesignSqlServer storageDesign, String username, String db, Connection sqlConnection) {
        String loginname;
        UserSqlServer user = (UserSqlServer)storageDesign.getUserSet().getByName(username);
        if (user == null) {
            user = storageDesign.getUserSet().createUser();
            user.setName(username);
            user.setDatabase(def.getDataBase());
            this.stampModelObject((ModelObject)user, db, username);
        }
        if ((loginname = this.getLogin(username, db, sqlConnection)) != null) {
            LoginSqlServer login = (LoginSqlServer)storageDesign.getLoginSet().getByName(loginname);
            if (login == null) {
                login = storageDesign.getLoginSet().createLogin();
                login.setName(loginname);
                this.stampModelObject((ModelObject)login, def, loginname);
            }
            user.setLogin(login);
            login.setUsers(username);
        }
        def.setOwner(user);
    }

    private String getLogin(String username, String db, Connection sqlConnection) {
        String login = null;
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("l.loginname").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("master.dbo.syslogins l").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.sysusers u").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("l").append('.').append("sid").append(' ');
            buffer.append('=').append(' ');
            buffer.append("u").append('.').append("sid").append(' ');
            buffer.append("AND").append(' ');
            buffer.append("u").append('.').append("NAME").append(' ');
            buffer.append('=').append(' ').append('\'');
            buffer.append(username).append('\'').append(' ');
            rs = statement.executeQuery(buffer.toString());
            if (rs != null && rs.next()) {
                login = rs.getString(1);
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHDefaultSqlServer.getLogin():", e);
        }
        return login;
    }

    private void bindColumns(DefaultSqlServer def, StorageDesignSqlServer storage, String rule_id, String db, Connection sqlConnection) {
        try {
            Statement statement = sqlConnection.createStatement();
            ResultSet rs = null;
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("col.name columnname").append(' ');
            buffer.append(',').append(' ');
            buffer.append("obj.name tablename").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.syscolumns col").append(' ');
            buffer.append(',').append(' ');
            buffer.append(MOHDefaultSqlServer.getFormattedName(db)).append('.').append("dbo.sysobjects obj").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("col.cdefault").append(' ');
            buffer.append('=').append(' ');
            buffer.append(rule_id).append(' ');
            buffer.append("AND").append(' ');
            buffer.append("col").append('.').append("ID").append(' ');
            buffer.append('=').append(' ');
            buffer.append("obj").append('.').append("ID").append(' ');
            rs = statement.executeQuery(buffer.toString());
            TableProxySetSqlServer tableSet = (TableProxySetSqlServer)storage.getTableProxySet();
            if (rs != null) {
                while (rs.next()) {
                    ColumnProxySqlServer c;
                    String col = rs.getString(1);
                    String table = rs.getString(2);
                    TableProxySqlServer t = tableSet.getByName(table);
                    if (t == null || (c = (ColumnProxySqlServer)t.getColumnProxyByName(col)) == null) continue;
                    c.setDefineDefault(true);
                    c.setDefaultObject(def);
                }
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("MOHRuleSqlServer.bindColumns():", e);
        }
    }

    private void setText(DefaultSqlServer def, String text) throws Exception {
        String definition = Token.getStringAfterToken(text, "AS");
        definition = Token.getValBetweenQuotes(definition);
        def.setConstant(definition.trim());
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList list = new ArrayList();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected() || !(dboNext instanceof DBUserSqlServer)) continue;
            DBUserSqlServer dbo = (DBUserSqlServer)dboNext;
            list.addAll(this.extractByUser(sqlConnection, dbo));
        }
        return list;
    }

    private List extractByUser(Connection sqlConnection, DBUserSqlServer dbo) throws Exception {
        ArrayList<DBObjectSqlServer> list = new ArrayList<DBObjectSqlServer>();
        String dbName = dbo.getDb();
        String uid = dbo.getUid();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("USE").append(' ');
            buffer.append(MOHDefaultSqlServer.getFormattedName(dbName)).append(' ').append("\n");
            buffer.append(';').append("\n").append("\n");
            buffer.append("SELECT").append(' ');
            buffer.append("NAME").append(' ');
            buffer.append(',').append(' ');
            buffer.append("ID").append(' ');
            buffer.append(',').append(' ');
            buffer.append("UID").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(MOHDefaultSqlServer.getFormattedName(dbName)).append('.').append("dbo.sysobjects s").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("XTYPE").append(' ');
            buffer.append('=').append(' ');
            buffer.append('\'').append("D").append('\'').append(' ');
            buffer.append("AND").append(' ');
            buffer.append(1).append(' ');
            buffer.append('=').append(' ');
            buffer.append('(').append(' ');
            buffer.append("SELECT").append(' ');
            buffer.append("OBJECTPROPERTY ( s.id ,'IsDefault')").append(' ');
            buffer.append(')').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("UID").append(' ');
            buffer.append('=').append(' ');
            buffer.append(uid);
            rs = statement.executeQuery(buffer.toString());
        }
        catch (SQLException e) {
            LOGGER.error("MOHDefaultSqlServer.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String defName = rs.getString(1);
                DBObjectSqlServer dboDef = new DBObjectSqlServer(AbstractDBMExtractionHandler.isAllSelected(), defName, OBJECT_TYPE, dbo.getSchema());
                dboDef.setDb(dbName);
                list.add(dboDef);
            }
        }
        if (statement != null) {
            statement.close();
        }
        return list;
    }
}

