/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDirectoryOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIRECTORY";
    private static final Logger LOGGER = new Logger(MOHDirectoryOracle.class);
    protected boolean dbaUser;

    public MOHDirectoryOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHDirectoryOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Directory begin");
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        Statement statement = sqlConnection.createStatement();
        ResultSet rs = null;
        try {
            String filterCondition = this.getFilterConditionOracle("directory_name");
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("directory_name").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
            if (filterCondition != null) {
                buffer.append("WHERE").append(' ').append(filterCondition).append(' ');
            }
            buffer.append("ORDER BY").append(' ');
            buffer.append("directory_name");
            rs = statement.executeQuery(buffer.toString());
        }
        catch (Exception e) {
            LOGGER.error("MOHDirectoryOracle.extract():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String userName = rs.getString("directory_name");
                DBObject dboUser = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), userName, OBJECT_TYPE);
                list.add(dboUser);
            }
            rs.close();
        }
        statement.close();
        TimeLog.log("Extract Directory begin");
        return list;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Statement statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) {
                ResultSet rs = null;
                try {
                    if (statement == null) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("SELECT").append(' ');
                        buffer.append("directory_name").append(',');
                        buffer.append("directory_path").append(' ');
                        buffer.append("FROM").append(' ');
                        buffer.append(this.dbaUser ? "dba_directories" : "all_directories").append(' ');
                        buffer.append("WHERE").append(' ');
                        buffer.append("directory_name").append('=').append('?');
                        statement = sqlConnection.prepareStatement(buffer.toString());
                    }
                    statement.setString(1, dbo.getName());
                    rs = statement.executeQuery();
                }
                catch (Exception e) {
                    System.out.println("MOHDirectoryOracle.generate(): " + e.getMessage());
                    LOGGER.error("MOHDirectoryOracle.generate():", e);
                }
                if (rs != null) {
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    while (rs.next()) {
                        String name = rs.getString("directory_name");
                        String path = rs.getString("directory_path");
                        DirectoryOracle directory = (DirectoryOracle)storage.getDirectorySet().getByName(name);
                        if (directory == null) {
                            directory = storage.getDirectorySet().createDirectory();
                            directory.setName(name);
                        }
                        if (!name.equals(name.toUpperCase())) {
                            directory.setNameHasQuotes(true);
                        }
                        directory.setDirPath(path);
                        this.stampModelObject(directory, dbo);
                    }
                    rs.close();
                }
            }
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (statement != null) {
            statement.close();
        }
    }
}

