/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.db2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDatatypeDB2
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DATATYPE";
    private static final Logger LOGGER = new Logger(MOHDatatypeDB2.class);

    public MOHDatatypeDB2(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        for (int i = 0; i < selectedObjects.size(); ++i) {
            DBObject dbo = (DBObject)selectedObjects.get(i);
            String name = dbo.getName();
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT SOURCETYPE, LENGTH, SCALE ");
                buffer.append("from SYSIBM.SYSDATATYPES ");
                buffer.append("WHERE NAME = '").append(dbo.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatatypeDB2.generate():", e);
            }
            if (rs != null) {
                if (rs.next()) {
                    DistinctType type = this.getDesign().getDataTypesDesign().createDistinctType();
                    type.setName(name);
                    this.stampModelObject(type, dbo);
                    this.setProperties(type, rs);
                }
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
    }

    private void setProperties(DistinctType type, ResultSet rs) throws Exception {
        String systype = rs.getString(1);
        int size = rs.getInt(2);
        int scale = rs.getInt(3);
        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getDbmeHandler().getRDBMSSite().getType(), systype);
        if (logicalDT == null) {
            logicalDT = this.getDesign().getLogicalDatatypeSet().getLogTypeByNativeType(systype, this.getDbmeHandler().getRDBMSSite().getType().getName());
        }
        if (logicalDT != null) {
            type.setLogicalDataType(logicalDT);
            type.setSize("" + size);
            type.setScale(scale);
            type.setPrecision(size);
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            Statement statement = null;
            ResultSet rs = null;
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT name from SYSIBM.SYSDATATYPES").append(' ');
                buffer.append("WHERE SCHEMA = '");
                buffer.append(dboNext.getName()).append("'");
                statement = sqlConnection.prepareStatement(buffer.toString());
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("MOHDatatypeDB2.extract(): " + e.getMessage());
            }
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    DBObject dbo = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), name, OBJECT_TYPE, dboNext.getName());
                    list.add(dbo);
                }
                rs.close();
            }
            if (statement == null) continue;
            statement.close();
        }
        return list;
    }
}

