/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb.v81;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.BufferPoolUDBv81;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateBufferPoolUDBv81
extends DDLStatementHandler {
    private static final Logger LOGGER = new Logger(SHCreateBufferPoolUDBv81.class);

    public SHCreateBufferPoolUDBv81(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateBufferPoolUDBv81.clearCR(line);
        if (Token.startsWithString(statement, "create bufferpool")) {
            try {
                this.parseBufferPool(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error(" Parsing " + statement + " for UDB failed!", e);
                this.importLog.addFailedStatement(SHCreateBufferPoolUDBv81.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseBufferPool(String statement) {
        this.statement = statement;
        String bpName = Token.getQuotedNameAfterToken(this.statement, "BUFFERPOOL").trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
        BufferPoolUDBv81 bp = (BufferPoolUDBv81)storageDesign.getBufferPoolSet().createBufferPool();
        if (bp != null) {
            bp.setName(bpName);
            this.design.getRelationalDesign().stampModelObjectDDL(bp);
            if (Token.getTokenAfter(this.statement, bpName).trim().equalsIgnoreCase("IMMEDIATE")) {
                bp.setCreateImmediate("YES");
            } else if (Token.getTokenAfter(this.statement, bpName).trim().equalsIgnoreCase("DEFERRED")) {
                bp.setCreateImmediate("NO");
            }
            if (statement.toUpperCase().indexOf("NODEGROUP") > -1) {
                String part = statement.substring(statement.toUpperCase().indexOf("NODEGROUP") + 24);
                part = Token.getStringBefore(part, "SIZE").trim();
                bp.setScope(part);
            } else if (statement.toUpperCase().indexOf("DATABASE PARTITION GROUP") > -1) {
                String part = statement.substring(statement.toUpperCase().indexOf("DATABASE PARTITION GROUP") + 24);
                part = Token.getStringBefore(part, "SIZE").trim();
                bp.setScope(part);
            }
            this.initSize(bp);
            this.initPageSize(bp);
            this.initExtendedStorage(bp);
        }
    }

    private void initSize(BufferPoolUDBv81 bp) {
        if (Token.hasToken(this.statement, "SIZE")) {
            try {
                int size = Integer.parseInt(Token.getTokenAfter(this.statement, "SIZE"));
                bp.setSize(size);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong SIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDBv81.initSize : " + e.getMessage());
            }
            if (Token.hasToken(this.statement, "EXCEPT") && Token.hasCloseAndOpenBrackets(this.statement)) {
                String nodes = Token.getValBetweenBrackets(this.statement).trim();
                bp.setNodesWithDiffSize(nodes);
            }
        }
    }

    private void initPageSize(BufferPoolUDBv81 bp) {
        if (Token.hasToken(this.statement, "PAGESIZE")) {
            try {
                int pageSize = Integer.parseInt(Token.getTokenAfter(this.statement, "PAGESIZE"));
                if (!Token.getTokenAfter(this.statement, "" + pageSize).equalsIgnoreCase("K")) {
                    pageSize /= 1024;
                }
                bp.setPageSize(pageSize);
            }
            catch (NumberFormatException e) {
                this.importLog.addWarning("Wrong PAGESIZE format in statement " + this.statement);
                LOGGER.error("wrong format in SHCreateBufferPoolUDBv81.initPageSize : " + e.getMessage());
            }
        }
    }

    private void initExtendedStorage(BufferPoolUDBv81 bp) {
        if (this.statement.toUpperCase().indexOf("EXTENDED STORAGE") > -1 && this.statement.toUpperCase().indexOf("NOT EXTENDED STORAGE") == -1) {
            bp.setExtendedStorage(true);
        }
    }
}

