/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.AlterTableHandler;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationReference;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.udb.FKProxyUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAlterTableUDB
extends DDLStatementHandler
implements AlterTableHandler {
    protected Table table;
    protected List statemensList = new ArrayList();
    protected static final Logger LOGGER = new Logger(SHAlterTableUDB.class);
    protected String name = "";

    public SHAlterTableUDB(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHAlterTableUDB.clearCR(line);
        if (Token.startsWithString(statement, "alter table") && (this.isUK(statement) || this.isPK(statement) || this.isFK(statement) || this.isCheck(statement))) {
            if (this.isPK(statement) || this.isUK(statement) || this.isCheck(statement) || this.isFK(statement)) {
                try {
                    this.parseAlterTable(statement);
                    this.importLog.incrementImportedStatements();
                }
                catch (Exception e) {
                    LOGGER.error("Parsing " + statement + " for UDB failed!", e);
                    this.importLog.addFailedStatement(SHAlterTableUDB.FormatCR(line, "\n"));
                }
            } else {
                this.statemensList.add(statement);
            }
        } else {
            this.nextHandler(line);
        }
    }

    public void parseAlterTable(String statement) {
        this.statement = statement;
        this.initTable();
        if (this.table != null) {
            String[] splittedStatement = statement.split(" ADD ");
            if (splittedStatement.length == 1) {
                splittedStatement = statement.split(" add ");
            }
            for (String alterStatement : Arrays.asList(splittedStatement)) {
                if (this.isPK(alterStatement)) {
                    this.initPK(alterStatement);
                    continue;
                }
                if (this.isFK(alterStatement)) {
                    this.parseFK(alterStatement);
                    continue;
                }
                if (this.isUK(alterStatement)) {
                    this.initUnique(alterStatement);
                    continue;
                }
                if (!this.isCheck(alterStatement)) continue;
                this.initCheck(alterStatement);
            }
        }
    }

    public void parseFK(String statement) {
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        this.statement = statement;
        if (this.table != null) {
            RDBMSSite site = this.design.getSelectedRDBMSSite();
            StorageDesignUDB storageDesign = (StorageDesignUDB)this.design.getStorageDesign(site);
            if (this.isFK()) {
                FKProxyUDB fk;
                this.initForeignKey();
                if (storageDesign != null && (fk = (FKProxyUDB)storageDesign.getFKProxySet().getByName(this.name)) != null) {
                    if (Token.hasToken(this.statement, "DELETE")) {
                        String deleteRule = Token.getTokenAfter(this.statement, "DELETE").trim();
                        if (deleteRule.equalsIgnoreCase("NO")) {
                            if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                deleteRule = "NO ACTION";
                            }
                        } else if (deleteRule.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                            deleteRule = "SET NULL";
                        }
                        FKIndexAssociation fkass = ((Index)fk.getObject()).getFKAssociation();
                        fkass.setDeleteRule(deleteRule);
                    }
                    if (Token.hasToken(this.statement, "UPDATE")) {
                        String updateRule = Token.getTokenAfter(this.statement, "UPDATE").trim();
                        if (updateRule.equalsIgnoreCase("NO") && Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                            updateRule = "NO ACTION";
                        }
                        fk.setOnUpdate(updateRule);
                    }
                }
            }
        }
    }

    private boolean isFK() {
        return Token.hasString(this.statement.toUpperCase(), "FOREIGN");
    }

    protected void initTable() {
        String name = Token.getNameAfterToken(this.statement, "TABLE", '\"', '\"').trim();
        String tableName = this.getNameFor(name);
        this.table = this.getTableFor(tableName);
    }

    protected void initForeignKey() {
        boolean hasForeignKey = false;
        if (this.statement.trim().startsWith("(")) {
            this.statement = Token.getValBetweenBrackets(this.statement);
        }
        String stringWithFK = this.statement;
        hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        while (hasForeignKey) {
            int positionForeign = stringWithFK.toUpperCase().indexOf("FOREIGN");
            String fkString = stringWithFK.substring(positionForeign);
            Object nameFK = "FK_ASS";
            if (Token.hasToken(stringWithFK, "CONSTRAINT")) {
                nameFK = Token.getQuotedNameAfterToken(stringWithFK, "CONSTRAINT");
            } else {
                String tableName = this.table.getName();
                if (tableName.length() > 13) {
                    tableName = tableName.substring(0, 13);
                }
                nameFK = tableName + "_FK" + this.table.getFKAssociationsCount();
            }
            this.name = nameFK;
            int positionBracket = fkString.indexOf(41);
            String firstBrackets = fkString.substring(0, positionBracket + 1).trim();
            String columns = Token.getValBetweenBrackets(firstBrackets);
            List columnNames = this.getColumnNames(columns);
            ArrayList<Column> columnsRef = new ArrayList<Column>();
            Column[] columnSet = (Column[])this.table.getElements();
            for (String name : columnNames) {
                name = Token.getName(name);
                for (int ci = 0; ci < columnSet.length; ++ci) {
                    String colname = columnSet[ci].getName().trim();
                    if (!name.equalsIgnoreCase(colname)) continue;
                    columnsRef.add(columnSet[ci]);
                }
            }
            int positionReference = fkString.toUpperCase().indexOf("REFERENCES");
            String tblName = Token.getValBeforeBrackets(fkString = fkString.substring(positionReference));
            String nameReferenced = Token.getQuotedNameAfterToken(tblName, "REFERENCES");
            String nameRef = this.getNameFor(nameReferenced);
            Table tableRef = this.getTableFor(nameRef);
            if (tableRef != null) {
                boolean hasBrackets = Token.hasString(fkString, "(");
                if (hasBrackets) {
                    String columnsReferenced = Token.getValBetweenBrackets(fkString);
                    List columnNamesReferenced = this.getColumnNames(columnsReferenced);
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = this.getUniqueIndexForColumnNames(tableRef, columnNamesReferenced);
                    if (index != null) {
                        FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                        fkass.setName((String)nameFK);
                        this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                        fkass.getLocalFKIndex().setName((String)nameFK);
                        if (this.design.getDesign().isPropagatePKChahges()) {
                            this.replaceAllColumns(fkass, columnsRef, index);
                        } else {
                            this.fixFKColumns(fkass, columnsRef, index);
                        }
                        boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                        if (hasOnDelete) {
                            String onDelete = Token.getTokenAfter(fkString, "DELETE").trim();
                            if (onDelete.equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                    onDelete = "NO ACTION";
                                }
                            } else if (onDelete.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                                onDelete = "SET NULL";
                            }
                            String[] choisesDelete = fkass.getDeleteRuleChoices();
                            for (int choise = 0; choise < choisesDelete.length; ++choise) {
                                if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                                fkass.setDeleteRule(choisesDelete[choise]);
                                break;
                            }
                        }
                    }
                } else {
                    FKIndexAssociationReference reference = this.design.getRelationalDesign().getFKIndexAssociationSet().createReference();
                    Index index = (Index)tableRef.getPK();
                    if (index != null) {
                        FKIndexAssociation fkass = this.table.addFK(index, null, reference);
                        fkass.setName((String)nameFK);
                        this.design.getRelationalDesign().stampModelObjectDDL(fkass);
                        fkass.getLocalFKIndex().setName((String)nameFK);
                        if (this.design.getDesign().isPropagatePKChahges()) {
                            this.replaceAllColumns(fkass, columnsRef, index);
                        } else {
                            this.fixFKColumns(fkass, columnsRef, index);
                        }
                        boolean hasOnDelete = Token.hasToken(fkString, "DELETE");
                        if (hasOnDelete) {
                            String onDelete = Token.getTokenAfter(fkString, "DELETE").trim();
                            if (onDelete.equalsIgnoreCase("NO")) {
                                if (Token.getTokenAfter(this.statement, "NO").trim().equalsIgnoreCase("ACTION")) {
                                    onDelete = "NO ACTION";
                                }
                            } else if (onDelete.equalsIgnoreCase("SET") && Token.getTokenAfter(this.statement, "SET").trim().equalsIgnoreCase("NULL")) {
                                onDelete = "SET NULL";
                            }
                            String[] choisesDelete = fkass.getDeleteRuleChoices();
                            for (int choise = 0; choise < choisesDelete.length; ++choise) {
                                if (!onDelete.equalsIgnoreCase(choisesDelete[choise])) continue;
                                fkass.setDeleteRule(choisesDelete[choise]);
                                break;
                            }
                        }
                    }
                }
            }
            stringWithFK = fkString;
            hasForeignKey = Token.hasToken(stringWithFK, "FOREIGN");
        }
    }

    protected List getColumnNames(String columnString) {
        ArrayList<String> columns = new ArrayList<String>();
        StringTokenizer tokColumns = new StringTokenizer(columnString, ",");
        while (tokColumns.hasMoreTokens()) {
            String token = tokColumns.nextToken().trim();
            columns.add(Token.removeQuotes(token.trim()));
        }
        return columns;
    }

    protected String getNameFor(String name) {
        int posPoint = name.indexOf(46);
        if (posPoint > 0) {
            StringTokenizer tokenName = new StringTokenizer(name, ".");
            String itemName = null;
            do {
                String partName;
                itemName = partName = tokenName.nextToken().trim();
            } while (tokenName.hasMoreTokens());
            int posPointKomma = itemName.indexOf(59);
            if (posPointKomma > 0) {
                itemName = itemName.substring(0, itemName.length() - 1);
            }
            return Token.getName(itemName);
        }
        int posPointKomma = name.indexOf(59);
        if (posPointKomma > 0) {
            name = name.substring(0, name.length() - 1);
        }
        return Token.getName(name);
    }

    protected Table getTableFor(String tableName) {
        Table table = null;
        TableSet tableSet = this.design.getRelationalDesign().getTableSet();
        Iterator itTableSet = tableSet.iterator();
        while (itTableSet.hasNext()) {
            Table tableFromSet = (Table)itTableSet.next();
            if (!tableFromSet.getName().equalsIgnoreCase(tableName)) continue;
            table = tableFromSet;
            break;
        }
        return table;
    }

    private Column getColumnFor(Table table, String name) {
        Column column = null;
        Column[] columns = (Column[])table.getElements();
        for (int i = 0; i < columns.length; ++i) {
            Column temp = columns[i];
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            column = temp;
            break;
        }
        return column;
    }

    protected void replaceAllColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        Column[] indCol = (Column[])index.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            if (column.isPartOfFKIndexAssociation(fkAss)) continue;
            Column indexColumn = indCol[p];
            fkAss.swapAndRemoveFKColumn(indexColumn, column, pkCol[p]);
        }
    }

    private void fixFKColumns(FKIndexAssociation fkAss, List columnsRef, Index pk) {
        KeyObject index = fkAss.getLocalFKIndex();
        Iterator it = columnsRef.iterator();
        Column[] pkCol = (Column[])pk.getElements();
        if (pkCol.length != columnsRef.size()) {
            StringBuffer buff = new StringBuffer();
            buff.append("Foreign key columns don't match Primary key columns\n").append("tab_ch ").append(index.getContainerWithKeyObject().getName()).append(" index ").append(index.getName()).append(" parent table ").append(pk.getContainerWithKeyObject().getName());
            LOGGER.error(buff.toString());
            this.importLog.addError(buff.toString());
        }
        int p = -1;
        while (it.hasNext()) {
            if (++p == pkCol.length) {
                return;
            }
            Column column = (Column)it.next();
            column.addFKAssociation(pkCol[p], fkAss);
            index.add(column);
        }
    }

    protected boolean isPK(String sqlStatement) {
        return sqlStatement.toUpperCase().indexOf("PRIMARY KEY") > -1;
    }

    protected boolean isUK(String sqlStatement) {
        return Token.hasToken(sqlStatement, "UNIQUE");
    }

    protected boolean isFK(String statement) {
        return Token.hasToken(statement, "ADD") || Token.hasToken(statement, "FOREIGN");
    }

    protected void initPK(String statement) {
        Object pkName = null;
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "PRIMARY KEY"), 1).trim();
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        if (Token.hasToken(statement, "CONSTRAINT")) {
            pkName = Token.getQuotedNameAfterToken(statement, "CONSTRAINT").trim();
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 15) {
                tableName = tableName.substring(0, 15);
            }
            pkName = tableName + "_PK";
        }
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            Index indexPK = this.table.createIndex();
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName = Token.getName(colName));
                if (column == null) continue;
                indexPK.add(column);
            }
            indexPK.makePK();
            indexPK.setName((String)pkName);
            this.design.getRelationalDesign().stampModelObjectDDL(indexPK);
        }
    }

    protected void initUnique(String statement) {
        Object unName = null;
        if (statement.trim().startsWith("(")) {
            statement = Token.getValBetweenBrackets(statement);
        }
        if (Token.hasToken(statement, "CONSTRAINT")) {
            unName = Token.getQuotedNameAfterToken(statement, "CONSTRAINT").trim();
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 13) {
                tableName = tableName.substring(0, 13);
            }
            unName = tableName + "_UK" + this.table.getUKeys().size();
        }
        String columnsStr = Token.getValBetweenBrackets(Token.getStringAfter(statement, "UNIQUE"), 1).trim();
        List columnNames = this.getColumnNames(columnsStr);
        if (columnNames.size() > 0) {
            Index indexUnique = this.table.createIndex();
            for (String colName : columnNames) {
                Column column = this.getColumnFor(this.table, colName = Token.getName(colName));
                if (column == null) continue;
                indexUnique.add(column);
            }
            indexUnique.setUnique(true);
            indexUnique.setName((String)unName);
            this.design.getRelationalDesign().stampModelObjectDDL(indexUnique);
        }
    }

    private boolean isCheck(String statement) {
        return statement.toUpperCase().indexOf("CHECK") > -1;
    }

    private void initCheck(String constr) {
        if (constr.trim().startsWith("(")) {
            constr = Token.getValBetweenBrackets(constr);
        }
        this.statement = constr;
        Object constrName = null;
        if (Token.hasToken(this.statement, "CONSTRAINT")) {
            constrName = Token.getQuotedNameAfterToken(this.statement, "CONSTRAINT").trim();
        } else {
            String tableName = this.table.getName();
            if (tableName.length() > 13) {
                tableName = tableName.substring(0, 13);
            }
            constrName = tableName + "_CK" + this.table.getCheckConstraints().size();
        }
        String condition = Token.getValBetweenBrackets(Token.getStringAfter(this.statement, "CHECK"), 1).trim();
        TableLevelConstraint constraint = this.table.createCheckConstraint((String)constrName, condition);
        this.table.addCheckConstraint(constraint);
        this.design.getRelationalDesign().stampModelObjectDDL(constraint);
    }

    private boolean isIndexForColumnNames(Index index, List names) {
        Column[] columns = (Column[])index.getElements();
        if (columns.length != names.size()) {
            return false;
        }
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equalsIgnoreCase(Token.getName((String)names.get(i)))) continue;
            return false;
        }
        return true;
    }

    protected Index getUniqueIndexForColumnNames(Table table, List names) {
        Index ind = (Index)table.getPK();
        if (ind != null && this.isIndexForColumnNames(ind, names)) {
            return ind;
        }
        Index[] inds = (Index[])table.getKeys();
        for (int i = 0; i < inds.length; ++i) {
            if (!inds[i].getIndexState().equalsIgnoreCase("Unique Constraint") || !this.isIndexForColumnNames(inds[i], names)) continue;
            return inds[i];
        }
        return null;
    }

    @Override
    public void processForeignKeys() {
        for (String alterStatement : this.statemensList) {
            this.parseAlterTable(alterStatement);
        }
    }
}

