/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.DDLStatementHandlerSqlServer;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.SynonymSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StoredProcedureSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySetSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.TableViewProxySqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHCreateSynonymSqlServerv2k5
extends DDLStatementHandlerSqlServer {
    private static final Logger LOGGER = new Logger(SHCreateSynonymSqlServerv2k5.class);

    public SHCreateSynonymSqlServerv2k5(Design design) {
        super(design);
    }

    @Override
    public void handle(String line) {
        String statement = SHCreateSynonymSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create synonym")) {
            try {
                this.parseSynonym(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                this.importLog.addFailedStatement(SHCreateSynonymSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    private void parseSynonym(String statement) {
        this.statement = statement;
        String synonymName = Token.getTokenAfter(statement, "SYNONYM").trim();
        String object = Token.getTokenAfter(statement, "FOR").trim();
        String owner = Token.getValBeforeCharacter(synonymName, '.').trim();
        String objectName = Token.getValAfterCharacter(object, '.').trim();
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        Table table = (Table)this.design.getDesign().getRelationalDesign().getTableSet().getByName(objectName);
        TableView view = null;
        StoredProcedureSqlServerv2k5 procedure = null;
        SchemaSqlServerv2k5 schema = null;
        if (!owner.equalsIgnoreCase("")) {
            synonymName = Token.getValAfterCharacter(synonymName, '.');
        }
        if (!synonymName.equalsIgnoreCase("") && !objectName.equalsIgnoreCase("")) {
            SynonymSqlServer synonym = storageDesign.getSynonymSet().createSynonym();
            synonym.setName(synonymName);
            this.design.getRelationalDesign().stampModelObjectDDL(synonym);
            if (table == null) {
                view = (TableView)storageDesign.getPhysicalDesign().getTableViewSet().getByName(objectName);
                if (view != null) {
                    TableViewProxySqlServerv2k5 viewProxy = (TableViewProxySqlServerv2k5)storageDesign.getTableViewProxySet().getProxy(view.getObjectID());
                    schema = (SchemaSqlServerv2k5)viewProxy.getDataBase().getSchemas().getByName(owner);
                    synonym.setSchema(schema);
                    synonym.setView(viewProxy);
                } else {
                    procedure = (StoredProcedureSqlServerv2k5)storageDesign.getStoredProcedureSet().getByName(objectName);
                    if (procedure != null) {
                        schema = (SchemaSqlServerv2k5)procedure.getDatabase().getSchemas().getByName(owner);
                        synonym.setSchema(schema);
                        synonym.setProcedure(procedure);
                    }
                }
            } else {
                TableProxySqlServerv2k5 tableProxy = (TableProxySqlServerv2k5)storageDesign.getTableProxySet().getProxy(table.getObjectID());
                schema = (SchemaSqlServerv2k5)tableProxy.getDatabase().getSchemas().getByName(owner);
                synonym.setSchema(schema);
                synonym.setTable(tableProxy);
            }
        } else if (!synonymName.equalsIgnoreCase("") && !object.equalsIgnoreCase("")) {
            TableViewProxySqlServerv2k5 viewProxy;
            SynonymSqlServer synonym = storageDesign.getSynonymSet().createSynonym();
            synonym.setName(synonymName);
            this.design.getRelationalDesign().stampModelObjectDDL(synonym);
            procedure = (StoredProcedureSqlServerv2k5)storageDesign.getStoredProcedureSet().getByName(object);
            if (procedure != null) {
                schema = (SchemaSqlServerv2k5)procedure.getDatabase().getSchemas().getByName(owner);
                synonym.setSchema(schema);
                synonym.setProcedure(procedure);
            }
            if ((viewProxy = (TableViewProxySqlServerv2k5)((TableViewProxySetSqlServerv2k5)storageDesign.getTableViewProxySet()).getByName(object)) != null) {
                schema = (SchemaSqlServerv2k5)viewProxy.getDataBase().getSchemas().getByName(owner);
                synonym.setSchema(schema);
                synonym.setView(viewProxy);
            }
        } else {
            LOGGER.error("SynonymSqlServer.parseSynonym: wrong syntax!");
            this.importLog.addWarning("Synonym without name.");
        }
    }
}

